// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple nvptx64-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK-64
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple i386-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK-32
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-cuda-mode -fexceptions -fcxx-exceptions -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK-32-EX
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

// Check for the data transfer medium in shared memory to transfer the reduction list to the first warp.

// Check that the execution mode of all 3 target regions is set to Spmd Mode.

template<typename tx>
tx ftemplate(int n) {
  int a;
  short b;
  tx c;
  float d;
  double e;

  #pragma omp target parallel reduction(+: e)
  {
    e += 5;
  }

  #pragma omp target parallel reduction(^: c) reduction(*: d)
  {
    c ^= 2;
    d *= 33;
  }

  #pragma omp target parallel reduction(|: a) reduction(max: b)
  {
    a |= 1;
    b = 99 > b ? 99 : b;
  }

  return a+b+c+d+e;
}

int bar(int n){
  int a = 0;

  a += ftemplate<char>(n);

  return a;
}

// define internal void [[PFN]](


// Reduction function

// Shuffle and reduce function
// Condition to reduce
// Now check if we should just copy over the remote reduction list

// Inter warp copy function
// [[DO_COPY]]
// Barrier after copy to shared memory storage medium.
// Read into warp 0.

// define internal void [[PFN1]](

// Reduction function

// Shuffle and reduce function
// Condition to reduce
// Now check if we should just copy over the remote reduction list

// Inter warp copy function
// [[DO_COPY]]
// Barrier after copy to shared memory storage medium.
// Read into warp 0.
// [[DO_COPY]]
// Barrier after copy to shared memory storage medium.
// Read into warp 0.

// define internal void [[PFN2]](


// Reduction function

// Shuffle and reduce function
// Condition to reduce
// Now check if we should just copy over the remote reduction list

// Inter warp copy function
// [[DO_COPY]]
// Barrier after copy to shared memory storage medium.
// Read into warp 0.
// [[DO_COPY]]
// Barrier after copy to shared memory storage medium.
// Read into warp 0.

#endif
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l24
// CHECK-64-SAME: (double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x i8*], align 8
// CHECK-64-NEXT:    store double* [[E]], double** [[E_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1:[0-9]+]], i8 2, i1 false)
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP4:%.*]] = bitcast double* [[TMP0]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP4]], i8** [[TMP3]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast [1 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-64-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, double*)* @__omp_outlined__ to i8*), i8* null, i8** [[TMP5]], i64 1)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@__omp_outlined__
// CHECK-64-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 8
// CHECK-64-NEXT:    [[E1:%.*]] = alloca double, align 8
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x i8*], align 8
// CHECK-64-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    store double* [[E]], double** [[E_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 8
// CHECK-64-NEXT:    store double 0.000000e+00, double* [[E1]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load double, double* [[E1]], align 8
// CHECK-64-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], 5.000000e+00
// CHECK-64-NEXT:    store double [[ADD]], double* [[E1]], align 8
// CHECK-64-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK-64-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast double* [[E1]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 8
// CHECK-64-NEXT:    [[TMP6:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-64-NEXT:    [[TMP7:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i64 8, i8* [[TMP6]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func)
// CHECK-64-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[TMP7]], 1
// CHECK-64-NEXT:    br i1 [[TMP8]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-64:       .omp.reduction.then:
// CHECK-64-NEXT:    [[TMP9:%.*]] = load double, double* [[TMP0]], align 8
// CHECK-64-NEXT:    [[TMP10:%.*]] = load double, double* [[E1]], align 8
// CHECK-64-NEXT:    [[ADD2:%.*]] = fadd double [[TMP9]], [[TMP10]]
// CHECK-64-NEXT:    store double [[ADD2]], double* [[TMP0]], align 8
// CHECK-64-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP3]])
// CHECK-64-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-64:       .omp.reduction.done:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [1 x i8*], align 8
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca double, align 8
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [1 x i8*]*
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to double**
// CHECK-64-NEXT:    [[TMP11:%.*]] = load double*, double** [[TMP10]], align 8
// CHECK-64-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP13:%.*]] = getelementptr double, double* [[TMP11]], i64 1
// CHECK-64-NEXT:    [[TMP14:%.*]] = bitcast double* [[TMP13]] to i8*
// CHECK-64-NEXT:    [[TMP15:%.*]] = bitcast double* [[TMP11]] to i64*
// CHECK-64-NEXT:    [[TMP16:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i64*
// CHECK-64-NEXT:    [[TMP17:%.*]] = load i64, i64* [[TMP15]], align 8
// CHECK-64-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-64-NEXT:    [[TMP19:%.*]] = trunc i32 [[TMP18]] to i16
// CHECK-64-NEXT:    [[TMP20:%.*]] = call i64 @__kmpc_shuffle_int64(i64 [[TMP17]], i16 [[TMP7]], i16 [[TMP19]])
// CHECK-64-NEXT:    store i64 [[TMP20]], i64* [[TMP16]], align 8
// CHECK-64-NEXT:    [[TMP21:%.*]] = getelementptr i64, i64* [[TMP15]], i64 1
// CHECK-64-NEXT:    [[TMP22:%.*]] = getelementptr i64, i64* [[TMP16]], i64 1
// CHECK-64-NEXT:    [[TMP23:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP23]], i8** [[TMP12]], align 8
// CHECK-64-NEXT:    [[TMP24:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-64-NEXT:    [[TMP25:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP26:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP27:%.*]] = and i1 [[TMP25]], [[TMP26]]
// CHECK-64-NEXT:    [[TMP28:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-64-NEXT:    [[TMP29:%.*]] = and i16 [[TMP6]], 1
// CHECK-64-NEXT:    [[TMP30:%.*]] = icmp eq i16 [[TMP29]], 0
// CHECK-64-NEXT:    [[TMP31:%.*]] = and i1 [[TMP28]], [[TMP30]]
// CHECK-64-NEXT:    [[TMP32:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-64-NEXT:    [[TMP33:%.*]] = and i1 [[TMP31]], [[TMP32]]
// CHECK-64-NEXT:    [[TMP34:%.*]] = or i1 [[TMP24]], [[TMP27]]
// CHECK-64-NEXT:    [[TMP35:%.*]] = or i1 [[TMP34]], [[TMP33]]
// CHECK-64-NEXT:    br i1 [[TMP35]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP36:%.*]] = bitcast [1 x i8*]* [[TMP5]] to i8*
// CHECK-64-NEXT:    [[TMP37:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-64-NEXT:    call void @"_omp$reduction$reduction_func"(i8* [[TMP36]], i8* [[TMP37]]) #[[ATTR3:[0-9]+]]
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP39:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-64-NEXT:    br i1 [[TMP40]], label [[THEN4:%.*]], label [[ELSE5:%.*]]
// CHECK-64:       then4:
// CHECK-64-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to double**
// CHECK-64-NEXT:    [[TMP43:%.*]] = load double*, double** [[TMP42]], align 8
// CHECK-64-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP45:%.*]] = bitcast i8** [[TMP44]] to double**
// CHECK-64-NEXT:    [[TMP46:%.*]] = load double*, double** [[TMP45]], align 8
// CHECK-64-NEXT:    [[TMP47:%.*]] = load double, double* [[TMP43]], align 8
// CHECK-64-NEXT:    store double [[TMP47]], double* [[TMP46]], align 8
// CHECK-64-NEXT:    br label [[IFCONT6:%.*]]
// CHECK-64:       else5:
// CHECK-64-NEXT:    br label [[IFCONT6]]
// CHECK-64:       ifcont6:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[DOTCNT_ADDR:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-64-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [1 x i8*]*
// CHECK-64-NEXT:    store i32 0, i32* [[DOTCNT_ADDR]], align 4
// CHECK-64-NEXT:    br label [[PRECOND:%.*]]
// CHECK-64:       precond:
// CHECK-64-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCNT_ADDR]], align 4
// CHECK-64-NEXT:    [[TMP9:%.*]] = icmp ult i32 [[TMP8]], 2
// CHECK-64-NEXT:    br i1 [[TMP9]], label [[BODY:%.*]], label [[EXIT:%.*]]
// CHECK-64:       body:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-64-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP11:%.*]] = load i8*, i8** [[TMP10]], align 8
// CHECK-64-NEXT:    [[TMP12:%.*]] = bitcast i8* [[TMP11]] to i32*
// CHECK-64-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP12]], i32 [[TMP8]]
// CHECK-64-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-64-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK-64-NEXT:    store volatile i32 [[TMP15]], i32 addrspace(3)* [[TMP14]], align 4
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP16]]
// CHECK-64-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-64:       then2:
// CHECK-64-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-64-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP19:%.*]] = load i8*, i8** [[TMP18]], align 8
// CHECK-64-NEXT:    [[TMP20:%.*]] = bitcast i8* [[TMP19]] to i32*
// CHECK-64-NEXT:    [[TMP21:%.*]] = getelementptr i32, i32* [[TMP20]], i32 [[TMP8]]
// CHECK-64-NEXT:    [[TMP22:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP17]], align 4
// CHECK-64-NEXT:    store i32 [[TMP22]], i32* [[TMP21]], align 4
// CHECK-64-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-64:       else3:
// CHECK-64-NEXT:    br label [[IFCONT4]]
// CHECK-64:       ifcont4:
// CHECK-64-NEXT:    [[TMP23:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK-64-NEXT:    store i32 [[TMP23]], i32* [[DOTCNT_ADDR]], align 4
// CHECK-64-NEXT:    br label [[PRECOND]]
// CHECK-64:       exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l29
// CHECK-64-SAME: (i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 8
// CHECK-64-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[TMP4]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP6:%.*]] = bitcast float* [[TMP1]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP6]], i8** [[TMP5]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-64-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i8*, float*)* @__omp_outlined__1 to i8*), i8* null, i8** [[TMP7]], i64 2)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@__omp_outlined__1
// CHECK-64-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK-64-NEXT:    [[C1:%.*]] = alloca i8, align 1
// CHECK-64-NEXT:    [[D2:%.*]] = alloca float, align 4
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 8
// CHECK-64-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK-64-NEXT:    store i8 0, i8* [[C1]], align 1
// CHECK-64-NEXT:    store float 1.000000e+00, float* [[D2]], align 4
// CHECK-64-NEXT:    [[TMP2:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-64-NEXT:    [[CONV:%.*]] = sext i8 [[TMP2]] to i32
// CHECK-64-NEXT:    [[XOR:%.*]] = xor i32 [[CONV]], 2
// CHECK-64-NEXT:    [[CONV3:%.*]] = trunc i32 [[XOR]] to i8
// CHECK-64-NEXT:    store i8 [[CONV3]], i8* [[C1]], align 1
// CHECK-64-NEXT:    [[TMP3:%.*]] = load float, float* [[D2]], align 4
// CHECK-64-NEXT:    [[MUL:%.*]] = fmul float [[TMP3]], 3.300000e+01
// CHECK-64-NEXT:    store float [[MUL]], float* [[D2]], align 4
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK-64-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    store i8* [[C1]], i8** [[TMP6]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP8:%.*]] = bitcast float* [[D2]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 8
// CHECK-64-NEXT:    [[TMP9:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-64-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 2, i64 16, i8* [[TMP9]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func3, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func4)
// CHECK-64-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], 1
// CHECK-64-NEXT:    br i1 [[TMP11]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-64:       .omp.reduction.then:
// CHECK-64-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP0]], align 1
// CHECK-64-NEXT:    [[CONV4:%.*]] = sext i8 [[TMP12]] to i32
// CHECK-64-NEXT:    [[TMP13:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-64-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-64-NEXT:    [[XOR6:%.*]] = xor i32 [[CONV4]], [[CONV5]]
// CHECK-64-NEXT:    [[CONV7:%.*]] = trunc i32 [[XOR6]] to i8
// CHECK-64-NEXT:    store i8 [[CONV7]], i8* [[TMP0]], align 1
// CHECK-64-NEXT:    [[TMP14:%.*]] = load float, float* [[TMP1]], align 4
// CHECK-64-NEXT:    [[TMP15:%.*]] = load float, float* [[D2]], align 4
// CHECK-64-NEXT:    [[MUL8:%.*]] = fmul float [[TMP14]], [[TMP15]]
// CHECK-64-NEXT:    store float [[MUL8]], float* [[TMP1]], align 4
// CHECK-64-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP5]])
// CHECK-64-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-64:       .omp.reduction.done:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func3
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i8, align 1
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca float, align 4
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP10:%.*]] = load i8*, i8** [[TMP9]], align 8
// CHECK-64-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP12:%.*]] = getelementptr i8, i8* [[TMP10]], i64 1
// CHECK-64-NEXT:    [[TMP13:%.*]] = load i8, i8* [[TMP10]], align 1
// CHECK-64-NEXT:    [[TMP14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-64-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-64-NEXT:    [[TMP16:%.*]] = trunc i32 [[TMP15]] to i16
// CHECK-64-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP14]], i16 [[TMP7]], i16 [[TMP16]])
// CHECK-64-NEXT:    [[TMP18:%.*]] = trunc i32 [[TMP17]] to i8
// CHECK-64-NEXT:    store i8 [[TMP18]], i8* [[DOTOMP_REDUCTION_ELEMENT]], align 1
// CHECK-64-NEXT:    [[TMP19:%.*]] = getelementptr i8, i8* [[TMP10]], i64 1
// CHECK-64-NEXT:    [[TMP20:%.*]] = getelementptr i8, i8* [[DOTOMP_REDUCTION_ELEMENT]], i64 1
// CHECK-64-NEXT:    store i8* [[DOTOMP_REDUCTION_ELEMENT]], i8** [[TMP11]], align 8
// CHECK-64-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK-64-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP22]], align 8
// CHECK-64-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP25:%.*]] = getelementptr float, float* [[TMP23]], i64 1
// CHECK-64-NEXT:    [[TMP26:%.*]] = bitcast float* [[TMP25]] to i8*
// CHECK-64-NEXT:    [[TMP27:%.*]] = bitcast float* [[TMP23]] to i32*
// CHECK-64-NEXT:    [[TMP28:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i32*
// CHECK-64-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK-64-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-64-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-64-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-64-NEXT:    store i32 [[TMP32]], i32* [[TMP28]], align 4
// CHECK-64-NEXT:    [[TMP33:%.*]] = getelementptr i32, i32* [[TMP27]], i64 1
// CHECK-64-NEXT:    [[TMP34:%.*]] = getelementptr i32, i32* [[TMP28]], i64 1
// CHECK-64-NEXT:    [[TMP35:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP35]], i8** [[TMP24]], align 8
// CHECK-64-NEXT:    [[TMP36:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-64-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP38:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP39:%.*]] = and i1 [[TMP37]], [[TMP38]]
// CHECK-64-NEXT:    [[TMP40:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-64-NEXT:    [[TMP41:%.*]] = and i16 [[TMP6]], 1
// CHECK-64-NEXT:    [[TMP42:%.*]] = icmp eq i16 [[TMP41]], 0
// CHECK-64-NEXT:    [[TMP43:%.*]] = and i1 [[TMP40]], [[TMP42]]
// CHECK-64-NEXT:    [[TMP44:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-64-NEXT:    [[TMP45:%.*]] = and i1 [[TMP43]], [[TMP44]]
// CHECK-64-NEXT:    [[TMP46:%.*]] = or i1 [[TMP36]], [[TMP39]]
// CHECK-64-NEXT:    [[TMP47:%.*]] = or i1 [[TMP46]], [[TMP45]]
// CHECK-64-NEXT:    br i1 [[TMP47]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP48:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-64-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-64-NEXT:    call void @"_omp$reduction$reduction_func2"(i8* [[TMP48]], i8* [[TMP49]]) #[[ATTR3]]
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    [[TMP50:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP51:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP52:%.*]] = and i1 [[TMP50]], [[TMP51]]
// CHECK-64-NEXT:    br i1 [[TMP52]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-64:       then5:
// CHECK-64-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP54:%.*]] = load i8*, i8** [[TMP53]], align 8
// CHECK-64-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP56:%.*]] = load i8*, i8** [[TMP55]], align 8
// CHECK-64-NEXT:    [[TMP57:%.*]] = load i8, i8* [[TMP54]], align 1
// CHECK-64-NEXT:    store i8 [[TMP57]], i8* [[TMP56]], align 1
// CHECK-64-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP59:%.*]] = bitcast i8** [[TMP58]] to float**
// CHECK-64-NEXT:    [[TMP60:%.*]] = load float*, float** [[TMP59]], align 8
// CHECK-64-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to float**
// CHECK-64-NEXT:    [[TMP63:%.*]] = load float*, float** [[TMP62]], align 8
// CHECK-64-NEXT:    [[TMP64:%.*]] = load float, float* [[TMP60]], align 4
// CHECK-64-NEXT:    store float [[TMP64]], float* [[TMP63]], align 4
// CHECK-64-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-64:       else6:
// CHECK-64-NEXT:    br label [[IFCONT7]]
// CHECK-64:       ifcont7:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func4
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-64-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-64-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 8
// CHECK-64-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-64-NEXT:    [[TMP11:%.*]] = bitcast i32 addrspace(3)* [[TMP10]] to i8 addrspace(3)*
// CHECK-64-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP9]], align 1
// CHECK-64-NEXT:    store volatile i8 [[TMP12]], i8 addrspace(3)* [[TMP11]], align 1
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-64-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-64:       then2:
// CHECK-64-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-64-NEXT:    [[TMP15:%.*]] = bitcast i32 addrspace(3)* [[TMP14]] to i8 addrspace(3)*
// CHECK-64-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP17:%.*]] = load i8*, i8** [[TMP16]], align 8
// CHECK-64-NEXT:    [[TMP18:%.*]] = load volatile i8, i8 addrspace(3)* [[TMP15]], align 1
// CHECK-64-NEXT:    store i8 [[TMP18]], i8* [[TMP17]], align 1
// CHECK-64-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-64:       else3:
// CHECK-64-NEXT:    br label [[IFCONT4]]
// CHECK-64:       ifcont4:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-64-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-64:       then6:
// CHECK-64-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 8
// CHECK-64-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i32*
// CHECK-64-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-64-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK-64-NEXT:    store volatile i32 [[TMP23]], i32 addrspace(3)* [[TMP22]], align 4
// CHECK-64-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-64:       else7:
// CHECK-64-NEXT:    br label [[IFCONT8]]
// CHECK-64:       ifcont8:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP24]]
// CHECK-64-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-64:       then10:
// CHECK-64-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-64-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP27:%.*]] = load i8*, i8** [[TMP26]], align 8
// CHECK-64-NEXT:    [[TMP28:%.*]] = bitcast i8* [[TMP27]] to i32*
// CHECK-64-NEXT:    [[TMP29:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP25]], align 4
// CHECK-64-NEXT:    store i32 [[TMP29]], i32* [[TMP28]], align 4
// CHECK-64-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-64:       else11:
// CHECK-64-NEXT:    br label [[IFCONT12]]
// CHECK-64:       ifcont12:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l35
// CHECK-64-SAME: (i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR0]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK-64-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 8
// CHECK-64-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP7:%.*]] = bitcast i16* [[TMP1]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP7]], i8** [[TMP6]], align 8
// CHECK-64-NEXT:    [[TMP8:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-64-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i32*, i16*)* @__omp_outlined__5 to i8*), i8* null, i8** [[TMP8]], i64 2)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@__omp_outlined__5
// CHECK-64-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR1]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK-64-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 8
// CHECK-64-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[B2:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK-64-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 8
// CHECK-64-NEXT:    store i32 0, i32* [[A1]], align 4
// CHECK-64-NEXT:    store i16 -32768, i16* [[B2]], align 2
// CHECK-64-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-64-NEXT:    [[OR:%.*]] = or i32 [[TMP2]], 1
// CHECK-64-NEXT:    store i32 [[OR]], i32* [[A1]], align 4
// CHECK-64-NEXT:    [[TMP3:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-64-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK-64-NEXT:    [[CMP:%.*]] = icmp sgt i32 99, [[CONV]]
// CHECK-64-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK-64:       cond.true:
// CHECK-64-NEXT:    br label [[COND_END:%.*]]
// CHECK-64:       cond.false:
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-64-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP4]] to i32
// CHECK-64-NEXT:    br label [[COND_END]]
// CHECK-64:       cond.end:
// CHECK-64-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[CONV3]], [[COND_FALSE]] ]
// CHECK-64-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
// CHECK-64-NEXT:    store i16 [[CONV4]], i16* [[B2]], align 2
// CHECK-64-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK-64-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP8:%.*]] = bitcast i32* [[A1]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 8
// CHECK-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP10:%.*]] = bitcast i16* [[B2]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP10]], i8** [[TMP9]], align 8
// CHECK-64-NEXT:    [[TMP11:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-64-NEXT:    [[TMP12:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]], i32 2, i64 16, i8* [[TMP11]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func7, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func8)
// CHECK-64-NEXT:    [[TMP13:%.*]] = icmp eq i32 [[TMP12]], 1
// CHECK-64-NEXT:    br i1 [[TMP13]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-64:       .omp.reduction.then:
// CHECK-64-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK-64-NEXT:    [[TMP15:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-64-NEXT:    [[OR5:%.*]] = or i32 [[TMP14]], [[TMP15]]
// CHECK-64-NEXT:    store i32 [[OR5]], i32* [[TMP0]], align 4
// CHECK-64-NEXT:    [[TMP16:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-64-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP16]] to i32
// CHECK-64-NEXT:    [[TMP17:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-64-NEXT:    [[CONV7:%.*]] = sext i16 [[TMP17]] to i32
// CHECK-64-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[CONV6]], [[CONV7]]
// CHECK-64-NEXT:    br i1 [[CMP8]], label [[COND_TRUE9:%.*]], label [[COND_FALSE10:%.*]]
// CHECK-64:       cond.true9:
// CHECK-64-NEXT:    [[TMP18:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-64-NEXT:    br label [[COND_END11:%.*]]
// CHECK-64:       cond.false10:
// CHECK-64-NEXT:    [[TMP19:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-64-NEXT:    br label [[COND_END11]]
// CHECK-64:       cond.end11:
// CHECK-64-NEXT:    [[COND12:%.*]] = phi i16 [ [[TMP18]], [[COND_TRUE9]] ], [ [[TMP19]], [[COND_FALSE10]] ]
// CHECK-64-NEXT:    store i16 [[COND12]], i16* [[TMP1]], align 2
// CHECK-64-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP6]])
// CHECK-64-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-64:       .omp.reduction.done:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func7
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 8
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca i16, align 2
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-64-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-64-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-64-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[TMP10]], align 8
// CHECK-64-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP11]], i64 1
// CHECK-64-NEXT:    [[TMP14:%.*]] = bitcast i32* [[TMP13]] to i8*
// CHECK-64-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK-64-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-64-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
// CHECK-64-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP15]], i16 [[TMP7]], i16 [[TMP17]])
// CHECK-64-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_REDUCTION_ELEMENT]], align 4
// CHECK-64-NEXT:    [[TMP19:%.*]] = getelementptr i32, i32* [[TMP11]], i64 1
// CHECK-64-NEXT:    [[TMP20:%.*]] = getelementptr i32, i32* [[DOTOMP_REDUCTION_ELEMENT]], i64 1
// CHECK-64-NEXT:    [[TMP21:%.*]] = bitcast i32* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP21]], i8** [[TMP12]], align 8
// CHECK-64-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i16**
// CHECK-64-NEXT:    [[TMP24:%.*]] = load i16*, i16** [[TMP23]], align 8
// CHECK-64-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP26:%.*]] = getelementptr i16, i16* [[TMP24]], i64 1
// CHECK-64-NEXT:    [[TMP27:%.*]] = bitcast i16* [[TMP26]] to i8*
// CHECK-64-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP24]], align 2
// CHECK-64-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
// CHECK-64-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-64-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-64-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-64-NEXT:    [[TMP33:%.*]] = trunc i32 [[TMP32]] to i16
// CHECK-64-NEXT:    store i16 [[TMP33]], i16* [[DOTOMP_REDUCTION_ELEMENT4]], align 2
// CHECK-64-NEXT:    [[TMP34:%.*]] = getelementptr i16, i16* [[TMP24]], i64 1
// CHECK-64-NEXT:    [[TMP35:%.*]] = getelementptr i16, i16* [[DOTOMP_REDUCTION_ELEMENT4]], i64 1
// CHECK-64-NEXT:    [[TMP36:%.*]] = bitcast i16* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-64-NEXT:    store i8* [[TMP36]], i8** [[TMP25]], align 8
// CHECK-64-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-64-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP39:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-64-NEXT:    [[TMP41:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-64-NEXT:    [[TMP42:%.*]] = and i16 [[TMP6]], 1
// CHECK-64-NEXT:    [[TMP43:%.*]] = icmp eq i16 [[TMP42]], 0
// CHECK-64-NEXT:    [[TMP44:%.*]] = and i1 [[TMP41]], [[TMP43]]
// CHECK-64-NEXT:    [[TMP45:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-64-NEXT:    [[TMP46:%.*]] = and i1 [[TMP44]], [[TMP45]]
// CHECK-64-NEXT:    [[TMP47:%.*]] = or i1 [[TMP37]], [[TMP40]]
// CHECK-64-NEXT:    [[TMP48:%.*]] = or i1 [[TMP47]], [[TMP46]]
// CHECK-64-NEXT:    br i1 [[TMP48]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-64-NEXT:    [[TMP50:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-64-NEXT:    call void @"_omp$reduction$reduction_func6"(i8* [[TMP49]], i8* [[TMP50]]) #[[ATTR3]]
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    [[TMP51:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-64-NEXT:    [[TMP52:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-64-NEXT:    [[TMP53:%.*]] = and i1 [[TMP51]], [[TMP52]]
// CHECK-64-NEXT:    br i1 [[TMP53]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-64:       then5:
// CHECK-64-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP55:%.*]] = bitcast i8** [[TMP54]] to i32**
// CHECK-64-NEXT:    [[TMP56:%.*]] = load i32*, i32** [[TMP55]], align 8
// CHECK-64-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP58:%.*]] = bitcast i8** [[TMP57]] to i32**
// CHECK-64-NEXT:    [[TMP59:%.*]] = load i32*, i32** [[TMP58]], align 8
// CHECK-64-NEXT:    [[TMP60:%.*]] = load i32, i32* [[TMP56]], align 4
// CHECK-64-NEXT:    store i32 [[TMP60]], i32* [[TMP59]], align 4
// CHECK-64-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i16**
// CHECK-64-NEXT:    [[TMP63:%.*]] = load i16*, i16** [[TMP62]], align 8
// CHECK-64-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i16**
// CHECK-64-NEXT:    [[TMP66:%.*]] = load i16*, i16** [[TMP65]], align 8
// CHECK-64-NEXT:    [[TMP67:%.*]] = load i16, i16* [[TMP63]], align 2
// CHECK-64-NEXT:    store i16 [[TMP67]], i16* [[TMP66]], align 2
// CHECK-64-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-64:       else6:
// CHECK-64-NEXT:    br label [[IFCONT7]]
// CHECK-64:       ifcont7:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func8
// CHECK-64-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 8
// CHECK-64-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-64-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-64-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-64-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-64:       then:
// CHECK-64-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 8
// CHECK-64-NEXT:    [[TMP10:%.*]] = bitcast i8* [[TMP9]] to i32*
// CHECK-64-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-64-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK-64-NEXT:    store volatile i32 [[TMP12]], i32 addrspace(3)* [[TMP11]], align 4
// CHECK-64-NEXT:    br label [[IFCONT:%.*]]
// CHECK-64:       else:
// CHECK-64-NEXT:    br label [[IFCONT]]
// CHECK-64:       ifcont:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-64-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-64:       then2:
// CHECK-64-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-64-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[TMP15]], align 8
// CHECK-64-NEXT:    [[TMP17:%.*]] = bitcast i8* [[TMP16]] to i32*
// CHECK-64-NEXT:    [[TMP18:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP14]], align 4
// CHECK-64-NEXT:    store i32 [[TMP18]], i32* [[TMP17]], align 4
// CHECK-64-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-64:       else3:
// CHECK-64-NEXT:    br label [[IFCONT4]]
// CHECK-64:       ifcont4:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-64-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-64:       then6:
// CHECK-64-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 8
// CHECK-64-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i16*
// CHECK-64-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-64-NEXT:    [[TMP23:%.*]] = bitcast i32 addrspace(3)* [[TMP22]] to i16 addrspace(3)*
// CHECK-64-NEXT:    [[TMP24:%.*]] = load i16, i16* [[TMP21]], align 2
// CHECK-64-NEXT:    store volatile i16 [[TMP24]], i16 addrspace(3)* [[TMP23]], align 2
// CHECK-64-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-64:       else7:
// CHECK-64-NEXT:    br label [[IFCONT8]]
// CHECK-64:       ifcont8:
// CHECK-64-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-64-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-64-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP25]]
// CHECK-64-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-64:       then10:
// CHECK-64-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-64-NEXT:    [[TMP27:%.*]] = bitcast i32 addrspace(3)* [[TMP26]] to i16 addrspace(3)*
// CHECK-64-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP29:%.*]] = load i8*, i8** [[TMP28]], align 8
// CHECK-64-NEXT:    [[TMP30:%.*]] = bitcast i8* [[TMP29]] to i16*
// CHECK-64-NEXT:    [[TMP31:%.*]] = load volatile i16, i16 addrspace(3)* [[TMP27]], align 2
// CHECK-64-NEXT:    store i16 [[TMP31]], i16* [[TMP30]], align 2
// CHECK-64-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-64:       else11:
// CHECK-64-NEXT:    br label [[IFCONT12]]
// CHECK-64:       ifcont12:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l24
// CHECK-32-SAME: (double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-NEXT:    store double* [[E]], double** [[E_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1:[0-9]+]], i8 2, i1 false)
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP4:%.*]] = bitcast double* [[TMP0]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP4]], i8** [[TMP3]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast [1 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, double*)* @__omp_outlined__ to i8*), i8* null, i8** [[TMP5]], i32 1)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@__omp_outlined__
// CHECK-32-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 4
// CHECK-32-NEXT:    [[E1:%.*]] = alloca double, align 8
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    store double* [[E]], double** [[E_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 4
// CHECK-32-NEXT:    store double 0.000000e+00, double* [[E1]], align 8
// CHECK-32-NEXT:    [[TMP1:%.*]] = load double, double* [[E1]], align 8
// CHECK-32-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], 5.000000e+00
// CHECK-32-NEXT:    store double [[ADD]], double* [[E1]], align 8
// CHECK-32-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK-32-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast double* [[E1]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 4
// CHECK-32-NEXT:    [[TMP6:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-NEXT:    [[TMP7:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 4, i8* [[TMP6]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func)
// CHECK-32-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[TMP7]], 1
// CHECK-32-NEXT:    br i1 [[TMP8]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32:       .omp.reduction.then:
// CHECK-32-NEXT:    [[TMP9:%.*]] = load double, double* [[TMP0]], align 8
// CHECK-32-NEXT:    [[TMP10:%.*]] = load double, double* [[E1]], align 8
// CHECK-32-NEXT:    [[ADD2:%.*]] = fadd double [[TMP9]], [[TMP10]]
// CHECK-32-NEXT:    store double [[ADD2]], double* [[TMP0]], align 8
// CHECK-32-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP3]])
// CHECK-32-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32:       .omp.reduction.done:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca double, align 8
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [1 x i8*]*
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to double**
// CHECK-32-NEXT:    [[TMP11:%.*]] = load double*, double** [[TMP10]], align 4
// CHECK-32-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP13:%.*]] = getelementptr double, double* [[TMP11]], i32 1
// CHECK-32-NEXT:    [[TMP14:%.*]] = bitcast double* [[TMP13]] to i8*
// CHECK-32-NEXT:    [[TMP15:%.*]] = bitcast double* [[TMP11]] to i64*
// CHECK-32-NEXT:    [[TMP16:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i64*
// CHECK-32-NEXT:    [[TMP17:%.*]] = load i64, i64* [[TMP15]], align 8
// CHECK-32-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-NEXT:    [[TMP19:%.*]] = trunc i32 [[TMP18]] to i16
// CHECK-32-NEXT:    [[TMP20:%.*]] = call i64 @__kmpc_shuffle_int64(i64 [[TMP17]], i16 [[TMP7]], i16 [[TMP19]])
// CHECK-32-NEXT:    store i64 [[TMP20]], i64* [[TMP16]], align 8
// CHECK-32-NEXT:    [[TMP21:%.*]] = getelementptr i64, i64* [[TMP15]], i32 1
// CHECK-32-NEXT:    [[TMP22:%.*]] = getelementptr i64, i64* [[TMP16]], i32 1
// CHECK-32-NEXT:    [[TMP23:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP23]], i8** [[TMP12]], align 4
// CHECK-32-NEXT:    [[TMP24:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-NEXT:    [[TMP25:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP26:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP27:%.*]] = and i1 [[TMP25]], [[TMP26]]
// CHECK-32-NEXT:    [[TMP28:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-NEXT:    [[TMP29:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-NEXT:    [[TMP30:%.*]] = icmp eq i16 [[TMP29]], 0
// CHECK-32-NEXT:    [[TMP31:%.*]] = and i1 [[TMP28]], [[TMP30]]
// CHECK-32-NEXT:    [[TMP32:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-NEXT:    [[TMP33:%.*]] = and i1 [[TMP31]], [[TMP32]]
// CHECK-32-NEXT:    [[TMP34:%.*]] = or i1 [[TMP24]], [[TMP27]]
// CHECK-32-NEXT:    [[TMP35:%.*]] = or i1 [[TMP34]], [[TMP33]]
// CHECK-32-NEXT:    br i1 [[TMP35]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP36:%.*]] = bitcast [1 x i8*]* [[TMP5]] to i8*
// CHECK-32-NEXT:    [[TMP37:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-NEXT:    call void @"_omp$reduction$reduction_func"(i8* [[TMP36]], i8* [[TMP37]]) #[[ATTR3:[0-9]+]]
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP39:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-32-NEXT:    br i1 [[TMP40]], label [[THEN4:%.*]], label [[ELSE5:%.*]]
// CHECK-32:       then4:
// CHECK-32-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to double**
// CHECK-32-NEXT:    [[TMP43:%.*]] = load double*, double** [[TMP42]], align 4
// CHECK-32-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP45:%.*]] = bitcast i8** [[TMP44]] to double**
// CHECK-32-NEXT:    [[TMP46:%.*]] = load double*, double** [[TMP45]], align 4
// CHECK-32-NEXT:    [[TMP47:%.*]] = load double, double* [[TMP43]], align 8
// CHECK-32-NEXT:    store double [[TMP47]], double* [[TMP46]], align 8
// CHECK-32-NEXT:    br label [[IFCONT6:%.*]]
// CHECK-32:       else5:
// CHECK-32-NEXT:    br label [[IFCONT6]]
// CHECK-32:       ifcont6:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[DOTCNT_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [1 x i8*]*
// CHECK-32-NEXT:    store i32 0, i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-NEXT:    br label [[PRECOND:%.*]]
// CHECK-32:       precond:
// CHECK-32-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP9:%.*]] = icmp ult i32 [[TMP8]], 2
// CHECK-32-NEXT:    br i1 [[TMP9]], label [[BODY:%.*]], label [[EXIT:%.*]]
// CHECK-32:       body:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP11:%.*]] = load i8*, i8** [[TMP10]], align 4
// CHECK-32-NEXT:    [[TMP12:%.*]] = bitcast i8* [[TMP11]] to i32*
// CHECK-32-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP12]], i32 [[TMP8]]
// CHECK-32-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK-32-NEXT:    store volatile i32 [[TMP15]], i32 addrspace(3)* [[TMP14]], align 4
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP16]]
// CHECK-32-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32:       then2:
// CHECK-32-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP19:%.*]] = load i8*, i8** [[TMP18]], align 4
// CHECK-32-NEXT:    [[TMP20:%.*]] = bitcast i8* [[TMP19]] to i32*
// CHECK-32-NEXT:    [[TMP21:%.*]] = getelementptr i32, i32* [[TMP20]], i32 [[TMP8]]
// CHECK-32-NEXT:    [[TMP22:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP17]], align 4
// CHECK-32-NEXT:    store i32 [[TMP22]], i32* [[TMP21]], align 4
// CHECK-32-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32:       else3:
// CHECK-32-NEXT:    br label [[IFCONT4]]
// CHECK-32:       ifcont4:
// CHECK-32-NEXT:    [[TMP23:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK-32-NEXT:    store i32 [[TMP23]], i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-NEXT:    br label [[PRECOND]]
// CHECK-32:       exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l29
// CHECK-32-SAME: (i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 4
// CHECK-32-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[TMP4]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP6:%.*]] = bitcast float* [[TMP1]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP6]], i8** [[TMP5]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i8*, float*)* @__omp_outlined__1 to i8*), i8* null, i8** [[TMP7]], i32 2)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@__omp_outlined__1
// CHECK-32-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK-32-NEXT:    [[C1:%.*]] = alloca i8, align 1
// CHECK-32-NEXT:    [[D2:%.*]] = alloca float, align 4
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 4
// CHECK-32-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK-32-NEXT:    store i8 0, i8* [[C1]], align 1
// CHECK-32-NEXT:    store float 1.000000e+00, float* [[D2]], align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-32-NEXT:    [[CONV:%.*]] = sext i8 [[TMP2]] to i32
// CHECK-32-NEXT:    [[XOR:%.*]] = xor i32 [[CONV]], 2
// CHECK-32-NEXT:    [[CONV3:%.*]] = trunc i32 [[XOR]] to i8
// CHECK-32-NEXT:    store i8 [[CONV3]], i8* [[C1]], align 1
// CHECK-32-NEXT:    [[TMP3:%.*]] = load float, float* [[D2]], align 4
// CHECK-32-NEXT:    [[MUL:%.*]] = fmul float [[TMP3]], 3.300000e+01
// CHECK-32-NEXT:    store float [[MUL]], float* [[D2]], align 4
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK-32-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    store i8* [[C1]], i8** [[TMP6]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP8:%.*]] = bitcast float* [[D2]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 4
// CHECK-32-NEXT:    [[TMP9:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 2, i32 8, i8* [[TMP9]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func3, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func4)
// CHECK-32-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], 1
// CHECK-32-NEXT:    br i1 [[TMP11]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32:       .omp.reduction.then:
// CHECK-32-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP0]], align 1
// CHECK-32-NEXT:    [[CONV4:%.*]] = sext i8 [[TMP12]] to i32
// CHECK-32-NEXT:    [[TMP13:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-32-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-32-NEXT:    [[XOR6:%.*]] = xor i32 [[CONV4]], [[CONV5]]
// CHECK-32-NEXT:    [[CONV7:%.*]] = trunc i32 [[XOR6]] to i8
// CHECK-32-NEXT:    store i8 [[CONV7]], i8* [[TMP0]], align 1
// CHECK-32-NEXT:    [[TMP14:%.*]] = load float, float* [[TMP1]], align 4
// CHECK-32-NEXT:    [[TMP15:%.*]] = load float, float* [[D2]], align 4
// CHECK-32-NEXT:    [[MUL8:%.*]] = fmul float [[TMP14]], [[TMP15]]
// CHECK-32-NEXT:    store float [[MUL8]], float* [[TMP1]], align 4
// CHECK-32-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP5]])
// CHECK-32-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32:       .omp.reduction.done:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func3
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i8, align 1
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca float, align 4
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP10:%.*]] = load i8*, i8** [[TMP9]], align 4
// CHECK-32-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP12:%.*]] = getelementptr i8, i8* [[TMP10]], i32 1
// CHECK-32-NEXT:    [[TMP13:%.*]] = load i8, i8* [[TMP10]], align 1
// CHECK-32-NEXT:    [[TMP14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-32-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-NEXT:    [[TMP16:%.*]] = trunc i32 [[TMP15]] to i16
// CHECK-32-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP14]], i16 [[TMP7]], i16 [[TMP16]])
// CHECK-32-NEXT:    [[TMP18:%.*]] = trunc i32 [[TMP17]] to i8
// CHECK-32-NEXT:    store i8 [[TMP18]], i8* [[DOTOMP_REDUCTION_ELEMENT]], align 1
// CHECK-32-NEXT:    [[TMP19:%.*]] = getelementptr i8, i8* [[TMP10]], i32 1
// CHECK-32-NEXT:    [[TMP20:%.*]] = getelementptr i8, i8* [[DOTOMP_REDUCTION_ELEMENT]], i32 1
// CHECK-32-NEXT:    store i8* [[DOTOMP_REDUCTION_ELEMENT]], i8** [[TMP11]], align 4
// CHECK-32-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK-32-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP22]], align 4
// CHECK-32-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP25:%.*]] = getelementptr float, float* [[TMP23]], i32 1
// CHECK-32-NEXT:    [[TMP26:%.*]] = bitcast float* [[TMP25]] to i8*
// CHECK-32-NEXT:    [[TMP27:%.*]] = bitcast float* [[TMP23]] to i32*
// CHECK-32-NEXT:    [[TMP28:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i32*
// CHECK-32-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK-32-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-32-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-32-NEXT:    store i32 [[TMP32]], i32* [[TMP28]], align 4
// CHECK-32-NEXT:    [[TMP33:%.*]] = getelementptr i32, i32* [[TMP27]], i32 1
// CHECK-32-NEXT:    [[TMP34:%.*]] = getelementptr i32, i32* [[TMP28]], i32 1
// CHECK-32-NEXT:    [[TMP35:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP35]], i8** [[TMP24]], align 4
// CHECK-32-NEXT:    [[TMP36:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP38:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP39:%.*]] = and i1 [[TMP37]], [[TMP38]]
// CHECK-32-NEXT:    [[TMP40:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-NEXT:    [[TMP41:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-NEXT:    [[TMP42:%.*]] = icmp eq i16 [[TMP41]], 0
// CHECK-32-NEXT:    [[TMP43:%.*]] = and i1 [[TMP40]], [[TMP42]]
// CHECK-32-NEXT:    [[TMP44:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-NEXT:    [[TMP45:%.*]] = and i1 [[TMP43]], [[TMP44]]
// CHECK-32-NEXT:    [[TMP46:%.*]] = or i1 [[TMP36]], [[TMP39]]
// CHECK-32-NEXT:    [[TMP47:%.*]] = or i1 [[TMP46]], [[TMP45]]
// CHECK-32-NEXT:    br i1 [[TMP47]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP48:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-32-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-NEXT:    call void @"_omp$reduction$reduction_func2"(i8* [[TMP48]], i8* [[TMP49]]) #[[ATTR3]]
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    [[TMP50:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP51:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP52:%.*]] = and i1 [[TMP50]], [[TMP51]]
// CHECK-32-NEXT:    br i1 [[TMP52]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-32:       then5:
// CHECK-32-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP54:%.*]] = load i8*, i8** [[TMP53]], align 4
// CHECK-32-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP56:%.*]] = load i8*, i8** [[TMP55]], align 4
// CHECK-32-NEXT:    [[TMP57:%.*]] = load i8, i8* [[TMP54]], align 1
// CHECK-32-NEXT:    store i8 [[TMP57]], i8* [[TMP56]], align 1
// CHECK-32-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP59:%.*]] = bitcast i8** [[TMP58]] to float**
// CHECK-32-NEXT:    [[TMP60:%.*]] = load float*, float** [[TMP59]], align 4
// CHECK-32-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to float**
// CHECK-32-NEXT:    [[TMP63:%.*]] = load float*, float** [[TMP62]], align 4
// CHECK-32-NEXT:    [[TMP64:%.*]] = load float, float* [[TMP60]], align 4
// CHECK-32-NEXT:    store float [[TMP64]], float* [[TMP63]], align 4
// CHECK-32-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-32:       else6:
// CHECK-32-NEXT:    br label [[IFCONT7]]
// CHECK-32:       ifcont7:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func4
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 4
// CHECK-32-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-NEXT:    [[TMP11:%.*]] = bitcast i32 addrspace(3)* [[TMP10]] to i8 addrspace(3)*
// CHECK-32-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP9]], align 1
// CHECK-32-NEXT:    store volatile i8 [[TMP12]], i8 addrspace(3)* [[TMP11]], align 1
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-32-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32:       then2:
// CHECK-32-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-NEXT:    [[TMP15:%.*]] = bitcast i32 addrspace(3)* [[TMP14]] to i8 addrspace(3)*
// CHECK-32-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP17:%.*]] = load i8*, i8** [[TMP16]], align 4
// CHECK-32-NEXT:    [[TMP18:%.*]] = load volatile i8, i8 addrspace(3)* [[TMP15]], align 1
// CHECK-32-NEXT:    store i8 [[TMP18]], i8* [[TMP17]], align 1
// CHECK-32-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32:       else3:
// CHECK-32-NEXT:    br label [[IFCONT4]]
// CHECK-32:       ifcont4:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-32:       then6:
// CHECK-32-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 4
// CHECK-32-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i32*
// CHECK-32-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK-32-NEXT:    store volatile i32 [[TMP23]], i32 addrspace(3)* [[TMP22]], align 4
// CHECK-32-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-32:       else7:
// CHECK-32-NEXT:    br label [[IFCONT8]]
// CHECK-32:       ifcont8:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP24]]
// CHECK-32-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-32:       then10:
// CHECK-32-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP27:%.*]] = load i8*, i8** [[TMP26]], align 4
// CHECK-32-NEXT:    [[TMP28:%.*]] = bitcast i8* [[TMP27]] to i32*
// CHECK-32-NEXT:    [[TMP29:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP25]], align 4
// CHECK-32-NEXT:    store i32 [[TMP29]], i32* [[TMP28]], align 4
// CHECK-32-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-32:       else11:
// CHECK-32-NEXT:    br label [[IFCONT12]]
// CHECK-32:       ifcont12:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l35
// CHECK-32-SAME: (i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR0]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK-32-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 4
// CHECK-32-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP7:%.*]] = bitcast i16* [[TMP1]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP7]], i8** [[TMP6]], align 4
// CHECK-32-NEXT:    [[TMP8:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i32*, i16*)* @__omp_outlined__5 to i8*), i8* null, i8** [[TMP8]], i32 2)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@__omp_outlined__5
// CHECK-32-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR1]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 4
// CHECK-32-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[B2:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK-32-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 4
// CHECK-32-NEXT:    store i32 0, i32* [[A1]], align 4
// CHECK-32-NEXT:    store i16 -32768, i16* [[B2]], align 2
// CHECK-32-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-32-NEXT:    [[OR:%.*]] = or i32 [[TMP2]], 1
// CHECK-32-NEXT:    store i32 [[OR]], i32* [[A1]], align 4
// CHECK-32-NEXT:    [[TMP3:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK-32-NEXT:    [[CMP:%.*]] = icmp sgt i32 99, [[CONV]]
// CHECK-32-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK-32:       cond.true:
// CHECK-32-NEXT:    br label [[COND_END:%.*]]
// CHECK-32:       cond.false:
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP4]] to i32
// CHECK-32-NEXT:    br label [[COND_END]]
// CHECK-32:       cond.end:
// CHECK-32-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[CONV3]], [[COND_FALSE]] ]
// CHECK-32-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
// CHECK-32-NEXT:    store i16 [[CONV4]], i16* [[B2]], align 2
// CHECK-32-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP8:%.*]] = bitcast i32* [[A1]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 4
// CHECK-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP10:%.*]] = bitcast i16* [[B2]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP10]], i8** [[TMP9]], align 4
// CHECK-32-NEXT:    [[TMP11:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-NEXT:    [[TMP12:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]], i32 2, i32 8, i8* [[TMP11]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func7, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func8)
// CHECK-32-NEXT:    [[TMP13:%.*]] = icmp eq i32 [[TMP12]], 1
// CHECK-32-NEXT:    br i1 [[TMP13]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32:       .omp.reduction.then:
// CHECK-32-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK-32-NEXT:    [[TMP15:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-32-NEXT:    [[OR5:%.*]] = or i32 [[TMP14]], [[TMP15]]
// CHECK-32-NEXT:    store i32 [[OR5]], i32* [[TMP0]], align 4
// CHECK-32-NEXT:    [[TMP16:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-32-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP16]] to i32
// CHECK-32-NEXT:    [[TMP17:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-NEXT:    [[CONV7:%.*]] = sext i16 [[TMP17]] to i32
// CHECK-32-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[CONV6]], [[CONV7]]
// CHECK-32-NEXT:    br i1 [[CMP8]], label [[COND_TRUE9:%.*]], label [[COND_FALSE10:%.*]]
// CHECK-32:       cond.true9:
// CHECK-32-NEXT:    [[TMP18:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-32-NEXT:    br label [[COND_END11:%.*]]
// CHECK-32:       cond.false10:
// CHECK-32-NEXT:    [[TMP19:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-NEXT:    br label [[COND_END11]]
// CHECK-32:       cond.end11:
// CHECK-32-NEXT:    [[COND12:%.*]] = phi i16 [ [[TMP18]], [[COND_TRUE9]] ], [ [[TMP19]], [[COND_FALSE10]] ]
// CHECK-32-NEXT:    store i16 [[COND12]], i16* [[TMP1]], align 2
// CHECK-32-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP6]])
// CHECK-32-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32:       .omp.reduction.done:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func7
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca i16, align 2
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-32-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[TMP10]], align 4
// CHECK-32-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP11]], i32 1
// CHECK-32-NEXT:    [[TMP14:%.*]] = bitcast i32* [[TMP13]] to i8*
// CHECK-32-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK-32-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
// CHECK-32-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP15]], i16 [[TMP7]], i16 [[TMP17]])
// CHECK-32-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_REDUCTION_ELEMENT]], align 4
// CHECK-32-NEXT:    [[TMP19:%.*]] = getelementptr i32, i32* [[TMP11]], i32 1
// CHECK-32-NEXT:    [[TMP20:%.*]] = getelementptr i32, i32* [[DOTOMP_REDUCTION_ELEMENT]], i32 1
// CHECK-32-NEXT:    [[TMP21:%.*]] = bitcast i32* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP21]], i8** [[TMP12]], align 4
// CHECK-32-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i16**
// CHECK-32-NEXT:    [[TMP24:%.*]] = load i16*, i16** [[TMP23]], align 4
// CHECK-32-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP26:%.*]] = getelementptr i16, i16* [[TMP24]], i32 1
// CHECK-32-NEXT:    [[TMP27:%.*]] = bitcast i16* [[TMP26]] to i8*
// CHECK-32-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP24]], align 2
// CHECK-32-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
// CHECK-32-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-32-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-32-NEXT:    [[TMP33:%.*]] = trunc i32 [[TMP32]] to i16
// CHECK-32-NEXT:    store i16 [[TMP33]], i16* [[DOTOMP_REDUCTION_ELEMENT4]], align 2
// CHECK-32-NEXT:    [[TMP34:%.*]] = getelementptr i16, i16* [[TMP24]], i32 1
// CHECK-32-NEXT:    [[TMP35:%.*]] = getelementptr i16, i16* [[DOTOMP_REDUCTION_ELEMENT4]], i32 1
// CHECK-32-NEXT:    [[TMP36:%.*]] = bitcast i16* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-32-NEXT:    store i8* [[TMP36]], i8** [[TMP25]], align 4
// CHECK-32-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP39:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-32-NEXT:    [[TMP41:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-NEXT:    [[TMP42:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-NEXT:    [[TMP43:%.*]] = icmp eq i16 [[TMP42]], 0
// CHECK-32-NEXT:    [[TMP44:%.*]] = and i1 [[TMP41]], [[TMP43]]
// CHECK-32-NEXT:    [[TMP45:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-NEXT:    [[TMP46:%.*]] = and i1 [[TMP44]], [[TMP45]]
// CHECK-32-NEXT:    [[TMP47:%.*]] = or i1 [[TMP37]], [[TMP40]]
// CHECK-32-NEXT:    [[TMP48:%.*]] = or i1 [[TMP47]], [[TMP46]]
// CHECK-32-NEXT:    br i1 [[TMP48]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-32-NEXT:    [[TMP50:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-NEXT:    call void @"_omp$reduction$reduction_func6"(i8* [[TMP49]], i8* [[TMP50]]) #[[ATTR3]]
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    [[TMP51:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-NEXT:    [[TMP52:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-NEXT:    [[TMP53:%.*]] = and i1 [[TMP51]], [[TMP52]]
// CHECK-32-NEXT:    br i1 [[TMP53]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-32:       then5:
// CHECK-32-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP55:%.*]] = bitcast i8** [[TMP54]] to i32**
// CHECK-32-NEXT:    [[TMP56:%.*]] = load i32*, i32** [[TMP55]], align 4
// CHECK-32-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP58:%.*]] = bitcast i8** [[TMP57]] to i32**
// CHECK-32-NEXT:    [[TMP59:%.*]] = load i32*, i32** [[TMP58]], align 4
// CHECK-32-NEXT:    [[TMP60:%.*]] = load i32, i32* [[TMP56]], align 4
// CHECK-32-NEXT:    store i32 [[TMP60]], i32* [[TMP59]], align 4
// CHECK-32-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i16**
// CHECK-32-NEXT:    [[TMP63:%.*]] = load i16*, i16** [[TMP62]], align 4
// CHECK-32-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i16**
// CHECK-32-NEXT:    [[TMP66:%.*]] = load i16*, i16** [[TMP65]], align 4
// CHECK-32-NEXT:    [[TMP67:%.*]] = load i16, i16* [[TMP63]], align 2
// CHECK-32-NEXT:    store i16 [[TMP67]], i16* [[TMP66]], align 2
// CHECK-32-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-32:       else6:
// CHECK-32-NEXT:    br label [[IFCONT7]]
// CHECK-32:       ifcont7:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func8
// CHECK-32-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32:       then:
// CHECK-32-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 4
// CHECK-32-NEXT:    [[TMP10:%.*]] = bitcast i8* [[TMP9]] to i32*
// CHECK-32-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK-32-NEXT:    store volatile i32 [[TMP12]], i32 addrspace(3)* [[TMP11]], align 4
// CHECK-32-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32:       else:
// CHECK-32-NEXT:    br label [[IFCONT]]
// CHECK-32:       ifcont:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-32-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32:       then2:
// CHECK-32-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[TMP15]], align 4
// CHECK-32-NEXT:    [[TMP17:%.*]] = bitcast i8* [[TMP16]] to i32*
// CHECK-32-NEXT:    [[TMP18:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP14]], align 4
// CHECK-32-NEXT:    store i32 [[TMP18]], i32* [[TMP17]], align 4
// CHECK-32-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32:       else3:
// CHECK-32-NEXT:    br label [[IFCONT4]]
// CHECK-32:       ifcont4:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-32:       then6:
// CHECK-32-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 4
// CHECK-32-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i16*
// CHECK-32-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-NEXT:    [[TMP23:%.*]] = bitcast i32 addrspace(3)* [[TMP22]] to i16 addrspace(3)*
// CHECK-32-NEXT:    [[TMP24:%.*]] = load i16, i16* [[TMP21]], align 2
// CHECK-32-NEXT:    store volatile i16 [[TMP24]], i16 addrspace(3)* [[TMP23]], align 2
// CHECK-32-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-32:       else7:
// CHECK-32-NEXT:    br label [[IFCONT8]]
// CHECK-32:       ifcont8:
// CHECK-32-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP25]]
// CHECK-32-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-32:       then10:
// CHECK-32-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-NEXT:    [[TMP27:%.*]] = bitcast i32 addrspace(3)* [[TMP26]] to i16 addrspace(3)*
// CHECK-32-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP29:%.*]] = load i8*, i8** [[TMP28]], align 4
// CHECK-32-NEXT:    [[TMP30:%.*]] = bitcast i8* [[TMP29]] to i16*
// CHECK-32-NEXT:    [[TMP31:%.*]] = load volatile i16, i16 addrspace(3)* [[TMP27]], align 2
// CHECK-32-NEXT:    store i16 [[TMP31]], i16* [[TMP30]], align 2
// CHECK-32-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-32:       else11:
// CHECK-32-NEXT:    br label [[IFCONT12]]
// CHECK-32:       ifcont12:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l24
// CHECK-32-EX-SAME: (double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-EX-NEXT:    store double* [[E]], double** [[E_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1:[0-9]+]], i8 2, i1 false)
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = bitcast double* [[TMP0]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP4]], i8** [[TMP3]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast [1 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, double*)* @__omp_outlined__ to i8*), i8* null, i8** [[TMP5]], i32 1)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@__omp_outlined__
// CHECK-32-EX-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[E:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[E_ADDR:%.*]] = alloca double*, align 4
// CHECK-32-EX-NEXT:    [[E1:%.*]] = alloca double, align 8
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store double* [[E]], double** [[E_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load double*, double** [[E_ADDR]], align 4
// CHECK-32-EX-NEXT:    store double 0.000000e+00, double* [[E1]], align 8
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load double, double* [[E1]], align 8
// CHECK-32-EX-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], 5.000000e+00
// CHECK-32-EX-NEXT:    store double [[ADD]], double* [[E1]], align 8
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast double* [[E1]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 4
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 4, i8* [[TMP6]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func)
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[TMP7]], 1
// CHECK-32-EX-NEXT:    br i1 [[TMP8]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32-EX:       .omp.reduction.then:
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = load double, double* [[TMP0]], align 8
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = load double, double* [[E1]], align 8
// CHECK-32-EX-NEXT:    [[ADD2:%.*]] = fadd double [[TMP9]], [[TMP10]]
// CHECK-32-EX-NEXT:    store double [[ADD2]], double* [[TMP0]], align 8
// CHECK-32-EX-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP3]])
// CHECK-32-EX-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32-EX:       .omp.reduction.done:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [1 x i8*], align 4
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca double, align 8
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [1 x i8*]*
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to double**
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = load double*, double** [[TMP10]], align 4
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = getelementptr double, double* [[TMP11]], i32 1
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = bitcast double* [[TMP13]] to i8*
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = bitcast double* [[TMP11]] to i64*
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i64*
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = load i64, i64* [[TMP15]], align 8
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = trunc i32 [[TMP18]] to i16
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = call i64 @__kmpc_shuffle_int64(i64 [[TMP17]], i16 [[TMP7]], i16 [[TMP19]])
// CHECK-32-EX-NEXT:    store i64 [[TMP20]], i64* [[TMP16]], align 8
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = getelementptr i64, i64* [[TMP15]], i32 1
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = getelementptr i64, i64* [[TMP16]], i32 1
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = bitcast double* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP23]], i8** [[TMP12]], align 4
// CHECK-32-EX-NEXT:    [[TMP24:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-EX-NEXT:    [[TMP25:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP26:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP27:%.*]] = and i1 [[TMP25]], [[TMP26]]
// CHECK-32-EX-NEXT:    [[TMP28:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-EX-NEXT:    [[TMP29:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-EX-NEXT:    [[TMP30:%.*]] = icmp eq i16 [[TMP29]], 0
// CHECK-32-EX-NEXT:    [[TMP31:%.*]] = and i1 [[TMP28]], [[TMP30]]
// CHECK-32-EX-NEXT:    [[TMP32:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-EX-NEXT:    [[TMP33:%.*]] = and i1 [[TMP31]], [[TMP32]]
// CHECK-32-EX-NEXT:    [[TMP34:%.*]] = or i1 [[TMP24]], [[TMP27]]
// CHECK-32-EX-NEXT:    [[TMP35:%.*]] = or i1 [[TMP34]], [[TMP33]]
// CHECK-32-EX-NEXT:    br i1 [[TMP35]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP36:%.*]] = bitcast [1 x i8*]* [[TMP5]] to i8*
// CHECK-32-EX-NEXT:    [[TMP37:%.*]] = bitcast [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-EX-NEXT:    call void @"_omp$reduction$reduction_func"(i8* [[TMP36]], i8* [[TMP37]]) #[[ATTR3:[0-9]+]]
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP39:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-32-EX-NEXT:    br i1 [[TMP40]], label [[THEN4:%.*]], label [[ELSE5:%.*]]
// CHECK-32-EX:       then4:
// CHECK-32-EX-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to double**
// CHECK-32-EX-NEXT:    [[TMP43:%.*]] = load double*, double** [[TMP42]], align 4
// CHECK-32-EX-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP45:%.*]] = bitcast i8** [[TMP44]] to double**
// CHECK-32-EX-NEXT:    [[TMP46:%.*]] = load double*, double** [[TMP45]], align 4
// CHECK-32-EX-NEXT:    [[TMP47:%.*]] = load double, double* [[TMP43]], align 8
// CHECK-32-EX-NEXT:    store double [[TMP47]], double* [[TMP46]], align 8
// CHECK-32-EX-NEXT:    br label [[IFCONT6:%.*]]
// CHECK-32-EX:       else5:
// CHECK-32-EX-NEXT:    br label [[IFCONT6]]
// CHECK-32-EX:       ifcont6:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[DOTCNT_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [1 x i8*]*
// CHECK-32-EX-NEXT:    store i32 0, i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-EX-NEXT:    br label [[PRECOND:%.*]]
// CHECK-32-EX:       precond:
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = icmp ult i32 [[TMP8]], 2
// CHECK-32-EX-NEXT:    br i1 [[TMP9]], label [[BODY:%.*]], label [[EXIT:%.*]]
// CHECK-32-EX:       body:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-EX-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = load i8*, i8** [[TMP10]], align 4
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = bitcast i8* [[TMP11]] to i32*
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP12]], i32 [[TMP8]]
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK-32-EX-NEXT:    store volatile i32 [[TMP15]], i32 addrspace(3)* [[TMP14]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP16]]
// CHECK-32-EX-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32-EX:       then2:
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = load i8*, i8** [[TMP18]], align 4
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = bitcast i8* [[TMP19]] to i32*
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = getelementptr i32, i32* [[TMP20]], i32 [[TMP8]]
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP17]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP22]], i32* [[TMP21]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32-EX:       else3:
// CHECK-32-EX-NEXT:    br label [[IFCONT4]]
// CHECK-32-EX:       ifcont4:
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK-32-EX-NEXT:    store i32 [[TMP23]], i32* [[DOTCNT_ADDR]], align 4
// CHECK-32-EX-NEXT:    br label [[PRECOND]]
// CHECK-32-EX:       exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l29
// CHECK-32-EX-SAME: (i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 4
// CHECK-32-EX-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[TMP4]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = bitcast float* [[TMP1]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP6]], i8** [[TMP5]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i8*, float*)* @__omp_outlined__1 to i8*), i8* null, i8** [[TMP7]], i32 2)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@__omp_outlined__1
// CHECK-32-EX-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i8* noundef nonnull align 1 dereferenceable(1) [[C:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[C_ADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK-32-EX-NEXT:    [[C1:%.*]] = alloca i8, align 1
// CHECK-32-EX-NEXT:    [[D2:%.*]] = alloca float, align 4
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i8* [[C]], i8** [[C_ADDR]], align 4
// CHECK-32-EX-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[C_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i8 0, i8* [[C1]], align 1
// CHECK-32-EX-NEXT:    store float 1.000000e+00, float* [[D2]], align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-32-EX-NEXT:    [[CONV:%.*]] = sext i8 [[TMP2]] to i32
// CHECK-32-EX-NEXT:    [[XOR:%.*]] = xor i32 [[CONV]], 2
// CHECK-32-EX-NEXT:    [[CONV3:%.*]] = trunc i32 [[XOR]] to i8
// CHECK-32-EX-NEXT:    store i8 [[CONV3]], i8* [[C1]], align 1
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load float, float* [[D2]], align 4
// CHECK-32-EX-NEXT:    [[MUL:%.*]] = fmul float [[TMP3]], 3.300000e+01
// CHECK-32-EX-NEXT:    store float [[MUL]], float* [[D2]], align 4
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    store i8* [[C1]], i8** [[TMP6]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = bitcast float* [[D2]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 4
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 2, i32 8, i8* [[TMP9]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func3, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func4)
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], 1
// CHECK-32-EX-NEXT:    br i1 [[TMP11]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32-EX:       .omp.reduction.then:
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP0]], align 1
// CHECK-32-EX-NEXT:    [[CONV4:%.*]] = sext i8 [[TMP12]] to i32
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = load i8, i8* [[C1]], align 1
// CHECK-32-EX-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-32-EX-NEXT:    [[XOR6:%.*]] = xor i32 [[CONV4]], [[CONV5]]
// CHECK-32-EX-NEXT:    [[CONV7:%.*]] = trunc i32 [[XOR6]] to i8
// CHECK-32-EX-NEXT:    store i8 [[CONV7]], i8* [[TMP0]], align 1
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = load float, float* [[TMP1]], align 4
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = load float, float* [[D2]], align 4
// CHECK-32-EX-NEXT:    [[MUL8:%.*]] = fmul float [[TMP14]], [[TMP15]]
// CHECK-32-EX-NEXT:    store float [[MUL8]], float* [[TMP1]], align 4
// CHECK-32-EX-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP5]])
// CHECK-32-EX-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32-EX:       .omp.reduction.done:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func3
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i8, align 1
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca float, align 4
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = load i8*, i8** [[TMP9]], align 4
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = getelementptr i8, i8* [[TMP10]], i32 1
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = load i8, i8* [[TMP10]], align 1
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = trunc i32 [[TMP15]] to i16
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP14]], i16 [[TMP7]], i16 [[TMP16]])
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = trunc i32 [[TMP17]] to i8
// CHECK-32-EX-NEXT:    store i8 [[TMP18]], i8* [[DOTOMP_REDUCTION_ELEMENT]], align 1
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = getelementptr i8, i8* [[TMP10]], i32 1
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = getelementptr i8, i8* [[DOTOMP_REDUCTION_ELEMENT]], i32 1
// CHECK-32-EX-NEXT:    store i8* [[DOTOMP_REDUCTION_ELEMENT]], i8** [[TMP11]], align 4
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP22]], align 4
// CHECK-32-EX-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP25:%.*]] = getelementptr float, float* [[TMP23]], i32 1
// CHECK-32-EX-NEXT:    [[TMP26:%.*]] = bitcast float* [[TMP25]] to i8*
// CHECK-32-EX-NEXT:    [[TMP27:%.*]] = bitcast float* [[TMP23]] to i32*
// CHECK-32-EX-NEXT:    [[TMP28:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i32*
// CHECK-32-EX-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK-32-EX-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-EX-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-32-EX-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-32-EX-NEXT:    store i32 [[TMP32]], i32* [[TMP28]], align 4
// CHECK-32-EX-NEXT:    [[TMP33:%.*]] = getelementptr i32, i32* [[TMP27]], i32 1
// CHECK-32-EX-NEXT:    [[TMP34:%.*]] = getelementptr i32, i32* [[TMP28]], i32 1
// CHECK-32-EX-NEXT:    [[TMP35:%.*]] = bitcast float* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP35]], i8** [[TMP24]], align 4
// CHECK-32-EX-NEXT:    [[TMP36:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-EX-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP38:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP39:%.*]] = and i1 [[TMP37]], [[TMP38]]
// CHECK-32-EX-NEXT:    [[TMP40:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-EX-NEXT:    [[TMP41:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-EX-NEXT:    [[TMP42:%.*]] = icmp eq i16 [[TMP41]], 0
// CHECK-32-EX-NEXT:    [[TMP43:%.*]] = and i1 [[TMP40]], [[TMP42]]
// CHECK-32-EX-NEXT:    [[TMP44:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-EX-NEXT:    [[TMP45:%.*]] = and i1 [[TMP43]], [[TMP44]]
// CHECK-32-EX-NEXT:    [[TMP46:%.*]] = or i1 [[TMP36]], [[TMP39]]
// CHECK-32-EX-NEXT:    [[TMP47:%.*]] = or i1 [[TMP46]], [[TMP45]]
// CHECK-32-EX-NEXT:    br i1 [[TMP47]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP48:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-32-EX-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-EX-NEXT:    call void @"_omp$reduction$reduction_func2"(i8* [[TMP48]], i8* [[TMP49]]) #[[ATTR3]]
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    [[TMP50:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP51:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP52:%.*]] = and i1 [[TMP50]], [[TMP51]]
// CHECK-32-EX-NEXT:    br i1 [[TMP52]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-32-EX:       then5:
// CHECK-32-EX-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP54:%.*]] = load i8*, i8** [[TMP53]], align 4
// CHECK-32-EX-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP56:%.*]] = load i8*, i8** [[TMP55]], align 4
// CHECK-32-EX-NEXT:    [[TMP57:%.*]] = load i8, i8* [[TMP54]], align 1
// CHECK-32-EX-NEXT:    store i8 [[TMP57]], i8* [[TMP56]], align 1
// CHECK-32-EX-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP59:%.*]] = bitcast i8** [[TMP58]] to float**
// CHECK-32-EX-NEXT:    [[TMP60:%.*]] = load float*, float** [[TMP59]], align 4
// CHECK-32-EX-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to float**
// CHECK-32-EX-NEXT:    [[TMP63:%.*]] = load float*, float** [[TMP62]], align 4
// CHECK-32-EX-NEXT:    [[TMP64:%.*]] = load float, float* [[TMP60]], align 4
// CHECK-32-EX-NEXT:    store float [[TMP64]], float* [[TMP63]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-32-EX:       else6:
// CHECK-32-EX-NEXT:    br label [[IFCONT7]]
// CHECK-32-EX:       ifcont7:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func4
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-EX-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 4
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = bitcast i32 addrspace(3)* [[TMP10]] to i8 addrspace(3)*
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = load i8, i8* [[TMP9]], align 1
// CHECK-32-EX-NEXT:    store volatile i8 [[TMP12]], i8 addrspace(3)* [[TMP11]], align 1
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-32-EX-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32-EX:       then2:
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = bitcast i32 addrspace(3)* [[TMP14]] to i8 addrspace(3)*
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = load i8*, i8** [[TMP16]], align 4
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = load volatile i8, i8 addrspace(3)* [[TMP15]], align 1
// CHECK-32-EX-NEXT:    store i8 [[TMP18]], i8* [[TMP17]], align 1
// CHECK-32-EX-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32-EX:       else3:
// CHECK-32-EX-NEXT:    br label [[IFCONT4]]
// CHECK-32-EX:       ifcont4:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-EX-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-32-EX:       then6:
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 4
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i32*
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK-32-EX-NEXT:    store volatile i32 [[TMP23]], i32 addrspace(3)* [[TMP22]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-32-EX:       else7:
// CHECK-32-EX-NEXT:    br label [[IFCONT8]]
// CHECK-32-EX:       ifcont8:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP24]]
// CHECK-32-EX-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-32-EX:       then10:
// CHECK-32-EX-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-EX-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP27:%.*]] = load i8*, i8** [[TMP26]], align 4
// CHECK-32-EX-NEXT:    [[TMP28:%.*]] = bitcast i8* [[TMP27]] to i32*
// CHECK-32-EX-NEXT:    [[TMP29:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP25]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP29]], i32* [[TMP28]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-32-EX:       else11:
// CHECK-32-EX-NEXT:    br label [[IFCONT12]]
// CHECK-32-EX:       ifcont12:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIcET_i_l35
// CHECK-32-EX-SAME: (i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR0]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_target_init(%struct.ident_t* @[[GLOB1]], i8 2, i1 false)
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP2]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP5]], i8** [[TMP4]], align 4
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = bitcast i16* [[TMP1]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP7]], i8** [[TMP6]], align 4
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = bitcast [2 x i8*]* [[CAPTURED_VARS_ADDRS]] to i8**
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_51(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 1, i32 -1, i32 -1, i8* bitcast (void (i32*, i32*, i32*, i16*)* @__omp_outlined__5 to i8*), i8* null, i8** [[TMP8]], i32 2)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit(%struct.ident_t* @[[GLOB1]], i8 2)
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@__omp_outlined__5
// CHECK-32-EX-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[B:%.*]]) #[[ATTR1]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca i16*, align 4
// CHECK-32-EX-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[B2:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i16* [[B]], i16** [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load i16*, i16** [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 0, i32* [[A1]], align 4
// CHECK-32-EX-NEXT:    store i16 -32768, i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-32-EX-NEXT:    [[OR:%.*]] = or i32 [[TMP2]], 1
// CHECK-32-EX-NEXT:    store i32 [[OR]], i32* [[A1]], align 4
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK-32-EX-NEXT:    [[CMP:%.*]] = icmp sgt i32 99, [[CONV]]
// CHECK-32-EX-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK-32-EX:       cond.true:
// CHECK-32-EX-NEXT:    br label [[COND_END:%.*]]
// CHECK-32-EX:       cond.false:
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP4]] to i32
// CHECK-32-EX-NEXT:    br label [[COND_END]]
// CHECK-32-EX:       cond.end:
// CHECK-32-EX-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[CONV3]], [[COND_FALSE]] ]
// CHECK-32-EX-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
// CHECK-32-EX-NEXT:    store i16 [[CONV4]], i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = bitcast i32* [[A1]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP8]], i8** [[TMP7]], align 4
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = bitcast i16* [[B2]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP10]], i8** [[TMP9]], align 4
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_RED_LIST]] to i8*
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = call i32 @__kmpc_nvptx_parallel_reduce_nowait_v2(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]], i32 2, i32 8, i8* [[TMP11]], void (i8*, i16, i16, i16)* @_omp_reduction_shuffle_and_reduce_func7, void (i8*, i32)* @_omp_reduction_inter_warp_copy_func8)
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = icmp eq i32 [[TMP12]], 1
// CHECK-32-EX-NEXT:    br i1 [[TMP13]], label [[DOTOMP_REDUCTION_THEN:%.*]], label [[DOTOMP_REDUCTION_DONE:%.*]]
// CHECK-32-EX:       .omp.reduction.then:
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = load i32, i32* [[A1]], align 4
// CHECK-32-EX-NEXT:    [[OR5:%.*]] = or i32 [[TMP14]], [[TMP15]]
// CHECK-32-EX-NEXT:    store i32 [[OR5]], i32* [[TMP0]], align 4
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-32-EX-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP16]] to i32
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    [[CONV7:%.*]] = sext i16 [[TMP17]] to i32
// CHECK-32-EX-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[CONV6]], [[CONV7]]
// CHECK-32-EX-NEXT:    br i1 [[CMP8]], label [[COND_TRUE9:%.*]], label [[COND_FALSE10:%.*]]
// CHECK-32-EX:       cond.true9:
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = load i16, i16* [[TMP1]], align 2
// CHECK-32-EX-NEXT:    br label [[COND_END11:%.*]]
// CHECK-32-EX:       cond.false10:
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = load i16, i16* [[B2]], align 2
// CHECK-32-EX-NEXT:    br label [[COND_END11]]
// CHECK-32-EX:       cond.end11:
// CHECK-32-EX-NEXT:    [[COND12:%.*]] = phi i16 [ [[TMP18]], [[COND_TRUE9]] ], [ [[TMP19]], [[COND_FALSE10]] ]
// CHECK-32-EX-NEXT:    store i16 [[COND12]], i16* [[TMP1]], align 2
// CHECK-32-EX-NEXT:    call void @__kmpc_nvptx_end_reduce_nowait(i32 [[TMP6]])
// CHECK-32-EX-NEXT:    br label [[DOTOMP_REDUCTION_DONE]]
// CHECK-32-EX:       .omp.reduction.done:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_shuffle_and_reduce_func7
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i16 noundef signext [[TMP1:%.*]], i16 noundef signext [[TMP2:%.*]], i16 noundef signext [[TMP3:%.*]]) #[[ATTR2]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR2:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTADDR3:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST:%.*]] = alloca [2 x i8*], align 4
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_ELEMENT:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[DOTOMP_REDUCTION_ELEMENT4:%.*]] = alloca i16, align 2
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i16 [[TMP1]], i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP2]], i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP3]], i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = bitcast i8* [[TMP4]] to [2 x i8*]*
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i16, i16* [[DOTADDR1]], align 2
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = load i16, i16* [[DOTADDR2]], align 2
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = load i16, i16* [[DOTADDR3]], align 2
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[TMP10]], align 4
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = getelementptr i32, i32* [[TMP11]], i32 1
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = bitcast i32* [[TMP13]] to i8*
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP15]], i16 [[TMP7]], i16 [[TMP17]])
// CHECK-32-EX-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_REDUCTION_ELEMENT]], align 4
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = getelementptr i32, i32* [[TMP11]], i32 1
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = getelementptr i32, i32* [[DOTOMP_REDUCTION_ELEMENT]], i32 1
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = bitcast i32* [[DOTOMP_REDUCTION_ELEMENT]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP21]], i8** [[TMP12]], align 4
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i16**
// CHECK-32-EX-NEXT:    [[TMP24:%.*]] = load i16*, i16** [[TMP23]], align 4
// CHECK-32-EX-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP26:%.*]] = getelementptr i16, i16* [[TMP24]], i32 1
// CHECK-32-EX-NEXT:    [[TMP27:%.*]] = bitcast i16* [[TMP26]] to i8*
// CHECK-32-EX-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP24]], align 2
// CHECK-32-EX-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
// CHECK-32-EX-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_warp_size()
// CHECK-32-EX-NEXT:    [[TMP31:%.*]] = trunc i32 [[TMP30]] to i16
// CHECK-32-EX-NEXT:    [[TMP32:%.*]] = call i32 @__kmpc_shuffle_int32(i32 [[TMP29]], i16 [[TMP7]], i16 [[TMP31]])
// CHECK-32-EX-NEXT:    [[TMP33:%.*]] = trunc i32 [[TMP32]] to i16
// CHECK-32-EX-NEXT:    store i16 [[TMP33]], i16* [[DOTOMP_REDUCTION_ELEMENT4]], align 2
// CHECK-32-EX-NEXT:    [[TMP34:%.*]] = getelementptr i16, i16* [[TMP24]], i32 1
// CHECK-32-EX-NEXT:    [[TMP35:%.*]] = getelementptr i16, i16* [[DOTOMP_REDUCTION_ELEMENT4]], i32 1
// CHECK-32-EX-NEXT:    [[TMP36:%.*]] = bitcast i16* [[DOTOMP_REDUCTION_ELEMENT4]] to i8*
// CHECK-32-EX-NEXT:    store i8* [[TMP36]], i8** [[TMP25]], align 4
// CHECK-32-EX-NEXT:    [[TMP37:%.*]] = icmp eq i16 [[TMP8]], 0
// CHECK-32-EX-NEXT:    [[TMP38:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP39:%.*]] = icmp ult i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP40:%.*]] = and i1 [[TMP38]], [[TMP39]]
// CHECK-32-EX-NEXT:    [[TMP41:%.*]] = icmp eq i16 [[TMP8]], 2
// CHECK-32-EX-NEXT:    [[TMP42:%.*]] = and i16 [[TMP6]], 1
// CHECK-32-EX-NEXT:    [[TMP43:%.*]] = icmp eq i16 [[TMP42]], 0
// CHECK-32-EX-NEXT:    [[TMP44:%.*]] = and i1 [[TMP41]], [[TMP43]]
// CHECK-32-EX-NEXT:    [[TMP45:%.*]] = icmp sgt i16 [[TMP7]], 0
// CHECK-32-EX-NEXT:    [[TMP46:%.*]] = and i1 [[TMP44]], [[TMP45]]
// CHECK-32-EX-NEXT:    [[TMP47:%.*]] = or i1 [[TMP37]], [[TMP40]]
// CHECK-32-EX-NEXT:    [[TMP48:%.*]] = or i1 [[TMP47]], [[TMP46]]
// CHECK-32-EX-NEXT:    br i1 [[TMP48]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP49:%.*]] = bitcast [2 x i8*]* [[TMP5]] to i8*
// CHECK-32-EX-NEXT:    [[TMP50:%.*]] = bitcast [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]] to i8*
// CHECK-32-EX-NEXT:    call void @"_omp$reduction$reduction_func6"(i8* [[TMP49]], i8* [[TMP50]]) #[[ATTR3]]
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    [[TMP51:%.*]] = icmp eq i16 [[TMP8]], 1
// CHECK-32-EX-NEXT:    [[TMP52:%.*]] = icmp uge i16 [[TMP6]], [[TMP7]]
// CHECK-32-EX-NEXT:    [[TMP53:%.*]] = and i1 [[TMP51]], [[TMP52]]
// CHECK-32-EX-NEXT:    br i1 [[TMP53]], label [[THEN5:%.*]], label [[ELSE6:%.*]]
// CHECK-32-EX:       then5:
// CHECK-32-EX-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP55:%.*]] = bitcast i8** [[TMP54]] to i32**
// CHECK-32-EX-NEXT:    [[TMP56:%.*]] = load i32*, i32** [[TMP55]], align 4
// CHECK-32-EX-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP58:%.*]] = bitcast i8** [[TMP57]] to i32**
// CHECK-32-EX-NEXT:    [[TMP59:%.*]] = load i32*, i32** [[TMP58]], align 4
// CHECK-32-EX-NEXT:    [[TMP60:%.*]] = load i32, i32* [[TMP56]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP60]], i32* [[TMP59]], align 4
// CHECK-32-EX-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOMP_REDUCTION_REMOTE_REDUCE_LIST]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i16**
// CHECK-32-EX-NEXT:    [[TMP63:%.*]] = load i16*, i16** [[TMP62]], align 4
// CHECK-32-EX-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP5]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i16**
// CHECK-32-EX-NEXT:    [[TMP66:%.*]] = load i16*, i16** [[TMP65]], align 4
// CHECK-32-EX-NEXT:    [[TMP67:%.*]] = load i16, i16* [[TMP63]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP67]], i16* [[TMP66]], align 2
// CHECK-32-EX-NEXT:    br label [[IFCONT7:%.*]]
// CHECK-32-EX:       else6:
// CHECK-32-EX-NEXT:    br label [[IFCONT7]]
// CHECK-32-EX:       ifcont7:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@_omp_reduction_inter_warp_copy_func8
// CHECK-32-EX-SAME: (i8* noundef [[TMP0:%.*]], i32 noundef [[TMP1:%.*]]) #[[ATTR2]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTADDR:%.*]] = alloca i8*, align 4
// CHECK-32-EX-NEXT:    [[DOTADDR1:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB1]])
// CHECK-32-EX-NEXT:    store i8* [[TMP0]], i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP1]], i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_LANE_ID:%.*]] = and i32 [[TMP4]], 31
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32-EX-NEXT:    [[NVPTX_WARP_ID:%.*]] = ashr i32 [[TMP5]], 5
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i8*, i8** [[DOTADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = bitcast i8* [[TMP6]] to [2 x i8*]*
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[WARP_MASTER:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-EX-NEXT:    br i1 [[WARP_MASTER]], label [[THEN:%.*]], label [[ELSE:%.*]]
// CHECK-32-EX:       then:
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = load i8*, i8** [[TMP8]], align 4
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = bitcast i8* [[TMP9]] to i32*
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-EX-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK-32-EX-NEXT:    store volatile i32 [[TMP12]], i32 addrspace(3)* [[TMP11]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT:%.*]]
// CHECK-32-EX:       else:
// CHECK-32-EX-NEXT:    br label [[IFCONT]]
// CHECK-32-EX:       ifcont:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[IS_ACTIVE_THREAD:%.*]] = icmp ult i32 [[TMP3]], [[TMP13]]
// CHECK-32-EX-NEXT:    br i1 [[IS_ACTIVE_THREAD]], label [[THEN2:%.*]], label [[ELSE3:%.*]]
// CHECK-32-EX:       then2:
// CHECK-32-EX-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-EX-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[TMP15]], align 4
// CHECK-32-EX-NEXT:    [[TMP17:%.*]] = bitcast i8* [[TMP16]] to i32*
// CHECK-32-EX-NEXT:    [[TMP18:%.*]] = load volatile i32, i32 addrspace(3)* [[TMP14]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP18]], i32* [[TMP17]], align 4
// CHECK-32-EX-NEXT:    br label [[IFCONT4:%.*]]
// CHECK-32-EX:       else3:
// CHECK-32-EX-NEXT:    br label [[IFCONT4]]
// CHECK-32-EX:       ifcont4:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[WARP_MASTER5:%.*]] = icmp eq i32 [[NVPTX_LANE_ID]], 0
// CHECK-32-EX-NEXT:    br i1 [[WARP_MASTER5]], label [[THEN6:%.*]], label [[ELSE7:%.*]]
// CHECK-32-EX:       then6:
// CHECK-32-EX-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP20:%.*]] = load i8*, i8** [[TMP19]], align 4
// CHECK-32-EX-NEXT:    [[TMP21:%.*]] = bitcast i8* [[TMP20]] to i16*
// CHECK-32-EX-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[NVPTX_WARP_ID]]
// CHECK-32-EX-NEXT:    [[TMP23:%.*]] = bitcast i32 addrspace(3)* [[TMP22]] to i16 addrspace(3)*
// CHECK-32-EX-NEXT:    [[TMP24:%.*]] = load i16, i16* [[TMP21]], align 2
// CHECK-32-EX-NEXT:    store volatile i16 [[TMP24]], i16 addrspace(3)* [[TMP23]], align 2
// CHECK-32-EX-NEXT:    br label [[IFCONT8:%.*]]
// CHECK-32-EX:       else7:
// CHECK-32-EX-NEXT:    br label [[IFCONT8]]
// CHECK-32-EX:       ifcont8:
// CHECK-32-EX-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]])
// CHECK-32-EX-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTADDR1]], align 4
// CHECK-32-EX-NEXT:    [[IS_ACTIVE_THREAD9:%.*]] = icmp ult i32 [[TMP3]], [[TMP25]]
// CHECK-32-EX-NEXT:    br i1 [[IS_ACTIVE_THREAD9]], label [[THEN10:%.*]], label [[ELSE11:%.*]]
// CHECK-32-EX:       then10:
// CHECK-32-EX-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [32 x i32], [32 x i32] addrspace(3)* @__openmp_nvptx_data_transfer_temporary_storage, i64 0, i32 [[TMP3]]
// CHECK-32-EX-NEXT:    [[TMP27:%.*]] = bitcast i32 addrspace(3)* [[TMP26]] to i16 addrspace(3)*
// CHECK-32-EX-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[TMP7]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP29:%.*]] = load i8*, i8** [[TMP28]], align 4
// CHECK-32-EX-NEXT:    [[TMP30:%.*]] = bitcast i8* [[TMP29]] to i16*
// CHECK-32-EX-NEXT:    [[TMP31:%.*]] = load volatile i16, i16 addrspace(3)* [[TMP27]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP31]], i16* [[TMP30]], align 2
// CHECK-32-EX-NEXT:    br label [[IFCONT12:%.*]]
// CHECK-32-EX:       else11:
// CHECK-32-EX-NEXT:    br label [[IFCONT12]]
// CHECK-32-EX:       ifcont12:
// CHECK-32-EX-NEXT:    ret void
//
