; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-- -mcpu=tahiti -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GCN,SI
; RUN: llc -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GCN,VI
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX10
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx908 -start-before=amdgpu-isel -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX9
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX11

declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
declare i32 @llvm.amdgcn.workitem.id.y() nounwind readnone

define float @v_uitofp_i32_to_f32_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_i32_to_f32_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i32_to_f32_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i32_to_f32_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i32_to_f32_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %arg0, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_sitofp_i32_to_f32_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_sitofp_i32_to_f32_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_sitofp_i32_to_f32_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_sitofp_i32_to_f32_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_sitofp_i32_to_f32_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %arg0, 255
  %cvt = sitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_to_f32_lshr7_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f32_lshr7_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 7, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f32_lshr7_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 7, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f32_lshr7_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 7, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f32_lshr7_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 7, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.7 = lshr i32 %arg0, 7
  %masked = and i32 %lshr.7, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_to_f32_lshr8_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f32_lshr8_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f32_lshr8_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f32_lshr8_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f32_lshr8_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.8 = lshr i32 %arg0, 8
  %masked = and i32 %lshr.8, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_to_f32_multi_use_lshr8_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_uitofp_to_f32_multi_use_lshr8_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; SI-NEXT:    buffer_store_dword v1, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_to_f32_multi_use_lshr8_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; VI-NEXT:    buffer_store_dword v1, off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f32_multi_use_lshr8_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX10-NEXT:    global_store_dword v[0:1], v1, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f32_multi_use_lshr8_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    global_store_dword v[0:1], v1, off
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f32_multi_use_lshr8_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v1, off
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.8 = lshr i32 %arg0, 8
  store i32 %lshr.8, i32 addrspace(1)* undef
  %masked = and i32 %lshr.8, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_to_f32_lshr16_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f32_lshr16_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f32_lshr16_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f32_lshr16_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f32_lshr16_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 16
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_to_f32_lshr24_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f32_lshr24_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f32_lshr24_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f32_lshr24_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f32_lshr24_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 24
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to float
  ret float %cvt
}

define float @v_uitofp_i8_to_f32(i8 %arg0) nounwind {
; GCN-LABEL: v_uitofp_i8_to_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i8_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i8_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i8_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cvt = uitofp i8 %arg0 to float
  ret float %cvt
}

define <2 x float> @v_uitofp_v2i8_to_v2f32(i16 %arg0) nounwind {
; GCN-LABEL: v_uitofp_v2i8_to_v2f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_v2i8_to_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_v2i8_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_v2i8_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %val = bitcast i16 %arg0 to <2 x i8>
  %cvt = uitofp <2 x i8> %val to <2 x float>
  ret <2 x float> %cvt
}

define <3 x float> @v_uitofp_v3i8_to_v3f32(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_v3i8_to_v3f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v3, v0
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GCN-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_v3i8_to_v3f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v3, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_v3i8_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v3, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_v3i8_to_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v3, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %trunc = trunc i32 %arg0 to i24
  %val = bitcast i24 %trunc to <3 x i8>
  %cvt = uitofp <3 x i8> %val to <3 x float>
  ret <3 x float> %cvt
}

define <4 x float> @v_uitofp_v4i8_to_v4f32(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_v4i8_to_v4f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GCN-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_v4i8_to_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_v4i8_to_v4f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_v4i8_to_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %val = bitcast i32 %arg0 to <4 x i8>
  %cvt = uitofp <4 x i8> %val to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @v_uitofp_unpack_i32_to_v4f32(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_unpack_i32_to_v4f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GCN-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_unpack_i32_to_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_unpack_i32_to_v4f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_unpack_i32_to_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v4, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mask.arg0 = and i32 %arg0, 255
  %cvt0 = uitofp i32 %mask.arg0 to float

  %lshr.8 = lshr i32 %arg0, 8
  %mask.lshr.8 = and i32 %lshr.8, 255
  %cvt1 = uitofp i32 %mask.lshr.8 to float

  %lshr.16 = lshr i32 %arg0, 16
  %mask.lshr.16 = and i32 %lshr.16, 255
  %cvt2 = uitofp i32 %mask.lshr.16 to float

  %lshr.24 = lshr i32 %arg0, 24
  %mask.lshr.24 = and i32 %lshr.24, 255
  %cvt3 = uitofp i32 %mask.lshr.24 to float

  %ins.0 = insertelement <4 x float> undef, float %cvt0, i32 0
  %ins.1 = insertelement <4 x float> %ins.0, float %cvt1, i32 1
  %ins.2 = insertelement <4 x float> %ins.1, float %cvt2, i32 2
  %ins.3 = insertelement <4 x float> %ins.2, float %cvt3, i32 3
  ret <4 x float> %ins.3
}

define half @v_uitofp_i32_to_f16_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_uitofp_i32_to_f16_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_i32_to_f16_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i32_to_f16_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i32_to_f16_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i32_to_f16_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %arg0, 255
  %cvt = uitofp i32 %masked to half
  ret half %cvt
}

define half @v_sitofp_i32_to_f16_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_sitofp_i32_to_f16_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_sitofp_i32_to_f16_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_sitofp_i32_to_f16_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_sitofp_i32_to_f16_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_sitofp_i32_to_f16_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %arg0, 255
  %cvt = sitofp i32 %masked to half
  ret half %cvt
}

define half @v_uitofp_to_f16_lshr8_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_uitofp_to_f16_lshr8_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_to_f16_lshr8_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f16_lshr8_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f16_lshr8_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f16_lshr8_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.8 = lshr i32 %arg0, 8
  %masked = and i32 %lshr.8, 255
  %cvt = uitofp i32 %masked to half
  ret half %cvt
}

define half @v_uitofp_to_f16_lshr16_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_uitofp_to_f16_lshr16_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_to_f16_lshr16_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f16_lshr16_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f16_lshr16_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f16_lshr16_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 16
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to half
  ret half %cvt
}

define half @v_uitofp_to_f16_lshr24_mask255(i32 %arg0) nounwind {
; SI-LABEL: v_uitofp_to_f16_lshr24_mask255:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_to_f16_lshr24_mask255:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f16_lshr24_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f16_lshr24_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f16_lshr24_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 24
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to half
  ret half %cvt
}

define half @v_uitofp_i8_to_f16(i8 %arg0) nounwind {
; SI-LABEL: v_uitofp_i8_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_i8_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f16_u16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i8_to_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_cvt_f16_u16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i8_to_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cvt_f16_u16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i8_to_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f16_u16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cvt = uitofp i8 %arg0 to half
  ret half %cvt
}

define double @v_uitofp_i32_to_f64_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_i32_to_f64_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GCN-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i32_to_f64_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i32_to_f64_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i32_to_f64_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %arg0, 255
  %cvt = uitofp i32 %masked to double
  ret double %cvt
}

define double @v_uitofp_to_f64_lshr8_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f64_lshr8_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GCN-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f64_lshr8_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX10-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f64_lshr8_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f64_lshr8_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.8 = lshr i32 %arg0, 8
  %masked = and i32 %lshr.8, 255
  %cvt = uitofp i32 %masked to double
  ret double %cvt
}

define double @v_uitofp_to_f64_lshr16_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f64_lshr16_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GCN-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f64_lshr16_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX10-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f64_lshr16_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f64_lshr16_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 16
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to double
  ret double %cvt
}

define double @v_uitofp_to_f64_lshr24_mask255(i32 %arg0) nounwind {
; GCN-LABEL: v_uitofp_to_f64_lshr24_mask255:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GCN-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_to_f64_lshr24_mask255:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_to_f64_lshr24_mask255:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_to_f64_lshr24_mask255:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %lshr.16 = lshr i32 %arg0, 24
  %masked = and i32 %lshr.16, 255
  %cvt = uitofp i32 %masked to double
  ret double %cvt
}

define double @v_uitofp_i8_to_f64(i8 %arg0) nounwind {
; SI-LABEL: v_uitofp_i8_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_uitofp_i8_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, 0xffff
; VI-NEXT:    v_and_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uitofp_i8_to_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0xffff
; GFX10-NEXT:    v_and_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uitofp_i8_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0xffff
; GFX9-NEXT:    v_and_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_uitofp_i8_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_cvt_f64_u32_e32 v[0:1], v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cvt = uitofp i8 %arg0 to double
  ret double %cvt
}

define amdgpu_kernel void @load_i8_to_f32(float addrspace(1)* noalias %out, i8 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_i8_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_i8_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_i8_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ubyte v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_i8_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ubyte v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_i8_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i8, i8 addrspace(1)* %in, i32 %tid
  %load = load i8, i8 addrspace(1)* %gep, align 1
  %cvt = uitofp i8 %load to float
  store float %cvt, float addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @load_v2i8_to_v2f32(<2 x float> addrspace(1)* noalias %out, <2 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v2i8_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v2i8_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ushort v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v2i8_to_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ushort v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v2i8_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v2i8_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u16 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x i8>, <2 x i8> addrspace(1)* %in, i32 %tid
  %load = load <2 x i8>, <2 x i8> addrspace(1)* %gep, align 2
  %cvt = uitofp <2 x i8> %load to <2 x float>
  store <2 x float> %cvt, <2 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @load_v3i8_to_v3f32(<3 x float> addrspace(1)* noalias %out, <3 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v3i8_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v2
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v2
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v2
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:8
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v3i8_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v3i8_to_v3f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v3i8_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v3i8_to_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b96 v3, v[0:2], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <3 x i8>, <3 x i8> addrspace(1)* %in, i32 %tid
  %load = load <3 x i8>, <3 x i8> addrspace(1)* %gep, align 4
  %cvt = uitofp <3 x i8> %load to <3 x float>
  store <3 x float> %cvt, <3 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @load_v4i8_to_v4f32(<4 x float> addrspace(1)* noalias %out, <4 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v4i8_to_v4f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v4i8_to_v4f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v4i8_to_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v4i8_to_v4f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v4i8_to_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %in, i32 %tid
  %load = load <4 x i8>, <4 x i8> addrspace(1)* %gep, align 4
  %cvt = uitofp <4 x i8> %load to <4 x float>
  store <4 x float> %cvt, <4 x float> addrspace(1)* %out, align 16
  ret void
}

; This should not be adding instructions to shift into the correct
; position in the word for the component.

; FIXME: Packing bytes
define amdgpu_kernel void @load_v4i8_to_v4f32_unaligned(<4 x float> addrspace(1)* noalias %out, <4 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v4i8_to_v4f32_unaligned:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v2, v[0:1], s[4:7], 0 addr64 offset:3
; SI-NEXT:    buffer_load_ubyte v4, v[0:1], s[4:7], 0 addr64 offset:2
; SI-NEXT:    buffer_load_ubyte v5, v[0:1], s[4:7], 0 addr64 offset:1
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v2
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v4
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v4i8_to_v4f32_unaligned:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v2, v[2:3]
; VI-NEXT:    flat_load_ubyte v3, v[4:5]
; VI-NEXT:    flat_load_ubyte v4, v[0:1]
; VI-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v1, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v3
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v4i8_to_v4f32_unaligned:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x3
; GFX10-NEXT:    global_load_ubyte v1, v0, s[2:3] offset:3
; GFX10-NEXT:    global_load_ubyte v2, v0, s[2:3] offset:2
; GFX10-NEXT:    global_load_ubyte v4, v0, s[2:3] offset:1
; GFX10-NEXT:    global_load_ubyte v5, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(3)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX10-NEXT:    s_waitcnt vmcnt(2)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v5
; GFX10-NEXT:    global_store_dwordx4 v6, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v4i8_to_v4f32_unaligned:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ubyte v1, v0, s[0:1] offset:3
; GFX9-NEXT:    global_load_ubyte v2, v0, s[0:1] offset:2
; GFX9-NEXT:    global_load_ubyte v4, v0, s[0:1] offset:1
; GFX9-NEXT:    global_load_ubyte v5, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v5
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v6, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v4i8_to_v4f32_unaligned:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    global_load_u8 v1, v0, s[2:3] offset:3
; GFX11-NEXT:    global_load_u8 v2, v0, s[2:3] offset:2
; GFX11-NEXT:    global_load_u8 v4, v0, s[2:3] offset:1
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(3)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX11-NEXT:    s_waitcnt vmcnt(2)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b128 v5, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %in, i32 %tid
  %load = load <4 x i8>, <4 x i8> addrspace(1)* %gep, align 1
  %cvt = uitofp <4 x i8> %load to <4 x float>
  store <4 x float> %cvt, <4 x float> addrspace(1)* %out, align 16
  ret void
}

; FIXME: Need to handle non-uniform case for function below (load without gep).
; Instructions still emitted to repack bytes for add use.
define amdgpu_kernel void @load_v4i8_to_v4f32_2_uses(<4 x float> addrspace(1)* noalias %out, <4 x i8> addrspace(1)* noalias %out2, <4 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v4i8_to_v4f32_2_uses:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s6, s2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 24, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xff00, v4
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v4
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v4
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v4
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, 9, v4
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v2, vcc, 9, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v6
; SI-NEXT:    v_or_b32_e32 v0, v7, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x900, v0
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x9000000, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v4i8_to_v4f32_2_uses:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v5, 9
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2c
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v6, 24, v4
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v4
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v4
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v4
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v4
; VI-NEXT:    v_and_b32_e32 v7, 0xffffff00, v4
; VI-NEXT:    v_add_u16_e32 v8, 9, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_nop 0
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v6
; VI-NEXT:    v_or_b32_sdwa v0, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x900
; VI-NEXT:    v_add_u16_e32 v0, 0x900, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v4i8_to_v4f32_2_uses:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x2c
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_sdwa v1, v1, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffffff00, v0
; GFX10-NEXT:    v_add_nc_u16 v4, v0, 9
; GFX10-NEXT:    v_add_nc_u16 v2, v2, 9
; GFX10-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_or_b32_sdwa v2, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX10-NEXT:    v_add_nc_u16 v1, v1, 0x900
; GFX10-NEXT:    v_add_nc_u16 v5, v2, 0x900
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX10-NEXT:    global_store_dword v4, v5, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v4i8_to_v4f32_2_uses:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_mov_b32_e32 v6, 9
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x2c
; GFX9-NEXT:    s_movk_i32 s4, 0x900
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v3, v4
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v4
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v4
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v4
; GFX9-NEXT:    v_and_b32_e32 v8, 0xffffff00, v4
; GFX9-NEXT:    v_add_u16_e32 v9, 9, v4
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v7
; GFX9-NEXT:    v_or_b32_sdwa v0, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x900, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v5, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v4i8_to_v4f32_2_uses:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x34
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x24
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x2c
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_add_nc_u16 v2, v0, 9
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffffff00, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u16 v1, v1, 9
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_nc_u16 v2, v2, 0x900
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v3, v0
; GFX11-NEXT:    v_add_nc_u16 v1, v1, 0x900
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v2
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[2:3]
; GFX11-NEXT:    global_store_b32 v4, v5, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid.x = call i32 @llvm.amdgcn.workitem.id.x()
  %in.ptr = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %in, i32 %tid.x
  %load = load <4 x i8>, <4 x i8> addrspace(1)* %in.ptr, align 4
  %cvt = uitofp <4 x i8> %load to <4 x float>
  store <4 x float> %cvt, <4 x float> addrspace(1)* %out, align 16
  %add = add <4 x i8> %load, <i8 9, i8 9, i8 9, i8 9> ; Second use of %load
  store <4 x i8> %add, <4 x i8> addrspace(1)* %out2, align 4
  ret void
}

; Make sure this doesn't crash.
define amdgpu_kernel void @load_v7i8_to_v7f32(<7 x float> addrspace(1)* noalias %out, <7 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v7i8_to_v7f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v2, v[0:1], s[4:7], 0 addr64 offset:3
; SI-NEXT:    buffer_load_ubyte v4, v[0:1], s[4:7], 0 addr64 offset:2
; SI-NEXT:    buffer_load_ubyte v5, v[0:1], s[4:7], 0 addr64 offset:1
; SI-NEXT:    buffer_load_ubyte v6, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    buffer_load_ubyte v7, v[0:1], s[4:7], 0 addr64 offset:5
; SI-NEXT:    buffer_load_ubyte v8, v[0:1], s[4:7], 0 addr64 offset:4
; SI-NEXT:    buffer_load_ubyte v9, v[0:1], s[4:7], 0 addr64 offset:6
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v2
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v4
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v5
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v6
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v5, v7
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v4, v8
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v6, v9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:24
; SI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v7i8_to_v7f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 5, v0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v10, v[2:3]
; VI-NEXT:    v_add_u32_e32 v2, vcc, 6, v0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 1, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 2, v0
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v6, v[6:7]
; VI-NEXT:    flat_load_ubyte v7, v[8:9]
; VI-NEXT:    flat_load_ubyte v8, v[2:3]
; VI-NEXT:    flat_load_ubyte v2, v[0:1]
; VI-NEXT:    flat_load_ubyte v4, v[4:5]
; VI-NEXT:    v_add_u32_e32 v0, vcc, 4, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v9, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v5, v10
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v7
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v2
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v6
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v6, v8
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v4, v9
; VI-NEXT:    buffer_store_dwordx3 v[4:6], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v7i8_to_v7f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x5
; GFX10-NEXT:    global_load_ubyte v5, v0, s[2:3] offset:6
; GFX10-NEXT:    global_load_ubyte v1, v0, s[2:3] offset:3
; GFX10-NEXT:    global_load_ubyte v2, v0, s[2:3] offset:2
; GFX10-NEXT:    global_load_ubyte v6, v0, s[2:3] offset:1
; GFX10-NEXT:    global_load_short_d16 v4, v0, s[2:3] offset:4
; GFX10-NEXT:    global_load_ubyte v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(4)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX10-NEXT:    s_waitcnt vmcnt(3)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX10-NEXT:    s_waitcnt vmcnt(2)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, v6
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v6, v5
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v5, v4
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v4, v4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dwordx3 v7, v[4:6], s[0:1] offset:16
; GFX10-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v7i8_to_v7f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[0:1] offset:4
; GFX9-NEXT:    global_load_ubyte v2, v0, s[0:1] offset:6
; GFX9-NEXT:    global_load_ubyte v3, v0, s[0:1] offset:3
; GFX9-NEXT:    global_load_ubyte v4, v0, s[0:1] offset:2
; GFX9-NEXT:    global_load_ubyte v5, v0, s[0:1] offset:1
; GFX9-NEXT:    global_load_ubyte v7, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_and_b32_e32 v9, 0xffff, v1
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v6, v2
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v3, v3
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v2, v4
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v1, v5
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v7
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v5, v9
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v4, v9
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX9-NEXT:    global_store_dwordx3 v8, v[4:6], s[0:1] offset:16
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v7i8_to_v7f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v7, 0 :: v_dual_lshlrev_b32 v0, 3, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x5
; GFX11-NEXT:    global_load_u8 v5, v0, s[2:3] offset:6
; GFX11-NEXT:    global_load_u8 v1, v0, s[2:3] offset:3
; GFX11-NEXT:    global_load_u8 v2, v0, s[2:3] offset:2
; GFX11-NEXT:    global_load_u8 v6, v0, s[2:3] offset:1
; GFX11-NEXT:    global_load_d16_b16 v4, v0, s[2:3] offset:4
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(4)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX11-NEXT:    s_waitcnt vmcnt(3)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX11-NEXT:    s_waitcnt vmcnt(2)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, v6
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v6, v5
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v5, v4
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v4, v4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b96 v7, v[4:6], s[0:1] offset:16
; GFX11-NEXT:    global_store_b128 v7, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <7 x i8>, <7 x i8> addrspace(1)* %in, i32 %tid
  %load = load <7 x i8>, <7 x i8> addrspace(1)* %gep, align 1
  %cvt = uitofp <7 x i8> %load to <7 x float>
  store <7 x float> %cvt, <7 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @load_v8i8_to_v8f32(<8 x float> addrspace(1)* noalias %out, <8 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: load_v8i8_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dwordx2 v[7:8], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v7
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v7
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v7
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v7
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v7, v8
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v6, v8
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v5, v8
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v4, v8
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: load_v8i8_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[7:8], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v3, v7
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v2, v7
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v1, v7
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v7
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v7, v8
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v6, v8
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v5, v8
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v4, v8
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: load_v8i8_to_v8f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v10, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[8:9], v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v7, v9
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v6, v9
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v5, v9
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v4, v9
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v3, v8
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v2, v8
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v1, v8
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v8
; GFX10-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1] offset:16
; GFX10-NEXT:    global_store_dwordx4 v10, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: load_v8i8_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[7:8], v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v3, v7
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v2, v7
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v1, v7
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v7
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v7, v8
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v6, v8
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v5, v8
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v4, v8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v9, v[4:7], s[0:1] offset:16
; GFX9-NEXT:    global_store_dwordx4 v9, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: load_v8i8_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v10, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[8:9], v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v7, v9
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v6, v9
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v5, v9
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v4, v9
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v3, v8
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v2, v8
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v1, v8
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v8
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v10, v[4:7], s[0:1] offset:16
; GFX11-NEXT:    global_store_b128 v10, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <8 x i8>, <8 x i8> addrspace(1)* %in, i32 %tid
  %load = load <8 x i8>, <8 x i8> addrspace(1)* %gep, align 8
  %cvt = uitofp <8 x i8> %load to <8 x float>
  store <8 x float> %cvt, <8 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @i8_zext_inreg_i32_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: i8_zext_inreg_i32_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 2, v0
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: i8_zext_inreg_i32_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 2, v0
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: i8_zext_inreg_i32_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: i8_zext_inreg_i32_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 2, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: i8_zext_inreg_i32_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %load = load i32, i32 addrspace(1)* %gep, align 4
  %add = add i32 %load, 2
  %inreg = and i32 %add, 255
  %cvt = uitofp i32 %inreg to float
  store float %cvt, float addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @i8_zext_inreg_hi1_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: i8_zext_inreg_hi1_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: i8_zext_inreg_hi1_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: i8_zext_inreg_hi1_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: i8_zext_inreg_hi1_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: i8_zext_inreg_hi1_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %load = load i32, i32 addrspace(1)* %gep, align 4
  %inreg = and i32 %load, 65280
  %shr = lshr i32 %inreg, 8
  %cvt = uitofp i32 %shr to float
  store float %cvt, float addrspace(1)* %out, align 4
  ret void
}

; We don't get these ones because of the zext, but instcombine removes
; them so it shouldn't really matter.
define amdgpu_kernel void @i8_zext_i32_to_f32(float addrspace(1)* noalias %out, i8 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: i8_zext_i32_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: i8_zext_i32_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: i8_zext_i32_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ubyte v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: i8_zext_i32_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ubyte v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: i8_zext_i32_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i8, i8 addrspace(1)* %in, i32 %tid
  %load = load i8, i8 addrspace(1)* %gep, align 1
  %ext = zext i8 %load to i32
  %cvt = uitofp i32 %ext to float
  store float %cvt, float addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @v4i8_zext_v4i32_to_v4f32(<4 x float> addrspace(1)* noalias %out, <4 x i8> addrspace(1)* noalias %in) nounwind {
; SI-LABEL: v4i8_zext_v4i32_to_v4f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v2, v[0:1], s[4:7], 0 addr64 offset:3
; SI-NEXT:    buffer_load_ubyte v4, v[0:1], s[4:7], 0 addr64 offset:2
; SI-NEXT:    buffer_load_ubyte v5, v[0:1], s[4:7], 0 addr64 offset:1
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v2
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v4
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v4i8_zext_v4i32_to_v4f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v2, v[2:3]
; VI-NEXT:    flat_load_ubyte v3, v[4:5]
; VI-NEXT:    flat_load_ubyte v4, v[0:1]
; VI-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v1, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v3, v3
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: v4i8_zext_v4i32_to_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x3
; GFX10-NEXT:    global_load_ubyte v1, v0, s[2:3] offset:3
; GFX10-NEXT:    global_load_ubyte v2, v0, s[2:3] offset:2
; GFX10-NEXT:    global_load_ubyte v4, v0, s[2:3] offset:1
; GFX10-NEXT:    global_load_ubyte v5, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(3)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX10-NEXT:    s_waitcnt vmcnt(2)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v5
; GFX10-NEXT:    global_store_dwordx4 v6, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: v4i8_zext_v4i32_to_v4f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ubyte v1, v0, s[0:1] offset:3
; GFX9-NEXT:    global_load_ubyte v2, v0, s[0:1] offset:2
; GFX9-NEXT:    global_load_ubyte v4, v0, s[0:1] offset:1
; GFX9-NEXT:    global_load_ubyte v5, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v5
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v6, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v4i8_zext_v4i32_to_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    global_load_u8 v1, v0, s[2:3] offset:3
; GFX11-NEXT:    global_load_u8 v2, v0, s[2:3] offset:2
; GFX11-NEXT:    global_load_u8 v4, v0, s[2:3] offset:1
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(3)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v3, v1
; GFX11-NEXT:    s_waitcnt vmcnt(2)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, v4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b128 v5, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %in, i32 %tid
  %load = load <4 x i8>, <4 x i8> addrspace(1)* %gep, align 1
  %ext = zext <4 x i8> %load to <4 x i32>
  %cvt = uitofp <4 x i32> %ext to <4 x float>
  store <4 x float> %cvt, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @extract_byte0_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: extract_byte0_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_byte0_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: extract_byte0_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: extract_byte0_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_byte0_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %val = load i32, i32 addrspace(1)* %gep
  %and = and i32 %val, 255
  %cvt = uitofp i32 %and to float
  store float %cvt, float addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @extract_byte1_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: extract_byte1_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_byte1_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: extract_byte1_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: extract_byte1_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_byte1_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte1_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %val = load i32, i32 addrspace(1)* %gep
  %srl = lshr i32 %val, 8
  %and = and i32 %srl, 255
  %cvt = uitofp i32 %and to float
  store float %cvt, float addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @extract_byte2_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: extract_byte2_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_byte2_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: extract_byte2_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: extract_byte2_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_byte2_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte2_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %val = load i32, i32 addrspace(1)* %gep
  %srl = lshr i32 %val, 16
  %and = and i32 %srl, 255
  %cvt = uitofp i32 %and to float
  store float %cvt, float addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @extract_byte3_to_f32(float addrspace(1)* noalias %out, i32 addrspace(1)* noalias %in) nounwind {
; SI-LABEL: extract_byte3_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_byte3_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: extract_byte3_to_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: extract_byte3_to_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_byte3_to_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x2c
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte3_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, i32 addrspace(1)* %in, i32 %tid
  %val = load i32, i32 addrspace(1)* %gep
  %srl = lshr i32 %val, 24
  %and = and i32 %srl, 255
  %cvt = uitofp i32 %and to float
  store float %cvt, float addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @cvt_ubyte0_or_multiuse(i32 addrspace(1)* %in, float addrspace(1)* %out) {
; SI-LABEL: cvt_ubyte0_or_multiuse:
; SI:       ; %bb.0: ; %bb
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    s_mov_b32 s2, 0
; SI-NEXT:    s_mov_b32 s3, s7
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, 0x80000001, v0
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v0
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: cvt_ubyte0_or_multiuse:
; VI:       ; %bb.0: ; %bb
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v0, 0x80000001, v0
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v0
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: cvt_ubyte0_or_multiuse:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_or_b32_e32 v0, 0x80000001, v0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    global_store_dword v2, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX9-LABEL: cvt_ubyte0_or_multiuse:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v0, 0x80000001, v0
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v2, v0
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: cvt_ubyte0_or_multiuse:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v0, 0x80000001, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    global_store_b32 v2, v0, s[2:3]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
bb:
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds i32, i32 addrspace(1)* %in, i32 %lid
  %load = load i32, i32 addrspace(1)* %gep
  %or = or i32 %load, -2147483647
  %and = and i32 %or, 255
  %uitofp = uitofp i32 %and to float
  %cast = bitcast i32 %or to float
  %add = fadd float %cast, %uitofp
  store float %add, float addrspace(1)* %out
  ret void
}

%Vec = type { [4 x i8] }

define amdgpu_kernel void @cvt_f32_ubyte0_vector() local_unnamed_addr {
; SI-LABEL: cvt_f32_ubyte0_vector:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:3
; SI-NEXT:    buffer_load_ubyte v1, off, s[0:3], 0 offset:2
; SI-NEXT:    buffer_load_ubyte v2, off, s[0:3], 0 offset:1
; SI-NEXT:    buffer_load_ubyte v3, off, s[0:3], 0
; SI-NEXT:    s_load_dword s0, s[0:1], 0x0
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_fma_f32 v0, s0, v0, 0.5
; SI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_byte v1, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_byte v2, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_byte v3, off, s[0:3], 0
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:  .LBB40_1: ; %for.body.i
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_branch .LBB40_1
;
; VI-LABEL: cvt_f32_ubyte0_vector:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:3
; VI-NEXT:    buffer_load_ubyte v1, off, s[0:3], 0 offset:2
; VI-NEXT:    buffer_load_ubyte v2, off, s[0:3], 0 offset:1
; VI-NEXT:    buffer_load_ubyte v3, off, s[0:3], 0
; VI-NEXT:    s_load_dword s0, s[0:1], 0x0
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e32 v0, s0, v0
; VI-NEXT:    v_add_f32_e32 v0, 0.5, v0
; VI-NEXT:    v_cvt_i32_f32_e32 v0, v0
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_byte v1, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_byte v2, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_byte v3, off, s[0:3], 0
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; VI-NEXT:  .LBB40_1: ; %for.body.i
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_branch .LBB40_1
;
; GFX10-LABEL: cvt_f32_ubyte0_vector:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x3
; GFX10-NEXT:    global_load_ubyte v1, v0, s[0:1] offset:3
; GFX10-NEXT:    global_load_ubyte v2, v0, s[0:1] offset:2
; GFX10-NEXT:    global_load_ubyte v3, v0, s[0:1] offset:1
; GFX10-NEXT:    global_load_ubyte v4, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX10-NEXT:    s_waitcnt vmcnt(3)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_fma_f32 v0, s0, v0, 0.5
; GFX10-NEXT:    v_cvt_i32_f32_e32 v0, v0
; GFX10-NEXT:    s_waitcnt vmcnt(2)
; GFX10-NEXT:    global_store_byte v[0:1], v2, off
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    global_store_byte v[0:1], v3, off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_byte v[0:1], v4, off
; GFX10-NEXT:    global_store_byte v[0:1], v0, off
; GFX10-NEXT:  .LBB40_1: ; %for.body.i
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_branch .LBB40_1
;
; GFX9-LABEL: cvt_f32_ubyte0_vector:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:  .LBB40_1: ; %for.body.i
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_ubyte v2, v[0:1], off offset:3
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    global_load_ubyte v4, v[0:1], off offset:2
; GFX9-NEXT:    global_load_ubyte v5, v[0:1], off offset:1
; GFX9-NEXT:    global_load_ubyte v6, v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, v2
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_fma_f32 v0, v3, v0, 0.5
; GFX9-NEXT:    v_cvt_i32_f32_e32 v0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    global_store_byte v[0:1], v4, off
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    global_store_byte v[0:1], v5, off
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    global_store_byte v[0:1], v6, off
; GFX9-NEXT:    global_store_byte v[0:1], v0, off
; GFX9-NEXT:    s_branch .LBB40_1
;
; GFX11-LABEL: cvt_f32_ubyte0_vector:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    global_load_u8 v1, v0, s[0:1] offset:3
; GFX11-NEXT:    global_load_u8 v2, v0, s[0:1] offset:2
; GFX11-NEXT:    global_load_u8 v3, v0, s[0:1] offset:1
; GFX11-NEXT:    global_load_u8 v0, v0, s[0:1]
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x0
; GFX11-NEXT:    s_waitcnt vmcnt(3)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f32 v1, s0, v1, 0.5
; GFX11-NEXT:    v_cvt_i32_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    global_store_b8 v[0:1], v2, off
; GFX11-NEXT:    global_store_b8 v[0:1], v3, off
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    global_store_b8 v[0:1], v1, off
; GFX11-NEXT:  .LBB40_1: ; %for.body.i
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_branch .LBB40_1
entry:
  br label %for.body.i

for.body.i:                                       ; preds = %for.body.i, %entry
  %retval.sroa.0.0.copyload = load %Vec*, %Vec* addrspace(1)* undef, align 8
  %add.ptr = getelementptr inbounds %Vec, %Vec* %retval.sroa.0.0.copyload, i64 undef
  %retval.sroa.0.0..sroa_cast = bitcast %Vec* %add.ptr to i32*
  %retval.sroa.0.0..sroa_cast_adr = addrspacecast i32* %retval.sroa.0.0..sroa_cast to i32 addrspace(1)*
  %retval.sroa.0.0.copyload.i = load i32, i32 addrspace(1)* %retval.sroa.0.0..sroa_cast_adr, align 1
  %p1.sroa.6.0.extract.shift = lshr i32 %retval.sroa.0.0.copyload.i, 24
  %p1.sroa.6.0.extract.trunc = trunc i32 %p1.sroa.6.0.extract.shift to i8
  %conv12 = uitofp i8 %p1.sroa.6.0.extract.trunc to float
  %0 = load float, float addrspace(1)* undef, align 8
  %mul = fmul contract float %0, %conv12
  %add = fadd contract float %mul, 5.000000e-01
  %conv13 = fptoui float %add to i8
  %retval.sroa.4.0.insert.ext = zext i8 %conv13 to i32
  %retval.sroa.4.0.insert.shift = shl nuw i32 %retval.sroa.4.0.insert.ext, 24
  %retval.sroa.3.0.insert.ext = and i32 %retval.sroa.0.0.copyload.i, 16711680
  %retval.sroa.3.0.insert.insert = or i32 %retval.sroa.4.0.insert.shift, %retval.sroa.3.0.insert.ext
  %retval.sroa.2.0.insert.ext = and i32 %retval.sroa.0.0.copyload.i, 65280
  %retval.sroa.2.0.insert.insert = or i32 %retval.sroa.3.0.insert.insert, %retval.sroa.2.0.insert.ext
  %retval.sroa.0.0.insert.ext = and i32 %retval.sroa.0.0.copyload.i, 255
  %retval.sroa.0.0.insert.insert = or i32 %retval.sroa.2.0.insert.insert, %retval.sroa.0.0.insert.ext
  store i32 %retval.sroa.0.0.insert.insert, i32 addrspace(1)* undef, align 1
  br label %for.body.i
}
