; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7m-none-eabi -mcpu=cortex-m7 | FileCheck %s --check-prefix=CHECK
; RUN: llc < %s -mtriple=thumbv7m-none-eabi -mcpu=cortex-m7 -arm-data-bank-mask=-1 | FileCheck %s --check-prefix=NOBANK

; This tests the cortex-m7 bank conflict hazard recognizer.
; Normally both loads would be scheduled early (both in the first cycle) due to
; their latency. But will bank conflict to TCM so are scheduled in different
; cycles.

define i32 @test(i32* %x0, i32 %y, i32 %z) {
; CHECK-LABEL: test:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldr r3, [r0]
; CHECK-NEXT:    subs r1, r3, r1
; CHECK-NEXT:    ldr r0, [r0, #8]
; CHECK-NEXT:    subs r1, r1, r2
; CHECK-NEXT:    adds r1, #1
; CHECK-NEXT:    muls r0, r1, r0
; CHECK-NEXT:    bx lr
; NOBANK-LABEL: test:
; NOBANK:       @ %bb.0: @ %entry
; NOBANK-NEXT:    ldr r3, [r0]
; NOBANK-NEXT:    ldr r0, [r0, #8]
; NOBANK-NEXT:    subs r1, r3, r1
; NOBANK-NEXT:    subs r1, r1, r2
; NOBANK-NEXT:    adds r1, #1
; NOBANK-NEXT:    muls r0, r1, r0
; NOBANK-NEXT:    bx lr
entry:
  %0 = load i32, i32* %x0, align 4
  %mul3 = add nsw i32 %0, 1
  %mul = sub nsw i32 %mul3, %y
  %sub = sub nsw i32 %mul, %z
  %arrayidx1 = getelementptr inbounds i32, i32* %x0, i32 2
  %1 = load i32, i32* %arrayidx1, align 4
  %mul2 = mul nsw i32 %sub, %1
  ret i32 %mul2
}
