; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin10 -mattr=+avx | FileCheck %s
; RUN: llc < %s -mtriple=i386-apple-darwin10 -mattr=+avx -x86-experimental-vector-widening-legalization | FileCheck %s --check-prefix=CHECK-WIDE

define <2 x float> @cvt_v2i8_v2f32(<2 x i8> %src) {
; CHECK-LABEL: cvt_v2i8_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpsllq $56, %xmm0, %xmm0
; CHECK-NEXT:    vpsrad $24, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; CHECK-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2i8_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpmovsxbd %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = sitofp <2 x i8> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x float> @cvt_v2i16_v2f32(<2 x i16> %src) {
; CHECK-LABEL: cvt_v2i16_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpsllq $48, %xmm0, %xmm0
; CHECK-NEXT:    vpsrad $16, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; CHECK-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2i16_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpmovsxwd %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = sitofp <2 x i16> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x float> @cvt_v2i32_v2f32(<2 x i32> %src) {
; CHECK-LABEL: cvt_v2i32_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; CHECK-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2i32_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = sitofp <2 x i32> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x float> @cvt_v2u8_v2f32(<2 x i8> %src) {
; CHECK-LABEL: cvt_v2u8_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; CHECK-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2u8_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; CHECK-WIDE-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = uitofp <2 x i8> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x float> @cvt_v2u16_v2f32(<2 x i16> %src) {
; CHECK-LABEL: cvt_v2u16_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1],zero,zero,xmm0[8,9],zero,zero,xmm0[8,9],zero,zero,xmm0[10,11],zero,zero
; CHECK-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2u16_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; CHECK-WIDE-NEXT:    vcvtdq2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = uitofp <2 x i16> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x float> @cvt_v2u32_v2f32(<2 x i32> %src) {
; CHECK-LABEL: cvt_v2u32_v2f32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; CHECK-NEXT:    vmovaps {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; CHECK-NEXT:    vorps %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vcvtpd2ps %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2u32_v2f32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; CHECK-WIDE-NEXT:    vmovdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; CHECK-WIDE-NEXT:    vpor %xmm1, %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vcvtpd2ps %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = uitofp <2 x i32> %src to <2 x float>
  ret <2 x float> %res
}

define <2 x i8> @cvt_v2f32_v2i8(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2i8:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-NEXT:    vpmovsxdq %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2i8:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; CHECK-WIDE-NEXT:    retl
  %res = fptosi <2 x float> %src to <2 x i8>
  ret <2 x i8> %res
}

define <2 x i16> @cvt_v2f32_v2i16(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2i16:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-NEXT:    vpmovsxdq %xmm0, %xmm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2i16:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; CHECK-WIDE-NEXT:    retl
  %res = fptosi <2 x float> %src to <2 x i16>
  ret <2 x i16> %res
}

define <2 x i32> @cvt_v2f32_v2i32(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2i32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2i32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = fptosi <2 x float> %src to <2 x i32>
  ret <2 x i32> %res
}

define <2 x i8> @cvt_v2f32_v2u8(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2u8:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2u8:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; CHECK-WIDE-NEXT:    retl
  %res = fptoui <2 x float> %src to <2 x i8>
  ret <2 x i8> %res
}

define <2 x i16> @cvt_v2f32_v2u16(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2u16:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2u16:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; CHECK-WIDE-NEXT:    retl
  %res = fptoui <2 x float> %src to <2 x i16>
  ret <2 x i16> %res
}

define <2 x i32> @cvt_v2f32_v2u32(<2 x float> %src) {
; CHECK-LABEL: cvt_v2f32_v2u32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    subl $68, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 72
; CHECK-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; CHECK-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; CHECK-NEXT:    vcmpltss %xmm2, %xmm1, %xmm3
; CHECK-NEXT:    vsubss %xmm2, %xmm1, %xmm4
; CHECK-NEXT:    vblendvps %xmm3, %xmm1, %xmm4, %xmm3
; CHECK-NEXT:    vmovss %xmm3, {{[0-9]+}}(%esp)
; CHECK-NEXT:    vcmpltss %xmm2, %xmm0, %xmm3
; CHECK-NEXT:    vsubss %xmm2, %xmm0, %xmm4
; CHECK-NEXT:    vblendvps %xmm3, %xmm0, %xmm4, %xmm3
; CHECK-NEXT:    vmovss %xmm3, {{[0-9]+}}(%esp)
; CHECK-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-NEXT:    fisttpll (%esp)
; CHECK-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-NEXT:    fisttpll {{[0-9]+}}(%esp)
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    vucomiss %xmm2, %xmm1
; CHECK-NEXT:    setae %al
; CHECK-NEXT:    shll $31, %eax
; CHECK-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    vucomiss %xmm2, %xmm0
; CHECK-NEXT:    setae %cl
; CHECK-NEXT:    shll $31, %ecx
; CHECK-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    vpinsrd $1, %ecx, %xmm0, %xmm0
; CHECK-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; CHECK-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; CHECK-NEXT:    addl $68, %esp
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: cvt_v2f32_v2u32:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vmovaps {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; CHECK-WIDE-NEXT:    vcmpltps %xmm1, %xmm0, %xmm2
; CHECK-WIDE-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm1, %xmm1
; CHECK-WIDE-NEXT:    vxorps LCPI11_1, %xmm1, %xmm1
; CHECK-WIDE-NEXT:    vcvttps2dq %xmm0, %xmm0
; CHECK-WIDE-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; CHECK-WIDE-NEXT:    retl
  %res = fptoui <2 x float> %src to <2 x i32>
  ret <2 x i32> %res
}

define <32 x i8> @PR40146(<4 x i64> %x) {
; CHECK-LABEL: PR40146:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; CHECK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; CHECK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; CHECK-NEXT:    retl
;
; CHECK-WIDE-LABEL: PR40146:
; CHECK-WIDE:       ## %bb.0:
; CHECK-WIDE-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-WIDE-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; CHECK-WIDE-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; CHECK-WIDE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; CHECK-WIDE-NEXT:    retl
  %perm = shufflevector <4 x i64> %x, <4 x i64> undef, <4 x i32> <i32 0, i32 undef, i32 1, i32 undef>
  %t1 = bitcast <4 x i64> %perm to <32 x i8>
  %t2 = shufflevector <32 x i8> %t1, <32 x i8> <i8 0, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 0, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef>, <32 x i32> <i32 0, i32 32, i32 1, i32 32, i32 2, i32 32, i32 3, i32 32, i32 4, i32 32, i32 5, i32 32, i32 6, i32 32, i32 7, i32 32, i32 16, i32 48, i32 17, i32 48, i32 18, i32 48, i32 19, i32 48, i32 20, i32 48, i32 21, i32 48, i32 22, i32 48, i32 23, i32 48>
  ret <32 x i8> %t2
}

