//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <functional>

// template <class T>
// struct hash
//     : public unary_function<T, size_t>
// {
//     size_t operator()(T val) const;
// };

// Not very portable

#include <functional>
#include <cassert>
#include <type_traits>
#include <cstddef>
#include <limits>

template <class T>
void
test()
{
    typedef std::hash<T> H;
    static_assert((std::is_same<typename H::argument_type, T>::value), "" );
    static_assert((std::is_same<typename H::result_type, std::size_t>::value), "" );
    H h;

    for (int i = 0; i <= 5; ++i)
    {
        T t(i);
        if (sizeof(T) <= sizeof(std::size_t))
            assert(h(t) == t);
    }
}

int main()
{
    test<bool>();
    test<char>();
    test<signed char>();
    test<unsigned char>();
    test<char16_t>();
    test<char32_t>();
    test<wchar_t>();
    test<short>();
    test<unsigned short>();
    test<int>();
    test<unsigned int>();
    test<long>();
    test<unsigned long>();
    test<long long>();
    test<unsigned long long>();

//	LWG #2119
    test<std::ptrdiff_t>();
    test<size_t>();

	test<int8_t>();
	test<int16_t>();
	test<int32_t>();
	test<int64_t>();
	
	test<int_fast8_t>();
	test<int_fast16_t>();
	test<int_fast32_t>();
	test<int_fast64_t>();

	test<int_least8_t>();
	test<int_least16_t>();
	test<int_least32_t>();
	test<int_least64_t>();

    test<intmax_t>();
    test<intptr_t>();
	
	test<uint8_t>();
	test<uint16_t>();
	test<uint32_t>();
	test<uint64_t>();
	
	test<uint_fast8_t>();
	test<uint_fast16_t>();
	test<uint_fast32_t>();
	test<uint_fast64_t>();

	test<uint_least8_t>();
	test<uint_least16_t>();
	test<uint_least32_t>();
	test<uint_least64_t>();

    test<uintmax_t>();
    test<uintptr_t>();
}
