#! /bin/sh

MD5='n'
SHA1='n'
SHA224='n'
SHA256='n'
SHA384='n'
SHA512='n'
B2_256='n'
B2_512='n'
BYTES='all'
while getopts 12345678cn: opts
do
  case $opts in
    1) MD5=y ;;
    2) SHA1=y ;;
    3) SHA224=y ;;
    4) SHA256=y ;;
    5) SHA384=y ;;
    6) SHA512=y ;;
    7) B2_256=y ;;
    8) B2_512=y ;;
    n) BYTES="$OPTARG" ;;
  esac
done
shift `expr ${OPTIND} - 1`

if [ "$BYTES" = 'all' ]; then
  for IDX in "$@" ; do
    if [ "$MD5" = 'y' ]; then md5sum $IDX ; fi
    if [ "$SHA1" = 'y' ]; then sha1sum $IDX ; fi
    if [ "$SHA224" = 'y' ]; then sha224sum $IDX ; fi
    if [ "$SHA256" = 'y' ]; then sha256sum $IDX ; fi
    if [ "$SHA384" = 'y' ]; then sha384sum $IDX ; fi
    if [ "$SHA512" = 'y' ]; then sha512sum $IDX ; fi
    if [ "$B2_256" = 'y' ]; then b2sum -l 256 $IDX ; fi
    if [ "$B2_512" = 'y' ]; then b2sum -l 512 $IDX ; fi
  done
else
  for IDX in "$@" ; do
    if [ "$MD5" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | md5sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$SHA1" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | sha1sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$SHA224" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | sha224sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$SHA256" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | sha256sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$SHA384" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | sha384sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$SHA512" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | sha512sum | sed -e "s/-$/$IDX/" ; fi
    if [ "$B2_256" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | b2sum -l 256 | sed -e "s/-$/$IDX/" ; fi
    if [ "$B2_512" = 'y' ]; then dd status=none if=$IDX bs=1 count="$BYTES" | b2sum -l 512 | sed -e "s/-$/$IDX/" ; fi
  done
fi
