/**************************************************************************************\
*              The Lisa Emulator Project  V1.2.6      DEV 2007.12.04                   *
*                                                                                      *
*                  Copyright (C) 1998, 2007 Ray A. Arachelian                          *
*                            All Rights Reserved                                       *
*                                                                                      *
*   Default native keystroke to Lisa COPS processor keyboard translation table.        *
*    this is a table of 256 ascii values to strings of upto 10 Lisa keycodes.          *
\**************************************************************************************/


// need to recode this for keytronix and non-US keyboards as well
char keydecodetable[256][11]=
{
  //SHIFT KEYDN KEYUP SHIFTUP  ---SPARE FOR ACCENTS--   HOSTASCII        HEX DEC  ASCII
  //KEYDN KEYUP                ---SPARE FOR ACCENTS--   HOSTASCII        HEX DEC  ASCII
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x00   0 ^@ */
  { 0xff, 0xf0, 0x70, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x01 }, /* 0x01   1 ^A */
  { 0xff, 0xee, 0x6e, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x02 }, /* 0x02   2 ^B */
  { 0xc6, 0x46, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x03 }, /* 0x03   3 ^C */
  { 0xff, 0xfb, 0x7b, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x04   4 ^D */
  { 0xff, 0xe0, 0x60, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x05 }, /* 0x05   5 ^E */
  { 0xff, 0xe9, 0x69, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x06 }, /* 0x06   6 ^F */
  { 0xff, 0xea, 0x6a, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x07 }, /* 0x07   7 ^G */
  { 0xc5, 0x45, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x08 }, /* 0x08   8 ^H */
  { 0xf8, 0x78, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x09   9 ^I */
  { 0xff, 0xd4, 0x54, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x0a  10 ^J */
  { 0xff, 0xd5, 0x55, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x0b }, /* 0x0b  11 ^K */
  { 0xff, 0xd9, 0x59, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x0c }, /* 0x0c  12 ^L */
  { 0xc8, 0x48, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x0d }, /* 0x0d  13 ^M */
  { 0xff, 0xef, 0x6f, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x0e  14 ^N */
  { 0xff, 0xdf, 0x5f, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x0f }, /* 0x0f  15 ^O */
  { 0xff, 0xc4, 0x44, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x10 }, /* 0x10  16 ^P */
  { 0xff, 0xf5, 0x75, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x11 }, /* 0x11  17 ^Q */
  { 0xff, 0xe5, 0x65, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x12 }, /* 0x12  18 ^R */
  { 0xff, 0xf6, 0x76, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x13 }, /* 0x13  19 ^S */
  { 0xff, 0xe6, 0x66, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x14 }, /* 0x14  20 ^T */
  { 0xff, 0xd2, 0x52, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x15 }, /* 0x15  21 ^U */
  { 0xff, 0xec, 0x6c, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x16 }, /* 0x16  22 ^V */
  { 0xff, 0xf7, 0x77, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x17 }, /* 0x17  23 ^W */
  { 0xff, 0xfa, 0x7a, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x18 }, /* 0x18  24 ^X */
  { 0xff, 0xe7, 0x67, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x19 }, /* 0x19  25 ^Y */
  { 0xff, 0xf9, 0x79, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x1a }, /* 0x1a  26 ^Z */
  { 0xa0, 0x20, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x1b }, /* 0x1b  27 ^[ */
  { 0xff, 0xc2, 0x42, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x1c  28 ^\ */
  { 0xff, 0xd7, 0x57, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x1d }, /* 0x1d  29 ^] */
  { 0xff, 0xe1, 0x61, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x1e }, /* 0x1e  30 ^^ */
  { 0xff, 0xc0, 0x40, 0x7f,   0   , 0   , 0   , 0   ,   0   , 0x1f }, /* 0x1f  31 ^_ */
  { 0xdc, 0x5c, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x20 }, /* 0x20  32    */
  { 0xfe, 0xf4, 0x74, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x21  33  ! */
  { 0xfe, 0xdb, 0x5b, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x22 }, /* 0x22  34  " */
  { 0xfe, 0xf2, 0x72, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x23  35  # */
  { 0xfe, 0xf3, 0x73, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x24 }, /* 0x24  36  $ */
  { 0xfe, 0xe4, 0x64, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x25 }, /* 0x25  37  % */
  { 0xfe, 0xe2, 0x62, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x26 }, /* 0x26  38  & */
  { 0xdb, 0x5b, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x27 }, /* 0x27  39  ' */
  { 0xfe, 0xd0, 0x50, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x28  40  ( */
  { 0xfe, 0xd1, 0x51, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x29 }, /* 0x29  41  ) */
  { 0xfe, 0xe3, 0x63, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x2a  42  * */
  { 0xfe, 0xc1, 0x41, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x2b }, /* 0x2b  43  + */
  { 0xdd, 0x5d, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x2c }, /* 0x2c  44  , */
  { 0xc0, 0x40, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x2d  45  - */
  { 0xde, 0x5e, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x2e }, /* 0x2e  46  . */
  { 0xcc, 0x4c, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x2f }, /* 0x2f  47  / */
  { 0xd1, 0x51, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x30  48  0 */
  { 0xf4, 0x74, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x31  49  1 */
  { 0xf1, 0x71, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x32 }, /* 0x32  50  2 */
  { 0xf2, 0x72, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x33 }, /* 0x33  51  3 */
  { 0xf3, 0x73, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x34 }, /* 0x34  52  4 */
  { 0xe4, 0x64, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x35 }, /* 0x35  53  5 */
  { 0xe1, 0x61, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x36 }, /* 0x36  54  6 */
  { 0xe2, 0x62, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x37 }, /* 0x37  55  7 */
  { 0xe3, 0x63, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x38 }, /* 0x38  56  8 */
  { 0xd0, 0x50, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x39 }, /* 0x39  57  9 */
  { 0xfe, 0xda, 0x5a, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x3a }, /* 0x3a  58  : */
  { 0xda, 0x5a, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x3b  59  ; */
  { 0xfe, 0xdd, 0x5d, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x3c }, /* 0x3c  60  < */
  { 0xc1, 0x41, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x3d  61  = */
  { 0xfe, 0xde, 0x5e, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x3e }, /* 0x3e  62  > */
  { 0xfe, 0xcc, 0x4c, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x3f }, /* 0x3f  63  ? */
  { 0xfe, 0xf1, 0x71, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x40  64  @ */
  { 0xfe, 0xf0, 0x70, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x41 }, /* 0x41  65  A */
  { 0xfe, 0xee, 0x6e, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x42 }, /* 0x42  66  B */
  { 0xfe, 0xed, 0x6d, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x43  67  C */
  { 0xfe, 0xfb, 0x7b, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x44  68  D */
  { 0xfe, 0xe0, 0x60, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x45  69  E */
  { 0xfe, 0xe9, 0x69, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x46 }, /* 0x46  70  F */
  { 0xfe, 0xea, 0x6a, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x47 }, /* 0x47  71  G */
  { 0xfe, 0xeb, 0x6b, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x48 }, /* 0x48  72  H */
  { 0xfe, 0xd3, 0x53, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x49  73  I */
  { 0xfe, 0xd4, 0x54, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x4a }, /* 0x4a  74  J */
  { 0xfe, 0xd5, 0x55, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x4b }, /* 0x4b  75  K */
  { 0xfe, 0xd9, 0x59, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x4c }, /* 0x4c  76  L */
  { 0xfe, 0xd8, 0x58, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x4d }, /* 0x4d  77  M */
  { 0xfe, 0xef, 0x6f, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x4e  78  N */
  { 0xfe, 0xdf, 0x5f, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x4f  79  O */
  { 0xfe, 0xc4, 0x44, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x50 }, /* 0x50  80  P */
  { 0xfe, 0xf5, 0x75, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x51  81  Q */
  { 0xfe, 0xe5, 0x65, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x52 }, /* 0x52  82  R */
  { 0xfe, 0xf6, 0x76, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x53 }, /* 0x53  83  S */
  { 0xfe, 0xe6, 0x66, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x54  84  T */
  { 0xfe, 0xd2, 0x52, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x55 }, /* 0x55  85  U */
  { 0xfe, 0xec, 0x6c, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x56 }, /* 0x56  86  V */
  { 0xfe, 0xf7, 0x77, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x57  87  W */
  { 0xfe, 0xfa, 0x7a, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x58 }, /* 0x58  88  X */
  { 0xfe, 0xe7, 0x67, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x59  89  Y */
  { 0xfe, 0xf9, 0x79, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x5a }, /* 0x5a  90  Z */
  { 0xd6, 0x56, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x5b  91  [ */
  { 0xc2, 0x42, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x5c }, /* 0x5c  92  \ */
  { 0xd7, 0x57, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x5d  93  ] */
  { 0xfe, 0xe1, 0x61, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x5e  94  ^ */
  { 0xfe, 0xc0, 0x40, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x5f }, /* 0x5f  95  _ */
  { 0xe8, 0x68, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x60  96  ` */
  { 0xf0, 0x70, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x61 }, /* 0x61  97  a */
  { 0xee, 0x6e, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x62 }, /* 0x62  98  b */
  { 0xed, 0x6d, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x63  99  c */
  { 0xfb, 0x7b, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x64 100  d */
  { 0xe0, 0x60, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x65 101  e */
  { 0xe9, 0x69, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x66 }, /* 0x66 102  f */
  { 0xea, 0x6a, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x67 }, /* 0x67 103  g */
  { 0xeb, 0x6b, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x68 }, /* 0x68 104  h */
  { 0xd3, 0x53, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x69 105  i */
  { 0xd4, 0x54, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x6a }, /* 0x6a 106  j */
  { 0xd5, 0x55, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x6b }, /* 0x6b 107  k */
  { 0xd9, 0x59, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x6c }, /* 0x6c 108  l */
  { 0xd8, 0x58, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x6d }, /* 0x6d 109  m */
  { 0xef, 0x6f, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x6e 110  n */
  { 0xdf, 0x5f, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x6f 111  o */
  { 0xc4, 0x44, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x70 }, /* 0x70 112  p */
  { 0xf5, 0x75, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x71 113  q */
  { 0xe5, 0x65, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x72 }, /* 0x72 114  r */
  { 0xf6, 0x76, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x73 }, /* 0x73 115  s */
  { 0xe6, 0x66, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x74 116  t */
  { 0xd2, 0x52, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x75 }, /* 0x75 117  u */
  { 0xec, 0x6c, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x76 }, /* 0x76 118  v */
  { 0xf7, 0x77, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x77 119  w */
  { 0xfa, 0x7a, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x78 }, /* 0x78 120  x */
  { 0xe7, 0x67, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x79 121  y */
  { 0xf9, 0x79, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x7a }, /* 0x7a 122  z */
  { 0xfe, 0xd6, 0x56, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x7b 123  { */
  { 0xfe, 0xcc, 0x4c, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0x7c }, /* 0x7c 124  | */  // was 0x42!
  { 0xfe, 0xd7, 0x57, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x7d 125  } */
  { 0xfe, 0xe8, 0x68, 0x7e,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x7e 126  ~ */
  { 0xc5, 0x45, 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0x7f }, /* 0x7f 127    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x80 128    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x81 129    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x82 130    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x83 131    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x84 132    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x85 133    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x86 134    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x87 135    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x88 136    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x89 137    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8a 138    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8b 139    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8c 140    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8d 141    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8e 142    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x8f 143    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x90 144    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x91 145    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x92 146    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x93 147    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x94 148    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x95 149    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x96 150    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x97 151    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x98 152    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x99 153    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9a 154    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9b 155    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9c 156    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9d 157    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9e 158    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0x9f 159    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa0 160    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa1 161    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa2 162    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa3 163    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa4 164    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa5 165    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa6 166    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa7 167    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa8 168    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xa9 169    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xaa 170    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xab 171    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xac 172    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xad 173    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xae 174    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xaf 175    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb0 176    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb1 177    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb2 178    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb3 179    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb4 180    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb5 181    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb6 182    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb7 183    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb8 184    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xb9 185    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xba 186    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xbb 187    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xbc 188    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xbd 189    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xbe 190    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xbf 191    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc0 192    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc1 193    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc2 194    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc3 195    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc4 196    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc5 197    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc6 198    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc7 199    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc8 200    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xc9 201    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xca 202    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xcb 203    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xcc 204    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xcd 205    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xce 206    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xcf 207    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd0 208    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd1 209    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd2 210    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd3 211    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd4 212    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd5 213    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd6 214    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd7 215    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd8 216    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xd9 217    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xda 218    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xdb 219    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xdc 220    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xdd 221    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xde 222    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xdf 223    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe0 224    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe1 225    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe2 226    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe3 227    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe4 228    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe5 229    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe6 230    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe7 231    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe8 232    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xe9 233    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xea 234    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xeb 235    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xec 236    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xed 237    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xee 238    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xef 239    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf0 240    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf1 241    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf2 242    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf3 243    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf4 244    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf5 245    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf6 246    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf7 247    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf8 248    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xf9 249    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xfa 250    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xfb 251    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xfc 252    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xfd 253    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }, /* 0xfe 254    */
  { 0   , 0   , 0   , 0   ,   0   , 0   , 0   , 0   ,   0   , 0    }  /* 0xff 255    */
};
