%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.20.0"

\header {
  lsrtags = "staff-notation, tweaks-and-overrides"

  texidoc = "
A glissando which extends into several @code{\\alternative} blocks can
be simulated by adding a hidden grace note with a glissando at the
start of each @code{\\alternative} block.  The grace note should be at
the same pitch as the note which starts the initial glissando.  This is
implemented here with a music function which takes the pitch of the
grace note as its argument.

Note that in polyphonic music the grace note must be matched with
corresponding grace notes in all other voices.

"
  doctitle = "Extending glissandi across repeats"
} % begin verbatim

repeatGliss = #(define-music-function (grace)
  (ly:pitch?)
  #{
    % the next two lines ensure the glissando is long enough
    % to be visible
    \once \override Glissando.springs-and-rods
      = #ly:spanner::set-spacing-rods
    \once \override Glissando.minimum-length = #3.5
    \once \hideNotes
    \grace $grace \glissando
  #})

\score {
  \relative c'' {
    \repeat volta 3 { c4 d e f\glissando }
    \alternative {
      { g2 d }
      { \repeatGliss f g2 e }
      { \repeatGliss f e2 d }
    }
  }
}

music =  \relative c' {
  \voiceOne
  \repeat volta 2 {
    g a b c\glissando
  }
  \alternative {
    { d1 }
    { \repeatGliss c \once \omit StringNumber e1\2 }
  }
}

\score {
  \new StaffGroup <<
    \new Staff <<
      \context Voice { \clef "G_8" \music }
    >>
    \new TabStaff  <<
      \context TabVoice { \clef "moderntab" \music }
    >>
  >>
}
