.TH "ZIP_NAME_LOCATE" "3" "April 25, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_name_locate\fR
\- get index of file by name
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.PD 0
.HP 4n
\fBzip_name_locate\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *fname\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_name_locate\fR()
function returns the index of the file named
\fIfname\fR
in
\fIarchive\fR.
If
\fIarchive\fR
does not contain a file with that name, \-1 is returned.
The
\fIflags\fR
are specified by
\fIor\fR'ing
the following values, or 0 for none of them.
.RS 6n
.TP 15n
\fRZIP_FL_NOCASE\fR
Ignore case distinctions.
(Will only work well if the file names are ASCII.)
With this flag,
\fBzip_name_locate\fR()
will be slow for archives with many files.
.TP 15n
\fRZIP_FL_NODIR\fR
Ignore directory part of file name in archive.
With this flag,
\fBzip_name_locate\fR()
will be slow for archives with many files.
.TP 15n
\fRZIP_FL_ENC_RAW\fR
.br
Compare against the unmodified names as it is in the ZIP archive.
.TP 15n
\fRZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary, before comparing.
.TP 15n
\fRZIP_FL_ENC_STRICT\fR
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8 before comparing.
.RE
\fINote\fR:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
\fBzip_name_locate\fR()
returns the index of the file named
\fIfname\fR
or \-1, if
\fIarchive\fR
does not contain an entry of that name.
.SH "ERRORS"
\fBzip_name_locate\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
One of the arguments is invalid.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOENT\fR]
No entry of the name
\fIfname\fR
is found in the archive.
.SH "SEE ALSO"
libzip(3),
zip_get_name(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
