.TH "ZIP_FILE_SET_MTIME" "3" "December 29, 2016" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_set_mtime\fR
\- set last modification time (mtime) for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.PD 0
.HP 4n
\fBzip_file_set_mtime\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fItime_t\ mtime\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_set_mtime\fR()
function sets the last modification time (mtime) for the file at
position
\fIindex\fR
in the zip archive to
\fImtime\fR.
Currently, no support for any
\fIflags\fR
is implemented.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_set_mtime\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_RDONLY\fR]
The
\fIarchive\fR
was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
