#include <xdkwrl/tools/traverser.h>
#include <xdkwrl/nodes/anchor.h>
#include <xdkwrl/nodes/appearance.h>
#include <xdkwrl/nodes/audioclip.h>
#include <xdkwrl/nodes/background.h>
#include <xdkwrl/nodes/billboard.h>
#include <xdkwrl/nodes/box.h>
#include <xdkwrl/nodes/collision.h>
#include <xdkwrl/nodes/color.h>
#include <xdkwrl/nodes/colorinterpolator.h>
#include <xdkwrl/nodes/cone.h>
#include <xdkwrl/nodes/contour2d.h>
#include <xdkwrl/nodes/coordinate.h>
#include <xdkwrl/nodes/coordinatedeformer.h>
#include <xdkwrl/nodes/coordinateinterpolator.h>
#include <xdkwrl/nodes/cylinder.h>
#include <xdkwrl/nodes/cylindersensor.h>
#include <xdkwrl/nodes/directionallight.h>
#include <xdkwrl/nodes/elevationgrid.h>
#include <xdkwrl/nodes/extrusion.h>
#include <xdkwrl/nodes/fog.h>
#include <xdkwrl/nodes/fontstyle.h>
#include <xdkwrl/nodes/geocoordinate.h>
#include <xdkwrl/nodes/geoelevationgrid.h>
#include <xdkwrl/nodes/geolod.h>
#include <xdkwrl/nodes/geolocation.h>
#include <xdkwrl/nodes/geometadata.h>
#include <xdkwrl/nodes/geoorigin.h>
#include <xdkwrl/nodes/geopositioninterpolator.h>
#include <xdkwrl/nodes/geotouchsensor.h>
#include <xdkwrl/nodes/geoviewpoint.h>
#include <xdkwrl/nodes/group.h>
#include <xdkwrl/nodes/imagetexture.h>
#include <xdkwrl/nodes/indexedfaceset.h>
#include <xdkwrl/nodes/indexedlineset.h>
#include <xdkwrl/nodes/inline.h>
#include <xdkwrl/nodes/inlineloadcontrol.h>
#include <xdkwrl/nodes/lod.h>
#include <xdkwrl/nodes/material.h>
#include <xdkwrl/nodes/movietexture.h>
#include <xdkwrl/nodes/navigationinfo.h>
#include <xdkwrl/nodes/normal.h>
#include <xdkwrl/nodes/normalinterpolator.h>
#include <xdkwrl/nodes/nurbscurve.h>
#include <xdkwrl/nodes/nurbscurve2d.h>
#include <xdkwrl/nodes/nurbsgroup.h>
#include <xdkwrl/nodes/nurbspositioninterpolator.h>
#include <xdkwrl/nodes/nurbssurface.h>
#include <xdkwrl/nodes/nurbstexturesurface.h>
#include <xdkwrl/nodes/orientationinterpolator.h>
#include <xdkwrl/nodes/pixeltexture.h>
#include <xdkwrl/nodes/planesensor.h>
#include <xdkwrl/nodes/pointlight.h>
#include <xdkwrl/nodes/pointset.h>
#include <xdkwrl/nodes/polyline2d.h>
#include <xdkwrl/nodes/positioninterpolator.h>
#include <xdkwrl/nodes/proximitysensor.h>
#include <xdkwrl/nodes/scalarinterpolator.h>
#include <xdkwrl/nodes/shape.h>
#include <xdkwrl/nodes/sound.h>
#include <xdkwrl/nodes/sphere.h>
#include <xdkwrl/nodes/spheresensor.h>
#include <xdkwrl/nodes/spotlight.h>
#include <xdkwrl/nodes/switch.h>
#include <xdkwrl/nodes/text.h>
#include <xdkwrl/nodes/texturecoordinate.h>
#include <xdkwrl/nodes/texturetransform.h>
#include <xdkwrl/nodes/timesensor.h>
#include <xdkwrl/nodes/touchsensor.h>
#include <xdkwrl/nodes/transform.h>
#include <xdkwrl/nodes/trimmedsurface.h>
#include <xdkwrl/nodes/viewpoint.h>
#include <xdkwrl/nodes/visibilitysensor.h>
#include <xdkwrl/nodes/worldinfo.h>

using namespace wrl;

//***************************************************************
// Implementation of Traverser
//***************************************************************
/*! \class wrl::Traverser
 * \ingroup tools
 *
 */
void
Traverser::treat(Anchor*)
{
}
void
Traverser::treat(Appearance*)
{
}
void
Traverser::treat(AudioClip*)
{
}
void
Traverser::treat(Background*)
{
}
void
Traverser::treat(Billboard*)
{
}
void
Traverser::treat(Box*)
{
}
void
Traverser::treat(Collision*)
{
}
void
Traverser::treat(Color*)
{
}
void
Traverser::treat(ColorInterpolator*)
{
}
void
Traverser::treat(Cone*)
{
}
void
Traverser::treat(Contour2D*)
{
}
void
Traverser::treat(Coordinate*)
{
}
void
Traverser::treat(CoordinateDeformer*)
{
}
void
Traverser::treat(CoordinateInterpolator*)
{
}
void
Traverser::treat(Cylinder*)
{
}
void
Traverser::treat(CylinderSensor*)
{
}
void
Traverser::treat(DirectionalLight*)
{
}
void
Traverser::treat(ElevationGrid*)
{
}
void
Traverser::treat(Extrusion*)
{
}
void
Traverser::treat(Fog*)
{
}
void
Traverser::treat(FontStyle*)
{
}
void
Traverser::treat(GeoCoordinate*)
{
}
void
Traverser::treat(GeoElevationGrid*)
{
}
void
Traverser::treat(GeoLOD*)
{
}
void
Traverser::treat(GeoLocation*)
{
}
void
Traverser::treat(GeoMetadata*)
{
}
void
Traverser::treat(GeoOrigin*)
{
}
void
Traverser::treat(GeoPositionInterpolator*)
{
}
void
Traverser::treat(GeoTouchSensor*)
{
}
void
Traverser::treat(GeoViewpoint*)
{
}
void
Traverser::treat(Group* g)
{
  for (MFNode::const_iterator iter = g->children.begin();
       iter != g->children.end();++iter)
  {
    (*this)(*iter);
  }  
}
void
Traverser::treat(ImageTexture*)
{
}
void
Traverser::treat(IndexedFaceSet*)
{
}
void
Traverser::treat(IndexedLineSet*)
{
}
void
Traverser::treat(Inline*)
{
}
void
Traverser::treat(InlineLoadControl*)
{
}
void
Traverser::treat(LOD*)
{
}
void
Traverser::treat(Material*)
{
}
void
Traverser::treat(MovieTexture*)
{
}
void
Traverser::treat(NavigationInfo*)
{
}
void
Traverser::treat(Normal*)
{
}
void
Traverser::treat(NormalInterpolator*)
{
}
void
Traverser::treat(NurbsCurve*)
{
}
void
Traverser::treat(NurbsCurve2D*)
{
}
void
Traverser::treat(NurbsGroup*)
{
}
void
Traverser::treat(NurbsPositionInterpolator*)
{
}
void
Traverser::treat(NurbsSurface*)
{
}
void
Traverser::treat(NurbsTextureSurface*)
{
}
void
Traverser::treat(OrientationInterpolator*)
{
}
void
Traverser::treat(PixelTexture*)
{
}
void
Traverser::treat(PlaneSensor*)
{
}
void
Traverser::treat(PointLight*)
{
}
void
Traverser::treat(PointSet*)
{
}
void
Traverser::treat(Polyline2D*)
{
}
void
Traverser::treat(PositionInterpolator*)
{
}
void
Traverser::treat(ProximitySensor*)
{
}
void
Traverser::treat(ScalarInterpolator*)
{
}
void
Traverser::treat(Shape*)
{
}
void
Traverser::treat(Sound*)
{
}
void
Traverser::treat(Sphere*)
{
}
void
Traverser::treat(SphereSensor*)
{
}
void
Traverser::treat(SpotLight*)
{
}
void
Traverser::treat(Switch* s)
{
  if (s->whichChoice != -1)
  {
    (*this)(s->choice[s->whichChoice]);
  }
}
void
Traverser::treat(Text*)
{
}
void
Traverser::treat(TextureCoordinate*)
{
}
void
Traverser::treat(TextureTransform*)
{
}
void
Traverser::treat(TimeSensor*)
{
}
void
Traverser::treat(TouchSensor*)
{
}
void
Traverser::treat(Transform* t)
{
  Transformator transformator;
  // Translation  
  transformator.translate(t->translation.x(),
			  t->translation.y(),
			  t->translation.z());
  // Translation of the rotation center
  transformator.translate(-t->center.x(),
			  -t->center.y(),
			  -t->center.z());
  // Rotation
  if (t->rotation.angle() != 0.0f)
  {
    transformator.rotate(t->rotation.angle(),
			 t->rotation.axis()[0],
			 t->rotation.axis()[1],
			 t->rotation.axis()[2]);
  }
  // Scale Rotation
  if (t->scaleOrientation.angle() != 0.0f)
  {
    transformator.rotate(t->scaleOrientation.angle(),
			 t->scaleOrientation.axis()[0],
			 t->scaleOrientation.axis()[1],
			 t->scaleOrientation.axis()[2]);
  }
  // Scale
  transformator.scale(t->scale.x(),t->scale.y(),t->scale.z());
  // Inverse Scale Rotation
  if (t->scaleOrientation.angle() != 0.0f)
  {
    transformator.rotate(-t->scaleOrientation.angle(),
			 t->scaleOrientation.axis()[0],
			 t->scaleOrientation.axis()[1],
			 t->scaleOrientation.axis()[2]);
  }
  // Inverse Translation of the rotation center
  transformator.translate(t->center.x(),
			  t->center.y(),
			  t->center.z());

  // And then traverse the children
  transformHierarchy_.push(transformator);
  for (MFNode::const_iterator
	 iter = t->children.begin();
       iter != t->children.end();++iter)
  {
    (*this)(*iter);
  }
  transformHierarchy_.pop();
}
void
Traverser::treat(TrimmedSurface*)
{
}
void
Traverser::treat(Viewpoint*)
{
}
void
Traverser::treat(VisibilitySensor*)
{
}
void
Traverser::treat(WorldInfo*)
{
}
void
Traverser::operator()(Node* node)
{
  if (node == NULL) return; 
  {
    Anchor* n = dynamic_cast<Anchor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Appearance* n = dynamic_cast<Appearance*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    AudioClip* n = dynamic_cast<AudioClip*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Background* n = dynamic_cast<Background*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Billboard* n = dynamic_cast<Billboard*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Box* n = dynamic_cast<Box*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Collision* n = dynamic_cast<Collision*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Color* n = dynamic_cast<Color*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    ColorInterpolator* n = dynamic_cast<ColorInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Cone* n = dynamic_cast<Cone*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Contour2D* n = dynamic_cast<Contour2D*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Coordinate* n = dynamic_cast<Coordinate*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    CoordinateDeformer* n = dynamic_cast<CoordinateDeformer*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    CoordinateInterpolator* n = dynamic_cast<CoordinateInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Cylinder* n = dynamic_cast<Cylinder*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    CylinderSensor* n = dynamic_cast<CylinderSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    DirectionalLight* n = dynamic_cast<DirectionalLight*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    ElevationGrid* n = dynamic_cast<ElevationGrid*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Extrusion* n = dynamic_cast<Extrusion*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Fog* n = dynamic_cast<Fog*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    FontStyle* n = dynamic_cast<FontStyle*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoCoordinate* n = dynamic_cast<GeoCoordinate*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoElevationGrid* n = dynamic_cast<GeoElevationGrid*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoLOD* n = dynamic_cast<GeoLOD*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoLocation* n = dynamic_cast<GeoLocation*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoMetadata* n = dynamic_cast<GeoMetadata*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoOrigin* n = dynamic_cast<GeoOrigin*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoPositionInterpolator* n = dynamic_cast<GeoPositionInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoTouchSensor* n = dynamic_cast<GeoTouchSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    GeoViewpoint* n = dynamic_cast<GeoViewpoint*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Group* n = dynamic_cast<Group*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    ImageTexture* n = dynamic_cast<ImageTexture*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    IndexedFaceSet* n = dynamic_cast<IndexedFaceSet*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    IndexedLineSet* n = dynamic_cast<IndexedLineSet*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Inline* n = dynamic_cast<Inline*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    InlineLoadControl* n = dynamic_cast<InlineLoadControl*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    LOD* n = dynamic_cast<LOD*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Material* n = dynamic_cast<Material*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    MovieTexture* n = dynamic_cast<MovieTexture*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NavigationInfo* n = dynamic_cast<NavigationInfo*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Normal* n = dynamic_cast<Normal*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NormalInterpolator* n = dynamic_cast<NormalInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsCurve* n = dynamic_cast<NurbsCurve*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsCurve2D* n = dynamic_cast<NurbsCurve2D*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsGroup* n = dynamic_cast<NurbsGroup*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsPositionInterpolator* n = dynamic_cast<NurbsPositionInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsSurface* n = dynamic_cast<NurbsSurface*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    NurbsTextureSurface* n = dynamic_cast<NurbsTextureSurface*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    OrientationInterpolator* n = dynamic_cast<OrientationInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    PixelTexture* n = dynamic_cast<PixelTexture*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    PlaneSensor* n = dynamic_cast<PlaneSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    PointLight* n = dynamic_cast<PointLight*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    PointSet* n = dynamic_cast<PointSet*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Polyline2D* n = dynamic_cast<Polyline2D*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    PositionInterpolator* n = dynamic_cast<PositionInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    ProximitySensor* n = dynamic_cast<ProximitySensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    ScalarInterpolator* n = dynamic_cast<ScalarInterpolator*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Shape* n = dynamic_cast<Shape*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Sound* n = dynamic_cast<Sound*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Sphere* n = dynamic_cast<Sphere*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    SphereSensor* n = dynamic_cast<SphereSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    SpotLight* n = dynamic_cast<SpotLight*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Switch* n = dynamic_cast<Switch*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Text* n = dynamic_cast<Text*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    TextureCoordinate* n = dynamic_cast<TextureCoordinate*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    TextureTransform* n = dynamic_cast<TextureTransform*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    TimeSensor* n = dynamic_cast<TimeSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    TouchSensor* n = dynamic_cast<TouchSensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Transform* n = dynamic_cast<Transform*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    TrimmedSurface* n = dynamic_cast<TrimmedSurface*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    Viewpoint* n = dynamic_cast<Viewpoint*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    VisibilitySensor* n = dynamic_cast<VisibilitySensor*>(node);
    if (n!=NULL) { treat(n); return; }
  }
  {
    WorldInfo* n = dynamic_cast<WorldInfo*>(node);
    if (n!=NULL) { treat(n); return; }
  }
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../../include/xdkwrl/tools/")
// End:
