#include <xdkwrl/proto.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfimage.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/mftime.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>

#include <stdexcept>

using namespace std;
using namespace wrl;

template<class T>
static
const string&
ithKey(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return fter->first;
}
template<class T>
static
T*
ithValue(map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}
template<class T>
static
const T*
ithValue(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}
//************************************************************
// Implementation of DeclaredNodeWithBindings
//************************************************************
/*! \class wrl::DeclaredNodeWithBindings
 * \ingroup basetypes
 *
 */
DeclaredNodeWithBindings::DeclaredNodeWithBindings(const char* name)
  : DeclaredNode(name)
{
}
void
DeclaredNodeWithBindings::propagateBindings()
{
  for (BindingMap::const_iterator iter = fieldBindings_.begin();
       iter != fieldBindings_.end();++iter)
  {
    for (list<Binding>::const_iterator jter = iter->second.begin();
	 jter != iter->second.end();++jter)
    {
      FieldHandle to   = iter->first->field(jter->first.c_str());
      FieldHandle from = field(jter->second.c_str());
      FieldHandle::copy(to,from);
    }
  }
  for (BindingMap::const_iterator iter = eventInBindings_.begin();
       iter != eventInBindings_.end();++iter)
  {
    for (list<Binding>::const_iterator jter = iter->second.begin();
	 jter != iter->second.end();++jter)
    {
      EventInHandle to   = iter->first->eventIn(jter->first.c_str());
      EventInHandle from = eventIn(jter->second.c_str());
//       EventInHandle::copy(to,from); // TODO:
    }
  }
  for (BindingMap::const_iterator iter = eventOutBindings_.begin();
       iter != eventOutBindings_.end();++iter)
  {
    for (list<Binding>::const_iterator jter = iter->second.begin();
	 jter != iter->second.end();++jter)
    {
      EventOutHandle to   = iter->first->eventOut(jter->first.c_str());
      EventOutHandle from = eventOut(jter->second.c_str());
//       EventOutHandle::copy(to,from); // TODO:
    }
  }
}
void
DeclaredNodeWithBindings::bindFields(Node* n,const char* to,const char* from)
{
  fieldBindings_[n].push_back(Binding(to,from));
}
void
DeclaredNodeWithBindings::bindEventsIn(Node* n,const char* to,const char* from)
{
  eventInBindings_[n].push_back(Binding(to,from));
}
void
DeclaredNodeWithBindings::bindEventsOut(Node* n,const char* to,const char* from)
{
  eventOutBindings_[n].push_back(Binding(to,from));
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFBool& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFColor& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFFloat& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFImage& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFInt32& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFNode& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFRotation& v)
{
  Node::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFString& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFTime& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFVec2f& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const SFVec3f& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFColor& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFFloat& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFInt32& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFNode& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFRotation& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFString& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFTime& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFVec2f& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
void
DeclaredNodeWithBindings::setField(const FieldHandle& f,const MFVec3f& v)
{
  DeclaredNode::setField(f,v);
  propagateBindings();
}
//************************************************************
// Implementation of ProtoDeclaration
//************************************************************
/*! \class wrl::ProtoDeclaration
 * \ingroup basetypes
 *
 */
ProtoDeclaration::ProtoDeclaration(const char* nodeTypeId,const char* name)
  : DeclaredNodeWithBindings(name),nodeTypeId_(nodeTypeId)
{  
}
void
ProtoDeclaration::setNodes(const MFNode& n)
{
  nodes_ = n;
}
Node*
ProtoDeclaration::duplicate() const
{
  ProtoDeclaration* p = new ProtoDeclaration(nodeTypeId_.c_str(),name());
  p->sfBoolMap_     = sfBoolMap_;    
  p->sfColorMap_    = sfColorMap_;   
  p->sfFloatMap_    = sfFloatMap_;   
  p->sfImageMap_    = sfImageMap_;   
  p->sfInt32Map_    = sfInt32Map_;   
  p->sfNodeMap_     = sfNodeMap_;    
  p->sfRotationMap_ = sfRotationMap_;        
  p->sfStringMap_   = sfStringMap_;  
  p->sfTimeMap_     = sfTimeMap_;    
  p->sfVec2fMap_    = sfVec2fMap_;   
  p->sfVec3fMap_    = sfVec3fMap_;   
  p->mfColorMap_    = mfColorMap_;   
  p->mfFloatMap_    = mfFloatMap_;   
  p->mfInt32Map_    = mfInt32Map_;   
  p->mfNodeMap_     = mfNodeMap_;    
  p->mfRotationMap_ = mfRotationMap_; 
  p->mfStringMap_   = mfStringMap_   ;
  p->mfTimeMap_     = mfTimeMap_;     
  p->mfVec2fMap_    = mfVec2fMap_;   
  p->mfVec3fMap_    = mfVec3fMap_;
  // Duplicate the nodes
  map<const Node*,Node*> nodeMap;
  for (MFNode::const_iterator iter = nodes_.begin();
       iter != nodes_.end();++iter)
  {
    p->nodes_.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  // Duplicate the bindings. It is very tricky here cause the bindings have
  // to be transposed to the instance and not the declaration.
  for (BindingMap::const_iterator iter = fieldBindings_.begin();
       iter != fieldBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->fieldBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventInBindings_.begin();
       iter != eventInBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventInBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventOutBindings_.begin();
       iter != eventOutBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventOutBindings_[nodeMap[node]] = iter->second;
  }  
  return p;
}
Node*
ProtoDeclaration::duplicate(std::map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ProtoDeclaration* p = new ProtoDeclaration(nodeTypeId_.c_str(),name());
  p->sfBoolMap_     = sfBoolMap_;    
  p->sfColorMap_    = sfColorMap_;   
  p->sfFloatMap_    = sfFloatMap_;   
  p->sfImageMap_    = sfImageMap_;   
  p->sfInt32Map_    = sfInt32Map_;   
  p->sfNodeMap_     = sfNodeMap_;    
  p->sfRotationMap_ = sfRotationMap_;        
  p->sfStringMap_   = sfStringMap_;  
  p->sfTimeMap_     = sfTimeMap_;    
  p->sfVec2fMap_    = sfVec2fMap_;   
  p->sfVec3fMap_    = sfVec3fMap_;   
  p->mfColorMap_    = mfColorMap_;   
  p->mfFloatMap_    = mfFloatMap_;   
  p->mfInt32Map_    = mfInt32Map_;   
  p->mfNodeMap_     = mfNodeMap_;    
  p->mfRotationMap_ = mfRotationMap_; 
  p->mfStringMap_   = mfStringMap_   ;
  p->mfTimeMap_     = mfTimeMap_;     
  p->mfVec2fMap_    = mfVec2fMap_;   
  p->mfVec3fMap_    = mfVec3fMap_;
  // Duplicate the nodes
  for (MFNode::const_iterator iter = nodes_.begin();
       iter != nodes_.end();++iter)
  {
    p->nodes_.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  // Duplicate the bindings. It is very tricky here cause the bindings have
  // to be transposed to the instance and not the declaration.
  for (BindingMap::const_iterator iter = fieldBindings_.begin();
       iter != fieldBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->fieldBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventInBindings_.begin();
       iter != eventInBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventInBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventOutBindings_.begin();
       iter != eventOutBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventOutBindings_[nodeMap[node]] = iter->second;
  }  
  return nodeMap[this] = p;
}
bool
ProtoDeclaration::isSetToDefaultValue(unsigned int) const
{
  // Rq: a proto declaration is necesarily set to default value. See
  // ProtoInstance
  return false;
}
//************************************************************
// Implementation of ExternProtoDeclaration
//************************************************************
/*! \class wrl::ExternProtoDeclaration
 * \ingroup basetypes
 *
 */
ExternProtoDeclaration::ExternProtoDeclaration(const char* nodeTypeId,
					       const char* name)
  : ProtoDeclaration(nodeTypeId,name),
    loaded_(false)
{
}
/*!
 * Reads the external declaration
 */ 
bool
ExternProtoDeclaration::getExternalDeclaration()
{
  // TODO: parse the file
  return false;
}
//************************************************************
// Implementation of ProtoInstance
//************************************************************
/*! \class wrl::ProtoInstance
 * \ingroup basetypes
 *
 */
ProtoInstance::ProtoInstance(const ProtoDeclaration* d,const char* name)
  : DeclaredNodeWithBindings(name),declaration_(d)
{
  sfBoolMap_     = d->sfBoolMap_;    
  sfColorMap_    = d->sfColorMap_;   
  sfFloatMap_    = d->sfFloatMap_;   
  sfImageMap_    = d->sfImageMap_;   
  sfInt32Map_    = d->sfInt32Map_;   
  sfNodeMap_     = d->sfNodeMap_;    
  sfRotationMap_ = d->sfRotationMap_;        
  sfStringMap_   = d->sfStringMap_;  
  sfTimeMap_     = d->sfTimeMap_;    
  sfVec2fMap_    = d->sfVec2fMap_;   
  sfVec3fMap_    = d->sfVec3fMap_;   
  mfColorMap_    = d->mfColorMap_;   
  mfFloatMap_    = d->mfFloatMap_;   
  mfInt32Map_    = d->mfInt32Map_;   
  mfNodeMap_     = d->mfNodeMap_;    
  mfRotationMap_ = d->mfRotationMap_; 
  mfStringMap_   = d->mfStringMap_   ;
  mfTimeMap_     = d->mfTimeMap_;     
  mfVec2fMap_    = d->mfVec2fMap_;   
  mfVec3fMap_    = d->mfVec3fMap_;
  // Duplicate the nodes
  map<const Node*,Node*> nodeMap;
  for (MFNode::const_iterator iter = d->nodes_.begin();
       iter != d->nodes_.end();++iter)
  {
    nodes_.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  // Duplicate the bindings. It is very tricky here cause the bindings have
  // to be transposed to the instance and not the declaration.
  for (BindingMap::const_iterator iter = d->fieldBindings_.begin();
       iter != d->fieldBindings_.end();++iter)
  {
    const Node* node = iter->first;
    fieldBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = d->eventInBindings_.begin();
       iter != d->eventInBindings_.end();++iter)
  {
    const Node* node = iter->first;
    eventInBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = d->eventOutBindings_.begin();
       iter != d->eventOutBindings_.end();++iter)
  {
    const Node* node = iter->first;
    eventOutBindings_[nodeMap[node]] = iter->second;
  }  
}
ProtoInstance::ProtoInstance(const char* name)
  : DeclaredNodeWithBindings(name),declaration_(NULL)
{
}
Node*
ProtoInstance::duplicate() const
{
  ProtoInstance* p = new ProtoInstance(name());
  p->declaration_ = declaration_;
  p->sfBoolMap_     = sfBoolMap_;    
  p->sfColorMap_    = sfColorMap_;   
  p->sfFloatMap_    = sfFloatMap_;   
  p->sfImageMap_    = sfImageMap_;   
  p->sfInt32Map_    = sfInt32Map_;   
  p->sfNodeMap_     = sfNodeMap_;    
  p->sfRotationMap_ = sfRotationMap_;        
  p->sfStringMap_   = sfStringMap_;  
  p->sfTimeMap_     = sfTimeMap_;    
  p->sfVec2fMap_    = sfVec2fMap_;   
  p->sfVec3fMap_    = sfVec3fMap_;   
  p->mfColorMap_    = mfColorMap_;   
  p->mfFloatMap_    = mfFloatMap_;   
  p->mfInt32Map_    = mfInt32Map_;   
  p->mfNodeMap_     = mfNodeMap_;    
  p->mfRotationMap_ = mfRotationMap_; 
  p->mfStringMap_   = mfStringMap_   ;
  p->mfTimeMap_     = mfTimeMap_;     
  p->mfVec2fMap_    = mfVec2fMap_;   
  p->mfVec3fMap_    = mfVec3fMap_;
  // Duplicate the nodes
  map<const Node*,Node*> nodeMap;
  for (MFNode::const_iterator iter = nodes_.begin();
       iter != nodes_.end();++iter)
  {
    p->nodes_.push_back(SFNode((*iter)->duplicate()));
  }
  // Duplicate the bindings. It is very tricky here cause the bindings have
  // to be transposed to the instance and not the declaration.
  for (BindingMap::const_iterator iter = fieldBindings_.begin();
       iter != fieldBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->fieldBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventInBindings_.begin();
       iter != eventInBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventInBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventOutBindings_.begin();
       iter != eventOutBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventOutBindings_[nodeMap[node]] = iter->second;
  }  
  return p;
}
Node*
ProtoInstance::duplicate(std::map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ProtoInstance* p = new ProtoInstance(name());
  p->declaration_ = declaration_;
  p->sfBoolMap_     = sfBoolMap_;    
  p->sfColorMap_    = sfColorMap_;   
  p->sfFloatMap_    = sfFloatMap_;   
  p->sfImageMap_    = sfImageMap_;   
  p->sfInt32Map_    = sfInt32Map_;   
  p->sfNodeMap_     = sfNodeMap_;    
  p->sfRotationMap_ = sfRotationMap_;        
  p->sfStringMap_   = sfStringMap_;  
  p->sfTimeMap_     = sfTimeMap_;    
  p->sfVec2fMap_    = sfVec2fMap_;   
  p->sfVec3fMap_    = sfVec3fMap_;   
  p->mfColorMap_    = mfColorMap_;   
  p->mfFloatMap_    = mfFloatMap_;   
  p->mfInt32Map_    = mfInt32Map_;   
  p->mfNodeMap_     = mfNodeMap_;    
  p->mfRotationMap_ = mfRotationMap_; 
  p->mfStringMap_   = mfStringMap_   ;
  p->mfTimeMap_     = mfTimeMap_;     
  p->mfVec2fMap_    = mfVec2fMap_;   
  p->mfVec3fMap_    = mfVec3fMap_;
  // Duplicate the nodes
  for (MFNode::const_iterator iter = nodes_.begin();
       iter != nodes_.end();++iter)
  {
    p->nodes_.push_back(SFNode( (*iter)->duplicate()));
  }
  // Duplicate the bindings. It is very tricky here cause the bindings have
  // to be transposed to the instance and not the declaration.
  for (BindingMap::const_iterator iter = fieldBindings_.begin();
       iter != fieldBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->fieldBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventInBindings_.begin();
       iter != eventInBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventInBindings_[nodeMap[node]] = iter->second;
  }  
  for (BindingMap::const_iterator iter = eventOutBindings_.begin();
       iter != eventOutBindings_.end();++iter)
  {
    const Node* node = iter->first;
    p->eventOutBindings_[nodeMap[node]] = iter->second;
  }  
  return nodeMap[this] = p;
}
bool
ProtoInstance::isSetToDefaultValue(unsigned int n) const
{
  // Compare with the value stored in the declaration node.
  unsigned int i=n;
  if (i<sfBoolMap_.size())
  {
    return
      *ithValue(sfBoolMap_,i) == *ithValue(declaration_->sfBoolMap_,i);
  }
  i -= sfBoolMap_.size();
  if (i<sfColorMap_.size())
  {
    return *ithValue(sfColorMap_,i) == *ithValue(declaration_->sfColorMap_,i);
  }
  i -= sfColorMap_.size();
  if (i<sfFloatMap_.size())
  {
    return
      *ithValue(sfFloatMap_,i) == *ithValue(declaration_->sfFloatMap_,i);
  }
  i -= sfFloatMap_.size();
  if (i<sfImageMap_.size())
  {
    return
      *ithValue(sfImageMap_,i) == *ithValue(declaration_->sfImageMap_,i);
  }
  i -= sfImageMap_.size();
  if (i<sfInt32Map_.size())
  {
    return
      *ithValue(sfInt32Map_,i) == *ithValue(declaration_->sfInt32Map_,i);
  }
  i -= sfInt32Map_.size();
  if (i<sfNodeMap_.size())
  {
    return
      *ithValue(sfNodeMap_,i) == *ithValue(declaration_->sfNodeMap_,i);
  }
  i -= sfNodeMap_.size();
  if (i<sfRotationMap_.size())
  {
    return
      *ithValue(sfRotationMap_,i) == *ithValue(declaration_->sfRotationMap_,i);
  }
  i -= sfRotationMap_.size();
  if (i<sfStringMap_.size())
  {
    return
      *ithValue(sfStringMap_,i) == *ithValue(declaration_->sfStringMap_,i);
  }
  i -= sfStringMap_.size();
  if (i<sfTimeMap_.size())
  {
    return
      *ithValue(sfTimeMap_,i) == *ithValue(declaration_->sfTimeMap_,i);
  }
  i -= sfTimeMap_.size();
  if (i<sfVec2fMap_.size())
  {
    return
      *ithValue(sfVec2fMap_,i) == *ithValue(declaration_->sfVec2fMap_,i);
  }
  i -= sfVec2fMap_.size();
  if (i<sfVec3fMap_.size())
  {
    return
      *ithValue(sfVec3fMap_,i) == *ithValue(declaration_->sfVec3fMap_,i);
  }
  i -= sfVec3fMap_.size();
  if (i<mfColorMap_.size())
  {
    return
      *ithValue(mfColorMap_,i) == *ithValue(declaration_->mfColorMap_,i);
  }
  i -= mfColorMap_.size();
  if (i<mfFloatMap_.size())
  {
    return
      *ithValue(mfFloatMap_,i) == *ithValue(declaration_->mfFloatMap_,i);
  }
  i -= mfFloatMap_.size();
  if (i<mfInt32Map_.size())
  {
    return
      *ithValue(mfInt32Map_,i) == *ithValue(declaration_->mfInt32Map_,i);
  }
  i -= mfInt32Map_.size();
  if (i<mfNodeMap_.size())
  {
    return
      *ithValue(mfNodeMap_,i) == *ithValue(declaration_->mfNodeMap_,i);
  }
  i -= mfNodeMap_.size();
  if (i<mfRotationMap_.size())
  {
    return
      *ithValue(mfRotationMap_,i) == *ithValue(declaration_->mfRotationMap_,i);
  }
  i -= mfRotationMap_.size();
  if (i<mfStringMap_.size())
  {
    return
      *ithValue(mfStringMap_,i) == *ithValue(declaration_->mfStringMap_,i);
  }
  i -= mfStringMap_.size();
  if (i<mfTimeMap_.size())
  {
    return
      *ithValue(mfTimeMap_,i) == *ithValue(declaration_->mfTimeMap_,i);
  }
  i -= mfTimeMap_.size();
  if (i<mfVec2fMap_.size())
  {
    return
      *ithValue(mfVec2fMap_,i) == *ithValue(declaration_->mfVec2fMap_,i);
  }
  i -= mfVec2fMap_.size();
  if (i<mfVec3fMap_.size())
  {
    return
      *ithValue(mfVec3fMap_,i) == *ithValue(declaration_->mfVec3fMap_,i);
  }
  i -= mfVec3fMap_.size();
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../include/xdkwrl/")
// End:
