#include <xdkwrl/nodes/worldinfo.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of WorldInfo
//************************************************************
/*! \class wrl::WorldInfo
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude worldinfo.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  title = string("");
  \endcode
  */
wrl::WorldInfo::WorldInfo(const char* name)
 : Node(name)
{

  title = string("");}
/*!
 * Virtual destructor, does nothing
 */
wrl::WorldInfo::~WorldInfo()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - info
 *  - title
 */
wrl::Node::FieldHandle
wrl::WorldInfo::field(const std::string& n)
{
  if(n==std::string("info"))
  {
    return Node::field(n,mfString,(void*) &info);
  }
  if(n==std::string("title"))
  {
    return Node::field(n,sfString,(void*) &title);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : info
 *  - 1 : title
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::WorldInfo::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("info",mfString,&info);
  case 1: return Node::field("title",sfString,&title);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::WorldInfo::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::WorldInfo::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::WorldInfo::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::WorldInfo::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::WorldInfo::duplicate() const
{
  WorldInfo* n = new WorldInfo(name());
  n->info = info;
  n->title = title;
  return n;
}
wrl::Node* 
wrl::WorldInfo::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  WorldInfo* n = new WorldInfo(name());
  nodeMap[this] = n;  n->info = info;
  n->title = title;
  return n;
}
bool
wrl::WorldInfo::isSetToDefaultValue(unsigned int i) const
{

  static const SFString titleDV_("");
  switch (i)
  {
  case 0: return info == MFString();
  case 1: return title == titleDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
