#include <xdkwrl/nodes/viewpoint.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Viewpoint
//************************************************************
/*! \class wrl::Viewpoint
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude viewpoint.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  fieldOfView = 0.785398f;
  jump = true;
  orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  position.setXYZ(0.0f,0.0f,10.0f);
  description = string("");
  \endcode
  */
wrl::Viewpoint::Viewpoint(const char* name)
 : Node(name)
{
  fieldOfView = 0.785398f;
  jump = true;
  orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  position.setXYZ(0.0f,0.0f,10.0f);
  description = string("");}
/*!
 * Virtual destructor, does nothing
 */
wrl::Viewpoint::~Viewpoint()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - fieldOfView
 *  - jump
 *  - orientation
 *  - position
 *  - description
 */
wrl::Node::FieldHandle
wrl::Viewpoint::field(const std::string& n)
{
  if(n==std::string("fieldOfView"))
  {
    return Node::field(n,sfFloat,(void*) &fieldOfView);
  }
  if(n==std::string("jump"))
  {
    return Node::field(n,sfBool,(void*) &jump);
  }
  if(n==std::string("orientation"))
  {
    return Node::field(n,sfRotation,(void*) &orientation);
  }
  if(n==std::string("position"))
  {
    return Node::field(n,sfVec3f,(void*) &position);
  }
  if(n==std::string("description"))
  {
    return Node::field(n,sfString,(void*) &description);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : fieldOfView
 *  - 1 : jump
 *  - 2 : orientation
 *  - 3 : position
 *  - 4 : description
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Viewpoint::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("fieldOfView",sfFloat,&fieldOfView);
  case 1: return Node::field("jump",sfBool,&jump);
  case 2: return Node::field("orientation",sfRotation,&orientation);
  case 3: return Node::field("position",sfVec3f,&position);
  case 4: return Node::field("description",sfString,&description);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_bind
 *  - set_fieldOfView
 *  - set_jump
 *  - set_orientation
 *  - set_position
 */
wrl::Node::EventInHandle
wrl::Viewpoint::eventIn(const std::string& n)
{
  if(n==std::string("set_bind"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_bind);
  }
  if(n==std::string("set_fieldOfView"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fieldOfView);
  }
  if(n==std::string("set_jump"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_jump);
  }
  if(n==std::string("set_orientation"))
  {
    return Node::eventIn(n,sfRotation,(void*) &set_orientation);
  }
  if(n==std::string("set_position"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_position);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_bind
 *  - 1 : set_fieldOfView
 *  - 2 : set_jump
 *  - 3 : set_orientation
 *  - 4 : set_position

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Viewpoint::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_bind",sfBool,&set_bind);
  case 1: return Node::eventIn("set_fieldOfView",sfFloat,&set_fieldOfView);
  case 2: return Node::eventIn("set_jump",sfBool,&set_jump);
  case 3: return Node::eventIn("set_orientation",sfRotation,&set_orientation);
  case 4: return Node::eventIn("set_position",sfVec3f,&set_position);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - bindTime
 *  - isBound
 *  - fieldOfView_changed
 *  - jump_changed
 *  - orientation_changed
 *  - position_changed
 */
wrl::Node::EventOutHandle
wrl::Viewpoint::eventOut(const std::string& n)
{
  if(n==std::string("bindTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &bindTime);
  }
  if(n==std::string("isBound"))
  {
    return Node::eventOut(n,sfBool,(void*) &isBound);
  }
  if(n==std::string("fieldOfView_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &fieldOfView_changed);
  }
  if(n==std::string("jump_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &jump_changed);
  }
  if(n==std::string("orientation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &orientation_changed);
  }
  if(n==std::string("position_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &position_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : bindTime
 *  - 1 : isBound
 *  - 2 : fieldOfView_changed
 *  - 3 : jump_changed
 *  - 4 : orientation_changed
 *  - 5 : position_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Viewpoint::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("bindTime",sfTime,&bindTime);
  case 1: return Node::eventOut("isBound",sfBool,&isBound);
  case 2: return Node::eventOut("fieldOfView_changed",sfFloat,&fieldOfView_changed);
  case 3: return Node::eventOut("jump_changed",sfBool,&jump_changed);
  case 4: return Node::eventOut("orientation_changed",sfRotation,&orientation_changed);
  case 5: return Node::eventOut("position_changed",sfVec3f,&position_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Viewpoint::duplicate() const
{
  Viewpoint* n = new Viewpoint(name());
  n->fieldOfView = fieldOfView;
  n->jump = jump;
  n->orientation = orientation;
  n->position = position;
  n->description = description;
  return n;
}
wrl::Node* 
wrl::Viewpoint::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Viewpoint* n = new Viewpoint(name());
  nodeMap[this] = n;  n->fieldOfView = fieldOfView;
  n->jump = jump;
  n->orientation = orientation;
  n->position = position;
  n->description = description;
  return n;
}
bool
wrl::Viewpoint::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat fieldOfViewDV_(0.785f);
  static const SFBool jumpDV_(true);
  static const SFRotation orientationDV_(0.0f,0.0f,1.0f,0.0f);
  static const SFVec3f positionDV_(0.0f,0.0f,10.0f);
  static const SFString descriptionDV_("");
  switch (i)
  {
  case 0: return fieldOfView == fieldOfViewDV_;
  case 1: return jump == jumpDV_;
  case 2: return orientation == orientationDV_;
  case 3: return position == positionDV_;
  case 4: return description == descriptionDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
