#include <xdkwrl/nodes/trimmedsurface.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of TrimmedSurface
//************************************************************
/*! \class wrl::TrimmedSurface
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude trimmedsurface.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::TrimmedSurface::TrimmedSurface(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::TrimmedSurface::~TrimmedSurface()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - trimmingContour
 *  - surface
 */
wrl::Node::FieldHandle
wrl::TrimmedSurface::field(const std::string& n)
{
  if(n==std::string("trimmingContour"))
  {
    return Node::field(n,mfNode,(void*) &trimmingContour);
  }
  if(n==std::string("surface"))
  {
    return Node::field(n,sfNode,(void*) &surface);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : trimmingContour
 *  - 1 : surface
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::TrimmedSurface::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("trimmingContour",mfNode,&trimmingContour);
  case 1: return Node::field("surface",sfNode,&surface);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addTrimmingContour
 *  - removeTrimmingContour
 *  - set_trimmingContour
 *  - set_surface
 */
wrl::Node::EventInHandle
wrl::TrimmedSurface::eventIn(const std::string& n)
{
  if(n==std::string("addTrimmingContour"))
  {
    return Node::eventIn(n,mfNode,(void*) &addTrimmingContour);
  }
  if(n==std::string("removeTrimmingContour"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeTrimmingContour);
  }
  if(n==std::string("set_trimmingContour"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_trimmingContour);
  }
  if(n==std::string("set_surface"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_surface);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addTrimmingContour
 *  - 1 : removeTrimmingContour
 *  - 2 : set_trimmingContour
 *  - 3 : set_surface

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::TrimmedSurface::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addTrimmingContour",mfNode,&addTrimmingContour);
  case 1: return Node::eventIn("removeTrimmingContour",mfNode,&removeTrimmingContour);
  case 2: return Node::eventIn("set_trimmingContour",mfNode,&set_trimmingContour);
  case 3: return Node::eventIn("set_surface",sfNode,&set_surface);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - trimmingContour_changed
 *  - surface_changed
 */
wrl::Node::EventOutHandle
wrl::TrimmedSurface::eventOut(const std::string& n)
{
  if(n==std::string("trimmingContour_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &trimmingContour_changed);
  }
  if(n==std::string("surface_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &surface_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : trimmingContour_changed
 *  - 1 : surface_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::TrimmedSurface::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("trimmingContour_changed",mfNode,&trimmingContour_changed);
  case 1: return Node::eventOut("surface_changed",sfNode,&surface_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::TrimmedSurface::duplicate() const
{
  TrimmedSurface* n = new TrimmedSurface(name());
  for (MFNode::const_iterator iter = trimmingContour.begin();
       iter != trimmingContour.end();++iter)
  {
     n->trimmingContour.push_back(SFNode((*iter)->duplicate()));
  }
  if (surface != NULL)
  {
    n->surface = surface->duplicate();
  }
  else
  {
    n->surface = NULL;
  }
  return n;
}
wrl::Node* 
wrl::TrimmedSurface::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  TrimmedSurface* n = new TrimmedSurface(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = trimmingContour.begin();
       iter != trimmingContour.end();++iter)
  {
     n->trimmingContour.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  if (surface != NULL)
  {
    n->surface = surface->duplicate(nodeMap);
  }
  else
  {
    n->surface = NULL;
  }
  return n;
}
bool
wrl::TrimmedSurface::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return trimmingContour == MFNode();
  case 1: return surface == SFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
