#include <xdkwrl/nodes/touchsensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of TouchSensor
//************************************************************
/*! \class wrl::TouchSensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude touchsensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  enabled = true;
  \endcode
  */
wrl::TouchSensor::TouchSensor(const char* name)
 : Node(name)
{
  enabled = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::TouchSensor::~TouchSensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - enabled
 */
wrl::Node::FieldHandle
wrl::TouchSensor::field(const std::string& n)
{
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : enabled
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::TouchSensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("enabled",sfBool,&enabled);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_enabled
 */
wrl::Node::EventInHandle
wrl::TouchSensor::eventIn(const std::string& n)
{
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::TouchSensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - hitNormal_changed
 *  - hitPoint_changed
 *  - hitTexCoord_changed
 *  - isActive
 *  - isOver
 *  - touchTime
 *  - enabled_changed
 */
wrl::Node::EventOutHandle
wrl::TouchSensor::eventOut(const std::string& n)
{
  if(n==std::string("hitNormal_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &hitNormal_changed);
  }
  if(n==std::string("hitPoint_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &hitPoint_changed);
  }
  if(n==std::string("hitTexCoord_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &hitTexCoord_changed);
  }
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("isOver"))
  {
    return Node::eventOut(n,sfBool,(void*) &isOver);
  }
  if(n==std::string("touchTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &touchTime);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : hitNormal_changed
 *  - 1 : hitPoint_changed
 *  - 2 : hitTexCoord_changed
 *  - 3 : isActive
 *  - 4 : isOver
 *  - 5 : touchTime
 *  - 6 : enabled_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::TouchSensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("hitNormal_changed",sfVec3f,&hitNormal_changed);
  case 1: return Node::eventOut("hitPoint_changed",sfVec3f,&hitPoint_changed);
  case 2: return Node::eventOut("hitTexCoord_changed",sfVec2f,&hitTexCoord_changed);
  case 3: return Node::eventOut("isActive",sfBool,&isActive);
  case 4: return Node::eventOut("isOver",sfBool,&isOver);
  case 5: return Node::eventOut("touchTime",sfTime,&touchTime);
  case 6: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::TouchSensor::duplicate() const
{
  TouchSensor* n = new TouchSensor(name());
  n->enabled = enabled;
  return n;
}
wrl::Node* 
wrl::TouchSensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  TouchSensor* n = new TouchSensor(name());
  nodeMap[this] = n;  n->enabled = enabled;
  return n;
}
bool
wrl::TouchSensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool enabledDV_(true);
  switch (i)
  {
  case 0: return enabled == enabledDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
