#include <xdkwrl/nodes/switch.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Switch
//************************************************************
/*! \class wrl::Switch
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude switch.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  whichChoice = -1;
  \endcode
  */
wrl::Switch::Switch(const char* name)
 : Node(name)
{

  whichChoice = -1;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Switch::~Switch()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - choice
 *  - whichChoice
 */
wrl::Node::FieldHandle
wrl::Switch::field(const std::string& n)
{
  if(n==std::string("choice"))
  {
    return Node::field(n,mfNode,(void*) &choice);
  }
  if(n==std::string("whichChoice"))
  {
    return Node::field(n,sfInt32,(void*) &whichChoice);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : choice
 *  - 1 : whichChoice
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Switch::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("choice",mfNode,&choice);
  case 1: return Node::field("whichChoice",sfInt32,&whichChoice);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_choice
 *  - set_whichChoice
 */
wrl::Node::EventInHandle
wrl::Switch::eventIn(const std::string& n)
{
  if(n==std::string("set_choice"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_choice);
  }
  if(n==std::string("set_whichChoice"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_whichChoice);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Switch::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_choice",mfNode,&set_choice);
  case 1: return Node::eventIn("set_whichChoice",sfInt32,&set_whichChoice);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - choice_changed
 *  - whichChoice_changed
 */
wrl::Node::EventOutHandle
wrl::Switch::eventOut(const std::string& n)
{
  if(n==std::string("choice_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &choice_changed);
  }
  if(n==std::string("whichChoice_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &whichChoice_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : choice_changed
 *  - 1 : whichChoice_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Switch::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("choice_changed",mfNode,&choice_changed);
  case 1: return Node::eventOut("whichChoice_changed",sfInt32,&whichChoice_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Switch::duplicate() const
{
  Switch* n = new Switch(name());
  for (MFNode::const_iterator iter = choice.begin();
       iter != choice.end();++iter)
  {
     n->choice.push_back(SFNode((*iter)->duplicate()));
  }
  n->whichChoice = whichChoice;
  return n;
}
wrl::Node* 
wrl::Switch::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Switch* n = new Switch(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = choice.begin();
       iter != choice.end();++iter)
  {
     n->choice.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->whichChoice = whichChoice;
  return n;
}
bool
wrl::Switch::isSetToDefaultValue(unsigned int i) const
{

  static const SFInt32 whichChoiceDV_(-1);
  switch (i)
  {
  case 0: return choice == MFNode();
  case 1: return whichChoice == whichChoiceDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
