#include <xdkwrl/nodes/spotlight.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of SpotLight
//************************************************************
/*! \class wrl::SpotLight
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude spotlight.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  ambientIntensity = 0.0f;
  attenuation.setXYZ(1.0f,0.0f,0.0f);
  beamWidth = 1.5708f;
  color.setRGB(1.0f,1.0f,1.0f);
  cutOffAngle = 0.785398f;
  direction.setXYZ(0.0f,0.0f,-1.0f);
  intensity = 1.0f;
  location.setXYZ(0.0f,0.0f,0.0f);
  on = true;
  radius = 100.0f;
  \endcode
  */
wrl::SpotLight::SpotLight(const char* name)
 : Node(name)
{
  ambientIntensity = 0.0f;
  attenuation.setXYZ(1.0f,0.0f,0.0f);
  beamWidth = 1.5708f;
  color.setRGB(1.0f,1.0f,1.0f);
  cutOffAngle = 0.785398f;
  direction.setXYZ(0.0f,0.0f,-1.0f);
  intensity = 1.0f;
  location.setXYZ(0.0f,0.0f,0.0f);
  on = true;
  radius = 100.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::SpotLight::~SpotLight()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - ambientIntensity
 *  - attenuation
 *  - beamWidth
 *  - color
 *  - cutOffAngle
 *  - direction
 *  - intensity
 *  - location
 *  - on
 *  - radius
 */
wrl::Node::FieldHandle
wrl::SpotLight::field(const std::string& n)
{
  if(n==std::string("ambientIntensity"))
  {
    return Node::field(n,sfFloat,(void*) &ambientIntensity);
  }
  if(n==std::string("attenuation"))
  {
    return Node::field(n,sfVec3f,(void*) &attenuation);
  }
  if(n==std::string("beamWidth"))
  {
    return Node::field(n,sfFloat,(void*) &beamWidth);
  }
  if(n==std::string("color"))
  {
    return Node::field(n,sfColor,(void*) &color);
  }
  if(n==std::string("cutOffAngle"))
  {
    return Node::field(n,sfFloat,(void*) &cutOffAngle);
  }
  if(n==std::string("direction"))
  {
    return Node::field(n,sfVec3f,(void*) &direction);
  }
  if(n==std::string("intensity"))
  {
    return Node::field(n,sfFloat,(void*) &intensity);
  }
  if(n==std::string("location"))
  {
    return Node::field(n,sfVec3f,(void*) &location);
  }
  if(n==std::string("on"))
  {
    return Node::field(n,sfBool,(void*) &on);
  }
  if(n==std::string("radius"))
  {
    return Node::field(n,sfFloat,(void*) &radius);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity
 *  - 1 : attenuation
 *  - 2 : beamWidth
 *  - 3 : color
 *  - 4 : cutOffAngle
 *  - 5 : direction
 *  - 6 : intensity
 *  - 7 : location
 *  - 8 : on
 *  - 9 : radius
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::SpotLight::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("ambientIntensity",sfFloat,&ambientIntensity);
  case 1: return Node::field("attenuation",sfVec3f,&attenuation);
  case 2: return Node::field("beamWidth",sfFloat,&beamWidth);
  case 3: return Node::field("color",sfColor,&color);
  case 4: return Node::field("cutOffAngle",sfFloat,&cutOffAngle);
  case 5: return Node::field("direction",sfVec3f,&direction);
  case 6: return Node::field("intensity",sfFloat,&intensity);
  case 7: return Node::field("location",sfVec3f,&location);
  case 8: return Node::field("on",sfBool,&on);
  case 9: return Node::field("radius",sfFloat,&radius);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_ambientIntensity
 *  - set_attenuation
 *  - set_beamWidth
 *  - set_color
 *  - set_cutOffAngle
 *  - set_direction
 *  - set_intensity
 *  - set_location
 *  - set_on
 *  - set_radius
 */
wrl::Node::EventInHandle
wrl::SpotLight::eventIn(const std::string& n)
{
  if(n==std::string("set_ambientIntensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_ambientIntensity);
  }
  if(n==std::string("set_attenuation"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_attenuation);
  }
  if(n==std::string("set_beamWidth"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_beamWidth);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_color);
  }
  if(n==std::string("set_cutOffAngle"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_cutOffAngle);
  }
  if(n==std::string("set_direction"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_direction);
  }
  if(n==std::string("set_intensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_intensity);
  }
  if(n==std::string("set_location"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_location);
  }
  if(n==std::string("set_on"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_on);
  }
  if(n==std::string("set_radius"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_radius);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::SpotLight::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_ambientIntensity",sfFloat,&set_ambientIntensity);
  case 1: return Node::eventIn("set_attenuation",sfVec3f,&set_attenuation);
  case 2: return Node::eventIn("set_beamWidth",sfFloat,&set_beamWidth);
  case 3: return Node::eventIn("set_color",sfColor,&set_color);
  case 4: return Node::eventIn("set_cutOffAngle",sfFloat,&set_cutOffAngle);
  case 5: return Node::eventIn("set_direction",sfVec3f,&set_direction);
  case 6: return Node::eventIn("set_intensity",sfFloat,&set_intensity);
  case 7: return Node::eventIn("set_location",sfVec3f,&set_location);
  case 8: return Node::eventIn("set_on",sfBool,&set_on);
  case 9: return Node::eventIn("set_radius",sfFloat,&set_radius);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - ambientIntensity_changed
 *  - attenuation_changed
 *  - beamWidth_changed
 *  - color_changed
 *  - cutOffAngle_changed
 *  - direction_changed
 *  - intensity_changed
 *  - location_changed
 *  - on_changed
 *  - radius_changed
 */
wrl::Node::EventOutHandle
wrl::SpotLight::eventOut(const std::string& n)
{
  if(n==std::string("ambientIntensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &ambientIntensity_changed);
  }
  if(n==std::string("attenuation_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &attenuation_changed);
  }
  if(n==std::string("beamWidth_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &beamWidth_changed);
  }
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &color_changed);
  }
  if(n==std::string("cutOffAngle_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &cutOffAngle_changed);
  }
  if(n==std::string("direction_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &direction_changed);
  }
  if(n==std::string("intensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &intensity_changed);
  }
  if(n==std::string("location_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &location_changed);
  }
  if(n==std::string("on_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &on_changed);
  }
  if(n==std::string("radius_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &radius_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity_changed
 *  - 1 : attenuation_changed
 *  - 2 : beamWidth_changed
 *  - 3 : color_changed
 *  - 4 : cutOffAngle_changed
 *  - 5 : direction_changed
 *  - 6 : intensity_changed
 *  - 7 : location_changed
 *  - 8 : on_changed
 *  - 9 : radius_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::SpotLight::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("ambientIntensity_changed",sfFloat,&ambientIntensity_changed);
  case 1: return Node::eventOut("attenuation_changed",sfVec3f,&attenuation_changed);
  case 2: return Node::eventOut("beamWidth_changed",sfFloat,&beamWidth_changed);
  case 3: return Node::eventOut("color_changed",sfColor,&color_changed);
  case 4: return Node::eventOut("cutOffAngle_changed",sfFloat,&cutOffAngle_changed);
  case 5: return Node::eventOut("direction_changed",sfVec3f,&direction_changed);
  case 6: return Node::eventOut("intensity_changed",sfFloat,&intensity_changed);
  case 7: return Node::eventOut("location_changed",sfVec3f,&location_changed);
  case 8: return Node::eventOut("on_changed",sfBool,&on_changed);
  case 9: return Node::eventOut("radius_changed",sfFloat,&radius_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::SpotLight::duplicate() const
{
  SpotLight* n = new SpotLight(name());
  n->ambientIntensity = ambientIntensity;
  n->attenuation = attenuation;
  n->beamWidth = beamWidth;
  n->color = color;
  n->cutOffAngle = cutOffAngle;
  n->direction = direction;
  n->intensity = intensity;
  n->location = location;
  n->on = on;
  n->radius = radius;
  return n;
}
wrl::Node* 
wrl::SpotLight::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  SpotLight* n = new SpotLight(name());
  nodeMap[this] = n;  n->ambientIntensity = ambientIntensity;
  n->attenuation = attenuation;
  n->beamWidth = beamWidth;
  n->color = color;
  n->cutOffAngle = cutOffAngle;
  n->direction = direction;
  n->intensity = intensity;
  n->location = location;
  n->on = on;
  n->radius = radius;
  return n;
}
bool
wrl::SpotLight::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat ambientIntensityDV_(0.0f);
  static const SFVec3f attenuationDV_(1.0f,0.0f,0.0f);
  static const SFFloat beamWidthDV_(1.57f);
  static const SFColor colorDV_(1.0f,1.0f,1.0f);
  static const SFFloat cutOffAngleDV_(0.785f);
  static const SFVec3f directionDV_(0.0f,0.0f,-1.0f);
  static const SFFloat intensityDV_(1.0f);
  static const SFVec3f locationDV_(0.0f,0.0f,0.0f);
  static const SFBool onDV_(true);
  static const SFFloat radiusDV_(100.0f);
  switch (i)
  {
  case 0: return ambientIntensity == ambientIntensityDV_;
  case 1: return attenuation == attenuationDV_;
  case 2: return beamWidth == beamWidthDV_;
  case 3: return color == colorDV_;
  case 4: return cutOffAngle == cutOffAngleDV_;
  case 5: return direction == directionDV_;
  case 6: return intensity == intensityDV_;
  case 7: return location == locationDV_;
  case 8: return on == onDV_;
  case 9: return radius == radiusDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
