#include <xdkwrl/nodes/sound.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Sound
//************************************************************
/*! \class wrl::Sound
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude sound.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  direction.setXYZ(0.0f,0.0f,1.0f);
  intensity = 1.0f;
  location.setXYZ(0.0f,0.0f,0.0f);
  maxBack = 10.0f;
  maxFront = 10.0f;
  minBack = 1.0f;
  minFront = 1.0f;
  priority = 0.0f;
  spatialize = true;
  \endcode
  */
wrl::Sound::Sound(const char* name)
 : Node(name)
{
  direction.setXYZ(0.0f,0.0f,1.0f);
  intensity = 1.0f;
  location.setXYZ(0.0f,0.0f,0.0f);
  maxBack = 10.0f;
  maxFront = 10.0f;
  minBack = 1.0f;
  minFront = 1.0f;
  priority = 0.0f;
  spatialize = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Sound::~Sound()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - direction
 *  - intensity
 *  - location
 *  - maxBack
 *  - maxFront
 *  - minBack
 *  - minFront
 *  - priority
 *  - source
 *  - spatialize
 */
wrl::Node::FieldHandle
wrl::Sound::field(const std::string& n)
{
  if(n==std::string("direction"))
  {
    return Node::field(n,sfVec3f,(void*) &direction);
  }
  if(n==std::string("intensity"))
  {
    return Node::field(n,sfFloat,(void*) &intensity);
  }
  if(n==std::string("location"))
  {
    return Node::field(n,sfVec3f,(void*) &location);
  }
  if(n==std::string("maxBack"))
  {
    return Node::field(n,sfFloat,(void*) &maxBack);
  }
  if(n==std::string("maxFront"))
  {
    return Node::field(n,sfFloat,(void*) &maxFront);
  }
  if(n==std::string("minBack"))
  {
    return Node::field(n,sfFloat,(void*) &minBack);
  }
  if(n==std::string("minFront"))
  {
    return Node::field(n,sfFloat,(void*) &minFront);
  }
  if(n==std::string("priority"))
  {
    return Node::field(n,sfFloat,(void*) &priority);
  }
  if(n==std::string("source"))
  {
    return Node::field(n,sfNode,(void*) &source);
  }
  if(n==std::string("spatialize"))
  {
    return Node::field(n,sfBool,(void*) &spatialize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : direction
 *  - 1 : intensity
 *  - 2 : location
 *  - 3 : maxBack
 *  - 4 : maxFront
 *  - 5 : minBack
 *  - 6 : minFront
 *  - 7 : priority
 *  - 8 : source
 *  - 9 : spatialize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Sound::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("direction",sfVec3f,&direction);
  case 1: return Node::field("intensity",sfFloat,&intensity);
  case 2: return Node::field("location",sfVec3f,&location);
  case 3: return Node::field("maxBack",sfFloat,&maxBack);
  case 4: return Node::field("maxFront",sfFloat,&maxFront);
  case 5: return Node::field("minBack",sfFloat,&minBack);
  case 6: return Node::field("minFront",sfFloat,&minFront);
  case 7: return Node::field("priority",sfFloat,&priority);
  case 8: return Node::field("source",sfNode,&source);
  case 9: return Node::field("spatialize",sfBool,&spatialize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_direction
 *  - set_intensity
 *  - set_location
 *  - set_maxBack
 *  - set_maxFront
 *  - set_minBack
 *  - set_minFront
 *  - set_priority
 *  - set_source
 */
wrl::Node::EventInHandle
wrl::Sound::eventIn(const std::string& n)
{
  if(n==std::string("set_direction"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_direction);
  }
  if(n==std::string("set_intensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_intensity);
  }
  if(n==std::string("set_location"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_location);
  }
  if(n==std::string("set_maxBack"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_maxBack);
  }
  if(n==std::string("set_maxFront"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_maxFront);
  }
  if(n==std::string("set_minBack"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_minBack);
  }
  if(n==std::string("set_minFront"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_minFront);
  }
  if(n==std::string("set_priority"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_priority);
  }
  if(n==std::string("set_source"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_source);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Sound::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_direction",sfVec3f,&set_direction);
  case 1: return Node::eventIn("set_intensity",sfFloat,&set_intensity);
  case 2: return Node::eventIn("set_location",sfVec3f,&set_location);
  case 3: return Node::eventIn("set_maxBack",sfFloat,&set_maxBack);
  case 4: return Node::eventIn("set_maxFront",sfFloat,&set_maxFront);
  case 5: return Node::eventIn("set_minBack",sfFloat,&set_minBack);
  case 6: return Node::eventIn("set_minFront",sfFloat,&set_minFront);
  case 7: return Node::eventIn("set_priority",sfFloat,&set_priority);
  case 8: return Node::eventIn("set_source",sfNode,&set_source);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - direction_changed
 *  - intensity_changed
 *  - location_changed
 *  - maxBack_changed
 *  - maxFront_changed
 *  - minBack_changed
 *  - minFront_changed
 *  - priority_changed
 *  - source_changed
 */
wrl::Node::EventOutHandle
wrl::Sound::eventOut(const std::string& n)
{
  if(n==std::string("direction_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &direction_changed);
  }
  if(n==std::string("intensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &intensity_changed);
  }
  if(n==std::string("location_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &location_changed);
  }
  if(n==std::string("maxBack_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &maxBack_changed);
  }
  if(n==std::string("maxFront_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &maxFront_changed);
  }
  if(n==std::string("minBack_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &minBack_changed);
  }
  if(n==std::string("minFront_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &minFront_changed);
  }
  if(n==std::string("priority_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &priority_changed);
  }
  if(n==std::string("source_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &source_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : direction_changed
 *  - 1 : intensity_changed
 *  - 2 : location_changed
 *  - 3 : maxBack_changed
 *  - 4 : maxFront_changed
 *  - 5 : minBack_changed
 *  - 6 : minFront_changed
 *  - 7 : priority_changed
 *  - 8 : source_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Sound::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("direction_changed",sfVec3f,&direction_changed);
  case 1: return Node::eventOut("intensity_changed",sfFloat,&intensity_changed);
  case 2: return Node::eventOut("location_changed",sfVec3f,&location_changed);
  case 3: return Node::eventOut("maxBack_changed",sfFloat,&maxBack_changed);
  case 4: return Node::eventOut("maxFront_changed",sfFloat,&maxFront_changed);
  case 5: return Node::eventOut("minBack_changed",sfFloat,&minBack_changed);
  case 6: return Node::eventOut("minFront_changed",sfFloat,&minFront_changed);
  case 7: return Node::eventOut("priority_changed",sfFloat,&priority_changed);
  case 8: return Node::eventOut("source_changed",sfNode,&source_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Sound::duplicate() const
{
  Sound* n = new Sound(name());
  n->direction = direction;
  n->intensity = intensity;
  n->location = location;
  n->maxBack = maxBack;
  n->maxFront = maxFront;
  n->minBack = minBack;
  n->minFront = minFront;
  n->priority = priority;
  if (source != NULL)
  {
    n->source = source->duplicate();
  }
  else
  {
    n->source = NULL;
  }
  n->spatialize = spatialize;
  return n;
}
wrl::Node* 
wrl::Sound::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Sound* n = new Sound(name());
  nodeMap[this] = n;  n->direction = direction;
  n->intensity = intensity;
  n->location = location;
  n->maxBack = maxBack;
  n->maxFront = maxFront;
  n->minBack = minBack;
  n->minFront = minFront;
  n->priority = priority;
  if (source != NULL)
  {
    n->source = source->duplicate(nodeMap);
  }
  else
  {
    n->source = NULL;
  }
  n->spatialize = spatialize;
  return n;
}
bool
wrl::Sound::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f directionDV_(0.0f,0.0f,1.0f);
  static const SFFloat intensityDV_(1.0f);
  static const SFVec3f locationDV_(0.0f,0.0f,0.0f);
  static const SFFloat maxBackDV_(10.0f);
  static const SFFloat maxFrontDV_(10.0f);
  static const SFFloat minBackDV_(1.0f);
  static const SFFloat minFrontDV_(1.0f);
  static const SFFloat priorityDV_(0.0f);
  static const SFBool spatializeDV_(true);
  switch (i)
  {
  case 0: return direction == directionDV_;
  case 1: return intensity == intensityDV_;
  case 2: return location == locationDV_;
  case 3: return maxBack == maxBackDV_;
  case 4: return maxFront == maxFrontDV_;
  case 5: return minBack == minBackDV_;
  case 6: return minFront == minFrontDV_;
  case 7: return priority == priorityDV_;
  case 8: return source == SFNode();
  case 9: return spatialize == spatializeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
