#include <xdkwrl/nodes/shape.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Shape
//************************************************************
/*! \class wrl::Shape
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude shape.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Shape::Shape(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Shape::~Shape()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - appearance
 *  - geometry
 */
wrl::Node::FieldHandle
wrl::Shape::field(const std::string& n)
{
  if(n==std::string("appearance"))
  {
    return Node::field(n,sfNode,(void*) &appearance);
  }
  if(n==std::string("geometry"))
  {
    return Node::field(n,sfNode,(void*) &geometry);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : appearance
 *  - 1 : geometry
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Shape::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("appearance",sfNode,&appearance);
  case 1: return Node::field("geometry",sfNode,&geometry);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_appearance
 *  - set_geometry
 */
wrl::Node::EventInHandle
wrl::Shape::eventIn(const std::string& n)
{
  if(n==std::string("set_appearance"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_appearance);
  }
  if(n==std::string("set_geometry"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_geometry);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Shape::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_appearance",sfNode,&set_appearance);
  case 1: return Node::eventIn("set_geometry",sfNode,&set_geometry);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - appearance_changed
 *  - geometry_changed
 */
wrl::Node::EventOutHandle
wrl::Shape::eventOut(const std::string& n)
{
  if(n==std::string("appearance_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &appearance_changed);
  }
  if(n==std::string("geometry_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &geometry_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : appearance_changed
 *  - 1 : geometry_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Shape::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("appearance_changed",sfNode,&appearance_changed);
  case 1: return Node::eventOut("geometry_changed",sfNode,&geometry_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Shape::duplicate() const
{
  Shape* n = new Shape(name());
  if (appearance != NULL)
  {
    n->appearance = appearance->duplicate();
  }
  else
  {
    n->appearance = NULL;
  }
  if (geometry != NULL)
  {
    n->geometry = geometry->duplicate();
  }
  else
  {
    n->geometry = NULL;
  }
  return n;
}
wrl::Node* 
wrl::Shape::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Shape* n = new Shape(name());
  nodeMap[this] = n;  if (appearance != NULL)
  {
    n->appearance = appearance->duplicate(nodeMap);
  }
  else
  {
    n->appearance = NULL;
  }
  if (geometry != NULL)
  {
    n->geometry = geometry->duplicate(nodeMap);
  }
  else
  {
    n->geometry = NULL;
  }
  return n;
}
bool
wrl::Shape::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return appearance == SFNode();
  case 1: return geometry == SFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
