#include <xdkwrl/nodes/proximitysensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of ProximitySensor
//************************************************************
/*! \class wrl::ProximitySensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude proximitysensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  center.setXYZ(0.0f,0.0f,0.0f);
  size.setXYZ(0.0f,0.0f,0.0f);
  enabled = true;
  \endcode
  */
wrl::ProximitySensor::ProximitySensor(const char* name)
 : Node(name)
{
  center.setXYZ(0.0f,0.0f,0.0f);
  size.setXYZ(0.0f,0.0f,0.0f);
  enabled = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::ProximitySensor::~ProximitySensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - center
 *  - size
 *  - enabled
 */
wrl::Node::FieldHandle
wrl::ProximitySensor::field(const std::string& n)
{
  if(n==std::string("center"))
  {
    return Node::field(n,sfVec3f,(void*) &center);
  }
  if(n==std::string("size"))
  {
    return Node::field(n,sfVec3f,(void*) &size);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center
 *  - 1 : size
 *  - 2 : enabled
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::ProximitySensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("center",sfVec3f,&center);
  case 1: return Node::field("size",sfVec3f,&size);
  case 2: return Node::field("enabled",sfBool,&enabled);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_center
 *  - set_size
 *  - set_enabled
 */
wrl::Node::EventInHandle
wrl::ProximitySensor::eventIn(const std::string& n)
{
  if(n==std::string("set_center"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_center);
  }
  if(n==std::string("set_size"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_size);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::ProximitySensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_center",sfVec3f,&set_center);
  case 1: return Node::eventIn("set_size",sfVec3f,&set_size);
  case 2: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isActive
 *  - position_changed
 *  - orientation_changed
 *  - enterTime
 *  - exitTime
 *  - center_changed
 *  - size_changed
 *  - enabled_changed
 */
wrl::Node::EventOutHandle
wrl::ProximitySensor::eventOut(const std::string& n)
{
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("position_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &position_changed);
  }
  if(n==std::string("orientation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &orientation_changed);
  }
  if(n==std::string("enterTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &enterTime);
  }
  if(n==std::string("exitTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &exitTime);
  }
  if(n==std::string("center_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &center_changed);
  }
  if(n==std::string("size_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &size_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isActive
 *  - 1 : position_changed
 *  - 2 : orientation_changed
 *  - 3 : enterTime
 *  - 4 : exitTime
 *  - 5 : center_changed
 *  - 6 : size_changed
 *  - 7 : enabled_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::ProximitySensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isActive",sfBool,&isActive);
  case 1: return Node::eventOut("position_changed",sfVec3f,&position_changed);
  case 2: return Node::eventOut("orientation_changed",sfRotation,&orientation_changed);
  case 3: return Node::eventOut("enterTime",sfTime,&enterTime);
  case 4: return Node::eventOut("exitTime",sfTime,&exitTime);
  case 5: return Node::eventOut("center_changed",sfVec3f,&center_changed);
  case 6: return Node::eventOut("size_changed",sfVec3f,&size_changed);
  case 7: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::ProximitySensor::duplicate() const
{
  ProximitySensor* n = new ProximitySensor(name());
  n->center = center;
  n->size = size;
  n->enabled = enabled;
  return n;
}
wrl::Node* 
wrl::ProximitySensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ProximitySensor* n = new ProximitySensor(name());
  nodeMap[this] = n;  n->center = center;
  n->size = size;
  n->enabled = enabled;
  return n;
}
bool
wrl::ProximitySensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f centerDV_(0.0f,0.0f,0.0f);
  static const SFVec3f sizeDV_(0.0f,0.0f,0.0f);
  static const SFBool enabledDV_(true);
  switch (i)
  {
  case 0: return center == centerDV_;
  case 1: return size == sizeDV_;
  case 2: return enabled == enabledDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
