#include <xdkwrl/nodes/planesensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of PlaneSensor
//************************************************************
/*! \class wrl::PlaneSensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude planesensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  autoOffset = true;
  enabled = true;
  maxPosition.setXY(-1.0f,-1.0f);
  minPosition.setXY(0.0f,0.0f);
  offset.setXYZ(0.0f,0.0f,0.0f);
  \endcode
  */
wrl::PlaneSensor::PlaneSensor(const char* name)
 : Node(name)
{
  autoOffset = true;
  enabled = true;
  maxPosition.setXY(-1.0f,-1.0f);
  minPosition.setXY(0.0f,0.0f);
  offset.setXYZ(0.0f,0.0f,0.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::PlaneSensor::~PlaneSensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - autoOffset
 *  - enabled
 *  - maxPosition
 *  - minPosition
 *  - offset
 */
wrl::Node::FieldHandle
wrl::PlaneSensor::field(const std::string& n)
{
  if(n==std::string("autoOffset"))
  {
    return Node::field(n,sfBool,(void*) &autoOffset);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  if(n==std::string("maxPosition"))
  {
    return Node::field(n,sfVec2f,(void*) &maxPosition);
  }
  if(n==std::string("minPosition"))
  {
    return Node::field(n,sfVec2f,(void*) &minPosition);
  }
  if(n==std::string("offset"))
  {
    return Node::field(n,sfVec3f,(void*) &offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : autoOffset
 *  - 1 : enabled
 *  - 2 : maxPosition
 *  - 3 : minPosition
 *  - 4 : offset
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::PlaneSensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("autoOffset",sfBool,&autoOffset);
  case 1: return Node::field("enabled",sfBool,&enabled);
  case 2: return Node::field("maxPosition",sfVec2f,&maxPosition);
  case 3: return Node::field("minPosition",sfVec2f,&minPosition);
  case 4: return Node::field("offset",sfVec3f,&offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_autoOffset
 *  - set_enabled
 *  - set_maxPosition
 *  - set_minPosition
 *  - set_offset
 */
wrl::Node::EventInHandle
wrl::PlaneSensor::eventIn(const std::string& n)
{
  if(n==std::string("set_autoOffset"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_autoOffset);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  if(n==std::string("set_maxPosition"))
  {
    return Node::eventIn(n,sfVec2f,(void*) &set_maxPosition);
  }
  if(n==std::string("set_minPosition"))
  {
    return Node::eventIn(n,sfVec2f,(void*) &set_minPosition);
  }
  if(n==std::string("set_offset"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::PlaneSensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_autoOffset",sfBool,&set_autoOffset);
  case 1: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  case 2: return Node::eventIn("set_maxPosition",sfVec2f,&set_maxPosition);
  case 3: return Node::eventIn("set_minPosition",sfVec2f,&set_minPosition);
  case 4: return Node::eventIn("set_offset",sfVec3f,&set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isActive
 *  - trackPoint_changed
 *  - translation_changed
 *  - autoOffset_changed
 *  - enabled_changed
 *  - maxPosition_changed
 *  - minPosition_changed
 *  - offset_changed
 */
wrl::Node::EventOutHandle
wrl::PlaneSensor::eventOut(const std::string& n)
{
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("trackPoint_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &trackPoint_changed);
  }
  if(n==std::string("translation_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &translation_changed);
  }
  if(n==std::string("autoOffset_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &autoOffset_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  if(n==std::string("maxPosition_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &maxPosition_changed);
  }
  if(n==std::string("minPosition_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &minPosition_changed);
  }
  if(n==std::string("offset_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &offset_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isActive
 *  - 1 : trackPoint_changed
 *  - 2 : translation_changed
 *  - 3 : autoOffset_changed
 *  - 4 : enabled_changed
 *  - 5 : maxPosition_changed
 *  - 6 : minPosition_changed
 *  - 7 : offset_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::PlaneSensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isActive",sfBool,&isActive);
  case 1: return Node::eventOut("trackPoint_changed",sfVec3f,&trackPoint_changed);
  case 2: return Node::eventOut("translation_changed",sfVec3f,&translation_changed);
  case 3: return Node::eventOut("autoOffset_changed",sfBool,&autoOffset_changed);
  case 4: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  case 5: return Node::eventOut("maxPosition_changed",sfVec2f,&maxPosition_changed);
  case 6: return Node::eventOut("minPosition_changed",sfVec2f,&minPosition_changed);
  case 7: return Node::eventOut("offset_changed",sfVec3f,&offset_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::PlaneSensor::duplicate() const
{
  PlaneSensor* n = new PlaneSensor(name());
  n->autoOffset = autoOffset;
  n->enabled = enabled;
  n->maxPosition = maxPosition;
  n->minPosition = minPosition;
  n->offset = offset;
  return n;
}
wrl::Node* 
wrl::PlaneSensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  PlaneSensor* n = new PlaneSensor(name());
  nodeMap[this] = n;  n->autoOffset = autoOffset;
  n->enabled = enabled;
  n->maxPosition = maxPosition;
  n->minPosition = minPosition;
  n->offset = offset;
  return n;
}
bool
wrl::PlaneSensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool autoOffsetDV_(true);
  static const SFBool enabledDV_(true);
  static const SFVec2f maxPositionDV_(-1.0f,-1.0f);
  static const SFVec2f minPositionDV_(0.0f,0.0f);
  static const SFVec3f offsetDV_(0.0f,0.0f,0.0f);
  switch (i)
  {
  case 0: return autoOffset == autoOffsetDV_;
  case 1: return enabled == enabledDV_;
  case 2: return maxPosition == maxPositionDV_;
  case 3: return minPosition == minPositionDV_;
  case 4: return offset == offsetDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
