#include <xdkwrl/nodes/pixeltexture.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of PixelTexture
//************************************************************
/*! \class wrl::PixelTexture
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude pixeltexture.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  repeatS = true;
  repeatT = true;
  \endcode
  */
wrl::PixelTexture::PixelTexture(const char* name)
 : Node(name)
{

  repeatS = true;
  repeatT = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::PixelTexture::~PixelTexture()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - image
 *  - repeatS
 *  - repeatT
 */
wrl::Node::FieldHandle
wrl::PixelTexture::field(const std::string& n)
{
  if(n==std::string("image"))
  {
    return Node::field(n,sfImage,(void*) &image);
  }
  if(n==std::string("repeatS"))
  {
    return Node::field(n,sfBool,(void*) &repeatS);
  }
  if(n==std::string("repeatT"))
  {
    return Node::field(n,sfBool,(void*) &repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : image
 *  - 1 : repeatS
 *  - 2 : repeatT
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::PixelTexture::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("image",sfImage,&image);
  case 1: return Node::field("repeatS",sfBool,&repeatS);
  case 2: return Node::field("repeatT",sfBool,&repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_image
 */
wrl::Node::EventInHandle
wrl::PixelTexture::eventIn(const std::string& n)
{
  if(n==std::string("set_image"))
  {
    return Node::eventIn(n,sfImage,(void*) &set_image);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::PixelTexture::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_image",sfImage,&set_image);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - image_changed
 */
wrl::Node::EventOutHandle
wrl::PixelTexture::eventOut(const std::string& n)
{
  if(n==std::string("image_changed"))
  {
    return Node::eventOut(n,sfImage,(void*) &image_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : image_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::PixelTexture::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("image_changed",sfImage,&image_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::PixelTexture::duplicate() const
{
  PixelTexture* n = new PixelTexture(name());
  n->image = image;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
wrl::Node* 
wrl::PixelTexture::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  PixelTexture* n = new PixelTexture(name());
  nodeMap[this] = n;  n->image = image;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
bool
wrl::PixelTexture::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool repeatSDV_(true);
  static const SFBool repeatTDV_(true);
  switch (i)
  {
  case 0: return image == SFImage();
  case 1: return repeatS == repeatSDV_;
  case 2: return repeatT == repeatTDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
