#include <xdkwrl/nodes/nurbstexturesurface.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NurbsTextureSurface
//************************************************************
/*! \class wrl::NurbsTextureSurface
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude nurbstexturesurface.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  uDimension = 0;
  uOrder = 3;
  vDimension = 0;
  vOrder = 3;
  \endcode
  */
wrl::NurbsTextureSurface::NurbsTextureSurface(const char* name)
 : Node(name)
{

  uDimension = 0;
  uOrder = 3;
  vDimension = 0;
  vOrder = 3;}
/*!
 * Virtual destructor, does nothing
 */
wrl::NurbsTextureSurface::~NurbsTextureSurface()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - controlPoint
 *  - weight
 *  - uDimension
 *  - uKnot
 *  - uOrder
 *  - vDimension
 *  - vKnot
 *  - vOrder
 */
wrl::Node::FieldHandle
wrl::NurbsTextureSurface::field(const std::string& n)
{
  if(n==std::string("controlPoint"))
  {
    return Node::field(n,mfVec2f,(void*) &controlPoint);
  }
  if(n==std::string("weight"))
  {
    return Node::field(n,mfFloat,(void*) &weight);
  }
  if(n==std::string("uDimension"))
  {
    return Node::field(n,sfInt32,(void*) &uDimension);
  }
  if(n==std::string("uKnot"))
  {
    return Node::field(n,mfFloat,(void*) &uKnot);
  }
  if(n==std::string("uOrder"))
  {
    return Node::field(n,sfInt32,(void*) &uOrder);
  }
  if(n==std::string("vDimension"))
  {
    return Node::field(n,sfInt32,(void*) &vDimension);
  }
  if(n==std::string("vKnot"))
  {
    return Node::field(n,mfFloat,(void*) &vKnot);
  }
  if(n==std::string("vOrder"))
  {
    return Node::field(n,sfInt32,(void*) &vOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint
 *  - 1 : weight
 *  - 2 : uDimension
 *  - 3 : uKnot
 *  - 4 : uOrder
 *  - 5 : vDimension
 *  - 6 : vKnot
 *  - 7 : vOrder
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NurbsTextureSurface::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("controlPoint",mfVec2f,&controlPoint);
  case 1: return Node::field("weight",mfFloat,&weight);
  case 2: return Node::field("uDimension",sfInt32,&uDimension);
  case 3: return Node::field("uKnot",mfFloat,&uKnot);
  case 4: return Node::field("uOrder",sfInt32,&uOrder);
  case 5: return Node::field("vDimension",sfInt32,&vDimension);
  case 6: return Node::field("vKnot",mfFloat,&vKnot);
  case 7: return Node::field("vOrder",sfInt32,&vOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_controlPoint
 *  - set_weight
 */
wrl::Node::EventInHandle
wrl::NurbsTextureSurface::eventIn(const std::string& n)
{
  if(n==std::string("set_controlPoint"))
  {
    return Node::eventIn(n,mfVec2f,(void*) &set_controlPoint);
  }
  if(n==std::string("set_weight"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NurbsTextureSurface::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_controlPoint",mfVec2f,&set_controlPoint);
  case 1: return Node::eventIn("set_weight",mfFloat,&set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - controlPoint_changed
 *  - weight_changed
 */
wrl::Node::EventOutHandle
wrl::NurbsTextureSurface::eventOut(const std::string& n)
{
  if(n==std::string("controlPoint_changed"))
  {
    return Node::eventOut(n,mfVec2f,(void*) &controlPoint_changed);
  }
  if(n==std::string("weight_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &weight_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint_changed
 *  - 1 : weight_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NurbsTextureSurface::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("controlPoint_changed",mfVec2f,&controlPoint_changed);
  case 1: return Node::eventOut("weight_changed",mfFloat,&weight_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NurbsTextureSurface::duplicate() const
{
  NurbsTextureSurface* n = new NurbsTextureSurface(name());
  n->controlPoint = controlPoint;
  n->weight = weight;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  return n;
}
wrl::Node* 
wrl::NurbsTextureSurface::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NurbsTextureSurface* n = new NurbsTextureSurface(name());
  nodeMap[this] = n;  n->controlPoint = controlPoint;
  n->weight = weight;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  return n;
}
bool
wrl::NurbsTextureSurface::isSetToDefaultValue(unsigned int i) const
{

  static const SFInt32 uDimensionDV_(0);
  static const SFInt32 uOrderDV_(3);
  static const SFInt32 vDimensionDV_(0);
  static const SFInt32 vOrderDV_(3);
  switch (i)
  {
  case 0: return controlPoint == MFVec2f();
  case 1: return weight == MFFloat();
  case 2: return uDimension == uDimensionDV_;
  case 3: return uKnot == MFFloat();
  case 4: return uOrder == uOrderDV_;
  case 5: return vDimension == vDimensionDV_;
  case 6: return vKnot == MFFloat();
  case 7: return vOrder == vOrderDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
