#include <xdkwrl/nodes/nurbspositioninterpolator.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NurbsPositionInterpolator
//************************************************************
/*! \class wrl::NurbsPositionInterpolator
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude nurbspositioninterpolator.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  dimension = 0;
  order = 4;
  \endcode
  */
wrl::NurbsPositionInterpolator::NurbsPositionInterpolator(const char* name)
 : Node(name)
{
  dimension = 0;
  order = 4;}
/*!
 * Virtual destructor, does nothing
 */
wrl::NurbsPositionInterpolator::~NurbsPositionInterpolator()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - dimension
 *  - keyValue
 *  - keyWeight
 *  - knot
 *  - order
 */
wrl::Node::FieldHandle
wrl::NurbsPositionInterpolator::field(const std::string& n)
{
  if(n==std::string("dimension"))
  {
    return Node::field(n,sfInt32,(void*) &dimension);
  }
  if(n==std::string("keyValue"))
  {
    return Node::field(n,mfVec3f,(void*) &keyValue);
  }
  if(n==std::string("keyWeight"))
  {
    return Node::field(n,mfFloat,(void*) &keyWeight);
  }
  if(n==std::string("knot"))
  {
    return Node::field(n,mfFloat,(void*) &knot);
  }
  if(n==std::string("order"))
  {
    return Node::field(n,sfInt32,(void*) &order);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : dimension
 *  - 1 : keyValue
 *  - 2 : keyWeight
 *  - 3 : knot
 *  - 4 : order
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NurbsPositionInterpolator::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("dimension",sfInt32,&dimension);
  case 1: return Node::field("keyValue",mfVec3f,&keyValue);
  case 2: return Node::field("keyWeight",mfFloat,&keyWeight);
  case 3: return Node::field("knot",mfFloat,&knot);
  case 4: return Node::field("order",sfInt32,&order);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_fraction
 *  - set_dimension
 *  - set_keyValue
 *  - set_keyWeight
 *  - set_knot
 *  - set_order
 */
wrl::Node::EventInHandle
wrl::NurbsPositionInterpolator::eventIn(const std::string& n)
{
  if(n==std::string("set_fraction"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fraction);
  }
  if(n==std::string("set_dimension"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_dimension);
  }
  if(n==std::string("set_keyValue"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_keyValue);
  }
  if(n==std::string("set_keyWeight"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_keyWeight);
  }
  if(n==std::string("set_knot"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_knot);
  }
  if(n==std::string("set_order"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_order);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_fraction
 *  - 1 : set_dimension
 *  - 2 : set_keyValue
 *  - 3 : set_keyWeight
 *  - 4 : set_knot
 *  - 5 : set_order

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NurbsPositionInterpolator::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_fraction",sfFloat,&set_fraction);
  case 1: return Node::eventIn("set_dimension",sfInt32,&set_dimension);
  case 2: return Node::eventIn("set_keyValue",mfVec3f,&set_keyValue);
  case 3: return Node::eventIn("set_keyWeight",mfFloat,&set_keyWeight);
  case 4: return Node::eventIn("set_knot",mfFloat,&set_knot);
  case 5: return Node::eventIn("set_order",sfInt32,&set_order);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - value_changed
 *  - dimension_changed
 *  - keyValue_changed
 *  - keyWeight_changed
 *  - knot_changed
 *  - order_changed
 */
wrl::Node::EventOutHandle
wrl::NurbsPositionInterpolator::eventOut(const std::string& n)
{
  if(n==std::string("value_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &value_changed);
  }
  if(n==std::string("dimension_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &dimension_changed);
  }
  if(n==std::string("keyValue_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &keyValue_changed);
  }
  if(n==std::string("keyWeight_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &keyWeight_changed);
  }
  if(n==std::string("knot_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &knot_changed);
  }
  if(n==std::string("order_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &order_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : value_changed
 *  - 1 : dimension_changed
 *  - 2 : keyValue_changed
 *  - 3 : keyWeight_changed
 *  - 4 : knot_changed
 *  - 5 : order_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NurbsPositionInterpolator::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("value_changed",sfVec3f,&value_changed);
  case 1: return Node::eventOut("dimension_changed",sfInt32,&dimension_changed);
  case 2: return Node::eventOut("keyValue_changed",mfVec3f,&keyValue_changed);
  case 3: return Node::eventOut("keyWeight_changed",mfFloat,&keyWeight_changed);
  case 4: return Node::eventOut("knot_changed",mfFloat,&knot_changed);
  case 5: return Node::eventOut("order_changed",sfInt32,&order_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NurbsPositionInterpolator::duplicate() const
{
  NurbsPositionInterpolator* n = new NurbsPositionInterpolator(name());
  n->dimension = dimension;
  n->keyValue = keyValue;
  n->keyWeight = keyWeight;
  n->knot = knot;
  n->order = order;
  return n;
}
wrl::Node* 
wrl::NurbsPositionInterpolator::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NurbsPositionInterpolator* n = new NurbsPositionInterpolator(name());
  nodeMap[this] = n;  n->dimension = dimension;
  n->keyValue = keyValue;
  n->keyWeight = keyWeight;
  n->knot = knot;
  n->order = order;
  return n;
}
bool
wrl::NurbsPositionInterpolator::isSetToDefaultValue(unsigned int i) const
{
  static const SFInt32 dimensionDV_(0);
  static const SFInt32 orderDV_(4);
  switch (i)
  {
  case 0: return dimension == dimensionDV_;
  case 1: return keyValue == MFVec3f();
  case 2: return keyWeight == MFFloat();
  case 3: return knot == MFFloat();
  case 4: return order == orderDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
