#include <xdkwrl/nodes/nurbscurve.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NurbsCurve
//************************************************************
/*! \class wrl::NurbsCurve
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude nurbscurve.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  tessellation = 0;
  order = 3;
  \endcode
  */
wrl::NurbsCurve::NurbsCurve(const char* name)
 : Node(name)
{

  tessellation = 0;
  order = 3;}
/*!
 * Virtual destructor, does nothing
 */
wrl::NurbsCurve::~NurbsCurve()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - controlPoint
 *  - weight
 *  - tessellation
 *  - knot
 *  - order
 */
wrl::Node::FieldHandle
wrl::NurbsCurve::field(const std::string& n)
{
  if(n==std::string("controlPoint"))
  {
    return Node::field(n,mfVec3f,(void*) &controlPoint);
  }
  if(n==std::string("weight"))
  {
    return Node::field(n,mfFloat,(void*) &weight);
  }
  if(n==std::string("tessellation"))
  {
    return Node::field(n,sfInt32,(void*) &tessellation);
  }
  if(n==std::string("knot"))
  {
    return Node::field(n,mfFloat,(void*) &knot);
  }
  if(n==std::string("order"))
  {
    return Node::field(n,sfInt32,(void*) &order);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint
 *  - 1 : weight
 *  - 2 : tessellation
 *  - 3 : knot
 *  - 4 : order
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NurbsCurve::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("controlPoint",mfVec3f,&controlPoint);
  case 1: return Node::field("weight",mfFloat,&weight);
  case 2: return Node::field("tessellation",sfInt32,&tessellation);
  case 3: return Node::field("knot",mfFloat,&knot);
  case 4: return Node::field("order",sfInt32,&order);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_controlPoint
 *  - set_weight
 *  - set_tessellation
 */
wrl::Node::EventInHandle
wrl::NurbsCurve::eventIn(const std::string& n)
{
  if(n==std::string("set_controlPoint"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_controlPoint);
  }
  if(n==std::string("set_weight"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_weight);
  }
  if(n==std::string("set_tessellation"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_tessellation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NurbsCurve::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_controlPoint",mfVec3f,&set_controlPoint);
  case 1: return Node::eventIn("set_weight",mfFloat,&set_weight);
  case 2: return Node::eventIn("set_tessellation",sfInt32,&set_tessellation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - controlPoint_changed
 *  - weight_changed
 *  - tessellation_changed
 */
wrl::Node::EventOutHandle
wrl::NurbsCurve::eventOut(const std::string& n)
{
  if(n==std::string("controlPoint_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &controlPoint_changed);
  }
  if(n==std::string("weight_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &weight_changed);
  }
  if(n==std::string("tessellation_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &tessellation_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint_changed
 *  - 1 : weight_changed
 *  - 2 : tessellation_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NurbsCurve::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("controlPoint_changed",mfVec3f,&controlPoint_changed);
  case 1: return Node::eventOut("weight_changed",mfFloat,&weight_changed);
  case 2: return Node::eventOut("tessellation_changed",sfInt32,&tessellation_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NurbsCurve::duplicate() const
{
  NurbsCurve* n = new NurbsCurve(name());
  n->controlPoint = controlPoint;
  n->weight = weight;
  n->tessellation = tessellation;
  n->knot = knot;
  n->order = order;
  return n;
}
wrl::Node* 
wrl::NurbsCurve::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NurbsCurve* n = new NurbsCurve(name());
  nodeMap[this] = n;  n->controlPoint = controlPoint;
  n->weight = weight;
  n->tessellation = tessellation;
  n->knot = knot;
  n->order = order;
  return n;
}
bool
wrl::NurbsCurve::isSetToDefaultValue(unsigned int i) const
{

  static const SFInt32 tessellationDV_(0);
  static const SFInt32 orderDV_(3);
  switch (i)
  {
  case 0: return controlPoint == MFVec3f();
  case 1: return weight == MFFloat();
  case 2: return tessellation == tessellationDV_;
  case 3: return knot == MFFloat();
  case 4: return order == orderDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
