#include <xdkwrl/nodes/inline.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Inline
//************************************************************
/*! \class wrl::Inline
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude inline.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::Inline::Inline(const char* name)
 : Node(name)
{

  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Inline::~Inline()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - url
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::Inline::field(const std::string& n)
{
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : url
 *  - 1 : bboxCenter
 *  - 2 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Inline::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("url",mfString,&url);
  case 1: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 2: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::Inline::eventIn(const std::string& n)
{
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Inline::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::Inline::eventOut(const std::string& n)
{
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Inline::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Inline::duplicate() const
{
  Inline* n = new Inline(name());
  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::Inline::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Inline* n = new Inline(name());
  nodeMap[this] = n;  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::Inline::isSetToDefaultValue(unsigned int i) const
{

  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return url == MFString();
  case 1: return bboxCenter == bboxCenterDV_;
  case 2: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
