#include <xdkwrl/nodes/indexedfaceset.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of IndexedFaceSet
//************************************************************
/*! \class wrl::IndexedFaceSet
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude indexedfaceset.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  ccw = true;
  colorPerVertex = true;
  convex = true;
  creaseAngle = 0.0f;
  normalPerVertex = true;
  solid = true;
  \endcode
  */
wrl::IndexedFaceSet::IndexedFaceSet(const char* name)
 : Node(name)
{

  ccw = true;
  colorPerVertex = true;
  convex = true;
  creaseAngle = 0.0f;
  normalPerVertex = true;
  solid = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::IndexedFaceSet::~IndexedFaceSet()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - coord
 *  - normal
 *  - texCoord
 *  - ccw
 *  - colorIndex
 *  - colorPerVertex
 *  - convex
 *  - coordIndex
 *  - creaseAngle
 *  - normalIndex
 *  - normalPerVertex
 *  - solid
 *  - texCoordIndex
 */
wrl::Node::FieldHandle
wrl::IndexedFaceSet::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfNode,(void*) &color);
  }
  if(n==std::string("coord"))
  {
    return Node::field(n,sfNode,(void*) &coord);
  }
  if(n==std::string("normal"))
  {
    return Node::field(n,sfNode,(void*) &normal);
  }
  if(n==std::string("texCoord"))
  {
    return Node::field(n,sfNode,(void*) &texCoord);
  }
  if(n==std::string("ccw"))
  {
    return Node::field(n,sfBool,(void*) &ccw);
  }
  if(n==std::string("colorIndex"))
  {
    return Node::field(n,mfInt32,(void*) &colorIndex);
  }
  if(n==std::string("colorPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &colorPerVertex);
  }
  if(n==std::string("convex"))
  {
    return Node::field(n,sfBool,(void*) &convex);
  }
  if(n==std::string("coordIndex"))
  {
    return Node::field(n,mfInt32,(void*) &coordIndex);
  }
  if(n==std::string("creaseAngle"))
  {
    return Node::field(n,sfFloat,(void*) &creaseAngle);
  }
  if(n==std::string("normalIndex"))
  {
    return Node::field(n,mfInt32,(void*) &normalIndex);
  }
  if(n==std::string("normalPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &normalPerVertex);
  }
  if(n==std::string("solid"))
  {
    return Node::field(n,sfBool,(void*) &solid);
  }
  if(n==std::string("texCoordIndex"))
  {
    return Node::field(n,mfInt32,(void*) &texCoordIndex);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : coord
 *  - 2 : normal
 *  - 3 : texCoord
 *  - 4 : ccw
 *  - 5 : colorIndex
 *  - 6 : colorPerVertex
 *  - 7 : convex
 *  - 8 : coordIndex
 *  - 9 : creaseAngle
 *  - 10 : normalIndex
 *  - 11 : normalPerVertex
 *  - 12 : solid
 *  - 13 : texCoordIndex
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::IndexedFaceSet::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfNode,&color);
  case 1: return Node::field("coord",sfNode,&coord);
  case 2: return Node::field("normal",sfNode,&normal);
  case 3: return Node::field("texCoord",sfNode,&texCoord);
  case 4: return Node::field("ccw",sfBool,&ccw);
  case 5: return Node::field("colorIndex",mfInt32,&colorIndex);
  case 6: return Node::field("colorPerVertex",sfBool,&colorPerVertex);
  case 7: return Node::field("convex",sfBool,&convex);
  case 8: return Node::field("coordIndex",mfInt32,&coordIndex);
  case 9: return Node::field("creaseAngle",sfFloat,&creaseAngle);
  case 10: return Node::field("normalIndex",mfInt32,&normalIndex);
  case 11: return Node::field("normalPerVertex",sfBool,&normalPerVertex);
  case 12: return Node::field("solid",sfBool,&solid);
  case 13: return Node::field("texCoordIndex",mfInt32,&texCoordIndex);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_colorIndex
 *  - set_coordIndex
 *  - set_normalIndex
 *  - set_texCoordIndex
 *  - set_color
 *  - set_coord
 *  - set_normal
 *  - set_texCoord
 */
wrl::Node::EventInHandle
wrl::IndexedFaceSet::eventIn(const std::string& n)
{
  if(n==std::string("set_colorIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_colorIndex);
  }
  if(n==std::string("set_coordIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_coordIndex);
  }
  if(n==std::string("set_normalIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_normalIndex);
  }
  if(n==std::string("set_texCoordIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_texCoordIndex);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_color);
  }
  if(n==std::string("set_coord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_coord);
  }
  if(n==std::string("set_normal"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_normal);
  }
  if(n==std::string("set_texCoord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_colorIndex
 *  - 1 : set_coordIndex
 *  - 2 : set_normalIndex
 *  - 3 : set_texCoordIndex
 *  - 4 : set_color
 *  - 5 : set_coord
 *  - 6 : set_normal
 *  - 7 : set_texCoord

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::IndexedFaceSet::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_colorIndex",mfInt32,&set_colorIndex);
  case 1: return Node::eventIn("set_coordIndex",mfInt32,&set_coordIndex);
  case 2: return Node::eventIn("set_normalIndex",mfInt32,&set_normalIndex);
  case 3: return Node::eventIn("set_texCoordIndex",mfInt32,&set_texCoordIndex);
  case 4: return Node::eventIn("set_color",sfNode,&set_color);
  case 5: return Node::eventIn("set_coord",sfNode,&set_coord);
  case 6: return Node::eventIn("set_normal",sfNode,&set_normal);
  case 7: return Node::eventIn("set_texCoord",sfNode,&set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 *  - coord_changed
 *  - normal_changed
 *  - texCoord_changed
 */
wrl::Node::EventOutHandle
wrl::IndexedFaceSet::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &color_changed);
  }
  if(n==std::string("coord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &coord_changed);
  }
  if(n==std::string("normal_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &normal_changed);
  }
  if(n==std::string("texCoord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &texCoord_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 *  - 1 : coord_changed
 *  - 2 : normal_changed
 *  - 3 : texCoord_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::IndexedFaceSet::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",sfNode,&color_changed);
  case 1: return Node::eventOut("coord_changed",sfNode,&coord_changed);
  case 2: return Node::eventOut("normal_changed",sfNode,&normal_changed);
  case 3: return Node::eventOut("texCoord_changed",sfNode,&texCoord_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::IndexedFaceSet::duplicate() const
{
  IndexedFaceSet* n = new IndexedFaceSet(name());
  if (color != NULL)
  {
    n->color = color->duplicate();
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate();
  }
  else
  {
    n->coord = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate();
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate();
  }
  else
  {
    n->texCoord = NULL;
  }
  n->ccw = ccw;
  n->colorIndex = colorIndex;
  n->colorPerVertex = colorPerVertex;
  n->convex = convex;
  n->coordIndex = coordIndex;
  n->creaseAngle = creaseAngle;
  n->normalIndex = normalIndex;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->texCoordIndex = texCoordIndex;
  return n;
}
wrl::Node* 
wrl::IndexedFaceSet::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  IndexedFaceSet* n = new IndexedFaceSet(name());
  nodeMap[this] = n;  if (color != NULL)
  {
    n->color = color->duplicate(nodeMap);
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate(nodeMap);
  }
  else
  {
    n->coord = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate(nodeMap);
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate(nodeMap);
  }
  else
  {
    n->texCoord = NULL;
  }
  n->ccw = ccw;
  n->colorIndex = colorIndex;
  n->colorPerVertex = colorPerVertex;
  n->convex = convex;
  n->coordIndex = coordIndex;
  n->creaseAngle = creaseAngle;
  n->normalIndex = normalIndex;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->texCoordIndex = texCoordIndex;
  return n;
}
bool
wrl::IndexedFaceSet::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool ccwDV_(true);
  static const SFBool colorPerVertexDV_(true);
  static const SFBool convexDV_(true);
  static const SFFloat creaseAngleDV_(0.0f);
  static const SFBool normalPerVertexDV_(true);
  static const SFBool solidDV_(true);
  switch (i)
  {
  case 0: return color == SFNode();
  case 1: return coord == SFNode();
  case 2: return normal == SFNode();
  case 3: return texCoord == SFNode();
  case 4: return ccw == ccwDV_;
  case 5: return colorIndex == MFInt32();
  case 6: return colorPerVertex == colorPerVertexDV_;
  case 7: return convex == convexDV_;
  case 8: return coordIndex == MFInt32();
  case 9: return creaseAngle == creaseAngleDV_;
  case 10: return normalIndex == MFInt32();
  case 11: return normalPerVertex == normalPerVertexDV_;
  case 12: return solid == solidDV_;
  case 13: return texCoordIndex == MFInt32();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
