#include <xdkwrl/nodes/geoviewpoint.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoViewpoint
//************************************************************
/*! \class wrl::GeoViewpoint
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geoviewpoint.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  fieldOfView = 0.785398f;
  headlight = true;
  jump = true;
  
  description = string("");
  
  orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  position = string("0 0 100000");
  speedFactor = 1.0f;
  \endcode
  */
wrl::GeoViewpoint::GeoViewpoint(const char* name)
 : Node(name)
{
  fieldOfView = 0.785398f;
  headlight = true;
  jump = true;
  
  description = string("");
  
  orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  position = string("0 0 100000");
  speedFactor = 1.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoViewpoint::~GeoViewpoint()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - fieldOfView
 *  - headlight
 *  - jump
 *  - navType
 *  - description
 *  - geoOrigin
 *  - geoSystem
 *  - orientation
 *  - position
 *  - speedFactor
 */
wrl::Node::FieldHandle
wrl::GeoViewpoint::field(const std::string& n)
{
  if(n==std::string("fieldOfView"))
  {
    return Node::field(n,sfFloat,(void*) &fieldOfView);
  }
  if(n==std::string("headlight"))
  {
    return Node::field(n,sfBool,(void*) &headlight);
  }
  if(n==std::string("jump"))
  {
    return Node::field(n,sfBool,(void*) &jump);
  }
  if(n==std::string("navType"))
  {
    return Node::field(n,mfString,(void*) &navType);
  }
  if(n==std::string("description"))
  {
    return Node::field(n,sfString,(void*) &description);
  }
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("orientation"))
  {
    return Node::field(n,sfRotation,(void*) &orientation);
  }
  if(n==std::string("position"))
  {
    return Node::field(n,sfString,(void*) &position);
  }
  if(n==std::string("speedFactor"))
  {
    return Node::field(n,sfFloat,(void*) &speedFactor);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : fieldOfView
 *  - 1 : headlight
 *  - 2 : jump
 *  - 3 : navType
 *  - 4 : description
 *  - 5 : geoOrigin
 *  - 6 : geoSystem
 *  - 7 : orientation
 *  - 8 : position
 *  - 9 : speedFactor
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoViewpoint::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("fieldOfView",sfFloat,&fieldOfView);
  case 1: return Node::field("headlight",sfBool,&headlight);
  case 2: return Node::field("jump",sfBool,&jump);
  case 3: return Node::field("navType",mfString,&navType);
  case 4: return Node::field("description",sfString,&description);
  case 5: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 6: return Node::field("geoSystem",mfString,&geoSystem);
  case 7: return Node::field("orientation",sfRotation,&orientation);
  case 8: return Node::field("position",sfString,&position);
  case 9: return Node::field("speedFactor",sfFloat,&speedFactor);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_bind
 *  - set_orientation
 *  - set_position
 *  - set_fieldOfView
 *  - set_headlight
 *  - set_jump
 *  - set_navType
 */
wrl::Node::EventInHandle
wrl::GeoViewpoint::eventIn(const std::string& n)
{
  if(n==std::string("set_bind"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_bind);
  }
  if(n==std::string("set_orientation"))
  {
    return Node::eventIn(n,sfString,(void*) &set_orientation);
  }
  if(n==std::string("set_position"))
  {
    return Node::eventIn(n,sfString,(void*) &set_position);
  }
  if(n==std::string("set_fieldOfView"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fieldOfView);
  }
  if(n==std::string("set_headlight"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_headlight);
  }
  if(n==std::string("set_jump"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_jump);
  }
  if(n==std::string("set_navType"))
  {
    return Node::eventIn(n,mfString,(void*) &set_navType);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_bind
 *  - 1 : set_orientation
 *  - 2 : set_position
 *  - 3 : set_fieldOfView
 *  - 4 : set_headlight
 *  - 5 : set_jump
 *  - 6 : set_navType

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoViewpoint::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_bind",sfBool,&set_bind);
  case 1: return Node::eventIn("set_orientation",sfString,&set_orientation);
  case 2: return Node::eventIn("set_position",sfString,&set_position);
  case 3: return Node::eventIn("set_fieldOfView",sfFloat,&set_fieldOfView);
  case 4: return Node::eventIn("set_headlight",sfBool,&set_headlight);
  case 5: return Node::eventIn("set_jump",sfBool,&set_jump);
  case 6: return Node::eventIn("set_navType",mfString,&set_navType);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - bindTime
 *  - isBound
 *  - fieldOfView_changed
 *  - headlight_changed
 *  - jump_changed
 *  - navType_changed
 */
wrl::Node::EventOutHandle
wrl::GeoViewpoint::eventOut(const std::string& n)
{
  if(n==std::string("bindTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &bindTime);
  }
  if(n==std::string("isBound"))
  {
    return Node::eventOut(n,sfBool,(void*) &isBound);
  }
  if(n==std::string("fieldOfView_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &fieldOfView_changed);
  }
  if(n==std::string("headlight_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &headlight_changed);
  }
  if(n==std::string("jump_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &jump_changed);
  }
  if(n==std::string("navType_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &navType_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : bindTime
 *  - 1 : isBound
 *  - 2 : fieldOfView_changed
 *  - 3 : headlight_changed
 *  - 4 : jump_changed
 *  - 5 : navType_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoViewpoint::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("bindTime",sfTime,&bindTime);
  case 1: return Node::eventOut("isBound",sfBool,&isBound);
  case 2: return Node::eventOut("fieldOfView_changed",sfFloat,&fieldOfView_changed);
  case 3: return Node::eventOut("headlight_changed",sfBool,&headlight_changed);
  case 4: return Node::eventOut("jump_changed",sfBool,&jump_changed);
  case 5: return Node::eventOut("navType_changed",mfString,&navType_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoViewpoint::duplicate() const
{
  GeoViewpoint* n = new GeoViewpoint(name());
  n->fieldOfView = fieldOfView;
  n->headlight = headlight;
  n->jump = jump;
  n->navType = navType;
  n->description = description;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->orientation = orientation;
  n->position = position;
  n->speedFactor = speedFactor;
  return n;
}
wrl::Node* 
wrl::GeoViewpoint::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoViewpoint* n = new GeoViewpoint(name());
  nodeMap[this] = n;  n->fieldOfView = fieldOfView;
  n->headlight = headlight;
  n->jump = jump;
  n->navType = navType;
  n->description = description;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->orientation = orientation;
  n->position = position;
  n->speedFactor = speedFactor;
  return n;
}
bool
wrl::GeoViewpoint::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat fieldOfViewDV_(0.785f);
  static const SFBool headlightDV_(true);
  static const SFBool jumpDV_(true);
  static MFString navTypeDV_;
  if (navTypeDV_.empty())
  {
  }
  static const SFString descriptionDV_("");
  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  static const SFRotation orientationDV_(0.0f,0.0f,1.0f,0.0f);
  static const SFString positionDV_("0 0 100000");
  static const SFFloat speedFactorDV_(1.0f);
  switch (i)
  {
  case 0: return fieldOfView == fieldOfViewDV_;
  case 1: return headlight == headlightDV_;
  case 2: return jump == jumpDV_;
  case 3: return navType == navTypeDV_;
  case 4: return description == descriptionDV_;
  case 5: return geoOrigin == SFNode();
  case 6: return geoSystem == geoSystemDV_;
  case 7: return orientation == orientationDV_;
  case 8: return position == positionDV_;
  case 9: return speedFactor == speedFactorDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
