#include <xdkwrl/nodes/geoorigin.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoOrigin
//************************************************************
/*! \class wrl::GeoOrigin
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geoorigin.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  
  geoCoords = string("");
  rotateYUp = false;
  \endcode
  */
wrl::GeoOrigin::GeoOrigin(const char* name)
 : Node(name)
{
  
  geoCoords = string("");
  rotateYUp = false;}
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoOrigin::~GeoOrigin()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - geoSystem
 *  - geoCoords
 *  - rotateYUp
 */
wrl::Node::FieldHandle
wrl::GeoOrigin::field(const std::string& n)
{
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("geoCoords"))
  {
    return Node::field(n,sfString,(void*) &geoCoords);
  }
  if(n==std::string("rotateYUp"))
  {
    return Node::field(n,sfBool,(void*) &rotateYUp);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoSystem
 *  - 1 : geoCoords
 *  - 2 : rotateYUp
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoOrigin::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("geoSystem",mfString,&geoSystem);
  case 1: return Node::field("geoCoords",sfString,&geoCoords);
  case 2: return Node::field("rotateYUp",sfBool,&rotateYUp);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_geoSystem
 *  - set_geoCoords
 */
wrl::Node::EventInHandle
wrl::GeoOrigin::eventIn(const std::string& n)
{
  if(n==std::string("set_geoSystem"))
  {
    return Node::eventIn(n,mfString,(void*) &set_geoSystem);
  }
  if(n==std::string("set_geoCoords"))
  {
    return Node::eventIn(n,sfString,(void*) &set_geoCoords);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoOrigin::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_geoSystem",mfString,&set_geoSystem);
  case 1: return Node::eventIn("set_geoCoords",sfString,&set_geoCoords);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - geoSystem_changed
 *  - geoCoords_changed
 */
wrl::Node::EventOutHandle
wrl::GeoOrigin::eventOut(const std::string& n)
{
  if(n==std::string("geoSystem_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &geoSystem_changed);
  }
  if(n==std::string("geoCoords_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &geoCoords_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoSystem_changed
 *  - 1 : geoCoords_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoOrigin::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("geoSystem_changed",mfString,&geoSystem_changed);
  case 1: return Node::eventOut("geoCoords_changed",sfString,&geoCoords_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoOrigin::duplicate() const
{
  GeoOrigin* n = new GeoOrigin(name());
  n->geoSystem = geoSystem;
  n->geoCoords = geoCoords;
  n->rotateYUp = rotateYUp;
  return n;
}
wrl::Node* 
wrl::GeoOrigin::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoOrigin* n = new GeoOrigin(name());
  nodeMap[this] = n;  n->geoSystem = geoSystem;
  n->geoCoords = geoCoords;
  n->rotateYUp = rotateYUp;
  return n;
}
bool
wrl::GeoOrigin::isSetToDefaultValue(unsigned int i) const
{
  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  static const SFString geoCoordsDV_("");
  static const SFBool rotateYUpDV_(false);
  switch (i)
  {
  case 0: return geoSystem == geoSystemDV_;
  case 1: return geoCoords == geoCoordsDV_;
  case 2: return rotateYUp == rotateYUpDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
