#include <xdkwrl/nodes/geoelevationgrid.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoElevationGrid
//************************************************************
/*! \class wrl::GeoElevationGrid
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geoelevationgrid.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  ccw = true;
  colorPerVertex = true;
  creaseAngle = 0.0f;
  
  geoGridOrigin = string("0 0 0");
  normalPerVertex = true;
  solid = true;
  xDimension = 0;
  xSpacing = string("1.0");
  yScale = 1.0f;
  zDimension = 0;
  zSpacing = string("1.0");
  \endcode
  */
wrl::GeoElevationGrid::GeoElevationGrid(const char* name)
 : Node(name)
{

  ccw = true;
  colorPerVertex = true;
  creaseAngle = 0.0f;
  
  geoGridOrigin = string("0 0 0");
  normalPerVertex = true;
  solid = true;
  xDimension = 0;
  xSpacing = string("1.0");
  yScale = 1.0f;
  zDimension = 0;
  zSpacing = string("1.0");}
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoElevationGrid::~GeoElevationGrid()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - normal
 *  - texCoord
 *  - ccw
 *  - colorPerVertex
 *  - creaseAngle
 *  - geoOrigin
 *  - geoSystem
 *  - geoGridOrigin
 *  - height
 *  - normalPerVertex
 *  - solid
 *  - xDimension
 *  - xSpacing
 *  - yScale
 *  - zDimension
 *  - zSpacing
 */
wrl::Node::FieldHandle
wrl::GeoElevationGrid::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfNode,(void*) &color);
  }
  if(n==std::string("normal"))
  {
    return Node::field(n,sfNode,(void*) &normal);
  }
  if(n==std::string("texCoord"))
  {
    return Node::field(n,sfNode,(void*) &texCoord);
  }
  if(n==std::string("ccw"))
  {
    return Node::field(n,sfBool,(void*) &ccw);
  }
  if(n==std::string("colorPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &colorPerVertex);
  }
  if(n==std::string("creaseAngle"))
  {
    return Node::field(n,sfFloat,(void*) &creaseAngle);
  }
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("geoGridOrigin"))
  {
    return Node::field(n,sfString,(void*) &geoGridOrigin);
  }
  if(n==std::string("height"))
  {
    return Node::field(n,mfFloat,(void*) &height);
  }
  if(n==std::string("normalPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &normalPerVertex);
  }
  if(n==std::string("solid"))
  {
    return Node::field(n,sfBool,(void*) &solid);
  }
  if(n==std::string("xDimension"))
  {
    return Node::field(n,sfInt32,(void*) &xDimension);
  }
  if(n==std::string("xSpacing"))
  {
    return Node::field(n,sfString,(void*) &xSpacing);
  }
  if(n==std::string("yScale"))
  {
    return Node::field(n,sfFloat,(void*) &yScale);
  }
  if(n==std::string("zDimension"))
  {
    return Node::field(n,sfInt32,(void*) &zDimension);
  }
  if(n==std::string("zSpacing"))
  {
    return Node::field(n,sfString,(void*) &zSpacing);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : normal
 *  - 2 : texCoord
 *  - 3 : ccw
 *  - 4 : colorPerVertex
 *  - 5 : creaseAngle
 *  - 6 : geoOrigin
 *  - 7 : geoSystem
 *  - 8 : geoGridOrigin
 *  - 9 : height
 *  - 10 : normalPerVertex
 *  - 11 : solid
 *  - 12 : xDimension
 *  - 13 : xSpacing
 *  - 14 : yScale
 *  - 15 : zDimension
 *  - 16 : zSpacing
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoElevationGrid::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfNode,&color);
  case 1: return Node::field("normal",sfNode,&normal);
  case 2: return Node::field("texCoord",sfNode,&texCoord);
  case 3: return Node::field("ccw",sfBool,&ccw);
  case 4: return Node::field("colorPerVertex",sfBool,&colorPerVertex);
  case 5: return Node::field("creaseAngle",sfFloat,&creaseAngle);
  case 6: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 7: return Node::field("geoSystem",mfString,&geoSystem);
  case 8: return Node::field("geoGridOrigin",sfString,&geoGridOrigin);
  case 9: return Node::field("height",mfFloat,&height);
  case 10: return Node::field("normalPerVertex",sfBool,&normalPerVertex);
  case 11: return Node::field("solid",sfBool,&solid);
  case 12: return Node::field("xDimension",sfInt32,&xDimension);
  case 13: return Node::field("xSpacing",sfString,&xSpacing);
  case 14: return Node::field("yScale",sfFloat,&yScale);
  case 15: return Node::field("zDimension",sfInt32,&zDimension);
  case 16: return Node::field("zSpacing",sfString,&zSpacing);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_height
 *  - set_yScale
 *  - set_color
 *  - set_normal
 *  - set_texCoord
 */
wrl::Node::EventInHandle
wrl::GeoElevationGrid::eventIn(const std::string& n)
{
  if(n==std::string("set_height"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_height);
  }
  if(n==std::string("set_yScale"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_yScale);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_color);
  }
  if(n==std::string("set_normal"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_normal);
  }
  if(n==std::string("set_texCoord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_height
 *  - 1 : set_yScale
 *  - 2 : set_color
 *  - 3 : set_normal
 *  - 4 : set_texCoord

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoElevationGrid::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_height",mfFloat,&set_height);
  case 1: return Node::eventIn("set_yScale",sfFloat,&set_yScale);
  case 2: return Node::eventIn("set_color",sfNode,&set_color);
  case 3: return Node::eventIn("set_normal",sfNode,&set_normal);
  case 4: return Node::eventIn("set_texCoord",sfNode,&set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 *  - normal_changed
 *  - texCoord_changed
 */
wrl::Node::EventOutHandle
wrl::GeoElevationGrid::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &color_changed);
  }
  if(n==std::string("normal_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &normal_changed);
  }
  if(n==std::string("texCoord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &texCoord_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 *  - 1 : normal_changed
 *  - 2 : texCoord_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoElevationGrid::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",sfNode,&color_changed);
  case 1: return Node::eventOut("normal_changed",sfNode,&normal_changed);
  case 2: return Node::eventOut("texCoord_changed",sfNode,&texCoord_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoElevationGrid::duplicate() const
{
  GeoElevationGrid* n = new GeoElevationGrid(name());
  if (color != NULL)
  {
    n->color = color->duplicate();
  }
  else
  {
    n->color = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate();
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate();
  }
  else
  {
    n->texCoord = NULL;
  }
  n->ccw = ccw;
  n->colorPerVertex = colorPerVertex;
  n->creaseAngle = creaseAngle;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->geoGridOrigin = geoGridOrigin;
  n->height = height;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->xDimension = xDimension;
  n->xSpacing = xSpacing;
  n->yScale = yScale;
  n->zDimension = zDimension;
  n->zSpacing = zSpacing;
  return n;
}
wrl::Node* 
wrl::GeoElevationGrid::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoElevationGrid* n = new GeoElevationGrid(name());
  nodeMap[this] = n;  if (color != NULL)
  {
    n->color = color->duplicate(nodeMap);
  }
  else
  {
    n->color = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate(nodeMap);
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate(nodeMap);
  }
  else
  {
    n->texCoord = NULL;
  }
  n->ccw = ccw;
  n->colorPerVertex = colorPerVertex;
  n->creaseAngle = creaseAngle;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->geoGridOrigin = geoGridOrigin;
  n->height = height;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->xDimension = xDimension;
  n->xSpacing = xSpacing;
  n->yScale = yScale;
  n->zDimension = zDimension;
  n->zSpacing = zSpacing;
  return n;
}
bool
wrl::GeoElevationGrid::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool ccwDV_(true);
  static const SFBool colorPerVertexDV_(true);
  static const SFFloat creaseAngleDV_(0.0f);
  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  static const SFString geoGridOriginDV_("0 0 0");
  static const SFBool normalPerVertexDV_(true);
  static const SFBool solidDV_(true);
  static const SFInt32 xDimensionDV_(0);
  static const SFString xSpacingDV_("1.0");
  static const SFFloat yScaleDV_(1.0f);
  static const SFInt32 zDimensionDV_(0);
  static const SFString zSpacingDV_("1.0");
  switch (i)
  {
  case 0: return color == SFNode();
  case 1: return normal == SFNode();
  case 2: return texCoord == SFNode();
  case 3: return ccw == ccwDV_;
  case 4: return colorPerVertex == colorPerVertexDV_;
  case 5: return creaseAngle == creaseAngleDV_;
  case 6: return geoOrigin == SFNode();
  case 7: return geoSystem == geoSystemDV_;
  case 8: return geoGridOrigin == geoGridOriginDV_;
  case 9: return height == MFFloat();
  case 10: return normalPerVertex == normalPerVertexDV_;
  case 11: return solid == solidDV_;
  case 12: return xDimension == xDimensionDV_;
  case 13: return xSpacing == xSpacingDV_;
  case 14: return yScale == yScaleDV_;
  case 15: return zDimension == zDimensionDV_;
  case 16: return zSpacing == zSpacingDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
