#include <xdkwrl/nodes/elevationgrid.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of ElevationGrid
//************************************************************
/*! \class wrl::ElevationGrid
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude elevationgrid.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  ccw = true;
  colorPerVertex = true;
  creaseAngle = 0.0f;
  normalPerVertex = true;
  solid = true;
  xDimension = 0;
  xSpacing = 1.0f;
  zDimension = 0;
  zSpacing = 1.0f;
  \endcode
  */
wrl::ElevationGrid::ElevationGrid(const char* name)
 : Node(name)
{

  ccw = true;
  colorPerVertex = true;
  creaseAngle = 0.0f;
  normalPerVertex = true;
  solid = true;
  xDimension = 0;
  xSpacing = 1.0f;
  zDimension = 0;
  zSpacing = 1.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::ElevationGrid::~ElevationGrid()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - normal
 *  - texCoord
 *  - height
 *  - ccw
 *  - colorPerVertex
 *  - creaseAngle
 *  - normalPerVertex
 *  - solid
 *  - xDimension
 *  - xSpacing
 *  - zDimension
 *  - zSpacing
 */
wrl::Node::FieldHandle
wrl::ElevationGrid::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfNode,(void*) &color);
  }
  if(n==std::string("normal"))
  {
    return Node::field(n,sfNode,(void*) &normal);
  }
  if(n==std::string("texCoord"))
  {
    return Node::field(n,sfNode,(void*) &texCoord);
  }
  if(n==std::string("height"))
  {
    return Node::field(n,mfFloat,(void*) &height);
  }
  if(n==std::string("ccw"))
  {
    return Node::field(n,sfBool,(void*) &ccw);
  }
  if(n==std::string("colorPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &colorPerVertex);
  }
  if(n==std::string("creaseAngle"))
  {
    return Node::field(n,sfFloat,(void*) &creaseAngle);
  }
  if(n==std::string("normalPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &normalPerVertex);
  }
  if(n==std::string("solid"))
  {
    return Node::field(n,sfBool,(void*) &solid);
  }
  if(n==std::string("xDimension"))
  {
    return Node::field(n,sfInt32,(void*) &xDimension);
  }
  if(n==std::string("xSpacing"))
  {
    return Node::field(n,sfFloat,(void*) &xSpacing);
  }
  if(n==std::string("zDimension"))
  {
    return Node::field(n,sfInt32,(void*) &zDimension);
  }
  if(n==std::string("zSpacing"))
  {
    return Node::field(n,sfFloat,(void*) &zSpacing);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : normal
 *  - 2 : texCoord
 *  - 3 : height
 *  - 4 : ccw
 *  - 5 : colorPerVertex
 *  - 6 : creaseAngle
 *  - 7 : normalPerVertex
 *  - 8 : solid
 *  - 9 : xDimension
 *  - 10 : xSpacing
 *  - 11 : zDimension
 *  - 12 : zSpacing
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::ElevationGrid::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfNode,&color);
  case 1: return Node::field("normal",sfNode,&normal);
  case 2: return Node::field("texCoord",sfNode,&texCoord);
  case 3: return Node::field("height",mfFloat,&height);
  case 4: return Node::field("ccw",sfBool,&ccw);
  case 5: return Node::field("colorPerVertex",sfBool,&colorPerVertex);
  case 6: return Node::field("creaseAngle",sfFloat,&creaseAngle);
  case 7: return Node::field("normalPerVertex",sfBool,&normalPerVertex);
  case 8: return Node::field("solid",sfBool,&solid);
  case 9: return Node::field("xDimension",sfInt32,&xDimension);
  case 10: return Node::field("xSpacing",sfFloat,&xSpacing);
  case 11: return Node::field("zDimension",sfInt32,&zDimension);
  case 12: return Node::field("zSpacing",sfFloat,&zSpacing);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_height
 *  - set_color
 *  - set_normal
 *  - set_texCoord
 */
wrl::Node::EventInHandle
wrl::ElevationGrid::eventIn(const std::string& n)
{
  if(n==std::string("set_height"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_height);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_color);
  }
  if(n==std::string("set_normal"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_normal);
  }
  if(n==std::string("set_texCoord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_height
 *  - 1 : set_color
 *  - 2 : set_normal
 *  - 3 : set_texCoord

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::ElevationGrid::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_height",mfFloat,&set_height);
  case 1: return Node::eventIn("set_color",sfNode,&set_color);
  case 2: return Node::eventIn("set_normal",sfNode,&set_normal);
  case 3: return Node::eventIn("set_texCoord",sfNode,&set_texCoord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 *  - normal_changed
 *  - texCoord_changed
 */
wrl::Node::EventOutHandle
wrl::ElevationGrid::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &color_changed);
  }
  if(n==std::string("normal_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &normal_changed);
  }
  if(n==std::string("texCoord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &texCoord_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 *  - 1 : normal_changed
 *  - 2 : texCoord_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::ElevationGrid::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",sfNode,&color_changed);
  case 1: return Node::eventOut("normal_changed",sfNode,&normal_changed);
  case 2: return Node::eventOut("texCoord_changed",sfNode,&texCoord_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::ElevationGrid::duplicate() const
{
  ElevationGrid* n = new ElevationGrid(name());
  if (color != NULL)
  {
    n->color = color->duplicate();
  }
  else
  {
    n->color = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate();
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate();
  }
  else
  {
    n->texCoord = NULL;
  }
  n->height = height;
  n->ccw = ccw;
  n->colorPerVertex = colorPerVertex;
  n->creaseAngle = creaseAngle;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->xDimension = xDimension;
  n->xSpacing = xSpacing;
  n->zDimension = zDimension;
  n->zSpacing = zSpacing;
  return n;
}
wrl::Node* 
wrl::ElevationGrid::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ElevationGrid* n = new ElevationGrid(name());
  nodeMap[this] = n;  if (color != NULL)
  {
    n->color = color->duplicate(nodeMap);
  }
  else
  {
    n->color = NULL;
  }
  if (normal != NULL)
  {
    n->normal = normal->duplicate(nodeMap);
  }
  else
  {
    n->normal = NULL;
  }
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate(nodeMap);
  }
  else
  {
    n->texCoord = NULL;
  }
  n->height = height;
  n->ccw = ccw;
  n->colorPerVertex = colorPerVertex;
  n->creaseAngle = creaseAngle;
  n->normalPerVertex = normalPerVertex;
  n->solid = solid;
  n->xDimension = xDimension;
  n->xSpacing = xSpacing;
  n->zDimension = zDimension;
  n->zSpacing = zSpacing;
  return n;
}
bool
wrl::ElevationGrid::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool ccwDV_(true);
  static const SFBool colorPerVertexDV_(true);
  static const SFFloat creaseAngleDV_(0.0f);
  static const SFBool normalPerVertexDV_(true);
  static const SFBool solidDV_(true);
  static const SFInt32 xDimensionDV_(0);
  static const SFFloat xSpacingDV_(1.0f);
  static const SFInt32 zDimensionDV_(0);
  static const SFFloat zSpacingDV_(1.0f);
  switch (i)
  {
  case 0: return color == SFNode();
  case 1: return normal == SFNode();
  case 2: return texCoord == SFNode();
  case 3: return height == MFFloat();
  case 4: return ccw == ccwDV_;
  case 5: return colorPerVertex == colorPerVertexDV_;
  case 6: return creaseAngle == creaseAngleDV_;
  case 7: return normalPerVertex == normalPerVertexDV_;
  case 8: return solid == solidDV_;
  case 9: return xDimension == xDimensionDV_;
  case 10: return xSpacing == xSpacingDV_;
  case 11: return zDimension == zDimensionDV_;
  case 12: return zSpacing == zSpacingDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
