#include <xdkwrl/nodes/cylindersensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of CylinderSensor
//************************************************************
/*! \class wrl::CylinderSensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude cylindersensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  autoOffset = true;
  diskAngle = 0.262f;
  enabled = true;
  maxAngle = -1.0f;
  minAngle = 0.0f;
  offset = 0.0f;
  \endcode
  */
wrl::CylinderSensor::CylinderSensor(const char* name)
 : Node(name)
{
  autoOffset = true;
  diskAngle = 0.262f;
  enabled = true;
  maxAngle = -1.0f;
  minAngle = 0.0f;
  offset = 0.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::CylinderSensor::~CylinderSensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - autoOffset
 *  - diskAngle
 *  - enabled
 *  - maxAngle
 *  - minAngle
 *  - offset
 */
wrl::Node::FieldHandle
wrl::CylinderSensor::field(const std::string& n)
{
  if(n==std::string("autoOffset"))
  {
    return Node::field(n,sfBool,(void*) &autoOffset);
  }
  if(n==std::string("diskAngle"))
  {
    return Node::field(n,sfFloat,(void*) &diskAngle);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  if(n==std::string("maxAngle"))
  {
    return Node::field(n,sfFloat,(void*) &maxAngle);
  }
  if(n==std::string("minAngle"))
  {
    return Node::field(n,sfFloat,(void*) &minAngle);
  }
  if(n==std::string("offset"))
  {
    return Node::field(n,sfFloat,(void*) &offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : autoOffset
 *  - 1 : diskAngle
 *  - 2 : enabled
 *  - 3 : maxAngle
 *  - 4 : minAngle
 *  - 5 : offset
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::CylinderSensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("autoOffset",sfBool,&autoOffset);
  case 1: return Node::field("diskAngle",sfFloat,&diskAngle);
  case 2: return Node::field("enabled",sfBool,&enabled);
  case 3: return Node::field("maxAngle",sfFloat,&maxAngle);
  case 4: return Node::field("minAngle",sfFloat,&minAngle);
  case 5: return Node::field("offset",sfFloat,&offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_autoOffset
 *  - set_diskAngle
 *  - set_enabled
 *  - set_maxAngle
 *  - set_minAngle
 *  - set_offset
 */
wrl::Node::EventInHandle
wrl::CylinderSensor::eventIn(const std::string& n)
{
  if(n==std::string("set_autoOffset"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_autoOffset);
  }
  if(n==std::string("set_diskAngle"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_diskAngle);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  if(n==std::string("set_maxAngle"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_maxAngle);
  }
  if(n==std::string("set_minAngle"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_minAngle);
  }
  if(n==std::string("set_offset"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::CylinderSensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_autoOffset",sfBool,&set_autoOffset);
  case 1: return Node::eventIn("set_diskAngle",sfFloat,&set_diskAngle);
  case 2: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  case 3: return Node::eventIn("set_maxAngle",sfFloat,&set_maxAngle);
  case 4: return Node::eventIn("set_minAngle",sfFloat,&set_minAngle);
  case 5: return Node::eventIn("set_offset",sfFloat,&set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isActive
 *  - rotation_changed
 *  - trackPoint_changed
 *  - autoOffset_changed
 *  - diskAngle_changed
 *  - enabled_changed
 *  - maxAngle_changed
 *  - minAngle_changed
 *  - offset_changed
 */
wrl::Node::EventOutHandle
wrl::CylinderSensor::eventOut(const std::string& n)
{
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("rotation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &rotation_changed);
  }
  if(n==std::string("trackPoint_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &trackPoint_changed);
  }
  if(n==std::string("autoOffset_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &autoOffset_changed);
  }
  if(n==std::string("diskAngle_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &diskAngle_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  if(n==std::string("maxAngle_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &maxAngle_changed);
  }
  if(n==std::string("minAngle_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &minAngle_changed);
  }
  if(n==std::string("offset_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &offset_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isActive
 *  - 1 : rotation_changed
 *  - 2 : trackPoint_changed
 *  - 3 : autoOffset_changed
 *  - 4 : diskAngle_changed
 *  - 5 : enabled_changed
 *  - 6 : maxAngle_changed
 *  - 7 : minAngle_changed
 *  - 8 : offset_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::CylinderSensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isActive",sfBool,&isActive);
  case 1: return Node::eventOut("rotation_changed",sfRotation,&rotation_changed);
  case 2: return Node::eventOut("trackPoint_changed",sfVec3f,&trackPoint_changed);
  case 3: return Node::eventOut("autoOffset_changed",sfBool,&autoOffset_changed);
  case 4: return Node::eventOut("diskAngle_changed",sfFloat,&diskAngle_changed);
  case 5: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  case 6: return Node::eventOut("maxAngle_changed",sfFloat,&maxAngle_changed);
  case 7: return Node::eventOut("minAngle_changed",sfFloat,&minAngle_changed);
  case 8: return Node::eventOut("offset_changed",sfFloat,&offset_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::CylinderSensor::duplicate() const
{
  CylinderSensor* n = new CylinderSensor(name());
  n->autoOffset = autoOffset;
  n->diskAngle = diskAngle;
  n->enabled = enabled;
  n->maxAngle = maxAngle;
  n->minAngle = minAngle;
  n->offset = offset;
  return n;
}
wrl::Node* 
wrl::CylinderSensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  CylinderSensor* n = new CylinderSensor(name());
  nodeMap[this] = n;  n->autoOffset = autoOffset;
  n->diskAngle = diskAngle;
  n->enabled = enabled;
  n->maxAngle = maxAngle;
  n->minAngle = minAngle;
  n->offset = offset;
  return n;
}
bool
wrl::CylinderSensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool autoOffsetDV_(true);
  static const SFFloat diskAngleDV_(0.262f);
  static const SFBool enabledDV_(true);
  static const SFFloat maxAngleDV_(-1.0f);
  static const SFFloat minAngleDV_(0.0f);
  static const SFFloat offsetDV_(0.0f);
  switch (i)
  {
  case 0: return autoOffset == autoOffsetDV_;
  case 1: return diskAngle == diskAngleDV_;
  case 2: return enabled == enabledDV_;
  case 3: return maxAngle == maxAngleDV_;
  case 4: return minAngle == minAngleDV_;
  case 5: return offset == offsetDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
