#include <xdkwrl/nodes/cylinder.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Cylinder
//************************************************************
/*! \class wrl::Cylinder
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude cylinder.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  bottom = true;
  height = 2.0f;
  radius = 1.0f;
  side = true;
  top = true;
  \endcode
  */
wrl::Cylinder::Cylinder(const char* name)
 : Node(name)
{
  bottom = true;
  height = 2.0f;
  radius = 1.0f;
  side = true;
  top = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Cylinder::~Cylinder()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - bottom
 *  - height
 *  - radius
 *  - side
 *  - top
 */
wrl::Node::FieldHandle
wrl::Cylinder::field(const std::string& n)
{
  if(n==std::string("bottom"))
  {
    return Node::field(n,sfBool,(void*) &bottom);
  }
  if(n==std::string("height"))
  {
    return Node::field(n,sfFloat,(void*) &height);
  }
  if(n==std::string("radius"))
  {
    return Node::field(n,sfFloat,(void*) &radius);
  }
  if(n==std::string("side"))
  {
    return Node::field(n,sfBool,(void*) &side);
  }
  if(n==std::string("top"))
  {
    return Node::field(n,sfBool,(void*) &top);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : bottom
 *  - 1 : height
 *  - 2 : radius
 *  - 3 : side
 *  - 4 : top
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Cylinder::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("bottom",sfBool,&bottom);
  case 1: return Node::field("height",sfFloat,&height);
  case 2: return Node::field("radius",sfFloat,&radius);
  case 3: return Node::field("side",sfBool,&side);
  case 4: return Node::field("top",sfBool,&top);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::Cylinder::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Cylinder::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::Cylinder::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Cylinder::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::Cylinder::duplicate() const
{
  Cylinder* n = new Cylinder(name());
  n->bottom = bottom;
  n->height = height;
  n->radius = radius;
  n->side = side;
  n->top = top;
  return n;
}
wrl::Node* 
wrl::Cylinder::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Cylinder* n = new Cylinder(name());
  nodeMap[this] = n;  n->bottom = bottom;
  n->height = height;
  n->radius = radius;
  n->side = side;
  n->top = top;
  return n;
}
bool
wrl::Cylinder::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool bottomDV_(true);
  static const SFFloat heightDV_(2.0f);
  static const SFFloat radiusDV_(1.0f);
  static const SFBool sideDV_(true);
  static const SFBool topDV_(true);
  switch (i)
  {
  case 0: return bottom == bottomDV_;
  case 1: return height == heightDV_;
  case 2: return radius == radiusDV_;
  case 3: return side == sideDV_;
  case 4: return top == topDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
