#include <xdkwrl/nodes/coordinateinterpolator.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of CoordinateInterpolator
//************************************************************
/*! \class wrl::CoordinateInterpolator
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude coordinateinterpolator.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::CoordinateInterpolator::CoordinateInterpolator(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::CoordinateInterpolator::~CoordinateInterpolator()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - key
 *  - keyValue
 */
wrl::Node::FieldHandle
wrl::CoordinateInterpolator::field(const std::string& n)
{
  if(n==std::string("key"))
  {
    return Node::field(n,mfFloat,(void*) &key);
  }
  if(n==std::string("keyValue"))
  {
    return Node::field(n,mfVec3f,(void*) &keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : key
 *  - 1 : keyValue
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::CoordinateInterpolator::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("key",mfFloat,&key);
  case 1: return Node::field("keyValue",mfVec3f,&keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_fraction
 *  - set_key
 *  - set_keyValue
 */
wrl::Node::EventInHandle
wrl::CoordinateInterpolator::eventIn(const std::string& n)
{
  if(n==std::string("set_fraction"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fraction);
  }
  if(n==std::string("set_key"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_key);
  }
  if(n==std::string("set_keyValue"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_keyValue);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_fraction
 *  - 1 : set_key
 *  - 2 : set_keyValue

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::CoordinateInterpolator::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_fraction",sfFloat,&set_fraction);
  case 1: return Node::eventIn("set_key",mfFloat,&set_key);
  case 2: return Node::eventIn("set_keyValue",mfVec3f,&set_keyValue);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - value_changed
 *  - key_changed
 *  - keyValue_changed
 */
wrl::Node::EventOutHandle
wrl::CoordinateInterpolator::eventOut(const std::string& n)
{
  if(n==std::string("value_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &value_changed);
  }
  if(n==std::string("key_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &key_changed);
  }
  if(n==std::string("keyValue_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &keyValue_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : value_changed
 *  - 1 : key_changed
 *  - 2 : keyValue_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::CoordinateInterpolator::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("value_changed",mfVec3f,&value_changed);
  case 1: return Node::eventOut("key_changed",mfFloat,&key_changed);
  case 2: return Node::eventOut("keyValue_changed",mfVec3f,&keyValue_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::CoordinateInterpolator::duplicate() const
{
  CoordinateInterpolator* n = new CoordinateInterpolator(name());
  n->key = key;
  n->keyValue = keyValue;
  return n;
}
wrl::Node* 
wrl::CoordinateInterpolator::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  CoordinateInterpolator* n = new CoordinateInterpolator(name());
  nodeMap[this] = n;  n->key = key;
  n->keyValue = keyValue;
  return n;
}
bool
wrl::CoordinateInterpolator::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return key == MFFloat();
  case 1: return keyValue == MFVec3f();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
