#include <xdkwrl/nodes/coordinatedeformer.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of CoordinateDeformer
//************************************************************
/*! \class wrl::CoordinateDeformer
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude coordinatedeformer.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  uDimension = 0;
  uOrder = 2;
  vDimension = 0;
  vOrder = 2;
  wDimension = 0;
  wOrder = 2;
  \endcode
  */
wrl::CoordinateDeformer::CoordinateDeformer(const char* name)
 : Node(name)
{

  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  uDimension = 0;
  uOrder = 2;
  vDimension = 0;
  vOrder = 2;
  wDimension = 0;
  wOrder = 2;}
/*!
 * Virtual destructor, does nothing
 */
wrl::CoordinateDeformer::~CoordinateDeformer()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - children
 *  - controlPoint
 *  - inputCoord
 *  - inputTransform
 *  - outputCoord
 *  - weight
 *  - bboxCenter
 *  - bboxSize
 *  - uDimension
 *  - uKnot
 *  - uOrder
 *  - vDimension
 *  - vKnot
 *  - vOrder
 *  - wDimension
 *  - wKnot
 *  - wOrder
 */
wrl::Node::FieldHandle
wrl::CoordinateDeformer::field(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("controlPoint"))
  {
    return Node::field(n,mfVec3f,(void*) &controlPoint);
  }
  if(n==std::string("inputCoord"))
  {
    return Node::field(n,mfNode,(void*) &inputCoord);
  }
  if(n==std::string("inputTransform"))
  {
    return Node::field(n,mfNode,(void*) &inputTransform);
  }
  if(n==std::string("outputCoord"))
  {
    return Node::field(n,mfNode,(void*) &outputCoord);
  }
  if(n==std::string("weight"))
  {
    return Node::field(n,mfFloat,(void*) &weight);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  if(n==std::string("uDimension"))
  {
    return Node::field(n,sfInt32,(void*) &uDimension);
  }
  if(n==std::string("uKnot"))
  {
    return Node::field(n,mfFloat,(void*) &uKnot);
  }
  if(n==std::string("uOrder"))
  {
    return Node::field(n,sfInt32,(void*) &uOrder);
  }
  if(n==std::string("vDimension"))
  {
    return Node::field(n,sfInt32,(void*) &vDimension);
  }
  if(n==std::string("vKnot"))
  {
    return Node::field(n,mfFloat,(void*) &vKnot);
  }
  if(n==std::string("vOrder"))
  {
    return Node::field(n,sfInt32,(void*) &vOrder);
  }
  if(n==std::string("wDimension"))
  {
    return Node::field(n,sfInt32,(void*) &wDimension);
  }
  if(n==std::string("wKnot"))
  {
    return Node::field(n,mfFloat,(void*) &wKnot);
  }
  if(n==std::string("wOrder"))
  {
    return Node::field(n,sfInt32,(void*) &wOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 *  - 1 : controlPoint
 *  - 2 : inputCoord
 *  - 3 : inputTransform
 *  - 4 : outputCoord
 *  - 5 : weight
 *  - 6 : bboxCenter
 *  - 7 : bboxSize
 *  - 8 : uDimension
 *  - 9 : uKnot
 *  - 10 : uOrder
 *  - 11 : vDimension
 *  - 12 : vKnot
 *  - 13 : vOrder
 *  - 14 : wDimension
 *  - 15 : wKnot
 *  - 16 : wOrder
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::CoordinateDeformer::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("children",mfNode,&children);
  case 1: return Node::field("controlPoint",mfVec3f,&controlPoint);
  case 2: return Node::field("inputCoord",mfNode,&inputCoord);
  case 3: return Node::field("inputTransform",mfNode,&inputTransform);
  case 4: return Node::field("outputCoord",mfNode,&outputCoord);
  case 5: return Node::field("weight",mfFloat,&weight);
  case 6: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 7: return Node::field("bboxSize",sfVec3f,&bboxSize);
  case 8: return Node::field("uDimension",sfInt32,&uDimension);
  case 9: return Node::field("uKnot",mfFloat,&uKnot);
  case 10: return Node::field("uOrder",sfInt32,&uOrder);
  case 11: return Node::field("vDimension",sfInt32,&vDimension);
  case 12: return Node::field("vKnot",mfFloat,&vKnot);
  case 13: return Node::field("vOrder",sfInt32,&vOrder);
  case 14: return Node::field("wDimension",sfInt32,&wDimension);
  case 15: return Node::field("wKnot",mfFloat,&wKnot);
  case 16: return Node::field("wOrder",sfInt32,&wOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_children
 *  - set_controlPoint
 *  - set_inputCoord
 *  - set_inputTransform
 *  - set_outputCoord
 *  - set_weight
 */
wrl::Node::EventInHandle
wrl::CoordinateDeformer::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  if(n==std::string("set_controlPoint"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_controlPoint);
  }
  if(n==std::string("set_inputCoord"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_inputCoord);
  }
  if(n==std::string("set_inputTransform"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_inputTransform);
  }
  if(n==std::string("set_outputCoord"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_outputCoord);
  }
  if(n==std::string("set_weight"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_children
 *  - 3 : set_controlPoint
 *  - 4 : set_inputCoord
 *  - 5 : set_inputTransform
 *  - 6 : set_outputCoord
 *  - 7 : set_weight

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::CoordinateDeformer::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_children",mfNode,&set_children);
  case 3: return Node::eventIn("set_controlPoint",mfVec3f,&set_controlPoint);
  case 4: return Node::eventIn("set_inputCoord",mfNode,&set_inputCoord);
  case 5: return Node::eventIn("set_inputTransform",mfNode,&set_inputTransform);
  case 6: return Node::eventIn("set_outputCoord",mfNode,&set_outputCoord);
  case 7: return Node::eventIn("set_weight",mfFloat,&set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children_changed
 *  - controlPoint_changed
 *  - inputCoord_changed
 *  - inputTransform_changed
 *  - outputCoord_changed
 *  - weight_changed
 */
wrl::Node::EventOutHandle
wrl::CoordinateDeformer::eventOut(const std::string& n)
{
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  if(n==std::string("controlPoint_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &controlPoint_changed);
  }
  if(n==std::string("inputCoord_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &inputCoord_changed);
  }
  if(n==std::string("inputTransform_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &inputTransform_changed);
  }
  if(n==std::string("outputCoord_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &outputCoord_changed);
  }
  if(n==std::string("weight_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &weight_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children_changed
 *  - 1 : controlPoint_changed
 *  - 2 : inputCoord_changed
 *  - 3 : inputTransform_changed
 *  - 4 : outputCoord_changed
 *  - 5 : weight_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::CoordinateDeformer::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children_changed",mfNode,&children_changed);
  case 1: return Node::eventOut("controlPoint_changed",mfVec3f,&controlPoint_changed);
  case 2: return Node::eventOut("inputCoord_changed",mfNode,&inputCoord_changed);
  case 3: return Node::eventOut("inputTransform_changed",mfNode,&inputTransform_changed);
  case 4: return Node::eventOut("outputCoord_changed",mfNode,&outputCoord_changed);
  case 5: return Node::eventOut("weight_changed",mfFloat,&weight_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::CoordinateDeformer::duplicate() const
{
  CoordinateDeformer* n = new CoordinateDeformer(name());
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->controlPoint = controlPoint;
  for (MFNode::const_iterator iter = inputCoord.begin();
       iter != inputCoord.end();++iter)
  {
     n->inputCoord.push_back(SFNode((*iter)->duplicate()));
  }
  for (MFNode::const_iterator iter = inputTransform.begin();
       iter != inputTransform.end();++iter)
  {
     n->inputTransform.push_back(SFNode((*iter)->duplicate()));
  }
  for (MFNode::const_iterator iter = outputCoord.begin();
       iter != outputCoord.end();++iter)
  {
     n->outputCoord.push_back(SFNode((*iter)->duplicate()));
  }
  n->weight = weight;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  n->wDimension = wDimension;
  n->wKnot = wKnot;
  n->wOrder = wOrder;
  return n;
}
wrl::Node* 
wrl::CoordinateDeformer::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  CoordinateDeformer* n = new CoordinateDeformer(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->controlPoint = controlPoint;
  for (MFNode::const_iterator iter = inputCoord.begin();
       iter != inputCoord.end();++iter)
  {
     n->inputCoord.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  for (MFNode::const_iterator iter = inputTransform.begin();
       iter != inputTransform.end();++iter)
  {
     n->inputTransform.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  for (MFNode::const_iterator iter = outputCoord.begin();
       iter != outputCoord.end();++iter)
  {
     n->outputCoord.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->weight = weight;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  n->wDimension = wDimension;
  n->wKnot = wKnot;
  n->wOrder = wOrder;
  return n;
}
bool
wrl::CoordinateDeformer::isSetToDefaultValue(unsigned int i) const
{

  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  static const SFInt32 uDimensionDV_(0);
  static const SFInt32 uOrderDV_(2);
  static const SFInt32 vDimensionDV_(0);
  static const SFInt32 vOrderDV_(2);
  static const SFInt32 wDimensionDV_(0);
  static const SFInt32 wOrderDV_(2);
  switch (i)
  {
  case 0: return children == MFNode();
  case 1: return controlPoint == MFVec3f();
  case 2: return inputCoord == MFNode();
  case 3: return inputTransform == MFNode();
  case 4: return outputCoord == MFNode();
  case 5: return weight == MFFloat();
  case 6: return bboxCenter == bboxCenterDV_;
  case 7: return bboxSize == bboxSizeDV_;
  case 8: return uDimension == uDimensionDV_;
  case 9: return uKnot == MFFloat();
  case 10: return uOrder == uOrderDV_;
  case 11: return vDimension == vDimensionDV_;
  case 12: return vKnot == MFFloat();
  case 13: return vOrder == vOrderDV_;
  case 14: return wDimension == wDimensionDV_;
  case 15: return wKnot == MFFloat();
  case 16: return wOrder == wOrderDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
