#include <xdkwrl/nodes/coordinate.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Coordinate
//************************************************************
/*! \class wrl::Coordinate
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude coordinate.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Coordinate::Coordinate(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Coordinate::~Coordinate()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - point
 */
wrl::Node::FieldHandle
wrl::Coordinate::field(const std::string& n)
{
  if(n==std::string("point"))
  {
    return Node::field(n,mfVec3f,(void*) &point);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : point
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Coordinate::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("point",mfVec3f,&point);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_point
 */
wrl::Node::EventInHandle
wrl::Coordinate::eventIn(const std::string& n)
{
  if(n==std::string("set_point"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_point);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Coordinate::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_point",mfVec3f,&set_point);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - point_changed
 */
wrl::Node::EventOutHandle
wrl::Coordinate::eventOut(const std::string& n)
{
  if(n==std::string("point_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &point_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : point_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Coordinate::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("point_changed",mfVec3f,&point_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Coordinate::duplicate() const
{
  Coordinate* n = new Coordinate(name());
  n->point = point;
  return n;
}
wrl::Node* 
wrl::Coordinate::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Coordinate* n = new Coordinate(name());
  nodeMap[this] = n;  n->point = point;
  return n;
}
bool
wrl::Coordinate::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return point == MFVec3f();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
