#include <xdkwrl/nodes/cone.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Cone
//************************************************************
/*! \class wrl::Cone
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude cone.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  bottomRadius = 1.0f;
  height = 2.0f;
  side = true;
  bottom = true;
  \endcode
  */
wrl::Cone::Cone(const char* name)
 : Node(name)
{
  bottomRadius = 1.0f;
  height = 2.0f;
  side = true;
  bottom = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Cone::~Cone()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - bottomRadius
 *  - height
 *  - side
 *  - bottom
 */
wrl::Node::FieldHandle
wrl::Cone::field(const std::string& n)
{
  if(n==std::string("bottomRadius"))
  {
    return Node::field(n,sfFloat,(void*) &bottomRadius);
  }
  if(n==std::string("height"))
  {
    return Node::field(n,sfFloat,(void*) &height);
  }
  if(n==std::string("side"))
  {
    return Node::field(n,sfBool,(void*) &side);
  }
  if(n==std::string("bottom"))
  {
    return Node::field(n,sfBool,(void*) &bottom);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : bottomRadius
 *  - 1 : height
 *  - 2 : side
 *  - 3 : bottom
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Cone::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("bottomRadius",sfFloat,&bottomRadius);
  case 1: return Node::field("height",sfFloat,&height);
  case 2: return Node::field("side",sfBool,&side);
  case 3: return Node::field("bottom",sfBool,&bottom);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::Cone::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Cone::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::Cone::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Cone::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::Cone::duplicate() const
{
  Cone* n = new Cone(name());
  n->bottomRadius = bottomRadius;
  n->height = height;
  n->side = side;
  n->bottom = bottom;
  return n;
}
wrl::Node* 
wrl::Cone::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Cone* n = new Cone(name());
  nodeMap[this] = n;  n->bottomRadius = bottomRadius;
  n->height = height;
  n->side = side;
  n->bottom = bottom;
  return n;
}
bool
wrl::Cone::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat bottomRadiusDV_(1.0f);
  static const SFFloat heightDV_(2.0f);
  static const SFBool sideDV_(true);
  static const SFBool bottomDV_(true);
  switch (i)
  {
  case 0: return bottomRadius == bottomRadiusDV_;
  case 1: return height == heightDV_;
  case 2: return side == sideDV_;
  case 3: return bottom == bottomDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
