#include <xdkwrl/nodes/collision.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Collision
//************************************************************
/*! \class wrl::Collision
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude collision.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  collide = true;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::Collision::Collision(const char* name)
 : Node(name)
{

  collide = true;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Collision::~Collision()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - children
 *  - collide
 *  - bboxCenter
 *  - bboxSize
 *  - proxy
 */
wrl::Node::FieldHandle
wrl::Collision::field(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("collide"))
  {
    return Node::field(n,sfBool,(void*) &collide);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  if(n==std::string("proxy"))
  {
    return Node::field(n,sfNode,(void*) &proxy);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 *  - 1 : collide
 *  - 2 : bboxCenter
 *  - 3 : bboxSize
 *  - 4 : proxy
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Collision::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("children",mfNode,&children);
  case 1: return Node::field("collide",sfBool,&collide);
  case 2: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 3: return Node::field("bboxSize",sfVec3f,&bboxSize);
  case 4: return Node::field("proxy",sfNode,&proxy);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_children
 *  - set_collide
 */
wrl::Node::EventInHandle
wrl::Collision::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  if(n==std::string("set_collide"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_collide);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_children
 *  - 3 : set_collide

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Collision::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_children",mfNode,&set_children);
  case 3: return Node::eventIn("set_collide",sfBool,&set_collide);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - collideTime
 *  - children_changed
 *  - collide_changed
 */
wrl::Node::EventOutHandle
wrl::Collision::eventOut(const std::string& n)
{
  if(n==std::string("collideTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &collideTime);
  }
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  if(n==std::string("collide_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &collide_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : collideTime
 *  - 1 : children_changed
 *  - 2 : collide_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Collision::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("collideTime",sfTime,&collideTime);
  case 1: return Node::eventOut("children_changed",mfNode,&children_changed);
  case 2: return Node::eventOut("collide_changed",sfBool,&collide_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Collision::duplicate() const
{
  Collision* n = new Collision(name());
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->collide = collide;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  if (proxy != NULL)
  {
    n->proxy = proxy->duplicate();
  }
  else
  {
    n->proxy = NULL;
  }
  return n;
}
wrl::Node* 
wrl::Collision::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Collision* n = new Collision(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->collide = collide;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  if (proxy != NULL)
  {
    n->proxy = proxy->duplicate(nodeMap);
  }
  else
  {
    n->proxy = NULL;
  }
  return n;
}
bool
wrl::Collision::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool collideDV_(true);
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return children == MFNode();
  case 1: return collide == collideDV_;
  case 2: return bboxCenter == bboxCenterDV_;
  case 3: return bboxSize == bboxSizeDV_;
  case 4: return proxy == SFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
