#include <xdkwrl/nodes/box.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Box
//************************************************************
/*! \class wrl::Box
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude box.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  size.setXYZ(2.0f,2.0f,2.0f);
  \endcode
  */
wrl::Box::Box(const char* name)
 : Node(name)
{
  size.setXYZ(2.0f,2.0f,2.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Box::~Box()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - size
 */
wrl::Node::FieldHandle
wrl::Box::field(const std::string& n)
{
  if(n==std::string("size"))
  {
    return Node::field(n,sfVec3f,(void*) &size);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : size
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Box::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("size",sfVec3f,&size);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::Box::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Box::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::Box::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Box::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::Box::duplicate() const
{
  Box* n = new Box(name());
  n->size = size;
  return n;
}
wrl::Node* 
wrl::Box::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Box* n = new Box(name());
  nodeMap[this] = n;  n->size = size;
  return n;
}
bool
wrl::Box::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f sizeDV_(2.0f,2.0f,2.0f);
  switch (i)
  {
  case 0: return size == sizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
