#include <xdkwrl/nodes/background.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Background
//************************************************************
/*! \class wrl::Background
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude background.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

      skyColor.push_back(SFColor(0.0f,0.0f,0.0f));
  \endcode
  */
wrl::Background::Background(const char* name)
 : Node(name)
{

      skyColor.push_back(SFColor(0.0f,0.0f,0.0f));}
/*!
 * Virtual destructor, does nothing
 */
wrl::Background::~Background()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - groundAngle
 *  - groundColor
 *  - backUrl
 *  - bottomUrl
 *  - frontUrl
 *  - leftUrl
 *  - rightUrl
 *  - topUrl
 *  - skyAngle
 *  - skyColor
 */
wrl::Node::FieldHandle
wrl::Background::field(const std::string& n)
{
  if(n==std::string("groundAngle"))
  {
    return Node::field(n,mfFloat,(void*) &groundAngle);
  }
  if(n==std::string("groundColor"))
  {
    return Node::field(n,mfColor,(void*) &groundColor);
  }
  if(n==std::string("backUrl"))
  {
    return Node::field(n,mfString,(void*) &backUrl);
  }
  if(n==std::string("bottomUrl"))
  {
    return Node::field(n,mfString,(void*) &bottomUrl);
  }
  if(n==std::string("frontUrl"))
  {
    return Node::field(n,mfString,(void*) &frontUrl);
  }
  if(n==std::string("leftUrl"))
  {
    return Node::field(n,mfString,(void*) &leftUrl);
  }
  if(n==std::string("rightUrl"))
  {
    return Node::field(n,mfString,(void*) &rightUrl);
  }
  if(n==std::string("topUrl"))
  {
    return Node::field(n,mfString,(void*) &topUrl);
  }
  if(n==std::string("skyAngle"))
  {
    return Node::field(n,mfFloat,(void*) &skyAngle);
  }
  if(n==std::string("skyColor"))
  {
    return Node::field(n,mfColor,(void*) &skyColor);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : groundAngle
 *  - 1 : groundColor
 *  - 2 : backUrl
 *  - 3 : bottomUrl
 *  - 4 : frontUrl
 *  - 5 : leftUrl
 *  - 6 : rightUrl
 *  - 7 : topUrl
 *  - 8 : skyAngle
 *  - 9 : skyColor
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Background::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("groundAngle",mfFloat,&groundAngle);
  case 1: return Node::field("groundColor",mfColor,&groundColor);
  case 2: return Node::field("backUrl",mfString,&backUrl);
  case 3: return Node::field("bottomUrl",mfString,&bottomUrl);
  case 4: return Node::field("frontUrl",mfString,&frontUrl);
  case 5: return Node::field("leftUrl",mfString,&leftUrl);
  case 6: return Node::field("rightUrl",mfString,&rightUrl);
  case 7: return Node::field("topUrl",mfString,&topUrl);
  case 8: return Node::field("skyAngle",mfFloat,&skyAngle);
  case 9: return Node::field("skyColor",mfColor,&skyColor);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_bind
 *  - set_groundAngle
 *  - set_groundColor
 *  - set_backUrl
 *  - set_bottomUrl
 *  - set_frontUrl
 *  - set_leftUrl
 *  - set_rightUrl
 *  - set_topUrl
 *  - set_skyAngle
 *  - set_skyColor
 */
wrl::Node::EventInHandle
wrl::Background::eventIn(const std::string& n)
{
  if(n==std::string("set_bind"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_bind);
  }
  if(n==std::string("set_groundAngle"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_groundAngle);
  }
  if(n==std::string("set_groundColor"))
  {
    return Node::eventIn(n,mfColor,(void*) &set_groundColor);
  }
  if(n==std::string("set_backUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_backUrl);
  }
  if(n==std::string("set_bottomUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_bottomUrl);
  }
  if(n==std::string("set_frontUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_frontUrl);
  }
  if(n==std::string("set_leftUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_leftUrl);
  }
  if(n==std::string("set_rightUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_rightUrl);
  }
  if(n==std::string("set_topUrl"))
  {
    return Node::eventIn(n,mfString,(void*) &set_topUrl);
  }
  if(n==std::string("set_skyAngle"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_skyAngle);
  }
  if(n==std::string("set_skyColor"))
  {
    return Node::eventIn(n,mfColor,(void*) &set_skyColor);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_bind
 *  - 1 : set_groundAngle
 *  - 2 : set_groundColor
 *  - 3 : set_backUrl
 *  - 4 : set_bottomUrl
 *  - 5 : set_frontUrl
 *  - 6 : set_leftUrl
 *  - 7 : set_rightUrl
 *  - 8 : set_topUrl
 *  - 9 : set_skyAngle
 *  - 10 : set_skyColor

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Background::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_bind",sfBool,&set_bind);
  case 1: return Node::eventIn("set_groundAngle",mfFloat,&set_groundAngle);
  case 2: return Node::eventIn("set_groundColor",mfColor,&set_groundColor);
  case 3: return Node::eventIn("set_backUrl",mfString,&set_backUrl);
  case 4: return Node::eventIn("set_bottomUrl",mfString,&set_bottomUrl);
  case 5: return Node::eventIn("set_frontUrl",mfString,&set_frontUrl);
  case 6: return Node::eventIn("set_leftUrl",mfString,&set_leftUrl);
  case 7: return Node::eventIn("set_rightUrl",mfString,&set_rightUrl);
  case 8: return Node::eventIn("set_topUrl",mfString,&set_topUrl);
  case 9: return Node::eventIn("set_skyAngle",mfFloat,&set_skyAngle);
  case 10: return Node::eventIn("set_skyColor",mfColor,&set_skyColor);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isBound
 *  - groundAngle_changed
 *  - groundColor_changed
 *  - backUrl_changed
 *  - bottomUrl_changed
 *  - frontUrl_changed
 *  - leftUrl_changed
 *  - rightUrl_changed
 *  - topUrl_changed
 *  - skyAngle_changed
 *  - skyColor_changed
 */
wrl::Node::EventOutHandle
wrl::Background::eventOut(const std::string& n)
{
  if(n==std::string("isBound"))
  {
    return Node::eventOut(n,sfBool,(void*) &isBound);
  }
  if(n==std::string("groundAngle_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &groundAngle_changed);
  }
  if(n==std::string("groundColor_changed"))
  {
    return Node::eventOut(n,mfColor,(void*) &groundColor_changed);
  }
  if(n==std::string("backUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &backUrl_changed);
  }
  if(n==std::string("bottomUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &bottomUrl_changed);
  }
  if(n==std::string("frontUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &frontUrl_changed);
  }
  if(n==std::string("leftUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &leftUrl_changed);
  }
  if(n==std::string("rightUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &rightUrl_changed);
  }
  if(n==std::string("topUrl_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &topUrl_changed);
  }
  if(n==std::string("skyAngle_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &skyAngle_changed);
  }
  if(n==std::string("skyColor_changed"))
  {
    return Node::eventOut(n,mfColor,(void*) &skyColor_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isBound
 *  - 1 : groundAngle_changed
 *  - 2 : groundColor_changed
 *  - 3 : backUrl_changed
 *  - 4 : bottomUrl_changed
 *  - 5 : frontUrl_changed
 *  - 6 : leftUrl_changed
 *  - 7 : rightUrl_changed
 *  - 8 : topUrl_changed
 *  - 9 : skyAngle_changed
 *  - 10 : skyColor_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Background::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isBound",sfBool,&isBound);
  case 1: return Node::eventOut("groundAngle_changed",mfFloat,&groundAngle_changed);
  case 2: return Node::eventOut("groundColor_changed",mfColor,&groundColor_changed);
  case 3: return Node::eventOut("backUrl_changed",mfString,&backUrl_changed);
  case 4: return Node::eventOut("bottomUrl_changed",mfString,&bottomUrl_changed);
  case 5: return Node::eventOut("frontUrl_changed",mfString,&frontUrl_changed);
  case 6: return Node::eventOut("leftUrl_changed",mfString,&leftUrl_changed);
  case 7: return Node::eventOut("rightUrl_changed",mfString,&rightUrl_changed);
  case 8: return Node::eventOut("topUrl_changed",mfString,&topUrl_changed);
  case 9: return Node::eventOut("skyAngle_changed",mfFloat,&skyAngle_changed);
  case 10: return Node::eventOut("skyColor_changed",mfColor,&skyColor_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Background::duplicate() const
{
  Background* n = new Background(name());
  n->groundAngle = groundAngle;
  n->groundColor = groundColor;
  n->backUrl = backUrl;
  n->bottomUrl = bottomUrl;
  n->frontUrl = frontUrl;
  n->leftUrl = leftUrl;
  n->rightUrl = rightUrl;
  n->topUrl = topUrl;
  n->skyAngle = skyAngle;
  n->skyColor = skyColor;
  return n;
}
wrl::Node* 
wrl::Background::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Background* n = new Background(name());
  nodeMap[this] = n;  n->groundAngle = groundAngle;
  n->groundColor = groundColor;
  n->backUrl = backUrl;
  n->bottomUrl = bottomUrl;
  n->frontUrl = frontUrl;
  n->leftUrl = leftUrl;
  n->rightUrl = rightUrl;
  n->topUrl = topUrl;
  n->skyAngle = skyAngle;
  n->skyColor = skyColor;
  return n;
}
bool
wrl::Background::isSetToDefaultValue(unsigned int i) const
{

  static MFColor skyColorDV_;
  if (skyColorDV_.empty())
  {
    skyColorDV_.push_back(SFColor(0.0f,0.0f,0.0f));
  }
  switch (i)
  {
  case 0: return groundAngle == MFFloat();
  case 1: return groundColor == MFColor();
  case 2: return backUrl == MFString();
  case 3: return bottomUrl == MFString();
  case 4: return frontUrl == MFString();
  case 5: return leftUrl == MFString();
  case 6: return rightUrl == MFString();
  case 7: return topUrl == MFString();
  case 8: return skyAngle == MFFloat();
  case 9: return skyColor == skyColorDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
