#include <xdkwrl/nodes/appearance.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Appearance
//************************************************************
/*! \class wrl::Appearance
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude appearance.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Appearance::Appearance(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Appearance::~Appearance()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - material
 *  - texture
 *  - textureTransform
 */
wrl::Node::FieldHandle
wrl::Appearance::field(const std::string& n)
{
  if(n==std::string("material"))
  {
    return Node::field(n,sfNode,(void*) &material);
  }
  if(n==std::string("texture"))
  {
    return Node::field(n,sfNode,(void*) &texture);
  }
  if(n==std::string("textureTransform"))
  {
    return Node::field(n,sfNode,(void*) &textureTransform);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : material
 *  - 1 : texture
 *  - 2 : textureTransform
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Appearance::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("material",sfNode,&material);
  case 1: return Node::field("texture",sfNode,&texture);
  case 2: return Node::field("textureTransform",sfNode,&textureTransform);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_material
 *  - set_texture
 *  - set_textureTransform
 */
wrl::Node::EventInHandle
wrl::Appearance::eventIn(const std::string& n)
{
  if(n==std::string("set_material"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_material);
  }
  if(n==std::string("set_texture"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_texture);
  }
  if(n==std::string("set_textureTransform"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_textureTransform);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Appearance::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_material",sfNode,&set_material);
  case 1: return Node::eventIn("set_texture",sfNode,&set_texture);
  case 2: return Node::eventIn("set_textureTransform",sfNode,&set_textureTransform);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - material_changed
 *  - texture_changed
 *  - textureTransform_changed
 */
wrl::Node::EventOutHandle
wrl::Appearance::eventOut(const std::string& n)
{
  if(n==std::string("material_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &material_changed);
  }
  if(n==std::string("texture_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &texture_changed);
  }
  if(n==std::string("textureTransform_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &textureTransform_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : material_changed
 *  - 1 : texture_changed
 *  - 2 : textureTransform_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Appearance::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("material_changed",sfNode,&material_changed);
  case 1: return Node::eventOut("texture_changed",sfNode,&texture_changed);
  case 2: return Node::eventOut("textureTransform_changed",sfNode,&textureTransform_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Appearance::duplicate() const
{
  Appearance* n = new Appearance(name());
  if (material != NULL)
  {
    n->material = material->duplicate();
  }
  else
  {
    n->material = NULL;
  }
  if (texture != NULL)
  {
    n->texture = texture->duplicate();
  }
  else
  {
    n->texture = NULL;
  }
  if (textureTransform != NULL)
  {
    n->textureTransform = textureTransform->duplicate();
  }
  else
  {
    n->textureTransform = NULL;
  }
  return n;
}
wrl::Node* 
wrl::Appearance::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Appearance* n = new Appearance(name());
  nodeMap[this] = n;  if (material != NULL)
  {
    n->material = material->duplicate(nodeMap);
  }
  else
  {
    n->material = NULL;
  }
  if (texture != NULL)
  {
    n->texture = texture->duplicate(nodeMap);
  }
  else
  {
    n->texture = NULL;
  }
  if (textureTransform != NULL)
  {
    n->textureTransform = textureTransform->duplicate(nodeMap);
  }
  else
  {
    n->textureTransform = NULL;
  }
  return n;
}
bool
wrl::Appearance::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return material == SFNode();
  case 1: return texture == SFNode();
  case 2: return textureTransform == SFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
