#include <xdkwrl/nodes/anchor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Anchor
//************************************************************
/*! \class wrl::Anchor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude anchor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  description = string("");
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::Anchor::Anchor(const char* name)
 : Node(name)
{

  description = string("");
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Anchor::~Anchor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - children
 *  - description
 *  - parameter
 *  - url
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::Anchor::field(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("description"))
  {
    return Node::field(n,sfString,(void*) &description);
  }
  if(n==std::string("parameter"))
  {
    return Node::field(n,mfString,(void*) &parameter);
  }
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 *  - 1 : description
 *  - 2 : parameter
 *  - 3 : url
 *  - 4 : bboxCenter
 *  - 5 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Anchor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("children",mfNode,&children);
  case 1: return Node::field("description",sfString,&description);
  case 2: return Node::field("parameter",mfString,&parameter);
  case 3: return Node::field("url",mfString,&url);
  case 4: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 5: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_children
 *  - set_description
 *  - set_parameter
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::Anchor::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  if(n==std::string("set_description"))
  {
    return Node::eventIn(n,sfString,(void*) &set_description);
  }
  if(n==std::string("set_parameter"))
  {
    return Node::eventIn(n,mfString,(void*) &set_parameter);
  }
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_children
 *  - 3 : set_description
 *  - 4 : set_parameter
 *  - 5 : set_url

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Anchor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_children",mfNode,&set_children);
  case 3: return Node::eventIn("set_description",sfString,&set_description);
  case 4: return Node::eventIn("set_parameter",mfString,&set_parameter);
  case 5: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children_changed
 *  - description_changed
 *  - parameter_changed
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::Anchor::eventOut(const std::string& n)
{
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  if(n==std::string("description_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &description_changed);
  }
  if(n==std::string("parameter_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &parameter_changed);
  }
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children_changed
 *  - 1 : description_changed
 *  - 2 : parameter_changed
 *  - 3 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Anchor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children_changed",mfNode,&children_changed);
  case 1: return Node::eventOut("description_changed",sfString,&description_changed);
  case 2: return Node::eventOut("parameter_changed",mfString,&parameter_changed);
  case 3: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Anchor::duplicate() const
{
  Anchor* n = new Anchor(name());
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->description = description;
  n->parameter = parameter;
  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::Anchor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Anchor* n = new Anchor(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->description = description;
  n->parameter = parameter;
  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::Anchor::isSetToDefaultValue(unsigned int i) const
{

  static const SFString descriptionDV_("");
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return children == MFNode();
  case 1: return description == descriptionDV_;
  case 2: return parameter == MFString();
  case 3: return url == MFString();
  case 4: return bboxCenter == bboxCenterDV_;
  case 5: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
