#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfimage.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/mftime.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>

#include <stdexcept>

using namespace std;
using namespace wrl;

template<class T>
static
const string&
ithKey(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return fter->first;
}
template<class T>
static
T*
ithValue(map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}
template<class T>
static
const T*
ithValue(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}

//************************************************************
// Implementation of Node
//************************************************************
/*! \class wrl::Node
 * \ingroup basetypes
 *
 * This is the base class of all nodes in a VRML scene. This is an abstract
 * so you cannot create an instance of it directly. This base class offers
 * mechanisms to access the fields of a given node. When you have a Node
 * pointer, if you know it's real type you can downcast it to access the
 * fields directly.  If you do not know this real type, you may still want
 * to access the fields. Or you may also want to get the name of a field as
 * string of character. All these functionnalities are offered thru the
 * FieldHandle class.
 *
 */
Node::Node(const char* name)
  : name_(name)
{
}
void
Node::setField(const FieldHandle& f,const SFBool& v)
{
  *f.sfBoolField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFColor& v)
{
  *f.sfColorField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFFloat& v)
{
  *f.sfFloatField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFImage& v)
{
  *f.sfImageField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFInt32& v)
{
  *f.sfInt32Field_ = v;
}
void
Node::setField(const FieldHandle& f,const SFNode& v)
{
  *f.sfNodeField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFRotation& v)
{
  *f.sfRotationField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFString& v)
{
  *f.sfStringField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFTime& v)
{
  *f.sfTimeField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFVec2f& v)
{
  *f.sfVec2fField_ = v;
}
void
Node::setField(const FieldHandle& f,const SFVec3f& v)
{
  *f.sfVec3fField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFColor& v)
{
  *f.mfColorField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFFloat& v)
{
  *f.mfFloatField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFInt32& v)
{
  *f.mfInt32Field_ = v;
}
void
Node::setField(const FieldHandle& f,const MFNode& v)
{
  *f.mfNodeField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFRotation& v)
{
  *f.mfRotationField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFString& v)
{
  *f.mfStringField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFTime& v)
{
  *f.mfTimeField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFVec2f& v)
{
  *f.mfVec2fField_ = v;
}
void
Node::setField(const FieldHandle& f,const MFVec3f& v)
{
  *f.mfVec3fField_ = v;
}
/*!
 * Set the name of the node. If a node has a name, it will generate a DEF
 * directive when printed, .
 */
void
Node::setName(const char* n)
{
  name_ = string(n);
}
void
Node::swapField(const FieldHandle& f,MFColor& v)
{
  f.mfColorField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFFloat& v)
{
  f.mfFloatField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFInt32& v)
{
  f.mfInt32Field_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFNode& v)
{
  f.mfNodeField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFRotation& v)
{
  f.mfRotationField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFString& v)
{
  f.mfStringField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFTime& v)
{
  f.mfTimeField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFVec2f& v)
{
  f.mfVec2fField_->swap(v);
}
void
Node::swapField(const FieldHandle& f,MFVec3f& v)
{
  f.mfVec3fField_->swap(v);
}
Node::FieldHandle
Node::field(const string& n,const FieldTypeId t,void* f)
{
  return FieldHandle(this,n,t,f);
}
Node::EventInHandle
Node::eventIn(const string& n,const FieldTypeId t,void* f)
{
  return EventInHandle(this,n,t,f);
}
Node::EventOutHandle
Node::eventOut(const string& n,const FieldTypeId t,void* f)
{
  return EventOutHandle(this,n,t,f);
}
/*! \fn wrl::Node::FieldHandle wrl::Node::field(const std::string& n)
 *
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such node.
 */
/*! \fn wrl::Node::FieldHandle wrl::Node::field(unsigned int i)
 *
 * Return a handle on the \p ith field of the node or a "unknown" typed
 * handle if there is no such node. See nbFields() to find the number of
 * fields.
 */
/*! \fn unsigned int wrl::Node::nbFields() const
 *
 * Return the number of fields (exposed or not) of the node type.  Each
 * field has a unique name and an unique number associated, which allows to
 * retrieve the field value either by its name or a number (for sequential
 * traversal of all fields for example). Each node specifies in its
 * documentation the relation of names and numbers.
 */
/*! \fn wrl::Node* wrl::Node::duplicate() const    
 * Returns a deep copy of this node, that is a fully independant node with
 * all children (if any) also copied. This is mainly useful for
 * instanciating protos.
 */ 
//************************************************************
// Implementation of Node::FieldHandle
//************************************************************
/*! \class wrl::Node::FieldHandle
 * \ingroup basetypes
 *
 */
bool
Node::FieldHandle::operator==(const Node::FieldHandle& h) const
{
  return fieldTypeId_ == h.fieldTypeId_ &&
    sfBoolField_     == h.sfBoolField_ &&
    sfColorField_    == h.sfColorField_ &&
    sfFloatField_    == h.sfFloatField_ &&
    sfImageField_    == h.sfImageField_ &&
    sfInt32Field_    == h.sfInt32Field_ &&
    sfNodeField_     == h.sfNodeField_ &&
    sfRotationField_ == h.sfRotationField_ &&
    sfStringField_   == h.sfStringField_ &&
    sfTimeField_     == h.sfTimeField_ &&
    sfVec2fField_    == h.sfVec2fField_ &&
    sfVec3fField_    == h.sfVec3fField_ &&
    mfColorField_    == h.mfColorField_ &&
    mfFloatField_    == h.mfFloatField_ &&
    mfInt32Field_    == h.mfInt32Field_ &&
    mfNodeField_     == h.mfNodeField_ &&
    mfRotationField_ == h.mfRotationField_ &&
    mfStringField_   == h.mfStringField_ &&
    mfTimeField_     == h.mfTimeField_ &&
    mfVec2fField_    == h.mfVec2fField_ &&
    mfVec3fField_    == h.mfVec3fField_;
}
bool
Node::FieldHandle::operator!=(const Node::FieldHandle& h) const
{
  return fieldTypeId_ != h.fieldTypeId_ ||
    sfBoolField_     != h.sfBoolField_ ||
    sfColorField_    != h.sfColorField_ ||
    sfFloatField_    != h.sfFloatField_ ||
    sfImageField_    != h.sfImageField_ ||
    sfInt32Field_    != h.sfInt32Field_ ||
    sfNodeField_     != h.sfNodeField_ ||
    sfRotationField_ != h.sfRotationField_ ||
    sfStringField_   != h.sfStringField_ ||
    sfTimeField_     != h.sfTimeField_ ||
    sfVec2fField_    != h.sfVec2fField_ ||
    sfVec3fField_    != h.sfVec3fField_ ||
    mfColorField_    != h.mfColorField_ ||
    mfFloatField_    != h.mfFloatField_ ||
    mfInt32Field_    != h.mfInt32Field_ ||
    mfNodeField_     != h.mfNodeField_ ||
    mfRotationField_ != h.mfRotationField_ ||
    mfStringField_   != h.mfStringField_ ||
    mfTimeField_     != h.mfTimeField_ ||
    mfVec2fField_    != h.mfVec2fField_ ||
    mfVec3fField_    != h.mfVec3fField_;
}
const char*
Node::FieldHandle::fieldTypeName() const
{
  switch (fieldTypeId_)
  {
  case sfBool:     return "SFBool";
  case sfColor:    return "SFColor";
  case sfFloat:    return "SFFloat";
  case sfImage:    return "SFImage";
  case sfInt32:    return "SFInt32";
  case sfNode:     return "SFNode";
  case sfRotation: return "SFRotation";
  case sfString:   return "SFString";
  case sfTime:     return "SFTime";
  case sfVec2f:    return "SFVec2f";
  case sfVec3f:    return "SFVec3f";
  case mfColor:    return "MFColor";
  case mfFloat:    return "MFFloat";
  case mfInt32:    return "MFInt32";
  case mfNode:     return "MFNode";
  case mfRotation: return "MFRotation";
  case mfString:   return "MFString";
  case mfTime:     return "MFTime";
  case mfVec2f:    return "MFVec2f";
  case mfVec3f:    return "MFVec3f";
  case unknown:    return "unknown";
  }
  return "unknown";  // cannot happen
}
Node::FieldHandle::FieldHandle(Node* node,const string& n,
			       const FieldTypeId t,void* f)
  : node_(node),
    fieldName_(n),
    fieldTypeId_(t),
    sfBoolField_(NULL),
    sfColorField_(NULL),
    sfFloatField_(NULL),
    sfImageField_(NULL),
    sfInt32Field_(NULL),
    sfNodeField_(NULL),
    sfRotationField_(NULL),
    sfStringField_(NULL),
    sfTimeField_(NULL),
    sfVec2fField_(NULL),
    sfVec3fField_(NULL),
    mfColorField_(NULL),
    mfFloatField_(NULL),
    mfInt32Field_(NULL),
    mfNodeField_(NULL),
    mfRotationField_(NULL),
    mfStringField_(NULL),
    mfTimeField_(NULL),
    mfVec2fField_(NULL),
    mfVec3fField_(NULL)
{  
  switch (fieldTypeId_)
  {
  case sfBool:
    {
      pair<SFBool,bool>* p = reinterpret_cast<pair<SFBool,bool>*>(f); 
      sfBoolField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfColor:
    {
      pair<SFColor,bool>* p = reinterpret_cast<pair<SFColor,bool>*>(f); 
      sfColorField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfFloat:
    {
      pair<SFFloat,bool>* p = reinterpret_cast<pair<SFFloat,bool>*>(f); 
      sfFloatField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfImage:
    {
      pair<SFImage,bool>* p = reinterpret_cast<pair<SFImage,bool>*>(f); 
      sfImageField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfInt32:
    {
      pair<SFInt32,bool>* p = reinterpret_cast<pair<SFInt32,bool>*>(f); 
      sfInt32Field_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfNode:
    {
      pair<SFNode,bool>* p = reinterpret_cast<pair<SFNode,bool>*>(f); 
      sfNodeField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfRotation:
    {
      pair<SFRotation,bool>* p = reinterpret_cast<pair<SFRotation,bool>*>(f); 
      sfRotationField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfString:
    {
      pair<SFString,bool>* p = reinterpret_cast<pair<SFString,bool>*>(f); 
      sfStringField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfTime:
    {
      pair<SFTime,bool>* p = reinterpret_cast<pair<SFTime,bool>*>(f); 
      sfTimeField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfVec2f:
    {
      pair<SFVec2f,bool>* p = reinterpret_cast<pair<SFVec2f,bool>*>(f); 
      sfVec2fField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case sfVec3f:
    {
      pair<SFVec3f,bool>* p = reinterpret_cast<pair<SFVec3f,bool>*>(f); 
      sfVec3fField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfColor:
    {
      pair<MFColor,bool>* p = reinterpret_cast<pair<MFColor,bool>*>(f); 
      mfColorField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfFloat:
    {
      pair<MFFloat,bool>* p = reinterpret_cast<pair<MFFloat,bool>*>(f); 
      mfFloatField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfInt32:
    {
      pair<MFInt32,bool>* p = reinterpret_cast<pair<MFInt32,bool>*>(f); 
      mfInt32Field_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfNode:
    {
      pair<MFNode,bool>* p = reinterpret_cast<pair<MFNode,bool>*>(f); 
      mfNodeField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfRotation:
    {
      pair<MFRotation,bool>* p = reinterpret_cast<pair<MFRotation,bool>*>(f); 
      mfRotationField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfString:
    {
      pair<MFString,bool>* p = reinterpret_cast<pair<MFString,bool>*>(f); 
      mfStringField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfTime:
    {
      pair<MFTime,bool>* p = reinterpret_cast<pair<MFTime,bool>*>(f); 
      mfTimeField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfVec2f:
    {
      pair<MFVec2f,bool>* p = reinterpret_cast<pair<MFVec2f,bool>*>(f); 
      mfVec2fField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case mfVec3f:
    {
      pair<MFVec3f,bool>* p = reinterpret_cast<pair<MFVec3f,bool>*>(f); 
      mfVec3fField_ = &(p->first);
      isExposed_ = p->second;
      break;
    }
  case unknown:    break;
  }  
}
void
Node::FieldHandle::copy(const Node::FieldHandle& to,
			const Node::FieldHandle& from)
{
  switch (to.fieldTypeId_)
  {
  case sfBool:     *to.sfBoolField_     = *from.sfBoolField_;break;
  case sfColor:    *to.sfColorField_    = *from.sfColorField_;break;
  case sfFloat:    *to.sfFloatField_    = *from.sfFloatField_;break;
  case sfImage:    *to.sfImageField_    = *from.sfImageField_;break;
  case sfInt32:    *to.sfInt32Field_    = *from.sfInt32Field_;break;
  case sfNode:     *to.sfNodeField_     = *from.sfNodeField_;break;
  case sfRotation: *to.sfRotationField_ = *from.sfRotationField_;break;
  case sfString:   *to.sfStringField_   = *from.sfStringField_;break;
  case sfTime:     *to.sfTimeField_     = *from.sfTimeField_;break;
  case sfVec2f:    *to.sfVec2fField_    = *from.sfVec2fField_;break;
  case sfVec3f:    *to.sfVec3fField_    = *from.sfVec3fField_;break;
  case mfColor:    *to.mfColorField_    = *from.mfColorField_;break;
  case mfFloat:    *to.mfFloatField_    = *from.mfFloatField_;break;
  case mfInt32:    *to.mfInt32Field_    = *from.mfInt32Field_;break;
  case mfNode:     *to.mfNodeField_     = *from.mfNodeField_;break;
  case mfRotation: *to.mfRotationField_ = *from.mfRotationField_;break;
  case mfString:   *to.mfStringField_   = *from.mfStringField_;break;
  case mfTime:     *to.mfTimeField_     = *from.mfTimeField_;break;
  case mfVec2f:    *to.mfVec2fField_    = *from.mfVec2fField_;break;
  case mfVec3f:    *to.mfVec3fField_    = *from.mfVec3fField_;break;
  case unknown:    break;
  }  
}
//************************************************************
// Implementation of Node::EventInHandle
//************************************************************
/*! \class wrl::Node::EventInHandle
 * \ingroup basetypes
 *
 */
bool
Node::EventInHandle::operator==(const Node::EventInHandle& h) const
{
  return fieldTypeId_ == h.fieldTypeId_ &&
    sfBoolField_     == h.sfBoolField_ &&
    sfColorField_    == h.sfColorField_ &&
    sfFloatField_    == h.sfFloatField_ &&
    sfImageField_    == h.sfImageField_ &&
    sfInt32Field_    == h.sfInt32Field_ &&
    sfNodeField_     == h.sfNodeField_ &&
    sfRotationField_ == h.sfRotationField_ &&
    sfStringField_   == h.sfStringField_ &&
    sfTimeField_     == h.sfTimeField_ &&
    sfVec2fField_    == h.sfVec2fField_ &&
    sfVec3fField_    == h.sfVec3fField_ &&
    mfColorField_    == h.mfColorField_ &&
    mfFloatField_    == h.mfFloatField_ &&
    mfInt32Field_    == h.mfInt32Field_ &&
    mfNodeField_     == h.mfNodeField_ &&
    mfRotationField_ == h.mfRotationField_ &&
    mfStringField_   == h.mfStringField_ &&
    mfTimeField_     == h.mfTimeField_ &&
    mfVec2fField_    == h.mfVec2fField_ &&
    mfVec3fField_    == h.mfVec3fField_;
}
bool
Node::EventInHandle::operator!=(const Node::EventInHandle& h) const
{
  return fieldTypeId_ != h.fieldTypeId_ ||
    sfBoolField_     != h.sfBoolField_ ||
    sfColorField_    != h.sfColorField_ ||
    sfFloatField_    != h.sfFloatField_ ||
    sfImageField_    != h.sfImageField_ ||
    sfInt32Field_    != h.sfInt32Field_ ||
    sfNodeField_     != h.sfNodeField_ ||
    sfRotationField_ != h.sfRotationField_ ||
    sfStringField_   != h.sfStringField_ ||
    sfTimeField_     != h.sfTimeField_ ||
    sfVec2fField_    != h.sfVec2fField_ ||
    sfVec3fField_    != h.sfVec3fField_ ||
    mfColorField_    != h.mfColorField_ ||
    mfFloatField_    != h.mfFloatField_ ||
    mfInt32Field_    != h.mfInt32Field_ ||
    mfNodeField_     != h.mfNodeField_ ||
    mfRotationField_ != h.mfRotationField_ ||
    mfStringField_   != h.mfStringField_ ||
    mfTimeField_     != h.mfTimeField_ ||
    mfVec2fField_    != h.mfVec2fField_ ||
    mfVec3fField_    != h.mfVec3fField_;
}
const char*
Node::EventInHandle::fieldTypeName() const
{
  switch (fieldTypeId_)
  {
  case sfBool:     return "SFBool";
  case sfColor:    return "SFColor";
  case sfFloat:    return "SFFloat";
  case sfImage:    return "SFImage";
  case sfInt32:    return "SFInt32";
  case sfNode:     return "SFNode";
  case sfRotation: return "SFRotation";
  case sfString:   return "SFString";
  case sfTime:     return "SFTime";
  case sfVec2f:    return "SFVec2f";
  case sfVec3f:    return "SFVec3f";
  case mfColor:    return "MFColor";
  case mfFloat:    return "MFFloat";
  case mfInt32:    return "MFInt32";
  case mfNode:     return "MFNode";
  case mfRotation: return "MFRotation";
  case mfString:   return "MFString";
  case mfTime:     return "MFTime";
  case mfVec2f:    return "MFVec2f";
  case mfVec3f:    return "MFVec3f";
  case unknown:    return "unknown";
  }
  return "unknown";  // cannot happen
}
Node::EventInHandle::EventInHandle(Node* node,const string& n,
				   const FieldTypeId t,void* f)
  : node_(node),
    fieldName_(n),
    fieldTypeId_(t),
    sfBoolField_(NULL),
    sfColorField_(NULL),
    sfFloatField_(NULL),
    sfImageField_(NULL),
    sfInt32Field_(NULL),
    sfNodeField_(NULL),
    sfRotationField_(NULL),
    sfStringField_(NULL),
    sfTimeField_(NULL),
    sfVec2fField_(NULL),
    sfVec3fField_(NULL),
    mfColorField_(NULL),
    mfFloatField_(NULL),
    mfInt32Field_(NULL),
    mfNodeField_(NULL),
    mfRotationField_(NULL),
    mfStringField_(NULL),
    mfTimeField_(NULL),
    mfVec2fField_(NULL),
    mfVec3fField_(NULL)
{  
  switch (fieldTypeId_)
  {
  case sfBool:     sfBoolField_     = reinterpret_cast<EventIn<SFBool>*>(f);break;    
  case sfColor:    sfColorField_    = reinterpret_cast<EventIn<SFColor>*>(f); break;
  case sfFloat:    sfFloatField_    = reinterpret_cast<EventIn<SFFloat>*>(f); break;
  case sfImage:    sfImageField_    = reinterpret_cast<EventIn<SFImage>*>(f); break;
  case sfInt32:    sfInt32Field_    = reinterpret_cast<EventIn<SFInt32>*>(f); break;
  case sfNode:     sfNodeField_     = reinterpret_cast<EventIn<SFNode>*>(f); break;
  case sfRotation: sfRotationField_ = reinterpret_cast<EventIn<SFRotation>*>(f); break;
  case sfString:   sfStringField_   = reinterpret_cast<EventIn<SFString>*>(f); break;
  case sfTime:     sfTimeField_     = reinterpret_cast<EventIn<SFTime>*>(f); break;
  case sfVec2f:    sfVec2fField_    = reinterpret_cast<EventIn<SFVec2f>*>(f); break;
  case sfVec3f:    sfVec3fField_    = reinterpret_cast<EventIn<SFVec3f>*>(f); break;
  case mfColor:    mfColorField_    = reinterpret_cast<EventIn<MFColor>*>(f); break;
  case mfFloat:    mfFloatField_    = reinterpret_cast<EventIn<MFFloat>*>(f); break;
  case mfInt32:    mfInt32Field_    = reinterpret_cast<EventIn<MFInt32>*>(f); break;
  case mfNode:     mfNodeField_     = reinterpret_cast<EventIn<MFNode>*>(f); break;
  case mfRotation: mfRotationField_ = reinterpret_cast<EventIn<MFRotation>*>(f); break;
  case mfString:   mfStringField_   = reinterpret_cast<EventIn<MFString>*>(f); break;
  case mfTime:     mfTimeField_     = reinterpret_cast<EventIn<MFTime>*>(f); break;
  case mfVec2f:    mfVec2fField_    = reinterpret_cast<EventIn<MFVec2f>*>(f); break;
  case mfVec3f:    mfVec3fField_    = reinterpret_cast<EventIn<MFVec3f>*>(f); break;
  case unknown:    break;
  }  
}
// TODO: check copy and duplicate for EventOut
//************************************************************
// Implementation of Node::EventOutHandle
//************************************************************
/*! \class wrl::Node::EventOutHandle
 * \ingroup basetypes
 *
 */
bool
Node::EventOutHandle::operator==(const Node::EventOutHandle& h) const
{
  return fieldTypeId_ == h.fieldTypeId_ &&
    sfBoolField_     == h.sfBoolField_ &&
    sfColorField_    == h.sfColorField_ &&
    sfFloatField_    == h.sfFloatField_ &&
    sfImageField_    == h.sfImageField_ &&
    sfInt32Field_    == h.sfInt32Field_ &&
    sfNodeField_     == h.sfNodeField_ &&
    sfRotationField_ == h.sfRotationField_ &&
    sfStringField_   == h.sfStringField_ &&
    sfTimeField_     == h.sfTimeField_ &&
    sfVec2fField_    == h.sfVec2fField_ &&
    sfVec3fField_    == h.sfVec3fField_ &&
    mfColorField_    == h.mfColorField_ &&
    mfFloatField_    == h.mfFloatField_ &&
    mfInt32Field_    == h.mfInt32Field_ &&
    mfNodeField_     == h.mfNodeField_ &&
    mfRotationField_ == h.mfRotationField_ &&
    mfStringField_   == h.mfStringField_ &&
    mfTimeField_     == h.mfTimeField_ &&
    mfVec2fField_    == h.mfVec2fField_ &&
    mfVec3fField_    == h.mfVec3fField_;
}
bool
Node::EventOutHandle::operator!=(const Node::EventOutHandle& h) const
{
  return fieldTypeId_ != h.fieldTypeId_ ||
    sfBoolField_     != h.sfBoolField_ ||
    sfColorField_    != h.sfColorField_ ||
    sfFloatField_    != h.sfFloatField_ ||
    sfImageField_    != h.sfImageField_ ||
    sfInt32Field_    != h.sfInt32Field_ ||
    sfNodeField_     != h.sfNodeField_ ||
    sfRotationField_ != h.sfRotationField_ ||
    sfStringField_   != h.sfStringField_ ||
    sfTimeField_     != h.sfTimeField_ ||
    sfVec2fField_    != h.sfVec2fField_ ||
    sfVec3fField_    != h.sfVec3fField_ ||
    mfColorField_    != h.mfColorField_ ||
    mfFloatField_    != h.mfFloatField_ ||
    mfInt32Field_    != h.mfInt32Field_ ||
    mfNodeField_     != h.mfNodeField_ ||
    mfRotationField_ != h.mfRotationField_ ||
    mfStringField_   != h.mfStringField_ ||
    mfTimeField_     != h.mfTimeField_ ||
    mfVec2fField_    != h.mfVec2fField_ ||
    mfVec3fField_    != h.mfVec3fField_;
}
const char*
Node::EventOutHandle::fieldTypeName() const
{
  switch (fieldTypeId_)
  {
  case sfBool:     return "SFBool";
  case sfColor:    return "SFColor";
  case sfFloat:    return "SFFloat";
  case sfImage:    return "SFImage";
  case sfInt32:    return "SFInt32";
  case sfNode:     return "SFNode";
  case sfRotation: return "SFRotation";
  case sfString:   return "SFString";
  case sfTime:     return "SFTime";
  case sfVec2f:    return "SFVec2f";
  case sfVec3f:    return "SFVec3f";
  case mfColor:    return "MFColor";
  case mfFloat:    return "MFFloat";
  case mfInt32:    return "MFInt32";
  case mfNode:     return "MFNode";
  case mfRotation: return "MFRotation";
  case mfString:   return "MFString";
  case mfTime:     return "MFTime";
  case mfVec2f:    return "MFVec2f";
  case mfVec3f:    return "MFVec3f";
  case unknown:    return "unknown";
  }
  return "unknown";  // cannot happen
}
Node::EventOutHandle::EventOutHandle(Node* node,const string& n,
				   const FieldTypeId t,void* f)
  : node_(node),
    fieldName_(n),
    fieldTypeId_(t),
    sfBoolField_(NULL),
    sfColorField_(NULL),
    sfFloatField_(NULL),
    sfImageField_(NULL),
    sfInt32Field_(NULL),
    sfNodeField_(NULL),
    sfRotationField_(NULL),
    sfStringField_(NULL),
    sfTimeField_(NULL),
    sfVec2fField_(NULL),
    sfVec3fField_(NULL),
    mfColorField_(NULL),
    mfFloatField_(NULL),
    mfInt32Field_(NULL),
    mfNodeField_(NULL),
    mfRotationField_(NULL),
    mfStringField_(NULL),
    mfTimeField_(NULL),
    mfVec2fField_(NULL),
    mfVec3fField_(NULL)
{  
  switch (fieldTypeId_)
  {
  case sfBool:     sfBoolField_     = reinterpret_cast<EventOut<SFBool>*>(f);break;    
  case sfColor:    sfColorField_    = reinterpret_cast<EventOut<SFColor>*>(f); break;
  case sfFloat:    sfFloatField_    = reinterpret_cast<EventOut<SFFloat>*>(f); break;
  case sfImage:    sfImageField_    = reinterpret_cast<EventOut<SFImage>*>(f); break;
  case sfInt32:    sfInt32Field_    = reinterpret_cast<EventOut<SFInt32>*>(f); break;
  case sfNode:     sfNodeField_     = reinterpret_cast<EventOut<SFNode>*>(f); break;
  case sfRotation: sfRotationField_ = reinterpret_cast<EventOut<SFRotation>*>(f); break;
  case sfString:   sfStringField_   = reinterpret_cast<EventOut<SFString>*>(f); break;
  case sfTime:     sfTimeField_     = reinterpret_cast<EventOut<SFTime>*>(f); break;
  case sfVec2f:    sfVec2fField_    = reinterpret_cast<EventOut<SFVec2f>*>(f); break;
  case sfVec3f:    sfVec3fField_    = reinterpret_cast<EventOut<SFVec3f>*>(f); break;
  case mfColor:    mfColorField_    = reinterpret_cast<EventOut<MFColor>*>(f); break;
  case mfFloat:    mfFloatField_    = reinterpret_cast<EventOut<MFFloat>*>(f); break;
  case mfInt32:    mfInt32Field_    = reinterpret_cast<EventOut<MFInt32>*>(f); break;
  case mfNode:     mfNodeField_     = reinterpret_cast<EventOut<MFNode>*>(f); break;
  case mfRotation: mfRotationField_ = reinterpret_cast<EventOut<MFRotation>*>(f); break;
  case mfString:   mfStringField_   = reinterpret_cast<EventOut<MFString>*>(f); break;
  case mfTime:     mfTimeField_     = reinterpret_cast<EventOut<MFTime>*>(f); break;
  case mfVec2f:    mfVec2fField_    = reinterpret_cast<EventOut<MFVec2f>*>(f); break;
  case mfVec3f:    mfVec3fField_    = reinterpret_cast<EventOut<MFVec3f>*>(f); break;
  case unknown:    break;
  }  
}
// TODO: check copy and duplicate for EventOut
//************************************************************
// Implementation of DeclaredNode
//************************************************************
/*! \class wrl::DeclaredNode
 * \ingroup basetypes
 *
 */
DeclaredNode::DeclaredNode(const char* name)
  : Node(name)
{
}
Node::EventInHandle
DeclaredNode::declareEventIn(const FieldTypeId t,const std::string& n)
{
  void* v=NULL;
  switch (t)
  {
  case sfBool:     v = &(sfBoolInMap_[n]     = EventIn<SFBool>());break;
  case sfColor:    v = &(sfColorInMap_[n]    = EventIn<SFColor>());break;
  case sfFloat:    v = &(sfFloatInMap_[n]    = EventIn<SFFloat>());break;
  case sfImage:    v = &(sfImageInMap_[n]    = EventIn<SFImage>());break;
  case sfInt32:    v = &(sfInt32InMap_[n]    = EventIn<SFInt32>());break;
  case sfNode:     v = &(sfNodeInMap_[n]     = EventIn<SFNode>());break;
  case sfRotation: v = &(sfRotationInMap_[n] = EventIn<SFRotation>());break;
  case sfString:   v = &(sfStringInMap_[n]   = EventIn<SFString>());break;
  case sfTime:     v = &(sfTimeInMap_[n]     = EventIn<SFTime>());break;
  case sfVec2f:    v = &(sfVec2fInMap_[n]    = EventIn<SFVec2f>());break;
  case sfVec3f:    v = &(sfVec3fInMap_[n]    = EventIn<SFVec3f>());break;
  case mfColor:    v = &(mfColorInMap_[n]    = EventIn<MFColor>());break;
  case mfFloat:    v = &(mfFloatInMap_[n]    = EventIn<MFFloat>());break;
  case mfInt32:    v = &(mfInt32InMap_[n]    = EventIn<MFInt32>());break;
  case mfNode:     v = &(mfNodeInMap_[n]     = EventIn<MFNode>());break;
  case mfRotation: v = &(mfRotationInMap_[n] = EventIn<MFRotation>());break;
  case mfString:   v = &(mfStringInMap_[n]   = EventIn<MFString>());break;
  case mfTime:     v = &(mfTimeInMap_[n]     = EventIn<MFTime>());break;
  case mfVec2f:    v = &(mfVec2fInMap_[n]    = EventIn<MFVec2f>());break;
  case mfVec3f:    v = &(mfVec3fInMap_[n]    = EventIn<MFVec3f>());break;
  case unknown:
    throw invalid_argument("unknown");
    break;
  }
  return Node::eventIn(n,t,v);
}
Node::EventOutHandle
DeclaredNode::declareEventOut(const FieldTypeId t,const std::string& n)
{
  void* v=NULL;
  switch (t)
  {
  case sfBool:     v = &(sfBoolOutMap_[n]     = EventOut<SFBool>());break;
  case sfColor:    v = &(sfColorOutMap_[n]    = EventOut<SFColor>());break;
  case sfFloat:    v = &(sfFloatOutMap_[n]    = EventOut<SFFloat>());break;
  case sfImage:    v = &(sfImageOutMap_[n]    = EventOut<SFImage>());break;
  case sfInt32:    v = &(sfInt32OutMap_[n]    = EventOut<SFInt32>());break;
  case sfNode:     v = &(sfNodeOutMap_[n]     = EventOut<SFNode>());break;
  case sfRotation: v = &(sfRotationOutMap_[n] = EventOut<SFRotation>());break;
  case sfString:   v = &(sfStringOutMap_[n]   = EventOut<SFString>());break;
  case sfTime:     v = &(sfTimeOutMap_[n]     = EventOut<SFTime>());break;
  case sfVec2f:    v = &(sfVec2fOutMap_[n]    = EventOut<SFVec2f>());break;
  case sfVec3f:    v = &(sfVec3fOutMap_[n]    = EventOut<SFVec3f>());break;
  case mfColor:    v = &(mfColorOutMap_[n]    = EventOut<MFColor>());break;
  case mfFloat:    v = &(mfFloatOutMap_[n]    = EventOut<MFFloat>());break;
  case mfInt32:    v = &(mfInt32OutMap_[n]    = EventOut<MFInt32>());break;
  case mfNode:     v = &(mfNodeOutMap_[n]     = EventOut<MFNode>());break;
  case mfRotation: v = &(mfRotationOutMap_[n] = EventOut<MFRotation>());break;
  case mfString:   v = &(mfStringOutMap_[n]   = EventOut<MFString>());break;
  case mfTime:     v = &(mfTimeOutMap_[n]     = EventOut<MFTime>());break;
  case mfVec2f:    v = &(mfVec2fOutMap_[n]    = EventOut<MFVec2f>());break;
  case mfVec3f:    v = &(mfVec3fOutMap_[n]    = EventOut<MFVec3f>());break;
  case unknown:
    throw invalid_argument("unknown");
    break;
  }
  return Node::eventOut(n,t,v);
}
Node::FieldHandle
DeclaredNode::declareField(const FieldTypeId t,const std::string& n)
{
  void* v=NULL;
  switch (t)
  {
  case sfBool:     v = &(sfBoolMap_[n]     = make_pair(SFBool(),false));break;
  case sfColor:    v = &(sfColorMap_[n]    = make_pair(SFColor(),false));break;
  case sfFloat:    v = &(sfFloatMap_[n]    = make_pair(SFFloat(),false));break;
  case sfImage:    v = &(sfImageMap_[n]    = make_pair(SFImage(),false));break;
  case sfInt32:    v = &(sfInt32Map_[n]    = make_pair(SFInt32(),false));break;
  case sfNode:     v = &(sfNodeMap_[n]     = make_pair(SFNode(),false));break;
  case sfRotation: v = &(sfRotationMap_[n] = make_pair(SFRotation(),false));break;
  case sfString:   v = &(sfStringMap_[n]   = make_pair(SFString(),false));break;
  case sfTime:     v = &(sfTimeMap_[n]     = make_pair(SFTime(),false));break;
  case sfVec2f:    v = &(sfVec2fMap_[n]    = make_pair(SFVec2f(),false));break;
  case sfVec3f:    v = &(sfVec3fMap_[n]    = make_pair(SFVec3f(),false));break;
  case mfColor:    v = &(mfColorMap_[n]    = make_pair(MFColor(),false));break;
  case mfFloat:    v = &(mfFloatMap_[n]    = make_pair(MFFloat(),false));break;
  case mfInt32:    v = &(mfInt32Map_[n]    = make_pair(MFInt32(),false));break;
  case mfNode:     v = &(mfNodeMap_[n]     = make_pair(MFNode(),false));break;
  case mfRotation: v = &(mfRotationMap_[n] = make_pair(MFRotation(),false));break;
  case mfString:   v = &(mfStringMap_[n]   = make_pair(MFString(),false));break;
  case mfTime:     v = &(mfTimeMap_[n]     = make_pair(MFTime(),false));break;
  case mfVec2f:    v = &(mfVec2fMap_[n]    = make_pair(MFVec2f(),false));break;
  case mfVec3f:    v = &(mfVec3fMap_[n]    = make_pair(MFVec3f(),false));break;
  case unknown:
    throw invalid_argument("unknown");
    break;
  }
  return Node::field(n,t,v);
}
Node::FieldHandle
DeclaredNode::declareExposedField(const FieldTypeId t,const std::string& n)
{
  void* v=NULL;
  switch (t)
  {
  case sfBool:     v = &(sfBoolMap_[n]     = make_pair(SFBool(),true));break;
  case sfColor:    v = &(sfColorMap_[n]    = make_pair(SFColor(),true));break;
  case sfFloat:    v = &(sfFloatMap_[n]    = make_pair(SFFloat(),true));break;
  case sfImage:    v = &(sfImageMap_[n]    = make_pair(SFImage(),true));break;
  case sfInt32:    v = &(sfInt32Map_[n]    = make_pair(SFInt32(),true));break;
  case sfNode:     v = &(sfNodeMap_[n]     = make_pair(SFNode(),true));break;
  case sfRotation: v = &(sfRotationMap_[n] = make_pair(SFRotation(),true));break;
  case sfString:   v = &(sfStringMap_[n]   = make_pair(SFString(),true));break;
  case sfTime:     v = &(sfTimeMap_[n]     = make_pair(SFTime(),true));break;
  case sfVec2f:    v = &(sfVec2fMap_[n]    = make_pair(SFVec2f(),true));break;
  case sfVec3f:    v = &(sfVec3fMap_[n]    = make_pair(SFVec3f(),true));break;
  case mfColor:    v = &(mfColorMap_[n]    = make_pair(MFColor(),true));break;
  case mfFloat:    v = &(mfFloatMap_[n]    = make_pair(MFFloat(),true));break;
  case mfInt32:    v = &(mfInt32Map_[n]    = make_pair(MFInt32(),true));break;
  case mfNode:     v = &(mfNodeMap_[n]     = make_pair(MFNode(),true));break;
  case mfRotation: v = &(mfRotationMap_[n] = make_pair(MFRotation(),true));break;
  case mfString:   v = &(mfStringMap_[n]   = make_pair(MFString(),true));break;
  case mfTime:     v = &(mfTimeMap_[n]     = make_pair(MFTime(),true));break;
  case mfVec2f:    v = &(mfVec2fMap_[n]    = make_pair(MFVec2f(),true));break;
  case mfVec3f:    v = &(mfVec3fMap_[n]    = make_pair(MFVec3f(),true));break;
  case unknown:
    throw invalid_argument("unknown");
    break;
  }
  return Node::field(n,t,v);
}
unsigned int
DeclaredNode::nbFields() const
{
  return
    sfBoolMap_.size()+
    sfColorMap_.size()+
    sfFloatMap_.size()+
    sfImageMap_.size()+
    sfInt32Map_.size()+
    sfNodeMap_.size()+
    sfRotationMap_.size()+
    sfStringMap_.size()+
    sfTimeMap_.size()+
    sfVec2fMap_.size()+
    sfVec3fMap_.size()+
    mfColorMap_.size()+
    mfFloatMap_.size()+
    mfInt32Map_.size()+
    mfNodeMap_.size()+
    mfRotationMap_.size()+
    mfStringMap_.size()+
    mfTimeMap_.size()+
    mfVec2fMap_.size()+
    mfVec3fMap_.size();
}
Node::FieldHandle
DeclaredNode::field(const string& n)
{
  {
    map<string,pair<SFBool,bool> >::iterator i = sfBoolMap_.find(n);
    if (i != sfBoolMap_.end())
    {
      return Node::field(n,sfBool,&(i->second));
    }
  }
  {
    map<string,pair<SFColor,bool> >::iterator i = sfColorMap_.find(n);
    if (i != sfColorMap_.end())
    {
      return Node::field(n,sfColor,&(i->second));
    }
  }
  {
    map<string,pair<SFFloat,bool> >::iterator i = sfFloatMap_.find(n);
    if (i != sfFloatMap_.end())
    {
      return Node::field(n,sfFloat,&(i->second));
    }
  }
  {
    map<string,pair<SFImage,bool> >::iterator i = sfImageMap_.find(n);
    if (i != sfImageMap_.end())
    {
      return Node::field(n,sfImage,&(i->second));
    }
  }
  {
    map<string,pair<SFInt32,bool> >::iterator i = sfInt32Map_.find(n);
    if (i != sfInt32Map_.end())
    {
      return Node::field(n,sfInt32,&(i->second));
    }
  }
  {
    map<string,pair<SFNode,bool> >::iterator i = sfNodeMap_.find(n);
    if (i != sfNodeMap_.end())
    {
      return Node::field(n,sfNode,&(i->second));
    }
  }
  {
    map<string,pair<SFRotation,bool> >::iterator i = sfRotationMap_.find(n);
    if (i != sfRotationMap_.end())
    {
      return Node::field(n,sfRotation,&(i->second));
    }
  }
  {
    map<string,pair<SFString,bool> >::iterator i = sfStringMap_.find(n);
    if (i != sfStringMap_.end())
    {
      return Node::field(n,sfString,&(i->second));
    }
  }
  {
    map<string,pair<SFTime,bool> >::iterator i = sfTimeMap_.find(n);
    if (i != sfTimeMap_.end())
    {
      return Node::field(n,sfTime,&(i->second));
    }
  }
  {
    map<string,pair<SFVec2f,bool> >::iterator i = sfVec2fMap_.find(n);
    if (i != sfVec2fMap_.end())
    {
      return Node::field(n,sfVec2f,&(i->second));
    }
  }
  {
    map<string,pair<SFVec3f,bool> >::iterator i = sfVec3fMap_.find(n);
    if (i != sfVec3fMap_.end())
    {
      return Node::field(n,sfVec3f,&(i->second));
    }
  }
  {
    map<string,pair<MFColor,bool> >::iterator i = mfColorMap_.find(n);
    if (i != mfColorMap_.end())
    {
      return Node::field(n,mfColor,&(i->second));
    }
  }
  {
    map<string,pair<MFFloat,bool> >::iterator i = mfFloatMap_.find(n);
    if (i != mfFloatMap_.end())
    {
      return Node::field(n,mfFloat,&(i->second));
    }
  }
  {
    map<string,pair<MFInt32,bool> >::iterator i = mfInt32Map_.find(n);
    if (i != mfInt32Map_.end())
    {
      return Node::field(n,mfInt32,&(i->second));
    }
  }
  {
    map<string,pair<MFNode,bool> >::iterator i = mfNodeMap_.find(n);
    if (i != mfNodeMap_.end())
    {
      return Node::field(n,mfNode,&(i->second));
    }
  }
  {
    map<string,pair<MFRotation,bool> >::iterator i = mfRotationMap_.find(n);
    if (i != mfRotationMap_.end())
    {
      return Node::field(n,mfRotation,&(i->second));
    }
  }
  {
    map<string,pair<MFString,bool> >::iterator i = mfStringMap_.find(n);
    if (i != mfStringMap_.end())
    {
      return Node::field(n,mfString,&(i->second));
    }
  }
  {
    map<string,pair<MFTime,bool> >::iterator i = mfTimeMap_.find(n);
    if (i != mfTimeMap_.end())
    {
      return Node::field(n,mfTime,&(i->second));
    }
  }
  {
    map<string,pair<MFVec2f,bool> >::iterator i = mfVec2fMap_.find(n);
    if (i != mfVec2fMap_.end())
    {
      return Node::field(n,mfVec2f,&(i->second));
    }
  }
  {
    map<string,pair<MFVec3f,bool> >::iterator i = mfVec3fMap_.find(n);
    if (i != mfVec3fMap_.end())
    {
      return Node::field(n,mfVec3f,&(i->second));
    }
  }
  return Node::field(n,unknown,NULL);
}
Node::FieldHandle
DeclaredNode::field(unsigned int n)
{
  unsigned int i=n;
  if (i<sfBoolMap_.size())
  {
    return Node::field(ithKey(sfBoolMap_,i),sfBool,
		       ithValue(sfBoolMap_,i));
  }
  i -= sfBoolMap_.size();
  if (i<sfColorMap_.size())
  {
    return Node::field(ithKey(sfColorMap_,i),sfColor,
		       ithValue(sfColorMap_,i));
  }
  i -= sfColorMap_.size();
  if (i<sfFloatMap_.size())
  {
    return Node::field(ithKey(sfFloatMap_,i),sfFloat,
		       ithValue(sfFloatMap_,i));
  }
  i -= sfFloatMap_.size();
  if (i<sfImageMap_.size())
  {
    return Node::field(ithKey(sfImageMap_,i),sfImage,
		       ithValue(sfImageMap_,i));
  }
  i -= sfImageMap_.size();
  if (i<sfInt32Map_.size())
  {
    return Node::field(ithKey(sfInt32Map_,i),sfInt32,
		       ithValue(sfInt32Map_,i));
  }
  i -= sfInt32Map_.size();
  if (i<sfNodeMap_.size())
  {
    return Node::field(ithKey(sfNodeMap_,i),sfNode,
		       ithValue(sfNodeMap_,i));
  }
  i -= sfNodeMap_.size();
  if (i<sfRotationMap_.size())
  {
    return Node::field(ithKey(sfRotationMap_,i),sfRotation,
		       ithValue(sfRotationMap_,i));
  }
  i -= sfRotationMap_.size();
  if (i<sfStringMap_.size())
  {
    return Node::field(ithKey(sfStringMap_,i),sfString,
		       ithValue(sfStringMap_,i));
  }
  i -= sfStringMap_.size();
  if (i<sfTimeMap_.size())
  {
    return Node::field(ithKey(sfTimeMap_,i),sfTime,
		       ithValue(sfTimeMap_,i));
  }
  i -= sfTimeMap_.size();
  if (i<sfVec2fMap_.size())
  {
    return Node::field(ithKey(sfVec2fMap_,i),sfVec2f,
		       ithValue(sfVec2fMap_,i));
  }
  i -= sfVec2fMap_.size();
  if (i<sfVec3fMap_.size())
  {
    return Node::field(ithKey(sfVec3fMap_,i),sfVec3f,
		       ithValue(sfVec3fMap_,i));
  }
  i -= sfVec3fMap_.size();
  if (i<mfColorMap_.size())
  {
    return Node::field(ithKey(mfColorMap_,i),mfColor,
		       ithValue(mfColorMap_,i));
  }
  i -= mfColorMap_.size();
  if (i<mfFloatMap_.size())
  {
    return Node::field(ithKey(mfFloatMap_,i),mfFloat,
		       ithValue(mfFloatMap_,i));
  }
  i -= mfFloatMap_.size();
  if (i<mfInt32Map_.size())
  {
    return Node::field(ithKey(mfInt32Map_,i),mfInt32,
		       ithValue(mfInt32Map_,i));
  }
  i -= mfInt32Map_.size();
  if (i<mfNodeMap_.size())
  {
    return Node::field(ithKey(mfNodeMap_,i),mfNode,
		       ithValue(mfNodeMap_,i));
  }
  i -= mfNodeMap_.size();
  if (i<mfRotationMap_.size())
  {
    return Node::field(ithKey(mfRotationMap_,i),mfRotation,
		       ithValue(mfRotationMap_,i));
  }
  i -= mfRotationMap_.size();
  if (i<mfStringMap_.size())
  {
    return Node::field(ithKey(mfStringMap_,i),mfString,
		       ithValue(mfStringMap_,i));
  }
  i -= mfStringMap_.size();
  if (i<mfTimeMap_.size())
  {
    return Node::field(ithKey(mfTimeMap_,i),mfTime,
		       ithValue(mfTimeMap_,i));
  }
  i -= mfTimeMap_.size();
  if (i<mfVec2fMap_.size())
  {
    return Node::field(ithKey(mfVec2fMap_,i),mfVec2f,
		       ithValue(mfVec2fMap_,i));
  }
  i -= mfVec2fMap_.size();
  if (i<mfVec3fMap_.size())
  {
    return Node::field(ithKey(mfVec3fMap_,i),mfVec3f,
		       ithValue(mfVec3fMap_,i));
  }
  i -= mfVec3fMap_.size();
  return FieldHandle();
}
bool
DeclaredNode::isDeclaredField(const string& n) const
{
  {
    map<string,pair<SFBool,bool> >::const_iterator i = sfBoolMap_.find(n);
    if (i != sfBoolMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFColor,bool> >::const_iterator i = sfColorMap_.find(n);
    if (i != sfColorMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFFloat,bool> >::const_iterator i = sfFloatMap_.find(n);
    if (i != sfFloatMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFImage,bool> >::const_iterator i = sfImageMap_.find(n);
    if (i != sfImageMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFInt32,bool> >::const_iterator i = sfInt32Map_.find(n);
    if (i != sfInt32Map_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFNode,bool> >::const_iterator i = sfNodeMap_.find(n);
    if (i != sfNodeMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFRotation,bool> >::const_iterator i = sfRotationMap_.find(n);
    if (i != sfRotationMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFString,bool> >::const_iterator i = sfStringMap_.find(n);
    if (i != sfStringMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFTime,bool> >::const_iterator i = sfTimeMap_.find(n);
    if (i != sfTimeMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFVec2f,bool> >::const_iterator i = sfVec2fMap_.find(n);
    if (i != sfVec2fMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<SFVec3f,bool> >::const_iterator i = sfVec3fMap_.find(n);
    if (i != sfVec3fMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFColor,bool> >::const_iterator i = mfColorMap_.find(n);
    if (i != mfColorMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFFloat,bool> >::const_iterator i = mfFloatMap_.find(n);
    if (i != mfFloatMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFInt32,bool> >::const_iterator i = mfInt32Map_.find(n);
    if (i != mfInt32Map_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFNode,bool> >::const_iterator i = mfNodeMap_.find(n);
    if (i != mfNodeMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFRotation,bool> >::const_iterator i = mfRotationMap_.find(n);
    if (i != mfRotationMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFString,bool> >::const_iterator i = mfStringMap_.find(n);
    if (i != mfStringMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFTime,bool> >::const_iterator i = mfTimeMap_.find(n);
    if (i != mfTimeMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFVec2f,bool> >::const_iterator i = mfVec2fMap_.find(n);
    if (i != mfVec2fMap_.end())
    {
      return true;
    }
  }
  {
    map<string,pair<MFVec3f,bool> >::const_iterator i = mfVec3fMap_.find(n);
    if (i != mfVec3fMap_.end())
    {
      return true;
    }
  }
  return false;
}
bool
DeclaredNode::isDeclaredField(unsigned int n) const
{
  unsigned int i=n;
  if (i<sfBoolMap_.size())
  {
    return true;
  }
  i -= sfBoolMap_.size();
  if (i<sfColorMap_.size())
  {
    return true;
  }
  i -= sfColorMap_.size();
  if (i<sfFloatMap_.size())
  {
    return true;
  }
  i -= sfFloatMap_.size();
  if (i<sfImageMap_.size())
  {
    return true;
  }
  i -= sfImageMap_.size();
  if (i<sfInt32Map_.size())
  {
    return true;
  }
  i -= sfInt32Map_.size();
  if (i<sfNodeMap_.size())
  {
    return true;
  }
  i -= sfNodeMap_.size();
  if (i<sfRotationMap_.size())
  {
    return true;
  }
  i -= sfRotationMap_.size();
  if (i<sfStringMap_.size())
  {
    return true;
  }
  i -= sfStringMap_.size();
  if (i<sfTimeMap_.size())
  {
    return true;
  }
  i -= sfTimeMap_.size();
  if (i<sfVec2fMap_.size())
  {
    return true;
  }
  i -= sfVec2fMap_.size();
  if (i<sfVec3fMap_.size())
  {
    return true;
  }
  i -= sfVec3fMap_.size();
  if (i<mfColorMap_.size())
  {
    return true;
  }
  i -= mfColorMap_.size();
  if (i<mfFloatMap_.size())
  {
    return true;
  }
  i -= mfFloatMap_.size();
  if (i<mfInt32Map_.size())
  {
    return true;
  }
  i -= mfInt32Map_.size();
  if (i<mfNodeMap_.size())
  {
    return true;
  }
  i -= mfNodeMap_.size();
  if (i<mfRotationMap_.size())
  {
    return true;
  }
  i -= mfRotationMap_.size();
  if (i<mfStringMap_.size())
  {
    return true;
  }
  i -= mfStringMap_.size();
  if (i<mfTimeMap_.size())
  {
    return true;
  }
  i -= mfTimeMap_.size();
  if (i<mfVec2fMap_.size())
  {
    return true;
  }
  i -= mfVec2fMap_.size();
  if (i<mfVec3fMap_.size())
  {
    return true;
  }
  i -= mfVec3fMap_.size();
  return false;
}
unsigned int
DeclaredNode::nbEventsIn() const
{
  return
    sfBoolInMap_.size()+
    sfColorInMap_.size()+
    sfFloatInMap_.size()+
    sfImageInMap_.size()+
    sfInt32InMap_.size()+
    sfNodeInMap_.size()+
    sfRotationInMap_.size()+
    sfStringInMap_.size()+
    sfTimeInMap_.size()+
    sfVec2fInMap_.size()+
    sfVec3fInMap_.size()+
    mfColorInMap_.size()+
    mfFloatInMap_.size()+
    mfInt32InMap_.size()+
    mfNodeInMap_.size()+
    mfRotationInMap_.size()+
    mfStringInMap_.size()+
    mfTimeInMap_.size()+
    mfVec2fInMap_.size()+
    mfVec3fInMap_.size();
}
Node::EventInHandle
DeclaredNode::eventIn(const string& n)
{
  {
    map<string,EventIn<SFBool> >::iterator i = sfBoolInMap_.find(n);
    if (i != sfBoolInMap_.end())
    {
      return Node::eventIn(n,sfBool,&(*i));
    }
  }
  {
    map<string,EventIn<SFColor> >::iterator i = sfColorInMap_.find(n);
    if (i != sfColorInMap_.end())
    {
      return Node::eventIn(n,sfColor,&(*i));
    }
  }
  {
    map<string,EventIn<SFFloat> >::iterator i = sfFloatInMap_.find(n);
    if (i != sfFloatInMap_.end())
    {
      return Node::eventIn(n,sfFloat,&(*i));
    }
  }
  {
    map<string,EventIn<SFImage> >::iterator i = sfImageInMap_.find(n);
    if (i != sfImageInMap_.end())
    {
      return Node::eventIn(n,sfImage,&(*i));
    }
  }
  {
    map<string,EventIn<SFInt32> >::iterator i = sfInt32InMap_.find(n);
    if (i != sfInt32InMap_.end())
    {
      return Node::eventIn(n,sfInt32,&(*i));
    }
  }
  {
    map<string,EventIn<SFNode> >::iterator i = sfNodeInMap_.find(n);
    if (i != sfNodeInMap_.end())
    {
      return Node::eventIn(n,sfNode,&(*i));
    }
  }
  {
    map<string,EventIn<SFRotation> >::iterator i = sfRotationInMap_.find(n);
    if (i != sfRotationInMap_.end())
    {
      return Node::eventIn(n,sfRotation,&(*i));
    }
  }
  {
    map<string,EventIn<SFString> >::iterator i = sfStringInMap_.find(n);
    if (i != sfStringInMap_.end())
    {
      return Node::eventIn(n,sfString,&(*i));
    }
  }
  {
    map<string,EventIn<SFTime> >::iterator i = sfTimeInMap_.find(n);
    if (i != sfTimeInMap_.end())
    {
      return Node::eventIn(n,sfTime,&(*i));
    }
  }
  {
    map<string,EventIn<SFVec2f> >::iterator i = sfVec2fInMap_.find(n);
    if (i != sfVec2fInMap_.end())
    {
      return Node::eventIn(n,sfVec2f,&(*i));
    }
  }
  {
    map<string,EventIn<SFVec3f> >::iterator i = sfVec3fInMap_.find(n);
    if (i != sfVec3fInMap_.end())
    {
      return Node::eventIn(n,sfVec3f,&(*i));
    }
  }
  {
    map<string,EventIn<MFColor> >::iterator i = mfColorInMap_.find(n);
    if (i != mfColorInMap_.end())
    {
      return Node::eventIn(n,mfColor,&(*i));
    }
  }
  {
    map<string,EventIn<MFFloat> >::iterator i = mfFloatInMap_.find(n);
    if (i != mfFloatInMap_.end())
    {
      return Node::eventIn(n,mfFloat,&(*i));
    }
  }
  {
    map<string,EventIn<MFInt32> >::iterator i = mfInt32InMap_.find(n);
    if (i != mfInt32InMap_.end())
    {
      return Node::eventIn(n,mfInt32,&(*i));
    }
  }
  {
    map<string,EventIn<MFNode> >::iterator i = mfNodeInMap_.find(n);
    if (i != mfNodeInMap_.end())
    {
      return Node::eventIn(n,mfNode,&(*i));
    }
  }
  {
    map<string,EventIn<MFRotation> >::iterator i = mfRotationInMap_.find(n);
    if (i != mfRotationInMap_.end())
    {
      return Node::eventIn(n,mfRotation,&(*i));
    }
  }
  {
    map<string,EventIn<MFString> >::iterator i = mfStringInMap_.find(n);
    if (i != mfStringInMap_.end())
    {
      return Node::eventIn(n,mfString,&(*i));
    }
  }
  {
    map<string,EventIn<MFTime> >::iterator i = mfTimeInMap_.find(n);
    if (i != mfTimeInMap_.end())
    {
      return Node::eventIn(n,mfTime,&(*i));
    }
  }
  {
    map<string,EventIn<MFVec2f> >::iterator i = mfVec2fInMap_.find(n);
    if (i != mfVec2fInMap_.end())
    {
      return Node::eventIn(n,mfVec2f,&(*i));
    }
  }
  {
    map<string,EventIn<MFVec3f> >::iterator i = mfVec3fInMap_.find(n);
    if (i != mfVec3fInMap_.end())
    {
      return Node::eventIn(n,mfVec3f,&(*i));
    }
  }
  return Node::eventIn(n,unknown,NULL);
}
Node::EventInHandle
DeclaredNode::eventIn(unsigned int n)
{
  unsigned int i=n;
  if (i<sfBoolInMap_.size())
  {
    return Node::eventIn(ithKey(sfBoolInMap_,i),sfBool,
			 ithValue(sfBoolInMap_,i));
  }
  i -= sfBoolInMap_.size();
  if (i<sfColorInMap_.size())
  {
    return Node::eventIn(ithKey(sfColorInMap_,i),sfColor,
			 ithValue(sfColorInMap_,i));
  }
  i -= sfColorInMap_.size();
  if (i<sfFloatInMap_.size())
  {
    return Node::eventIn(ithKey(sfFloatInMap_,i),sfFloat,
			 ithValue(sfFloatInMap_,i));
  }
  i -= sfFloatInMap_.size();
  if (i<sfImageInMap_.size())
  {
    return Node::eventIn(ithKey(sfImageInMap_,i),sfImage,
			 ithValue(sfImageInMap_,i));
  }
  i -= sfImageInMap_.size();
  if (i<sfInt32InMap_.size())
  {
    return Node::eventIn(ithKey(sfInt32InMap_,i),sfInt32,
			 ithValue(sfInt32InMap_,i));
  }
  i -= sfInt32InMap_.size();
  if (i<sfNodeInMap_.size())
  {
    return Node::eventIn(ithKey(sfNodeInMap_,i),sfNode,
			 ithValue(sfNodeInMap_,i));
  }
  i -= sfNodeInMap_.size();
  if (i<sfRotationInMap_.size())
  {
    return Node::eventIn(ithKey(sfRotationInMap_,i),sfRotation,
			 ithValue(sfRotationInMap_,i));
  }
  i -= sfRotationInMap_.size();
  if (i<sfStringInMap_.size())
  {
    return Node::eventIn(ithKey(sfStringInMap_,i),sfString,
			 ithValue(sfStringInMap_,i));
  }
  i -= sfStringInMap_.size();
  if (i<sfTimeInMap_.size())
  {
    return Node::eventIn(ithKey(sfTimeInMap_,i),sfTime,
			 ithValue(sfTimeInMap_,i));
  }
  i -= sfTimeInMap_.size();
  if (i<sfVec2fInMap_.size())
  {
    return Node::eventIn(ithKey(sfVec2fInMap_,i),sfVec2f,
			 ithValue(sfVec2fInMap_,i));
  }
  i -= sfVec2fInMap_.size();
  if (i<sfVec3fInMap_.size())
  {
    return Node::eventIn(ithKey(sfVec3fInMap_,i),sfVec3f,
			 ithValue(sfVec3fInMap_,i));
  }
  i -= sfVec3fInMap_.size();
  if (i<mfColorInMap_.size())
  {
    return Node::eventIn(ithKey(mfColorInMap_,i),mfColor,
			 ithValue(mfColorInMap_,i));
  }
  i -= mfColorInMap_.size();
  if (i<mfFloatInMap_.size())
  {
    return Node::eventIn(ithKey(mfFloatInMap_,i),mfFloat,
			 ithValue(mfFloatInMap_,i));
  }
  i -= mfFloatInMap_.size();
  if (i<mfInt32InMap_.size())
  {
    return Node::eventIn(ithKey(mfInt32InMap_,i),mfInt32,
			 ithValue(mfInt32InMap_,i));
  }
  i -= mfInt32InMap_.size();
  if (i<mfNodeInMap_.size())
  {
    return Node::eventIn(ithKey(mfNodeInMap_,i),mfNode,
			 ithValue(mfNodeInMap_,i));
  }
  i -= mfNodeInMap_.size();
  if (i<mfRotationInMap_.size())
  {
    return Node::eventIn(ithKey(mfRotationInMap_,i),mfRotation,
			 ithValue(mfRotationInMap_,i));
  }
  i -= mfRotationInMap_.size();
  if (i<mfStringInMap_.size())
  {
    return Node::eventIn(ithKey(mfStringInMap_,i),mfString,
			 ithValue(mfStringInMap_,i));
  }
  i -= mfStringInMap_.size();
  if (i<mfTimeInMap_.size())
  {
    return Node::eventIn(ithKey(mfTimeInMap_,i),mfTime,
			 ithValue(mfTimeInMap_,i));
  }
  i -= mfTimeInMap_.size();
  if (i<mfVec2fInMap_.size())
  {
    return Node::eventIn(ithKey(mfVec2fInMap_,i),mfVec2f,
			 ithValue(mfVec2fInMap_,i));
  }
  i -= mfVec2fInMap_.size();
  if (i<mfVec3fInMap_.size())
  {
    return Node::eventIn(ithKey(mfVec3fInMap_,i),mfVec3f,
			 ithValue(mfVec3fInMap_,i));
  }
  i -= mfVec3fInMap_.size();
  return EventInHandle();
}
unsigned int
DeclaredNode::nbEventsOut() const
{
  return
    sfBoolOutMap_.size()+
    sfColorOutMap_.size()+
    sfFloatOutMap_.size()+
    sfImageOutMap_.size()+
    sfInt32OutMap_.size()+
    sfNodeOutMap_.size()+
    sfRotationOutMap_.size()+
    sfStringOutMap_.size()+
    sfTimeOutMap_.size()+
    sfVec2fOutMap_.size()+
    sfVec3fOutMap_.size()+
    mfColorOutMap_.size()+
    mfFloatOutMap_.size()+
    mfInt32OutMap_.size()+
    mfNodeOutMap_.size()+
    mfRotationOutMap_.size()+
    mfStringOutMap_.size()+
    mfTimeOutMap_.size()+
    mfVec2fOutMap_.size()+
    mfVec3fOutMap_.size();
}
Node::EventOutHandle
DeclaredNode::eventOut(const string& n)
{
  {
    map<string,EventOut<SFBool> >::iterator i = sfBoolOutMap_.find(n);
    if (i != sfBoolOutMap_.end())
    {
      return Node::eventOut(n,sfBool,&(*i));
    }
  }
  {
    map<string,EventOut<SFColor> >::iterator i = sfColorOutMap_.find(n);
    if (i != sfColorOutMap_.end())
    {
      return Node::eventOut(n,sfColor,&(*i));
    }
  }
  {
    map<string,EventOut<SFFloat> >::iterator i = sfFloatOutMap_.find(n);
    if (i != sfFloatOutMap_.end())
    {
      return Node::eventOut(n,sfFloat,&(*i));
    }
  }
  {
    map<string,EventOut<SFImage> >::iterator i = sfImageOutMap_.find(n);
    if (i != sfImageOutMap_.end())
    {
      return Node::eventOut(n,sfImage,&(*i));
    }
  }
  {
    map<string,EventOut<SFInt32> >::iterator i = sfInt32OutMap_.find(n);
    if (i != sfInt32OutMap_.end())
    {
      return Node::eventOut(n,sfInt32,&(*i));
    }
  }
  {
    map<string,EventOut<SFNode> >::iterator i = sfNodeOutMap_.find(n);
    if (i != sfNodeOutMap_.end())
    {
      return Node::eventOut(n,sfNode,&(*i));
    }
  }
  {
    map<string,EventOut<SFRotation> >::iterator i = sfRotationOutMap_.find(n);
    if (i != sfRotationOutMap_.end())
    {
      return Node::eventOut(n,sfRotation,&(*i));
    }
  }
  {
    map<string,EventOut<SFString> >::iterator i = sfStringOutMap_.find(n);
    if (i != sfStringOutMap_.end())
    {
      return Node::eventOut(n,sfString,&(*i));
    }
  }
  {
    map<string,EventOut<SFTime> >::iterator i = sfTimeOutMap_.find(n);
    if (i != sfTimeOutMap_.end())
    {
      return Node::eventOut(n,sfTime,&(*i));
    }
  }
  {
    map<string,EventOut<SFVec2f> >::iterator i = sfVec2fOutMap_.find(n);
    if (i != sfVec2fOutMap_.end())
    {
      return Node::eventOut(n,sfVec2f,&(*i));
    }
  }
  {
    map<string,EventOut<SFVec3f> >::iterator i = sfVec3fOutMap_.find(n);
    if (i != sfVec3fOutMap_.end())
    {
      return Node::eventOut(n,sfVec3f,&(*i));
    }
  }
  {
    map<string,EventOut<MFColor> >::iterator i = mfColorOutMap_.find(n);
    if (i != mfColorOutMap_.end())
    {
      return Node::eventOut(n,mfColor,&(*i));
    }
  }
  {
    map<string,EventOut<MFFloat> >::iterator i = mfFloatOutMap_.find(n);
    if (i != mfFloatOutMap_.end())
    {
      return Node::eventOut(n,mfFloat,&(*i));
    }
  }
  {
    map<string,EventOut<MFInt32> >::iterator i = mfInt32OutMap_.find(n);
    if (i != mfInt32OutMap_.end())
    {
      return Node::eventOut(n,mfInt32,&(*i));
    }
  }
  {
    map<string,EventOut<MFNode> >::iterator i = mfNodeOutMap_.find(n);
    if (i != mfNodeOutMap_.end())
    {
      return Node::eventOut(n,mfNode,&(*i));
    }
  }
  {
    map<string,EventOut<MFRotation> >::iterator i = mfRotationOutMap_.find(n);
    if (i != mfRotationOutMap_.end())
    {
      return Node::eventOut(n,mfRotation,&(*i));
    }
  }
  {
    map<string,EventOut<MFString> >::iterator i = mfStringOutMap_.find(n);
    if (i != mfStringOutMap_.end())
    {
      return Node::eventOut(n,mfString,&(*i));
    }
  }
  {
    map<string,EventOut<MFTime> >::iterator i = mfTimeOutMap_.find(n);
    if (i != mfTimeOutMap_.end())
    {
      return Node::eventOut(n,mfTime,&(*i));
    }
  }
  {
    map<string,EventOut<MFVec2f> >::iterator i = mfVec2fOutMap_.find(n);
    if (i != mfVec2fOutMap_.end())
    {
      return Node::eventOut(n,mfVec2f,&(*i));
    }
  }
  {
    map<string,EventOut<MFVec3f> >::iterator i = mfVec3fOutMap_.find(n);
    if (i != mfVec3fOutMap_.end())
    {
      return Node::eventOut(n,mfVec3f,&(*i));
    }
  }
  return Node::eventOut(n,unknown,NULL);
}
Node::EventOutHandle
DeclaredNode::eventOut(unsigned int n)
{
  unsigned int i=n;
  if (i<sfBoolOutMap_.size())
  {
    return Node::eventOut(ithKey(sfBoolOutMap_,i),sfBool,
			  ithValue(sfBoolOutMap_,i));
  }
  i -= sfBoolOutMap_.size();
  if (i<sfColorOutMap_.size())
  {
    return Node::eventOut(ithKey(sfColorOutMap_,i),sfColor,
			  ithValue(sfColorOutMap_,i));
  }
  i -= sfColorOutMap_.size();
  if (i<sfFloatOutMap_.size())
  {
    return Node::eventOut(ithKey(sfFloatOutMap_,i),sfFloat,
			  ithValue(sfFloatOutMap_,i));
  }
  i -= sfFloatOutMap_.size();
  if (i<sfImageOutMap_.size())
  {
    return Node::eventOut(ithKey(sfImageOutMap_,i),sfImage,
			  ithValue(sfImageOutMap_,i));
  }
  i -= sfImageOutMap_.size();
  if (i<sfInt32OutMap_.size())
  {
    return Node::eventOut(ithKey(sfInt32OutMap_,i),sfInt32,
			  ithValue(sfInt32OutMap_,i));
  }
  i -= sfInt32OutMap_.size();
  if (i<sfNodeOutMap_.size())
  {
    return Node::eventOut(ithKey(sfNodeOutMap_,i),sfNode,
			  ithValue(sfNodeOutMap_,i));
  }
  i -= sfNodeOutMap_.size();
  if (i<sfRotationOutMap_.size())
  {
    return Node::eventOut(ithKey(sfRotationOutMap_,i),sfRotation,
			  ithValue(sfRotationOutMap_,i));
  }
  i -= sfRotationOutMap_.size();
  if (i<sfStringOutMap_.size())
  {
    return Node::eventOut(ithKey(sfStringOutMap_,i),sfString,
			  ithValue(sfStringOutMap_,i));
  }
  i -= sfStringOutMap_.size();
  if (i<sfTimeOutMap_.size())
  {
    return Node::eventOut(ithKey(sfTimeOutMap_,i),sfTime,
			  ithValue(sfTimeOutMap_,i));
  }
  i -= sfTimeOutMap_.size();
  if (i<sfVec2fOutMap_.size())
  {
    return Node::eventOut(ithKey(sfVec2fOutMap_,i),sfVec2f,
			  ithValue(sfVec2fOutMap_,i));
  }
  i -= sfVec2fOutMap_.size();
  if (i<sfVec3fOutMap_.size())
  {
    return Node::eventOut(ithKey(sfVec3fOutMap_,i),sfVec3f,
			  ithValue(sfVec3fOutMap_,i));
  }
  i -= sfVec3fOutMap_.size();
  if (i<mfColorOutMap_.size())
  {
    return Node::eventOut(ithKey(mfColorOutMap_,i),mfColor,
			  ithValue(mfColorOutMap_,i));
  }
  i -= mfColorOutMap_.size();
  if (i<mfFloatOutMap_.size())
  {
    return Node::eventOut(ithKey(mfFloatOutMap_,i),mfFloat,
			  ithValue(mfFloatOutMap_,i));
  }
  i -= mfFloatOutMap_.size();
  if (i<mfInt32OutMap_.size())
  {
    return Node::eventOut(ithKey(mfInt32OutMap_,i),mfInt32,
			  ithValue(mfInt32OutMap_,i));
  }
  i -= mfInt32OutMap_.size();
  if (i<mfNodeOutMap_.size())
  {
    return Node::eventOut(ithKey(mfNodeOutMap_,i),mfNode,
			  ithValue(mfNodeOutMap_,i));
  }
  i -= mfNodeOutMap_.size();
  if (i<mfRotationOutMap_.size())
  {
    return Node::eventOut(ithKey(mfRotationOutMap_,i),mfRotation,
			  ithValue(mfRotationOutMap_,i));
  }
  i -= mfRotationOutMap_.size();
  if (i<mfStringOutMap_.size())
  {
    return Node::eventOut(ithKey(mfStringOutMap_,i),mfString,
			  ithValue(mfStringOutMap_,i));
  }
  i -= mfStringOutMap_.size();
  if (i<mfTimeOutMap_.size())
  {
    return Node::eventOut(ithKey(mfTimeOutMap_,i),mfTime,
			  ithValue(mfTimeOutMap_,i));
  }
  i -= mfTimeOutMap_.size();
  if (i<mfVec2fOutMap_.size())
  {
    return Node::eventOut(ithKey(mfVec2fOutMap_,i),mfVec2f,
			  ithValue(mfVec2fOutMap_,i));
  }
  i -= mfVec2fOutMap_.size();
  if (i<mfVec3fOutMap_.size())
  {
    return Node::eventOut(ithKey(mfVec3fOutMap_,i),mfVec3f,
			  ithValue(mfVec3fOutMap_,i));
  }
  i -= mfVec3fOutMap_.size();
  return EventOutHandle();
}
bool
DeclaredNode::isDeclaredEventIn(const std::string& n) const
{
  {
    map<string,EventIn<SFBool> >::const_iterator i = sfBoolInMap_.find(n);
    if (i != sfBoolInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFColor> >::const_iterator i = sfColorInMap_.find(n);
    if (i != sfColorInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFFloat> >::const_iterator i = sfFloatInMap_.find(n);
    if (i != sfFloatInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFImage> >::const_iterator i = sfImageInMap_.find(n);
    if (i != sfImageInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFInt32> >::const_iterator i = sfInt32InMap_.find(n);
    if (i != sfInt32InMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFNode> >::const_iterator i = sfNodeInMap_.find(n);
    if (i != sfNodeInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFRotation> >::const_iterator i = sfRotationInMap_.find(n);
    if (i != sfRotationInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFString> >::const_iterator i = sfStringInMap_.find(n);
    if (i != sfStringInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFTime> >::const_iterator i = sfTimeInMap_.find(n);
    if (i != sfTimeInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFVec2f> >::const_iterator i = sfVec2fInMap_.find(n);
    if (i != sfVec2fInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<SFVec3f> >::const_iterator i = sfVec3fInMap_.find(n);
    if (i != sfVec3fInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFColor> >::const_iterator i = mfColorInMap_.find(n);
    if (i != mfColorInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFFloat> >::const_iterator i = mfFloatInMap_.find(n);
    if (i != mfFloatInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFInt32> >::const_iterator i = mfInt32InMap_.find(n);
    if (i != mfInt32InMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFNode> >::const_iterator i = mfNodeInMap_.find(n);
    if (i != mfNodeInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFRotation> >::const_iterator i = mfRotationInMap_.find(n);
    if (i != mfRotationInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFString> >::const_iterator i = mfStringInMap_.find(n);
    if (i != mfStringInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFTime> >::const_iterator i = mfTimeInMap_.find(n);
    if (i != mfTimeInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFVec2f> >::const_iterator i = mfVec2fInMap_.find(n);
    if (i != mfVec2fInMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventIn<MFVec3f> >::const_iterator i = mfVec3fInMap_.find(n);
    if (i != mfVec3fInMap_.end())
    {
      return true;
    }
  }
  return false;
}
bool
DeclaredNode::isDeclaredEventIn(unsigned int n) const
{
  unsigned int i=n;
  if (i<sfBoolInMap_.size())
  {
    return true;
  }
  i -= sfBoolInMap_.size();
  if (i<sfColorInMap_.size())
  {
    return true;
  }
  i -= sfColorInMap_.size();
  if (i<sfFloatInMap_.size())
  {
    return true;
  }
  i -= sfFloatInMap_.size();
  if (i<sfImageInMap_.size())
  {
    return true;
  }
  i -= sfImageInMap_.size();
  if (i<sfInt32InMap_.size())
  {
    return true;
  }
  i -= sfInt32InMap_.size();
  if (i<sfNodeInMap_.size())
  {
    return true;
  }
  i -= sfNodeInMap_.size();
  if (i<sfRotationInMap_.size())
  {
    return true;
  }
  i -= sfRotationInMap_.size();
  if (i<sfStringInMap_.size())
  {
    return true;
  }
  i -= sfStringInMap_.size();
  if (i<sfTimeInMap_.size())
  {
    return true;
  }
  i -= sfTimeInMap_.size();
  if (i<sfVec2fInMap_.size())
  {
    return true;
  }
  i -= sfVec2fInMap_.size();
  if (i<sfVec3fInMap_.size())
  {
    return true;
  }
  i -= sfVec3fInMap_.size();
  if (i<mfColorInMap_.size())
  {
    return true;
  }
  i -= mfColorInMap_.size();
  if (i<mfFloatInMap_.size())
  {
    return true;
  }
  i -= mfFloatInMap_.size();
  if (i<mfInt32InMap_.size())
  {
    return true;
  }
  i -= mfInt32InMap_.size();
  if (i<mfNodeInMap_.size())
  {
    return true;
  }
  i -= mfNodeInMap_.size();
  if (i<mfRotationInMap_.size())
  {
    return true;
  }
  i -= mfRotationInMap_.size();
  if (i<mfStringInMap_.size())
  {
    return true;
  }
  i -= mfStringInMap_.size();
  if (i<mfTimeInMap_.size())
  {
    return true;
  }
  i -= mfTimeInMap_.size();
  if (i<mfVec2fInMap_.size())
  {
    return true;
  }
  i -= mfVec2fInMap_.size();
  if (i<mfVec3fInMap_.size())
  {
    return true;
  }
  i -= mfVec3fInMap_.size();
  return false;
}
bool
DeclaredNode::isDeclaredEventOut(const std::string& n) const
{
  {
    map<string,EventOut<SFBool> >::const_iterator i = sfBoolOutMap_.find(n);
    if (i != sfBoolOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFColor> >::const_iterator i = sfColorOutMap_.find(n);
    if (i != sfColorOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFFloat> >::const_iterator i = sfFloatOutMap_.find(n);
    if (i != sfFloatOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFImage> >::const_iterator i = sfImageOutMap_.find(n);
    if (i != sfImageOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFInt32> >::const_iterator i = sfInt32OutMap_.find(n);
    if (i != sfInt32OutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFNode> >::const_iterator i = sfNodeOutMap_.find(n);
    if (i != sfNodeOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFRotation> >::const_iterator i = sfRotationOutMap_.find(n);
    if (i != sfRotationOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFString> >::const_iterator i = sfStringOutMap_.find(n);
    if (i != sfStringOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFTime> >::const_iterator i = sfTimeOutMap_.find(n);
    if (i != sfTimeOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFVec2f> >::const_iterator i = sfVec2fOutMap_.find(n);
    if (i != sfVec2fOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<SFVec3f> >::const_iterator i = sfVec3fOutMap_.find(n);
    if (i != sfVec3fOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFColor> >::const_iterator i = mfColorOutMap_.find(n);
    if (i != mfColorOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFFloat> >::const_iterator i = mfFloatOutMap_.find(n);
    if (i != mfFloatOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFInt32> >::const_iterator i = mfInt32OutMap_.find(n);
    if (i != mfInt32OutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFNode> >::const_iterator i = mfNodeOutMap_.find(n);
    if (i != mfNodeOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFRotation> >::const_iterator i = mfRotationOutMap_.find(n);
    if (i != mfRotationOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFString> >::const_iterator i = mfStringOutMap_.find(n);
    if (i != mfStringOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFTime> >::const_iterator i = mfTimeOutMap_.find(n);
    if (i != mfTimeOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFVec2f> >::const_iterator i = mfVec2fOutMap_.find(n);
    if (i != mfVec2fOutMap_.end())
    {
      return true;
    }
  }
  {
    map<string,EventOut<MFVec3f> >::const_iterator i = mfVec3fOutMap_.find(n);
    if (i != mfVec3fOutMap_.end())
    {
      return true;
    }
  }
  return false;
}
bool
DeclaredNode::isDeclaredEventOut(unsigned int n) const
{
  unsigned int i=n;
  if (i<sfBoolOutMap_.size())
  {
    return true;
  }
  i -= sfBoolOutMap_.size();
  if (i<sfColorOutMap_.size())
  {
    return true;
  }
  i -= sfColorOutMap_.size();
  if (i<sfFloatOutMap_.size())
  {
    return true;
  }
  i -= sfFloatOutMap_.size();
  if (i<sfImageOutMap_.size())
  {
    return true;
  }
  i -= sfImageOutMap_.size();
  if (i<sfInt32OutMap_.size())
  {
    return true;
  }
  i -= sfInt32OutMap_.size();
  if (i<sfNodeOutMap_.size())
  {
    return true;
  }
  i -= sfNodeOutMap_.size();
  if (i<sfRotationOutMap_.size())
  {
    return true;
  }
  i -= sfRotationOutMap_.size();
  if (i<sfStringOutMap_.size())
  {
    return true;
  }
  i -= sfStringOutMap_.size();
  if (i<sfTimeOutMap_.size())
  {
    return true;
  }
  i -= sfTimeOutMap_.size();
  if (i<sfVec2fOutMap_.size())
  {
    return true;
  }
  i -= sfVec2fOutMap_.size();
  if (i<sfVec3fOutMap_.size())
  {
    return true;
  }
  i -= sfVec3fOutMap_.size();
  if (i<mfColorOutMap_.size())
  {
    return true;
  }
  i -= mfColorOutMap_.size();
  if (i<mfFloatOutMap_.size())
  {
    return true;
  }
  i -= mfFloatOutMap_.size();
  if (i<mfInt32OutMap_.size())
  {
    return true;
  }
  i -= mfInt32OutMap_.size();
  if (i<mfNodeOutMap_.size())
  {
    return true;
  }
  i -= mfNodeOutMap_.size();
  if (i<mfRotationOutMap_.size())
  {
    return true;
  }
  i -= mfRotationOutMap_.size();
  if (i<mfStringOutMap_.size())
  {
    return true;
  }
  i -= mfStringOutMap_.size();
  if (i<mfTimeOutMap_.size())
  {
    return true;
  }
  i -= mfTimeOutMap_.size();
  if (i<mfVec2fOutMap_.size())
  {
    return true;
  }
  i -= mfVec2fOutMap_.size();
  if (i<mfVec3fOutMap_.size())
  {
    return true;
  }
  i -= mfVec3fOutMap_.size();
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../include/xdkwrl/")
// End:
