#include <xdkwrl/fieldtypes/sfimage.h>

namespace wrl
{
	SFImage::SFImage(const SFImage& i)
	{
		width_ = i.width_;
		height_ = i.height_;
		numComponents_ = i.numComponents_;
		pixels_ = new unsigned char[width_*height_*numComponents_];
		std::copy(i.pixels_,i.pixels_+width_*height_*numComponents_,
			pixels_);
	}
	SFImage& SFImage::operator=(const SFImage& i)
	{
		// We must check for the tricky case a=a (to avoid subtle leaks)
		if (this != &i)
		{
			// Deallocate previously used pixels
			if (pixels_ != NULL)
			{
				delete [] pixels_;
			}
			// Copy the new
			width_ = i.width_;
			height_ = i.height_;
			numComponents_ = i.numComponents_;
			pixels_ = new unsigned char[width_*height_*numComponents_];
			std::copy(i.pixels_,i.pixels_+width_*height_*numComponents_,
				pixels_);
		}
		return *this;
	}  
	std::ostream& operator<<(std::ostream& s,const SFImage& f)
	{
		s<<f.width_<<' '<<f.height_<<' '<<f.numComponents_<<' ';
		for (unsigned char* p = f.pixels_,
			*pstop = f.pixels_+f.width_*f.height_*f.numComponents_;
			p != pstop;)
		{
			int i = 0;
			for(unsigned int k=0;k<f.numComponents_;++k)
			{
				i <<= 8;
				i += *p++;
			}
			if (i != 0)
			{
				s<<"0x";
			}
			s<<std::hex<<i<<' ';
		}
		return s<<std::dec;    
	}
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/fieldtypes")
// End:

