#ifndef XDKWRL_VIEWPOINT_H
#define XDKWRL_VIEWPOINT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Viewpoint
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Viewpoint : public Node
  {
   public:
     Viewpoint(const char* name="");
     virtual ~Viewpoint();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       fieldOfView = 0.785398f;
       \endcode
       */
       SFFloat    fieldOfView;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       jump = true;
       \endcode
       */
       SFBool     jump;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
       \endcode
       */
       SFRotation orientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       position.setXYZ(0.0f,0.0f,10.0f);
       \endcode
       */
       SFVec3f    position;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       description = string("");
        \endcode
       */
       SFString   description;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFBool>     set_bind;
      /*!
       * Set event associated to exposedField fieldOfView
       */
       EventIn<SFFloat>    set_fieldOfView;
      /*!
       * Set event associated to exposedField jump
       */
       EventIn<SFBool>     set_jump;
      /*!
       * Set event associated to exposedField orientation
       */
       EventIn<SFRotation> set_orientation;
      /*!
       * Set event associated to exposedField position
       */
       EventIn<SFVec3f>    set_position;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     bindTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isBound;
      /*!
       * Changed event associated to exposedField fieldOfView
       */
       EventOut<SFFloat>    fieldOfView_changed;
      /*!
       * Changed event associated to exposedField jump
       */
       EventOut<SFBool>     jump_changed;
      /*!
       * Changed event associated to exposedField orientation
       */
       EventOut<SFRotation> orientation_changed;
      /*!
       * Changed event associated to exposedField position
       */
       EventOut<SFVec3f>    position_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Viewpoint
//************************************************************
/*!
 * Returns <code>"Viewpoint"</code>. Useful for printing.
 */
inline const char*
wrl::Viewpoint::typeName() const
{
  return "Viewpoint";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Viewpoint::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Viewpoint::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Viewpoint::nbEventsOut() const
{
   return 2;
}
#endif // XDKWRL_VIEWPOINT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
