#ifndef XDKWRL_TOUCHSENSOR_H
#define XDKWRL_TOUCHSENSOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of TouchSensor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API TouchSensor : public Node
  {
   public:
     TouchSensor(const char* name="");
     virtual ~TouchSensor();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       enabled = true;
       \endcode
       */
       SFBool     enabled;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField enabled
       */
       EventIn<SFBool>     set_enabled;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    hitNormal_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    hitPoint_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec2f>    hitTexCoord_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isActive;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isOver;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     touchTime;
      /*!
       * Changed event associated to exposedField enabled
       */
       EventOut<SFBool>     enabled_changed;
  //!@}
  };
};
//************************************************************
// Implementation of TouchSensor
//************************************************************
/*!
 * Returns <code>"TouchSensor"</code>. Useful for printing.
 */
inline const char*
wrl::TouchSensor::typeName() const
{
  return "TouchSensor";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::TouchSensor::nbFields() const
{
   return 1;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::TouchSensor::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::TouchSensor::nbEventsOut() const
{
   return 6;
}
#endif // XDKWRL_TOUCHSENSOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
