#ifndef XDKWRL_TEXT_H
#define XDKWRL_TEXT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Text
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Text : public Node
  {
   public:
     Text(const char* name="");
     virtual ~Text();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   string;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     fontStyle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    length;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       maxExtent = 0.0f;
       \endcode
       */
       SFFloat    maxExtent;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField string
       */
       EventIn<MFString>   set_string;
      /*!
       * Set event associated to exposedField fontStyle
       */
       EventIn<SFNode>     set_fontStyle;
      /*!
       * Set event associated to exposedField length
       */
       EventIn<MFFloat>    set_length;
      /*!
       * Set event associated to exposedField maxExtent
       */
       EventIn<SFFloat>    set_maxExtent;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField string
       */
       EventOut<MFString>   string_changed;
      /*!
       * Changed event associated to exposedField fontStyle
       */
       EventOut<SFNode>     fontStyle_changed;
      /*!
       * Changed event associated to exposedField length
       */
       EventOut<MFFloat>    length_changed;
      /*!
       * Changed event associated to exposedField maxExtent
       */
       EventOut<SFFloat>    maxExtent_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Text
//************************************************************
/*!
 * Returns <code>"Text"</code>. Useful for printing.
 */
inline const char*
wrl::Text::typeName() const
{
  return "Text";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Text::nbFields() const
{
   return 4;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Text::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Text::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_TEXT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
