#ifndef XDKWRL_NAVIGATIONINFO_H
#define XDKWRL_NAVIGATIONINFO_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of NavigationInfo
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API NavigationInfo : public Node
  {
   public:
     NavigationInfo(const char* name="");
     virtual ~NavigationInfo();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           avatarSize.push_back(SFFloat(0.25f));
    avatarSize.push_back(SFFloat(1.6f));
    avatarSize.push_back(SFFloat(0.75f));
       \endcode
       */
       MFFloat    avatarSize;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       headlight = true;
       \endcode
       */
       SFBool     headlight;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       speed = 1.0f;
       \endcode
       */
       SFFloat    speed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
       \endcode
       */
       MFString   type;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       visibilityLimit = 0.0f;
       \endcode
       */
       SFFloat    visibilityLimit;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFBool>     set_bind;
      /*!
       * Set event associated to exposedField avatarSize
       */
       EventIn<MFFloat>    set_avatarSize;
      /*!
       * Set event associated to exposedField headlight
       */
       EventIn<SFBool>     set_headlight;
      /*!
       * Set event associated to exposedField speed
       */
       EventIn<SFFloat>    set_speed;
      /*!
       * Set event associated to exposedField type
       */
       EventIn<MFString>   set_type;
      /*!
       * Set event associated to exposedField visibilityLimit
       */
       EventIn<SFFloat>    set_visibilityLimit;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isBound;
      /*!
       * Changed event associated to exposedField avatarSize
       */
       EventOut<MFFloat>    avatarSize_changed;
      /*!
       * Changed event associated to exposedField headlight
       */
       EventOut<SFBool>     headlight_changed;
      /*!
       * Changed event associated to exposedField speed
       */
       EventOut<SFFloat>    speed_changed;
      /*!
       * Changed event associated to exposedField type
       */
       EventOut<MFString>   type_changed;
      /*!
       * Changed event associated to exposedField visibilityLimit
       */
       EventOut<SFFloat>    visibilityLimit_changed;
  //!@}
  };
};
//************************************************************
// Implementation of NavigationInfo
//************************************************************
/*!
 * Returns <code>"NavigationInfo"</code>. Useful for printing.
 */
inline const char*
wrl::NavigationInfo::typeName() const
{
  return "NavigationInfo";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::NavigationInfo::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::NavigationInfo::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::NavigationInfo::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_NAVIGATIONINFO_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
