#ifndef XDKWRL_GEOPOSITIONINTERPOLATOR_H
#define XDKWRL_GEOPOSITIONINTERPOLATOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of GeoPositionInterpolator
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API GeoPositionInterpolator : public Node
  {
   public:
     GeoPositionInterpolator(const char* name="");
     virtual ~GeoPositionInterpolator();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     geoOrigin;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
        \endcode
       */
       MFString   geoSystem;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    key;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   keyValue;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFFloat>    set_fraction;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFString>   geovalue_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    value_changed;
  //!@}
  };
};
//************************************************************
// Implementation of GeoPositionInterpolator
//************************************************************
/*!
 * Returns <code>"GeoPositionInterpolator"</code>. Useful for printing.
 */
inline const char*
wrl::GeoPositionInterpolator::typeName() const
{
  return "GeoPositionInterpolator";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::GeoPositionInterpolator::nbFields() const
{
   return 4;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::GeoPositionInterpolator::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::GeoPositionInterpolator::nbEventsOut() const
{
   return 2;
}
#endif // XDKWRL_GEOPOSITIONINTERPOLATOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
